/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.mraplots;

import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import pt.lsts.dot.IMCGraph;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.mra.visualizations.SimpleMRAVisualization;
import pt.lsts.neptus.plugins.PluginDescription;

@PluginDescription(name="Network", icon="pt/lsts/neptus/plugins/mraplots/msg_inspector.png", experimental=true)
public class NetworkConnections
extends SimpleMRAVisualization {
    private static final long serialVersionUID = -8135678083471983681L;
    protected LsfIndex index;
    protected JLabel label = new JLabel();

    public NetworkConnections(MRAPanel panel) {
        super(panel);
    }

    public boolean canBeApplied(IMraLogGroup source) {
        return source.getFile("Data.lsf") != null && source.getFile("IMC.xml") != null;
    }

    public JComponent getVisualization(IMraLogGroup source, double timestep) {
        try {
            if (this.index == null) {
                this.index = new LsfIndex(source.getFile("Data.lsf"), new IMCDefinition((InputStream)new FileInputStream(source.getFile("IMC.xml"))));
            }
            try {
                IMCGraph graph = new IMCGraph(this.index);
                BufferedImage img = graph.generateSystemsGraph().generateImage();
                this.label.setIcon(new ImageIcon(img));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.label.setText(I18n.text((String)"Your system doesn't have dot support"));
            }
            return new JScrollPane(this.label);
        }
        catch (Exception e) {
            return new JLabel(I18n.text((String)"ERROR") + ": " + e.getMessage());
        }
    }

    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }
}

