/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.mraplots;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.mraplots.MraPhotosVisualization;
import pt.lsts.neptus.util.ImageUtils;

public class PhotoToolbar
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected MraPhotosVisualization display;
    protected JToggleButton grayToggle;
    protected JToggleButton sharpenToggle;
    protected JToggleButton wbalanceToggle;
    protected JToggleButton contrastToggle;
    protected JToggleButton brightToggle;
    protected JToggleButton legendToggle;
    protected JButton nextButton;
    protected JButton prevButton;
    protected File[] allFiles;
    protected double startTime;
    protected double endTime;
    protected SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss.SSS");

    public PhotoToolbar(MraPhotosVisualization display) {
        this.display = display;
        this.allFiles = MraPhotosVisualization.listPhotos(display.getPhotosDir());
        this.startTime = display.timestampOf(this.allFiles[0]);
        this.endTime = display.timestampOf(this.allFiles[this.allFiles.length - 1]);
        this.initialize();
    }

    protected synchronized void setTime(double time) {
        for (int i = 0; i < this.allFiles.length; ++i) {
            if (!(this.display.timestampOf(this.allFiles[i]) >= time)) continue;
            this.display.setCurFile(this.allFiles[i]);
            return;
        }
    }

    protected void initialize() {
        this.nextButton = new JButton(">");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoToolbar.this.next();
            }
        });
        this.nextButton.setToolTipText(I18n.text((String)"Next photo"));
        this.prevButton = new JButton("<");
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoToolbar.this.prev();
            }
        });
        this.prevButton.setToolTipText(I18n.text((String)"Previous photo"));
        this.grayToggle = new JToggleButton("G");
        this.grayToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoToolbar.this.display.grayscale = PhotoToolbar.this.grayToggle.isSelected();
                PhotoToolbar.this.display.setCurFile(PhotoToolbar.this.display.getCurFile());
            }
        });
        this.grayToggle.setToolTipText(I18n.text((String)"Toggle grayscale filter"));
        this.add(this.grayToggle);
        this.brightToggle = new JToggleButton("B");
        this.brightToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoToolbar.this.display.brighten = PhotoToolbar.this.brightToggle.isSelected();
                PhotoToolbar.this.display.setCurFile(PhotoToolbar.this.display.getCurFile());
            }
        });
        this.brightToggle.setToolTipText(I18n.text((String)"Toggle brightness filter"));
        this.add(this.brightToggle);
        this.sharpenToggle = new JToggleButton("S");
        this.sharpenToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoToolbar.this.display.sharpen = PhotoToolbar.this.sharpenToggle.isSelected();
                PhotoToolbar.this.display.setCurFile(PhotoToolbar.this.display.getCurFile());
            }
        });
        this.sharpenToggle.setToolTipText(I18n.text((String)"Toggle sharpen filter"));
        this.add(this.sharpenToggle);
        this.contrastToggle = new JToggleButton("C");
        this.contrastToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoToolbar.this.display.contrast = PhotoToolbar.this.contrastToggle.isSelected();
                PhotoToolbar.this.display.setCurFile(PhotoToolbar.this.display.getCurFile());
            }
        });
        this.contrastToggle.setToolTipText(I18n.text((String)"Toggle contrast enhancement"));
        this.add(this.contrastToggle);
        this.wbalanceToggle = new JToggleButton("W");
        this.wbalanceToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PhotoToolbar.this.wbalanceToggle.isSelected()) {
                    PhotoToolbar.this.display.whiteBalanceOp = null;
                } else {
                    Color c = JColorChooser.showDialog(PhotoToolbar.this.display, "Select neutral white", PhotoToolbar.this.brightestPixel((BufferedImage)PhotoToolbar.this.display.imageToDisplay));
                    if (c != null) {
                        PhotoToolbar.this.display.whiteBalanceOp = ImageUtils.whiteBalanceOp((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue());
                    } else {
                        PhotoToolbar.this.wbalanceToggle.setSelected(false);
                    }
                }
                PhotoToolbar.this.display.setCurFile(PhotoToolbar.this.display.getCurFile());
            }
        });
        this.wbalanceToggle.setToolTipText(I18n.text((String)"Toggle white balance filter"));
        this.add(this.wbalanceToggle);
        this.legendToggle = new JToggleButton("L");
        this.legendToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoToolbar.this.display.showLegend = PhotoToolbar.this.legendToggle.isSelected();
                PhotoToolbar.this.display.setCurFile(PhotoToolbar.this.display.getCurFile());
            }
        });
        this.legendToggle.setSelected(true);
        this.legendToggle.setToolTipText(I18n.text((String)"Show legend"));
        this.add(this.legendToggle);
        this.add(this.prevButton);
        this.add(this.nextButton);
    }

    protected Color brightestPixel(BufferedImage img) {
        int brightest = 0;
        Color bColor = Color.black;
        Color tmp = new Color(0);
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                tmp = new Color(img.getRGB(x, y));
                if (tmp.getBlue() + tmp.getGreen() + tmp.getRed() <= brightest) continue;
                brightest = tmp.getBlue() + tmp.getGreen() + tmp.getRed();
                bColor = tmp;
            }
        }
        return bColor;
    }

    protected Color averageColor(BufferedImage img) {
        double sumRed = 0.0;
        double sumGreen = 0.0;
        double sumBlue = 0.0;
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                Color tmp = new Color(img.getRGB(x, y));
                sumRed += (double)tmp.getRed();
                sumGreen += (double)tmp.getGreen();
                sumBlue += (double)tmp.getBlue();
            }
        }
        int r = (int)(sumRed / (double)(img.getWidth() * img.getHeight()));
        int g = (int)(sumGreen / (double)(img.getWidth() * img.getHeight()));
        int b = (int)(sumBlue / (double)(img.getWidth() * img.getHeight()));
        return new Color(r, g, b);
    }

    protected void next() {
        File current = this.display.getCurFile();
        final int index = Arrays.binarySearch(this.allFiles, current);
        new Thread(new Runnable(){

            @Override
            public void run() {
                PhotoToolbar.this.display.setCurFile(PhotoToolbar.this.allFiles[index + 1]);
            }
        }).start();
    }

    protected void prev() {
        File current = this.display.getCurFile();
        final int index = Arrays.binarySearch(this.allFiles, current);
        new Thread(new Runnable(){

            @Override
            public void run() {
                PhotoToolbar.this.display.setCurFile(PhotoToolbar.this.allFiles[index - 1]);
            }
        }).start();
    }
}

