/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.mraplots;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingWorker;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.NeptusMRA;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.Plot3D;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.SimpleRendererInteraction;
import pt.lsts.neptus.plugins.mraplots.RevisionSidePanel;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.llf.LogUtils;

@PluginDescription(name="Log Preview", icon="pt/lsts/neptus/plugins/mraplots/eye.png")
public class RevisionOverlays
extends SimpleRendererInteraction {
    @NeptusProperty
    public String defaultDirectory = ".";
    private static final long serialVersionUID = -1737553152800873793L;
    private RevisionSidePanel sidePanel = new RevisionSidePanel(this);
    StateRenderer2D renderer = null;

    public RevisionOverlays(ConsoleLayout console) {
        super(console);
        this.setVisibility(false);
        this.sidePanel.setMinimumSize(new Dimension(150, 150));
        this.sidePanel.setPreferredSize(new Dimension(150, 150));
    }

    public boolean isExclusive() {
        return true;
    }

    protected JPopupMenu buildPopup() {
        JPopupMenu popup = new JPopupMenu();
        popup.add("Open Lsf").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RevisionOverlays.this.sidePanel.selectFile();
            }
        });
        if (this.sidePanel.getLogSource() != null) {
            popup.addSeparator();
            popup.add("Open in MRA").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            NeptusMRA mra = new NeptusMRA();
                            mra.setDefaultCloseOperation(2);
                            mra.getMraFilesHandler().openLog(RevisionOverlays.this.sidePanel.getLogFile());
                        }
                    }).run();
                }
            });
            popup.add("Import plan").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RevisionOverlays.this.importPlan();
                }
            });
            popup.add("3D Plot").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDialog dialog = new JDialog((Frame)RevisionOverlays.this.getConsole());
                    final Plot3D plot = new Plot3D(null);
                    dialog.getContentPane().add(plot.getComponent(RevisionOverlays.this.sidePanel.getLogSource(), 1.0));
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            plot.onCleanup();
                        }
                    });
                    dialog.setDefaultCloseOperation(2);
                    dialog.setSize(600, 400);
                    dialog.setResizable(false);
                    dialog.setTitle("3D log review - " + RevisionOverlays.this.sidePanel.getLogFile().getName());
                    plot.onShow();
                    dialog.setVisible(true);
                }
            });
        }
        return popup;
    }

    protected void importMarkers() {
    }

    protected void importPlan() {
        IMraLogGroup logSource = this.sidePanel.getLogSource();
        if (logSource == null) {
            return;
        }
        PlanType plan = LogUtils.generatePlan((MissionType)this.getConsole().getMission(), (IMraLogGroup)logSource);
        if (plan == null) {
            GuiUtils.errorMessage((Component)this.getConsole(), (String)"Import plan", (String)"No plan was found in this log.");
            return;
        }
        String lastPlanId = plan.getId();
        String planId = null;
        while (true) {
            if ((planId = JOptionPane.showInputDialog((Component)this.getConsole(), I18n.text((String)"Enter the plan ID"), lastPlanId)) == null) {
                return;
            }
            if (this.getConsole().getMission().getIndividualPlansList().get(planId) == null) break;
            int option = JOptionPane.showConfirmDialog((Component)this.getConsole(), I18n.text((String)"Do you wish to replace the existing plan with same name?"));
            if (option == 2) {
                return;
            }
            if (option == 0) break;
            lastPlanId = planId;
        }
        plan.setId(planId);
        plan.setVehicle(this.getConsole().getMainSystem());
        plan.setMissionType(this.getConsole().getMission());
        this.getConsole().getMission().addPlan(plan);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                RevisionOverlays.this.getConsole().getMission().save(true);
                return null;
            }
        };
        worker.execute();
        if (this.getConsole().getPlan() == null || this.getConsole().getPlan().getId().equalsIgnoreCase(plan.getId())) {
            this.getConsole().setPlan(plan);
        }
        this.getConsole().warnMissionListeners();
    }

    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        if (event.getButton() == 3) {
            JPopupMenu popup = this.buildPopup();
            popup.show((Component)source, event.getX(), event.getY());
        } else {
            super.mouseClicked(event, source);
        }
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        Container parent;
        this.renderer = source;
        for (parent = source.getParent(); parent != null && !(parent.getLayout() instanceof BorderLayout); parent = parent.getParent()) {
        }
        if (mode) {
            parent.add((Component)this.sidePanel, "East");
        } else {
            parent = this.sidePanel.getParent();
            this.sidePanel.getParent().remove(this.sidePanel);
        }
        parent.invalidate();
        parent.validate();
        parent.repaint();
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

