/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.mraplots;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import pt.lsts.imc.lsf.LsfIndexListener;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.plugins.PluginsRepository;
import pt.lsts.neptus.plugins.mraplots.RevisionOverlays;
import pt.lsts.neptus.renderer2d.ImageLayer;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.llf.LsfLogSource;

public class RevisionSidePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel fileLabel;
    private JButton fileSelection;
    private RevisionOverlays overlays;
    private JPanel filePanel = new JPanel(new BorderLayout());
    private JPanel overlaysPanel;
    private Vector<Renderer2DPainter> painters = new Vector();
    private IMraLogGroup logSource = null;
    private File logFile = null;

    public void clearOverlays() {
        for (Renderer2DPainter painter : this.painters) {
            this.overlays.renderer.removePostRenderPainter(painter);
        }
        this.painters.clear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RevisionSidePanel.this.overlaysPanel.removeAll();
                RevisionSidePanel.this.overlaysPanel.revalidate();
            }
        });
    }

    public void addOverlay(String name, final Renderer2DPainter painter) {
        this.painters.add(painter);
        final JCheckBox check = new JCheckBox(name);
        check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (check.isSelected()) {
                    ((RevisionSidePanel)RevisionSidePanel.this).overlays.renderer.addPreRenderPainter(painter);
                } else {
                    ((RevisionSidePanel)RevisionSidePanel.this).overlays.renderer.removePreRenderPainter(painter);
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RevisionSidePanel.this.overlaysPanel.add(check);
                RevisionSidePanel.this.overlaysPanel.revalidate();
            }
        });
    }

    public RevisionSidePanel(RevisionOverlays overlays) {
        this.overlays = overlays;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.fileLabel = new JLabel(I18n.text((String)"(no log loaded)"));
        this.fileLabel.setBorder(BorderFactory.createBevelBorder(1));
        this.fileLabel.setBackground(Color.white);
        this.fileLabel.setOpaque(true);
        this.filePanel.add((Component)this.fileLabel, "Center");
        this.fileSelection = new JButton("...");
        this.fileSelection.setMargin(new Insets(1, 1, 1, 1));
        this.fileSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RevisionSidePanel.this.selectFile();
            }
        });
        this.filePanel.add((Component)this.fileSelection, "East");
        this.filePanel.setMaximumSize(new Dimension(200, 25));
        this.add(this.filePanel);
        this.overlaysPanel = new JPanel();
        this.overlaysPanel.setLayout(new BoxLayout(this.overlaysPanel, 3));
        this.add(new JScrollPane(this.overlaysPanel));
    }

    private void loadOverlays(LsfLogSource source) {
        File[] fileArray;
        Vector<Object> layers = new Vector<Object>();
        for (String string : PluginsRepository.getReplayLayers().keySet()) {
            layers.add(PluginsRepository.getPlugin((String)string, LogReplayLayer.class, (Object[])new Object[0]));
        }
        for (LogReplayLayer logReplayLayer : layers) {
            if (!logReplayLayer.canBeApplied((IMraLogGroup)source, LogReplayComponent.Context.Console)) continue;
            logReplayLayer.parse((IMraLogGroup)source);
            this.addOverlay(logReplayLayer.getName(), (Renderer2DPainter)logReplayLayer);
        }
        File dir = source.getFile("mra");
        for (File f : fileArray = dir.listFiles()) {
            if (!FileUtil.getFileExtension((File)f).equals("layer")) continue;
            try {
                this.addOverlay(f.getName(), (Renderer2DPainter)ImageLayer.read((File)f));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void selectFile() {
        final JFileChooser chooser = new JFileChooser(this.overlays.defaultDirectory);
        chooser.setFileFilter(GuiUtils.getCustomFileFilter((String)I18n.text((String)"LSF log files"), (String[])new String[]{"lsf", "lsf.gz"}));
        chooser.setApproveButtonText(I18n.text((String)"Open Log"));
        int option = chooser.showOpenDialog((Component)this.overlays.getConsole());
        if (option != 0) {
            return;
        }
        Thread logLoading = new Thread(new Runnable(){

            @Override
            public void run() {
                final ProgressMonitor monitor = new ProgressMonitor((Component)RevisionSidePanel.this.overlays.getConsole(), I18n.text((String)"Opening LSF log"), I18n.text((String)"Opening LSF log"), 0, 100);
                try {
                    RevisionSidePanel.this.clearOverlays();
                    RevisionSidePanel.this.fileLabel.setText("loading...");
                    RevisionSidePanel.this.logFile = chooser.getSelectedFile();
                    LsfLogSource source = new LsfLogSource(chooser.getSelectedFile(), new LsfIndexListener(){

                        public void updateStatus(String messageToDisplay) {
                            monitor.setNote(messageToDisplay);
                        }
                    });
                    RevisionSidePanel.this.logSource = (IMraLogGroup)source;
                    RevisionSidePanel.this.loadOverlays(source);
                }
                catch (Exception e) {
                    GuiUtils.errorMessage((Component)RevisionSidePanel.this.overlays.getConsole(), (Exception)e);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RevisionSidePanel.this.fileLabel.setText(chooser.getSelectedFile().getParentFile().getName());
                    }
                });
                monitor.close();
                ((RevisionSidePanel)RevisionSidePanel.this).overlays.defaultDirectory = chooser.getSelectedFile().getParent();
            }
        });
        logLoading.start();
    }

    public File getLogFile() {
        return this.logFile;
    }

    public IMraLogGroup getLogSource() {
        return this.logSource;
    }
}

