/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.mraplots;

import java.awt.BorderLayout;
import javax.swing.JComponent;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.mra.visualizations.SimpleMRAVisualization;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.mraplots.Histogram;

@PluginDescription(name="Sidescan Histogram")
public class SidescanHistogram
extends SimpleMRAVisualization {
    private static final long serialVersionUID = 1L;
    protected Histogram histogram = new Histogram();

    public boolean canBeApplied(IMraLogGroup source) {
        return source.getLog("SonarData") != null || source.getLog("SidescanPing") != null;
    }

    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }

    public JComponent getVisualization(final IMraLogGroup source, double timestep) {
        this.setLayout(new BorderLayout());
        this.add(this.histogram);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                double[] sums = null;
                int count = 0;
                String msg = "SonarData";
                if (source.getLog("SonarData") == null) {
                    msg = "SidescanPing";
                }
                for (IMCMessage ping : source.getLsfIndex().getIterator(msg)) {
                    byte[] data = ping.getRawData("data");
                    if (sums == null) {
                        sums = new double[data.length];
                    }
                    for (int i = 0; i < sums.length; ++i) {
                        int n = i;
                        sums[n] = sums[n] + (double)(data[i] & 0xFF);
                    }
                    if (++count % 100 != 0) continue;
                    double[] tmp = new double[sums.length];
                    for (int i = 0; i < sums.length; ++i) {
                        tmp[i] = sums[i] / (double)count;
                    }
                    SidescanHistogram.this.histogram.setData(tmp, 0.0, 255.0);
                }
                for (int i = 0; i < sums.length; ++i) {
                    sums[i] = sums[i] / (double)count;
                }
                SidescanHistogram.this.histogram.setData(sums, 0.0, 255.0);
            }
        });
        t.setDaemon(true);
        t.start();
        return this;
    }

    public SidescanHistogram(MRAPanel panel) {
        super(panel);
    }
}

