/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.mraplots;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorBar;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.plugins.mraplots.XYZDataType;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.coord.UTMCoordinates;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.ImageElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.llf.LogUtils;

public class XYZUtils {
    static double[][] invertDataSet(double[][] dataSet) {
        double[][] kdkdinv = new double[dataSet.length][dataSet[0].length];
        for (int i = 0; i < dataSet.length; ++i) {
            for (int j = 0; j < dataSet.length; ++j) {
                kdkdinv[i][j] = !Double.isNaN(dataSet[i][j]) ? 1.0 - dataSet[i][j] : Double.NaN;
            }
        }
        return kdkdinv;
    }

    static double[] calcMinMaxOfVector(Vector<Double> xvec) {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        for (double xt : xvec) {
            if (xt == Double.NaN) continue;
            if (xt < minX) {
                minX = xt;
            }
            if (!(xt > maxX)) continue;
            maxX = xt;
        }
        return new double[]{minX, maxX};
    }

    public static double[] calcWidthHeightScale(double dimX, double dimY, int targetImageWidth, int targetImageHeight) {
        double scale = 1.0;
        int width = targetImageWidth;
        int height = targetImageHeight;
        double ratio2 = dimX / dimY;
        double ratio1 = (double)targetImageWidth / (double)targetImageHeight;
        if (ratio2 < ratio1) {
            width = (int)((double)width / ratio1);
        } else {
            height = (int)((double)height * ratio1);
        }
        scale = dimX / (double)height;
        return new double[]{width, height, scale};
    }

    static double[][] discretizeQuadMatrix(int gridSize, Rectangle2D bounds, Point2D[] points, Double[] values) {
        double dx = bounds.getWidth() / (double)gridSize;
        double dy = bounds.getHeight() / (double)gridSize;
        Double[] vals = new Double[gridSize * gridSize];
        int[] numPoints = new int[gridSize * gridSize];
        for (int i = 0; i < points.length; ++i) {
            Point2D pt = points[i];
            int indX = (int)Math.floor((pt.getX() - bounds.getMinX()) / dx);
            int indY = (int)Math.floor((pt.getY() - bounds.getMinY()) / dy);
            int ind = indX * gridSize + indY;
            vals[ind] = vals[ind = Math.min(ind, gridSize * gridSize - 1)] == null ? values[i] : Double.valueOf(((double)numPoints[ind] * vals[ind] + values[i]) / (double)(numPoints[ind] + 1));
            int n = ind;
            numPoints[n] = numPoints[n] + 1;
        }
        int sizeG = (int)Math.floor(Math.sqrt(vals.length));
        double[][] ret = new double[sizeG][sizeG];
        for (int i = 0; i < ret.length; ++i) {
            for (int j = 0; j < ret.length; ++j) {
                ret[i][j] = vals[i * ret.length + j] != null ? vals[i * ret.length + j] : Double.NaN;
            }
        }
        return ret;
    }

    public static void getInterpolatedData(double[][] data, ColorMap colormap, BufferedImage image, int alpha) {
        BufferedImage tmp = new BufferedImage(data[0].length, data.length, 2);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                if (Double.isNaN(data[i][j])) continue;
                Color c = colormap.getColor(data[i][j]);
                c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
                tmp.setRGB(j, data.length - 1 - i, c.getRGB());
            }
        }
        Graphics2D bg = image.createGraphics();
        bg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        bg.scale((double)image.getWidth() / (double)tmp.getWidth(), (double)image.getHeight() / (double)tmp.getHeight());
        bg.drawImage((Image)tmp, 0, 0, null);
    }

    public static boolean saveImageToPNG(BufferedImage image, File destFile) {
        try {
            return ImageIO.write((RenderedImage)image, "png", destFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean saveImageToJPG(BufferedImage image, File destFile) {
        try {
            return ImageIO.write((RenderedImage)image, "jpg", destFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static XYZDataType getInterpolatedData(LocationType baseLoc, Vector<Double> xvec, Vector<Double> yvec, Vector<Double> zvec, int targetImageWidth, int targetImageHeight, int gridSize) {
        double[] xMinMaxVal = XYZUtils.calcMinMaxOfVector(xvec);
        double minX = xMinMaxVal[0];
        double maxX = xMinMaxVal[1];
        double[] yMinMaxVal = XYZUtils.calcMinMaxOfVector(yvec);
        double minY = yMinMaxVal[0];
        double maxY = yMinMaxVal[1];
        double[] zMinMaxVal = XYZUtils.calcMinMaxOfVector(zvec);
        double minZ = zMinMaxVal[0];
        double maxZ = zMinMaxVal[1];
        double[] dim = new double[]{maxX - minX, maxY - minY};
        double[] widthHeightScaleVal = XYZUtils.calcWidthHeightScale(dim[0], dim[1], targetImageWidth, targetImageHeight);
        int width = (int)widthHeightScaleVal[0];
        int height = (int)widthHeightScaleVal[1];
        double scale = widthHeightScaleVal[2];
        LocationType topCorner = new LocationType(baseLoc);
        topCorner.translatePosition(maxX, minY, 0.0);
        LocationType centerLocation = new LocationType(baseLoc);
        centerLocation.translatePosition(maxX - (maxX - minX) / 2.0, minY + (maxY - minY) / 2.0, 0.0);
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, maxX - minX, maxY - minY);
        Point2D[] points = new Point2D[xvec.size()];
        for (int i = 0; i < xvec.size(); ++i) {
            points[i] = new Point2D.Double(xvec.get(i) - minX, yvec.get(i) - minY);
        }
        double[][] quadMatrixArray = XYZUtils.discretizeQuadMatrix(gridSize, bounds, points, zvec.toArray(new Double[0]));
        double minZ1 = Double.POSITIVE_INFINITY;
        double maxZ1 = Double.NEGATIVE_INFINITY;
        double[][] arr$ = quadMatrixArray;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] zt1;
            for (double zt : zt1 = arr$[i$]) {
                if (zt == Double.NaN) continue;
                if (zt < minZ1) {
                    minZ1 = zt;
                }
                if (!(zt > maxZ1)) continue;
                maxZ1 = zt;
            }
        }
        for (int i = 0; i < quadMatrixArray.length; ++i) {
            for (int j = 0; j < quadMatrixArray.length; ++j) {
                quadMatrixArray[i][j] = !Double.isNaN(quadMatrixArray[i][j]) ? (quadMatrixArray[i][j] - minZ1) / (maxZ1 - minZ1) : Double.NaN;
            }
        }
        XYZDataType xyzDataType = new XYZDataType();
        xyzDataType.topCornerLoc = topCorner;
        xyzDataType.centerLoc = centerLocation;
        xyzDataType.width = width;
        xyzDataType.height = height;
        xyzDataType.scale = scale;
        xyzDataType.dataSet = quadMatrixArray;
        xyzDataType.minX = minX;
        xyzDataType.maxX = maxX;
        xyzDataType.minY = minY;
        xyzDataType.maxY = maxY;
        xyzDataType.minZ = minZ;
        xyzDataType.maxZ = maxZ;
        return xyzDataType;
    }

    static MapType getAsMapType(BufferedImage image, BufferedImage heightImage, String imageNameId, String mapBaseDir, LocationType centerLocation, double scale, double maxHeight, double maxDepth) {
        File baseMapDir = new File(mapBaseDir);
        baseMapDir.mkdirs();
        String imageFilePath = new File(baseMapDir, imageNameId + ".png").getAbsolutePath();
        String heightImageFilePath = new File(baseMapDir, imageNameId + "-height-map.png").getAbsolutePath();
        String mapFilePath = new File(baseMapDir, "map-" + imageNameId + ".nmap").getAbsolutePath();
        XYZUtils.saveImageToPNG(image, new File(imageFilePath));
        XYZUtils.saveImageToPNG(heightImage, new File(heightImageFilePath));
        MapType mapT = new MapType();
        mapT.setCenterLocation(centerLocation);
        CoordinateSystem cs = new CoordinateSystem();
        cs.setLocation(centerLocation);
        ImageElement imageElement = new ImageElement(MapGroup.getNewInstance((CoordinateSystem)cs), mapT);
        imageElement.setId(imageNameId);
        imageElement.setCenterLocation(centerLocation);
        imageElement.setImageScale(scale);
        imageElement.setImage((Image)image);
        imageElement.setImageFileName(imageFilePath);
        imageElement.setOriginalFilePath(imageElement.getImageFileName());
        imageElement.setBathymetric(true);
        imageElement.setHeightImage((Image)heightImage);
        imageElement.setBathymetricImageFileName(heightImageFilePath);
        imageElement.setMaxHeight(maxHeight);
        imageElement.setMaxDepth(maxDepth);
        imageElement.setTransparency(99);
        mapT.setId("map-" + imageNameId);
        mapT.setName("map-" + imageNameId);
        mapT.setOriginalFilePath(mapFilePath);
        mapT.setHref(mapFilePath);
        imageElement.setParentMap(mapT);
        mapT.addObject((AbstractElement)imageElement);
        mapT.saveFile(mapFilePath);
        return mapT;
    }

    static void drawLegend(Graphics2D g, ColorMap cmap, String name, double scale, String unit, double min, double max) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setTransform(new AffineTransform());
        g.setColor(new Color(255, 255, 255, 100));
        g.fillRoundRect(10, 10, 100, 170, 10, 10);
        ColorBar cb = new ColorBar(1, cmap);
        cb.setSize(15, 80);
        g.setColor(Color.black);
        Font prev = g.getFont();
        g.setFont(new Font("Helvetica", 1, 14));
        g.drawString(name, 15, 25);
        g.setFont(prev);
        g.translate(15, 45);
        cb.paint((Graphics)g);
        g.translate(-10, -15);
        try {
            g.drawString(GuiUtils.getNeptusDecimalFormat((int)2).format(max) + unit, 28, 20);
            g.drawString(GuiUtils.getNeptusDecimalFormat((int)2).format((max + min) / 2.0) + unit, 28, 60);
            g.drawString(GuiUtils.getNeptusDecimalFormat((int)2).format(min) + unit, 28, 100);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
        g.translate(10, 120);
        g.drawLine(0, -3, 0, 3);
        g.drawLine(0, 0, 90, 0);
        g.drawLine(90, -3, 90, 3);
        g.drawString(GuiUtils.getNeptusDecimalFormat((int)2).format(90.0 / scale) + " " + unit, 25, 15);
    }

    static void drawPath(Graphics2D g, double scaleX, double scaleY, double minX, double minY, double timeStep, IMraLogGroup logSource) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setTransform(new AffineTransform());
        g.setColor(new Color(0, 0, 0, 10));
        IMraLog stateParser = logSource.getLog("EstimatedState");
        Point2D.Double lastPt = null;
        IMCMessage stateEntry = stateParser.nextLogEntry();
        LocationType refLoc = LogUtils.getLocation((IMCMessage)stateEntry).convertToAbsoluteLatLonDepth();
        boolean isImc5 = false;
        if (logSource.getLsfIndex().getDefinitions().getVersion().compareTo("5.0.0") >= 0) {
            isImc5 = true;
        }
        while (stateEntry != null) {
            LocationType loc = LogUtils.getLocation((IMCMessage)stateEntry).convertToAbsoluteLatLonDepth();
            double[] xyz = loc.getOffsetFrom(refLoc);
            double north = isImc5 ? xyz[0] : stateEntry.getDouble("x");
            double east = isImc5 ? xyz[1] : stateEntry.getDouble("y");
            Point2D.Double pt = new Point2D.Double((east - minY) * scaleY, (-minX - north) * scaleX);
            if (timeStep == 0.0) {
                g.setColor(new Color(0, 0, 0, 20));
            } else {
                g.setColor(Color.black);
            }
            if (lastPt != null && pt != null) {
                g.draw(new Line2D.Double(lastPt, pt));
            }
            lastPt = pt;
            if (timeStep == 0.0) {
                stateEntry = stateParser.nextLogEntry();
                continue;
            }
            stateParser.advance((long)(timeStep * 1000.0));
            stateEntry = stateParser.nextLogEntry();
        }
    }

    public static void bathymCadiz() throws Exception {
        FileInputStream fis = new FileInputStream("/home/zp/Desktop/grid_5_cadizsub_UTM-29N.xyz");
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        Vector<Double> xvec = new Vector<Double>();
        Vector<Double> yvec = new Vector<Double>();
        Vector<Double> zvec = new Vector<Double>();
        LocationType ref = null;
        String line = br.readLine();
        while (line != null) {
            String[] xt;
            if (!line.startsWith("#") && (xt = line.split("[\t ,]")).length == 3) {
                try {
                    UTMCoordinates utm;
                    double xx = Double.parseDouble(xt[0]);
                    double yy = Double.parseDouble(xt[1]);
                    double zz = Double.parseDouble(xt[2]);
                    if (ref == null) {
                        utm = new UTMCoordinates(xx, yy, 29, 'N');
                        utm.UTMtoLL();
                        ref = new LocationType(utm.getLatitudeDegrees(), utm.getLongitudeDegrees());
                    }
                    utm = new UTMCoordinates(xx, yy, 29, 'N');
                    utm.UTMtoLL();
                    LocationType tmp = new LocationType(utm.getLatitudeDegrees(), utm.getLongitudeDegrees());
                    System.out.println(tmp);
                    double[] offsets = tmp.getOffsetFrom(ref);
                    xvec.add(offsets[0]);
                    yvec.add(offsets[1]);
                    zvec.add(-zz);
                }
                catch (NumberFormatException e) {
                    e.getMessage();
                }
            }
            line = br.readLine();
        }
        br.close();
        int targetImageWidth = 800;
        int targetImageHeight = 600;
        int gridSize = 297;
        XYZDataType xyzData = XYZUtils.getInterpolatedData(ref, xvec, yvec, zvec, targetImageWidth, targetImageHeight, gridSize);
        BufferedImage destination = new BufferedImage(xyzData.width, xyzData.height, 2);
        BufferedImage destination1 = new BufferedImage(xyzData.width, xyzData.height, 2);
        BufferedImage destination2 = new BufferedImage(xyzData.width, xyzData.height, 2);
        double[][] kdkdinv = XYZUtils.invertDataSet(xyzData.dataSet);
        XYZUtils.getInterpolatedData(xyzData.dataSet, ColorMapFactory.createJetColorMap(), destination, 255);
        JLabel lblw = new JLabel(new ImageIcon(destination));
        GuiUtils.testFrame((JComponent)lblw, (String)"", (int)800, (int)600);
        XYZUtils.getInterpolatedData(xyzData.dataSet, ColorMapFactory.createGrayScaleColorMap(), destination1, 255);
        JLabel lblw1 = new JLabel(new ImageIcon(destination1));
        GuiUtils.testFrame((JComponent)lblw1, (String)"", (int)800, (int)600);
        XYZUtils.getInterpolatedData(kdkdinv, ColorMapFactory.createGrayScaleColorMap(), destination2, 255);
        JLabel lblw2 = new JLabel(new ImageIcon(destination2));
        GuiUtils.testFrame((JComponent)lblw2, (String)"", (int)800, (int)600);
        ImageIO.write((RenderedImage)destination, "png", new File("cadiz-jet.png"));
        ImageIO.write((RenderedImage)destination1, "png", new File("cadiz-gray.png"));
        ImageIO.write((RenderedImage)destination2, "png", new File("cadiz-inv-gray.png"));
        MapType mapT = XYZUtils.getAsMapType(destination, destination2, "Cadiz-Bat", ".", xyzData.centerLoc, xyzData.scale, xyzData.maxZ, xyzData.minZ);
        NeptusLog.pub().info((Object)("<###> " + FileUtil.getAsPrettyPrintFormatedXMLString((String)mapT.asXML())));
    }

    public static void main(String[] args) throws Exception {
        XYZUtils.bathymCadiz();
        System.exit(0);
        double[] vec = XYZUtils.calcWidthHeightScale(417.4842522414401, 417.05859590325053, 800, 600);
        NeptusLog.pub().info((Object)("<###> " + vec[0]));
        NeptusLog.pub().info((Object)("<###> " + vec[1]));
        NeptusLog.pub().info((Object)("<###> " + vec[2]));
        FileInputStream fis = new FileInputStream("..\\Batimetria\\batimetria_leixoes.xyz");
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        Vector<Double> xvec = new Vector<Double>();
        Vector<Double> yvec = new Vector<Double>();
        Vector<Double> zvec = new Vector<Double>();
        String line = br.readLine();
        while (line != null) {
            String[] xt;
            if (!line.startsWith("#") && (xt = line.split("[\t ,]")).length == 3) {
                try {
                    double xx = Double.parseDouble(xt[1]);
                    double yy = Double.parseDouble(xt[0]);
                    double zz = Double.parseDouble(xt[2]);
                    xvec.add(xx);
                    yvec.add(yy);
                    zvec.add(-zz);
                }
                catch (NumberFormatException e) {
                    e.getMessage();
                }
            }
            line = br.readLine();
        }
        br.close();
        LocationType baseLoc = new LocationType();
        baseLoc.setLatitudeStr("41N09'35.293''");
        baseLoc.setLongitudeStr("08W41'35.721''");
        baseLoc.translatePosition(-465778.48, -152987.42, 0.0);
        NeptusLog.pub().info((Object)("<###>Base location = " + baseLoc));
        int targetImageWidth = 800;
        int targetImageHeight = 600;
        int gridSize = 297;
        XYZDataType xyzData = XYZUtils.getInterpolatedData(baseLoc, xvec, yvec, zvec, targetImageWidth, targetImageHeight, gridSize);
        BufferedImage destination = new BufferedImage(xyzData.width, xyzData.height, 2);
        BufferedImage destination1 = new BufferedImage(xyzData.width, xyzData.height, 2);
        BufferedImage destination2 = new BufferedImage(xyzData.width, xyzData.height, 2);
        double[][] kdkdinv = XYZUtils.invertDataSet(xyzData.dataSet);
        XYZUtils.getInterpolatedData(xyzData.dataSet, ColorMapFactory.createJetColorMap(), destination, 255);
        JLabel lblw = new JLabel(new ImageIcon(destination));
        GuiUtils.testFrame((JComponent)lblw, (String)"", (int)800, (int)600);
        XYZUtils.getInterpolatedData(xyzData.dataSet, ColorMapFactory.createGrayScaleColorMap(), destination1, 255);
        JLabel lblw1 = new JLabel(new ImageIcon(destination1));
        GuiUtils.testFrame((JComponent)lblw1, (String)"", (int)800, (int)600);
        XYZUtils.getInterpolatedData(kdkdinv, ColorMapFactory.createGrayScaleColorMap(), destination2, 255);
        JLabel lblw2 = new JLabel(new ImageIcon(destination2));
        GuiUtils.testFrame((JComponent)lblw2, (String)"", (int)800, (int)600);
        ImageIO.write((RenderedImage)destination, "png", new File("bathyLeixoes-jet.png"));
        ImageIO.write((RenderedImage)destination1, "png", new File("bathyLeixoes-gray.png"));
        ImageIO.write((RenderedImage)destination2, "png", new File("bathyLeixoes-inv-gray.png"));
        MapType mapT = XYZUtils.getAsMapType(destination, destination2, "APDL-Bat", ".", xyzData.centerLoc, xyzData.scale, xyzData.maxZ, xyzData.minZ);
        NeptusLog.pub().info((Object)("<###> " + FileUtil.getAsPrettyPrintFormatedXMLString((String)mapT.asXML())));
    }
}

