/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.rtplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.plots.ScriptEnvironment;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.rtplot.RealTimePlotSettings;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;

@PluginDescription(name="Real-Time plot", icon="pt/lsts/neptus/plugins/rtplot/rtplot.png")
@Popup(accelerator=85, pos=Popup.POSITION.CENTER, height=300, width=300)
public class RealTimePlot
extends ConsolePanel
implements IPeriodicUpdates,
ConfigurationListener {
    private static final long serialVersionUID = 1L;
    private JFreeChart timeSeriesChart = null;
    private TimeSeriesCollection tsc = new TimeSeriesCollection();
    private JButton btnEdit;
    private JButton btnClear;
    private LinkedHashMap<String, Script> scripts = new LinkedHashMap();
    private Context context;
    private LinkedHashMap<String, Global> vehicleContexts = new LinkedHashMap();
    private ScriptEnvironment env = new ScriptEnvironment();
    private JPanel bottom;
    @NeptusProperty(name="Periodicity (milliseconds)")
    public int periodicity = 1000;
    @NeptusProperty(name="Maximum Number of points")
    public int numPoints = 100;
    @NeptusProperty(name="Traces Script")
    public String traceScripts = "roll: ${EstimatedState.phi} * 180 / Math.PI;\npitch: ${EstimatedState.theta} * 180 / Math.PI;\nyaw: ${EstimatedState.psi} * 180 / Math.PI";
    private String traceScriptsBefore = "";

    public RealTimePlot(ConsoleLayout c) {
        super(c);
        this.setLayout(new BorderLayout());
        this.bottom = new JPanel(new GridLayout(1, 0));
        this.btnEdit = new JButton(I18n.text((String)"Settings"));
        this.bottom.add(this.btnEdit);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RealTimePlotSettings.editSettings(RealTimePlot.this);
            }
        });
        this.btnClear = new JButton(I18n.text((String)"Clear"));
        this.bottom.add(this.btnClear);
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RealTimePlot.this.tsc.removeAllSeries();
            }
        });
        this.add(this.bottom, "South");
        this.timeSeriesChart = ChartFactory.createTimeSeriesChart(null, null, null, (XYDataset)this.tsc, (boolean)true, (boolean)true, (boolean)true);
        this.add((Component)new ChartPanel(this.timeSeriesChart), "Center");
        this.context = Context.enter();
        this.context.initStandardObjects();
    }

    public long millisBetweenUpdates() {
        return this.periodicity;
    }

    public boolean update() {
        if (!this.isShowing()) {
            return true;
        }
        Set<String> traces = this.scripts.keySet();
        for (ImcSystem sys : ImcSystemsHolder.lookupActiveSystemVehicles()) {
            Global global;
            this.context = Context.enter();
            this.context.initStandardObjects();
            if (!this.vehicleContexts.containsKey(sys.getName())) {
                global = new Global(this.context);
                Object o = Context.javaToJS((Object)ImcMsgManager.getManager().getState(sys.getName()), (Scriptable)global);
                ScriptableObject.putProperty((Scriptable)global, (String)"state", (Object)o);
                ScriptableObject.putProperty((Scriptable)global, (String)"env", (Object)this.env);
                this.vehicleContexts.put(sys.getName(), global);
            }
            global = this.vehicleContexts.get(sys.getName());
            for (String s : traces) {
                try {
                    String seriesName;
                    TimeSeries ts;
                    Object o = this.scripts.get(s).exec(this.context, (Scriptable)global);
                    if (o instanceof NativeJavaObject) {
                        o = ((NativeJavaObject)o).unwrap();
                    }
                    if ((ts = this.tsc.getSeries(seriesName = sys.getName() + "." + s)) == null) {
                        ts = new TimeSeries(seriesName);
                        ts.setMaximumItemCount(this.numPoints);
                        this.tsc.addSeries(ts);
                    }
                    ts.addOrUpdate((RegularTimePeriod)new Millisecond(new Date(System.currentTimeMillis())), Double.parseDouble(o.toString()));
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e);
                }
            }
            Context.exit();
        }
        return true;
    }

    public void propertiesChanged() {
        if (!this.traceScripts.equals(this.traceScriptsBefore)) {
            this.tsc.removeAllSeries();
            this.scripts.clear();
            try {
                this.parseScript();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.traceScriptsBefore = this.traceScripts;
    }

    protected void parseScript() throws Exception {
        Pattern p = Pattern.compile("([\\w ]+):(.*)");
        for (String line : this.traceScripts.split("\n")) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            String ss = m.group(2);
            ss = ss.replaceAll("\\$\\{([^\\}]*)\\}", "state.expr(\"$1\")");
            String name = m.group(1);
            Context.enter();
            Script sc = this.context.compileString(ss, name, 1, null);
            Context.exit();
            this.scripts.put(name, sc);
        }
        this.tsc.removeAllSeries();
    }

    public void initSubPanel() {
        this.traceScriptsBefore = this.traceScripts;
        this.propertiesChanged();
    }

    public void cleanSubPanel() {
    }
}

