/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.rtplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.rtplot.RealTimePlot;
import pt.lsts.neptus.util.GuiUtils;

public class RealTimePlotSettings
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JEditorPane editorPane = new JEditorPane();
    protected JFormattedTextField periodicityField = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat((int)0));
    protected JFormattedTextField numPointsField = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat((int)0));

    public RealTimePlotSettings(RealTimePlot plot) {
        this.setLayout(new BorderLayout(3, 3));
        this.add((Component)new JScrollPane(this.editorPane), "Center");
        JPanel bottom = new JPanel(new GridLayout(0, 2));
        bottom.add(new JLabel(I18n.text((String)"Periodicity (milliseconds)") + ":"));
        bottom.add(this.periodicityField);
        bottom.add(new JLabel(I18n.text((String)"Trace points") + ":"));
        bottom.add(this.numPointsField);
        this.add((Component)bottom, "South");
        this.editorPane.setText(plot.traceScripts);
        this.periodicityField.setText("" + plot.periodicity);
        this.numPointsField.setText("" + plot.numPoints);
    }

    public static void editSettings(final RealTimePlot plot) {
        final JDialog dialog = new JDialog((Frame)plot.getConsole());
        final RealTimePlotSettings settings = new RealTimePlotSettings(plot);
        dialog.getContentPane().add(settings);
        dialog.setSize(400, 400);
        dialog.setModal(true);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int op = GuiUtils.confirmDialog((Component)dialog, (String)I18n.text((String)"Select an Option"), (String)I18n.text((String)"Do you wish to save changes?"));
                if (op == 0) {
                    plot.periodicity = Integer.parseInt(settings.periodicityField.getText());
                    plot.numPoints = Integer.parseInt(settings.numPointsField.getText());
                    plot.traceScripts = settings.editorPane.getText();
                    plot.propertiesChanged();
                    dialog.dispose();
                } else if (op == 1) {
                    dialog.dispose();
                }
            }
        });
        GuiUtils.centerParent((Window)dialog, (Window)plot.getConsole());
        dialog.setVisible(true);
    }
}

