/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.seastate;

import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.GpsFix;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.imc.lsf.LsfIterator;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.MRATimeSeriesPlot;

public class SeaStatePlot
extends MRATimeSeriesPlot {
    public SeaStatePlot(MRAPanel panel) {
        super(panel);
    }

    public boolean canBeApplied(LsfIndex index) {
        LsfIterator it = index.getIterator(GpsFix.class, 5000);
        if (it == null) {
            return false;
        }
        for (GpsFix fix : it) {
            if (fix.getSatellites() <= 0) continue;
            return true;
        }
        return false;
    }

    private void addWave(EstimatedState pt1, EstimatedState pt2) {
        double amplitude = Math.abs(pt2.getAlt() - pt1.getAlt());
        double period = pt2.getTimestamp() - pt1.getTimestamp();
        if (period > 10.0 || period < 0.5) {
            return;
        }
        this.addValue(pt2.getTimestampMillis(), pt1.getSourceName() + ".amplitude", amplitude);
        this.addValue(pt2.getTimestampMillis(), pt1.getSourceName() + ".period", period);
        System.out.println("wave from " + pt1.getAlt() + " to " + pt2.getAlt() + " time: " + (pt2.getTimestamp() - pt1.getTimestamp()));
    }

    public void process(LsfIndex source) {
        LsfIterator it = this.index.getIterator(EstimatedState.class, 200);
        boolean ascending = false;
        EstimatedState lastMin = (EstimatedState)it.next();
        while (lastMin.getDepth() > 0.5 && it.hasNext() || lastMin.getVx() > 0.2) {
            lastMin = (EstimatedState)it.next();
        }
        EstimatedState lastMax = lastMin;
        if (lastMin == null || !it.hasNext()) {
            return;
        }
        boolean bl = ascending = ((EstimatedState)it.next()).getAlt() >= lastMin.getAlt();
        while (it.hasNext()) {
            EstimatedState state = (EstimatedState)it.next();
            if (state.getDepth() > 0.5 || state.getVx() > 0.2 || state.getAlt() == -1.0) continue;
            if (ascending) {
                if (state.getAlt() >= lastMax.getAlt()) {
                    lastMax = state;
                    continue;
                }
                this.addWave(lastMin, lastMax);
                ascending = false;
                lastMin = lastMax;
                continue;
            }
            if (state.getAlt() <= lastMin.getAlt()) {
                lastMin = state;
                continue;
            }
            this.addWave(lastMax, lastMin);
            ascending = true;
            lastMax = lastMin;
        }
    }
}

