/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.leds;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.LedBrightness;
import pt.lsts.imc.QueryLedBrightness;
import pt.lsts.imc.SetLedBrightness;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.leds.LedsSlider;
import pt.lsts.neptus.plugins.leds.LedsUtils;
import pt.lsts.neptus.plugins.leds.PictureComponent;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.util.GuiUtils;

@Popup(pos=Popup.POSITION.TOP_LEFT, width=300, height=530, accelerator=68)
@PluginDescription(author="hfq", description="Panel that enables setting up leds brightness", name="Leds Control Panel", version="0.1", icon="images/menus/tip.png")
public class LedsControlPanel
extends ConsolePanel
implements IPeriodicUpdates,
ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="Periodicity (milliseconds)", description="Set update periodicity in miliseconds", editable=true)
    public int periodicity = 1000;
    private ConsoleLayout console;
    protected LedsSlider slider1;
    protected LedsSlider slider2;
    protected LedsSlider slider3;
    protected LedsSlider slider4;
    protected JPanel checkBoxPanel;
    protected JCheckBox checkBoxSetAllLeds;
    protected PictureComponent picComp;
    protected int sliderNumComp = 0;
    protected boolean allLedsToBeSet = false;
    protected LinkedHashMap<String, SetLedBrightness> msgsSetLeds = new LinkedHashMap();
    protected LinkedHashMap<String, QueryLedBrightness> msgsQueryLeds = new LinkedHashMap();

    public LedsControlPanel(ConsoleLayout console) {
        super(console);
        this.console = console;
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.removeAll();
        this.setOpaque(true);
        this.setResizable(true);
        this.initMsgMapping();
    }

    private void initMsgMapping() {
        for (int i = 0; i < 12; ++i) {
            SetLedBrightness setMsg = new SetLedBrightness();
            setMsg.setName(LedsUtils.ledNames[i]);
            this.msgsSetLeds.put(LedsUtils.ledNames[i], setMsg);
            QueryLedBrightness queryMsg = new QueryLedBrightness();
            queryMsg.setName(LedsUtils.ledNames[i]);
            this.msgsQueryLeds.put(LedsUtils.ledNames[i], queryMsg);
        }
    }

    private void createPanel() {
        this.slider1 = new LedsSlider(1, this);
        this.slider2 = new LedsSlider(2, this);
        this.slider3 = new LedsSlider(3, this);
        this.slider4 = new LedsSlider(4, this);
        this.add(this.slider1, "w 100%, wrap");
        this.add(this.slider2, "w 100%, wrap");
        this.add(this.slider3, "w 100%, wrap");
        this.add(this.slider4, "w 100%, wrap");
        this.checkBoxPanel = new JPanel();
        this.setPropertiesCheckBox();
        this.add(this.checkBoxPanel, "w 100%, wrap");
        this.picComp = new PictureComponent((JComponent)((Object)this));
        this.add(this.picComp, "w 100%, wrap");
    }

    private void setPropertiesCheckBox() {
        this.checkBoxPanel.setLayout((LayoutManager)new MigLayout());
        this.checkBoxPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 1, 0, 0)));
        this.checkBoxPanel.setOpaque(false);
        this.checkBoxSetAllLeds = new JCheckBox("Set up all Leds");
        this.checkBoxSetAllLeds.setName("Set all Leds");
        this.checkBoxSetAllLeds.setMnemonic(65);
        this.checkBoxSetAllLeds.setSelected(false);
        this.checkBoxSetAllLeds.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        this.checkBoxSetAllLeds.setOpaque(false);
        this.checkBoxSetAllLeds.addItemListener(this);
        this.checkBoxPanel.add((Component)this.checkBoxSetAllLeds, "wrap");
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D graphic2d = (Graphics2D)g;
        Color color1 = this.getBackground();
        Color color2 = Color.DARK_GRAY;
        GradientPaint gradPaint = new GradientPaint(0.0f, 0.0f, color1, this.getWidth(), this.getHeight(), color2);
        graphic2d.setPaint(gradPaint);
        graphic2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void initSubPanel() {
        this.createPanel();
        Border panEdge = BorderFactory.createEmptyBorder(0, 10, 10, 10);
        this.setBorder(panEdge);
        this.console.addMainVehicleListener((MainVehicleChangeListener)this);
        ImcMsgManager.getManager().addListener((MessageListener)this);
    }

    public void cleanSubPanel() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void printMsgMapping() {
        NeptusLog.pub().info((Object)"Led brightness class id: 314");
        NeptusLog.pub().info((Object)"Query Led class id  313");
        for (Map.Entry<String, SetLedBrightness> entry : this.msgsSetLeds.entrySet()) {
            NeptusLog.pub().info((Object)("Key: " + entry.getKey() + " Value: " + entry.getValue()));
        }
    }

    public long millisBetweenUpdates() {
        return this.periodicity;
    }

    public boolean update() {
        for (Map.Entry<String, QueryLedBrightness> entry : this.msgsQueryLeds.entrySet()) {
            QueryLedBrightness msg = this.msgsQueryLeds.get(entry.getKey());
            this.send((IMCMessage)msg);
        }
        return true;
    }

    @Subscribe
    public void consume(LedBrightness msg) {
        try {
            String name = msg.getName();
            short i = msg.getValue();
            NeptusLog.pub().info((Object)("value of brightness on led " + name + ": " + i));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        LedsControlPanel lcp = new LedsControlPanel(null);
        lcp.printMsgMapping();
        Border panEdge = BorderFactory.createEmptyBorder(0, 10, 10, 10);
        lcp.setBorder(panEdge);
        lcp.createPanel();
        GuiUtils.testFrame((JComponent)((Object)lcp), (String)("Test" + lcp.getClass().getSimpleName()), (int)300, (int)530);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.allLedsToBeSet) {
            this.allLedsToBeSet = false;
        } else {
            this.allLedsToBeSet = true;
            this.sliderNumComp = 5;
        }
    }
}

