/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.leds;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.leds.LedsControlPanel;
import pt.lsts.neptus.plugins.leds.LedsUtils;

public class LedsSlider
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private LedsControlPanel parent;
    private JSlider slider;
    private int sliderNumber = 0;
    private int sliderValue = 0;
    private JTextField sliderTextField;
    private Border loweredetched;
    private TitledBorder titled;
    private JPanel collectionLedsPanel;
    private JLabel led1Label;
    private JTextField led1;
    private JLabel led2Label;
    private JTextField led2;
    private JLabel led3Label;
    private JTextField led3;

    public LedsSlider(int sliderNumber, LedsControlPanel parent) {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.parent = parent;
        this.sliderNumber = sliderNumber;
        this.setOpaque(false);
        this.setSize(1, 0);
        this.createBorder();
        this.createSlider();
        this.createSliderTextField();
    }

    private void createBorder() {
        this.loweredetched = BorderFactory.createLoweredBevelBorder();
        this.titled = BorderFactory.createTitledBorder(this.loweredetched, I18n.text((String)"Leds Group ") + String.valueOf(this.sliderNumber));
        this.titled.setTitleJustification(1);
        this.titled.setTitlePosition(0);
        this.setBorder(this.titled);
    }

    public void createSlider() {
        this.slider = new JSlider(0, 0, 100, 0);
        this.slider.setValue(0);
        this.slider.setMajorTickSpacing(20);
        this.slider.setMinorTickSpacing(1);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setCursor(new Cursor(12));
        this.slider.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        this.slider.setToolTipText(I18n.text((String)"Leds Group ") + String.valueOf(this.sliderNumber) + I18n.text((String)" Brightness Controller"));
        this.slider.setFont(new Font("Serif", 2, 10));
        this.slider.setOpaque(false);
        this.slider.addChangeListener(this);
        this.add(this.slider);
    }

    private void createSliderTextField() {
        this.sliderTextField = new JTextField();
        this.sliderTextField.setColumns(3);
        this.sliderTextField.setCursor(new Cursor(2));
        this.sliderTextField.setText(String.valueOf(this.sliderValue));
        this.sliderTextField.setEditable(false);
        this.sliderTextField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        this.add(this.sliderTextField);
    }

    protected void createTextFieldsForGroup() {
        this.collectionLedsPanel = new JPanel();
        this.collectionLedsPanel.setLayout((LayoutManager)new MigLayout());
        this.collectionLedsPanel.setOpaque(false);
        this.collectionLedsPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.collectionLedsPanel.setName(String.valueOf(this.sliderNumber));
        this.led1Label = new JLabel();
        this.led2Label = new JLabel();
        this.led3Label = new JLabel();
        this.setPropertiesForLedsLabel(this.led1Label, this.led2Label, this.led3Label);
        this.led1 = new JTextField();
        this.led2 = new JTextField();
        this.led3 = new JTextField();
        this.setPropertiesForLedsTextField(this.led1, this.led2, this.led3);
        this.collectionLedsPanel.add(this.led1Label);
        this.collectionLedsPanel.add(this.led1);
        this.collectionLedsPanel.add(this.led2Label);
        this.collectionLedsPanel.add(this.led2);
        this.collectionLedsPanel.add(this.led3Label);
        this.collectionLedsPanel.add(this.led3);
        this.add(this.collectionLedsPanel);
    }

    private void setPropertiesForLedsLabel(JLabel label1, JLabel label2, JLabel label3) {
        label1.setFont(new Font("Serif", 3, 9));
        label1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 1));
        label1.setOpaque(false);
        label2.setFont(new Font("Serif", 3, 9));
        label2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 1));
        label2.setOpaque(false);
        label3.setFont(new Font("Serif", 3, 9));
        label3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 1));
        label3.setOpaque(false);
        switch (this.sliderNumber) {
            case 1: {
                label1.setText(I18n.text((String)LedsUtils.ledNames[0]));
                label2.setText(I18n.text((String)LedsUtils.ledNames[1]));
                label3.setText(I18n.text((String)LedsUtils.ledNames[2]));
                break;
            }
            case 2: {
                label1.setText(I18n.text((String)LedsUtils.ledNames[3]));
                label2.setText(I18n.text((String)LedsUtils.ledNames[4]));
                label3.setText(I18n.text((String)LedsUtils.ledNames[5]));
                break;
            }
            case 3: {
                label1.setText(I18n.text((String)LedsUtils.ledNames[6]));
                label2.setText(I18n.text((String)LedsUtils.ledNames[7]));
                label3.setText(I18n.text((String)LedsUtils.ledNames[8]));
                break;
            }
            case 4: {
                label1.setText(I18n.text((String)LedsUtils.ledNames[9]));
                label2.setText(I18n.text((String)LedsUtils.ledNames[10]));
                label3.setText(I18n.text((String)LedsUtils.ledNames[11]));
            }
        }
    }

    private void setPropertiesForLedsTextField(JTextField text1, JTextField text2, JTextField text3) {
        text1.setColumns(3);
        text1.setEditable(false);
        text1.setText(String.valueOf(0));
        text2.setColumns(3);
        text2.setEditable(false);
        text2.setText(String.valueOf(0));
        text3.setColumns(3);
        text3.setEditable(false);
        text3.setText(String.valueOf(0));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!this.parent.allLedsToBeSet) {
            if (!source.getValueIsAdjusting()) {
                this.sliderValue = source.getValue();
                this.sliderTextField.setText(String.valueOf(this.sliderValue));
                this.sendBrightnessMsgs();
            } else {
                this.sliderValue = source.getValue();
                this.sliderTextField.setText(String.valueOf(this.sliderValue));
            }
            if (this.sliderNumber != this.parent.sliderNumComp) {
                this.parent.picComp.updatePicture(this.sliderNumber);
            }
            this.parent.sliderNumComp = this.sliderNumber;
        } else {
            if (!source.getValueIsAdjusting()) {
                this.sliderValue = source.getValue();
                this.sliderTextField.setText(String.valueOf(this.sliderValue));
                for (int i = 1; i <= 4; ++i) {
                    if (this.equals(this.parent.slider1)) {
                        this.parent.slider2.slider.setValue(this.sliderValue);
                        this.parent.slider2.sliderTextField.setText(String.valueOf(this.sliderValue));
                        this.parent.slider3.slider.setValue(this.sliderValue);
                        this.parent.slider3.sliderTextField.setText(String.valueOf(this.sliderValue));
                        this.parent.slider4.slider.setValue(this.sliderValue);
                        this.parent.slider4.sliderTextField.setText(String.valueOf(this.sliderValue));
                        continue;
                    }
                    if (this.equals(this.parent.slider2)) {
                        this.parent.slider1.slider.setValue(this.sliderValue);
                        this.parent.slider1.sliderTextField.setText(String.valueOf(this.sliderValue));
                        this.parent.slider3.slider.setValue(this.sliderValue);
                        this.parent.slider3.sliderTextField.setText(String.valueOf(this.sliderValue));
                        this.parent.slider4.slider.setValue(this.sliderValue);
                        this.parent.slider4.sliderTextField.setText(String.valueOf(this.sliderValue));
                        continue;
                    }
                    if (this.equals(this.parent.slider3)) {
                        this.parent.slider1.slider.setValue(this.sliderValue);
                        this.parent.slider1.sliderTextField.setText(String.valueOf(this.sliderValue));
                        this.parent.slider2.slider.setValue(this.sliderValue);
                        this.parent.slider2.sliderTextField.setText(String.valueOf(this.sliderValue));
                        this.parent.slider4.slider.setValue(this.sliderValue);
                        this.parent.slider4.sliderTextField.setText(String.valueOf(this.sliderValue));
                        continue;
                    }
                    if (!this.equals(this.parent.slider4)) continue;
                    this.parent.slider1.slider.setValue(this.sliderValue);
                    this.parent.slider1.sliderTextField.setText(String.valueOf(this.sliderValue));
                    this.parent.slider2.slider.setValue(this.sliderValue);
                    this.parent.slider2.sliderTextField.setText(String.valueOf(this.sliderValue));
                    this.parent.slider3.slider.setValue(this.sliderValue);
                    this.parent.slider3.sliderTextField.setText(String.valueOf(this.sliderValue));
                }
                this.sendBrightnessMsgs();
            } else {
                this.sliderValue = source.getValue();
                this.sliderTextField.setText(String.valueOf(this.sliderValue));
            }
            this.parent.picComp.updatePicture(this.parent.sliderNumComp);
        }
    }

    private void sendBrightnessMsgs() {
        switch (this.parent.sliderNumComp) {
            case 1: {
                for (int i = 0; i < 3; ++i) {
                    this.parent.msgsSetLeds.get(LedsUtils.ledNames[i]).setValue((short)LedsUtils.convPercToLedsBright(this.sliderValue));
                    this.parent.send((IMCMessage)this.parent.msgsSetLeds.get(LedsUtils.ledNames[i]));
                }
                break;
            }
            case 2: {
                for (int i = 3; i < 6; ++i) {
                    this.parent.msgsSetLeds.get(LedsUtils.ledNames[i]).setValue((short)LedsUtils.convPercToLedsBright(this.sliderValue));
                    this.parent.send((IMCMessage)this.parent.msgsSetLeds.get(LedsUtils.ledNames[i]));
                }
                break;
            }
            case 3: {
                for (int i = 6; i < 9; ++i) {
                    this.parent.msgsSetLeds.get(LedsUtils.ledNames[i]).setValue((short)LedsUtils.convPercToLedsBright(this.sliderValue));
                    this.parent.send((IMCMessage)this.parent.msgsSetLeds.get(LedsUtils.ledNames[i]));
                }
                break;
            }
            case 4: {
                for (int i = 9; i < 12; ++i) {
                    this.parent.msgsSetLeds.get(LedsUtils.ledNames[i]).setValue((short)LedsUtils.convPercToLedsBright(this.sliderValue));
                    this.parent.send((IMCMessage)this.parent.msgsSetLeds.get(LedsUtils.ledNames[i]));
                }
                break;
            }
            case 5: {
                for (int i = 0; i < 12; ++i) {
                    this.parent.msgsSetLeds.get(LedsUtils.ledNames[i]).setValue((short)LedsUtils.convPercToLedsBright(this.sliderValue));
                    this.parent.send((IMCMessage)this.parent.msgsSetLeds.get(LedsUtils.ledNames[i]));
                }
                break;
            }
        }
    }
}

