/*
 * Below is the copyright agreement for IMCJava.
 * 
 * Copyright (c) 2010-2014, Laboratório de Sistemas e Tecnologia Subaquática
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     - Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     - Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     - Neither the names of IMC, LSTS, IMCJava nor the names of its 
 *       contributors may be used to endorse or promote products derived from 
 *       this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL LABORATORIO DE SISTEMAS E TECNOLOGIA SUBAQUATICA
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
package pt.lsts.imc;

/**
 *  IMC Message Received Iridium Message (170)<br/>
 */

public class IridiumMsgRx extends IMCMessage {

	public static final int ID_STATIC = 170;

	public IridiumMsgRx() {
		super(ID_STATIC);
	}

	public IridiumMsgRx(IMCMessage msg) {
		super(ID_STATIC);
		try{
			copyFrom(msg);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	public IridiumMsgRx(IMCDefinition defs) {
		super(defs, ID_STATIC);
	}

	public static IridiumMsgRx create(Object... values) {
		IridiumMsgRx m = new IridiumMsgRx();
		for (int i = 0; i < values.length-1; i+= 2)
			m.setValue(values[i].toString(), values[i+1]);
		return m;
	}

	public static IridiumMsgRx clone(IMCMessage msg) throws Exception {

		IridiumMsgRx m = new IridiumMsgRx();
		if (msg == null)
			return m;
		if(msg.definitions != m.definitions){
			msg = msg.cloneMessage();
			IMCUtil.updateMessage(msg, m.definitions);
		}
		else if (msg.getMgid()!=m.getMgid())
			throw new Exception("Argument "+msg.getAbbrev()+" is incompatible with message "+m.getAbbrev());

		m.getHeader().values.putAll(msg.getHeader().values);
		m.values.putAll(msg.values);
		return m;
	}

	public IridiumMsgRx(String origin, double htime, double lat, double lon, byte[] data) {
		super(ID_STATIC);
		if (origin != null)
			setOrigin(origin);
		setHtime(htime);
		setLat(lat);
		setLon(lon);
		if (data != null)
			setData(data);
	}

	/**
	 *  @return Origin Identifier - plaintext
	 */
	public String getOrigin() {
		return getString("origin");
	}

	/**
	 *  @param origin Origin Identifier
	 */
	public IridiumMsgRx setOrigin(String origin) {
		values.put("origin", origin);
		return this;
	}

	/**
	 *  @return Timestamp (s) - fp64_t
	 */
	public double getHtime() {
		return getDouble("htime");
	}

	/**
	 *  @param htime Timestamp (s)
	 */
	public IridiumMsgRx setHtime(double htime) {
		values.put("htime", htime);
		return this;
	}

	/**
	 *  @return Latitude Reference (rad) - fp64_t
	 */
	public double getLat() {
		return getDouble("lat");
	}

	/**
	 *  @param lat Latitude Reference (rad)
	 */
	public IridiumMsgRx setLat(double lat) {
		values.put("lat", lat);
		return this;
	}

	/**
	 *  @return Longitude Reference (rad) - fp64_t
	 */
	public double getLon() {
		return getDouble("lon");
	}

	/**
	 *  @param lon Longitude Reference (rad)
	 */
	public IridiumMsgRx setLon(double lon) {
		values.put("lon", lon);
		return this;
	}

	/**
	 *  @return Data - rawdata
	 */
	public byte[] getData() {
		return getRawData("data");
	}

	/**
	 *  @param data Data
	 */
	public IridiumMsgRx setData(byte[] data) {
		values.put("data", data);
		return this;
	}

}
