/*
 * Below is the copyright agreement for IMCJava.
 * 
 * Copyright (c) 2010-2014, Laboratório de Sistemas e Tecnologia Subaquática
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     - Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     - Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     - Neither the names of IMC, LSTS, IMCJava nor the names of its 
 *       contributors may be used to endorse or promote products derived from 
 *       this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL LABORATORIO DE SISTEMAS E TECNOLOGIA SUBAQUATICA
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
package pt.lsts.imc.state;

import pt.lsts.imc.*;

public class ImcSysState extends ImcSystemState {

	public ImcSysState() {
		super(IMCDefinition.getInstance());
	}

	/**
	 * Retrieve the last {@link EntityState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link EntityState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EntityState lastEntityState() {
		IMCMessage m = get("EntityState");
		if (m != null)
			try {
				EntityState ms = new EntityState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EntityState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link EntityState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EntityState lastEntityState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.EntityState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				EntityState ms = new EntityState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EntityState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EntityState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EntityState pollEntityState(long timeoutMillis) {
		IMCMessage m = poll("EntityState", timeoutMillis);
		if (m != null)
			try {
				EntityState ms = new EntityState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EntityState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EntityState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EntityState pollEntityState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("EntityState", entityName, timeoutMillis);
		if (m != null)
			try {
				EntityState ms = new EntityState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link QueryEntityState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link QueryEntityState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.QueryEntityState lastQueryEntityState() {
		IMCMessage m = get("QueryEntityState");
		if (m != null)
			try {
				QueryEntityState ms = new QueryEntityState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link QueryEntityState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link QueryEntityState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.QueryEntityState lastQueryEntityState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.QueryEntityState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				QueryEntityState ms = new QueryEntityState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link QueryEntityState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link QueryEntityState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.QueryEntityState pollQueryEntityState(long timeoutMillis) {
		IMCMessage m = poll("QueryEntityState", timeoutMillis);
		if (m != null)
			try {
				QueryEntityState ms = new QueryEntityState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link QueryEntityState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link QueryEntityState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.QueryEntityState pollQueryEntityState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("QueryEntityState", entityName, timeoutMillis);
		if (m != null)
			try {
				QueryEntityState ms = new QueryEntityState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EntityInfo} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link EntityInfo} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EntityInfo lastEntityInfo() {
		IMCMessage m = get("EntityInfo");
		if (m != null)
			try {
				EntityInfo ms = new EntityInfo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EntityInfo} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link EntityInfo} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EntityInfo lastEntityInfo(String entityName) {
		IMCMessage m = get(pt.lsts.imc.EntityInfo.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				EntityInfo ms = new EntityInfo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EntityInfo}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EntityInfo} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EntityInfo pollEntityInfo(long timeoutMillis) {
		IMCMessage m = poll("EntityInfo", timeoutMillis);
		if (m != null)
			try {
				EntityInfo ms = new EntityInfo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EntityInfo} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EntityInfo} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EntityInfo pollEntityInfo(String entityName, long timeoutMillis) {
		IMCMessage m = poll("EntityInfo", entityName, timeoutMillis);
		if (m != null)
			try {
				EntityInfo ms = new EntityInfo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link QueryEntityInfo} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link QueryEntityInfo} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.QueryEntityInfo lastQueryEntityInfo() {
		IMCMessage m = get("QueryEntityInfo");
		if (m != null)
			try {
				QueryEntityInfo ms = new QueryEntityInfo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link QueryEntityInfo} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link QueryEntityInfo} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.QueryEntityInfo lastQueryEntityInfo(String entityName) {
		IMCMessage m = get(pt.lsts.imc.QueryEntityInfo.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				QueryEntityInfo ms = new QueryEntityInfo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link QueryEntityInfo}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link QueryEntityInfo} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.QueryEntityInfo pollQueryEntityInfo(long timeoutMillis) {
		IMCMessage m = poll("QueryEntityInfo", timeoutMillis);
		if (m != null)
			try {
				QueryEntityInfo ms = new QueryEntityInfo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link QueryEntityInfo} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link QueryEntityInfo} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.QueryEntityInfo pollQueryEntityInfo(String entityName, long timeoutMillis) {
		IMCMessage m = poll("QueryEntityInfo", entityName, timeoutMillis);
		if (m != null)
			try {
				QueryEntityInfo ms = new QueryEntityInfo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EntityList} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link EntityList} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EntityList lastEntityList() {
		IMCMessage m = get("EntityList");
		if (m != null)
			try {
				EntityList ms = new EntityList();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EntityList} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link EntityList} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EntityList lastEntityList(String entityName) {
		IMCMessage m = get(pt.lsts.imc.EntityList.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				EntityList ms = new EntityList();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EntityList}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EntityList} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EntityList pollEntityList(long timeoutMillis) {
		IMCMessage m = poll("EntityList", timeoutMillis);
		if (m != null)
			try {
				EntityList ms = new EntityList();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EntityList} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EntityList} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EntityList pollEntityList(String entityName, long timeoutMillis) {
		IMCMessage m = poll("EntityList", entityName, timeoutMillis);
		if (m != null)
			try {
				EntityList ms = new EntityList();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CpuUsage} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link CpuUsage} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CpuUsage lastCpuUsage() {
		IMCMessage m = get("CpuUsage");
		if (m != null)
			try {
				CpuUsage ms = new CpuUsage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CpuUsage} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link CpuUsage} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CpuUsage lastCpuUsage(String entityName) {
		IMCMessage m = get(pt.lsts.imc.CpuUsage.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				CpuUsage ms = new CpuUsage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CpuUsage}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CpuUsage} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CpuUsage pollCpuUsage(long timeoutMillis) {
		IMCMessage m = poll("CpuUsage", timeoutMillis);
		if (m != null)
			try {
				CpuUsage ms = new CpuUsage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CpuUsage} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CpuUsage} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CpuUsage pollCpuUsage(String entityName, long timeoutMillis) {
		IMCMessage m = poll("CpuUsage", entityName, timeoutMillis);
		if (m != null)
			try {
				CpuUsage ms = new CpuUsage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TransportBindings} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link TransportBindings} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TransportBindings lastTransportBindings() {
		IMCMessage m = get("TransportBindings");
		if (m != null)
			try {
				TransportBindings ms = new TransportBindings();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TransportBindings} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link TransportBindings} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TransportBindings lastTransportBindings(String entityName) {
		IMCMessage m = get(pt.lsts.imc.TransportBindings.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				TransportBindings ms = new TransportBindings();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TransportBindings}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TransportBindings} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TransportBindings pollTransportBindings(long timeoutMillis) {
		IMCMessage m = poll("TransportBindings", timeoutMillis);
		if (m != null)
			try {
				TransportBindings ms = new TransportBindings();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TransportBindings} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TransportBindings} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TransportBindings pollTransportBindings(String entityName, long timeoutMillis) {
		IMCMessage m = poll("TransportBindings", entityName, timeoutMillis);
		if (m != null)
			try {
				TransportBindings ms = new TransportBindings();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RestartSystem} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link RestartSystem} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RestartSystem lastRestartSystem() {
		IMCMessage m = get("RestartSystem");
		if (m != null)
			try {
				RestartSystem ms = new RestartSystem();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RestartSystem} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link RestartSystem} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RestartSystem lastRestartSystem(String entityName) {
		IMCMessage m = get(pt.lsts.imc.RestartSystem.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				RestartSystem ms = new RestartSystem();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RestartSystem}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RestartSystem} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RestartSystem pollRestartSystem(long timeoutMillis) {
		IMCMessage m = poll("RestartSystem", timeoutMillis);
		if (m != null)
			try {
				RestartSystem ms = new RestartSystem();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RestartSystem} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RestartSystem} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RestartSystem pollRestartSystem(String entityName, long timeoutMillis) {
		IMCMessage m = poll("RestartSystem", entityName, timeoutMillis);
		if (m != null)
			try {
				RestartSystem ms = new RestartSystem();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DevCalibrationControl} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DevCalibrationControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DevCalibrationControl lastDevCalibrationControl() {
		IMCMessage m = get("DevCalibrationControl");
		if (m != null)
			try {
				DevCalibrationControl ms = new DevCalibrationControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DevCalibrationControl} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DevCalibrationControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DevCalibrationControl lastDevCalibrationControl(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DevCalibrationControl.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DevCalibrationControl ms = new DevCalibrationControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DevCalibrationControl}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DevCalibrationControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DevCalibrationControl pollDevCalibrationControl(long timeoutMillis) {
		IMCMessage m = poll("DevCalibrationControl", timeoutMillis);
		if (m != null)
			try {
				DevCalibrationControl ms = new DevCalibrationControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DevCalibrationControl} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DevCalibrationControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DevCalibrationControl pollDevCalibrationControl(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DevCalibrationControl", entityName, timeoutMillis);
		if (m != null)
			try {
				DevCalibrationControl ms = new DevCalibrationControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DevCalibrationState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DevCalibrationState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DevCalibrationState lastDevCalibrationState() {
		IMCMessage m = get("DevCalibrationState");
		if (m != null)
			try {
				DevCalibrationState ms = new DevCalibrationState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DevCalibrationState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DevCalibrationState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DevCalibrationState lastDevCalibrationState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DevCalibrationState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DevCalibrationState ms = new DevCalibrationState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DevCalibrationState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DevCalibrationState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DevCalibrationState pollDevCalibrationState(long timeoutMillis) {
		IMCMessage m = poll("DevCalibrationState", timeoutMillis);
		if (m != null)
			try {
				DevCalibrationState ms = new DevCalibrationState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DevCalibrationState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DevCalibrationState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DevCalibrationState pollDevCalibrationState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DevCalibrationState", entityName, timeoutMillis);
		if (m != null)
			try {
				DevCalibrationState ms = new DevCalibrationState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EntityActivationState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link EntityActivationState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EntityActivationState lastEntityActivationState() {
		IMCMessage m = get("EntityActivationState");
		if (m != null)
			try {
				EntityActivationState ms = new EntityActivationState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EntityActivationState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link EntityActivationState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EntityActivationState lastEntityActivationState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.EntityActivationState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				EntityActivationState ms = new EntityActivationState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EntityActivationState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EntityActivationState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EntityActivationState pollEntityActivationState(long timeoutMillis) {
		IMCMessage m = poll("EntityActivationState", timeoutMillis);
		if (m != null)
			try {
				EntityActivationState ms = new EntityActivationState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EntityActivationState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EntityActivationState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EntityActivationState pollEntityActivationState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("EntityActivationState", entityName, timeoutMillis);
		if (m != null)
			try {
				EntityActivationState ms = new EntityActivationState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link QueryEntityActivationState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link QueryEntityActivationState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.QueryEntityActivationState lastQueryEntityActivationState() {
		IMCMessage m = get("QueryEntityActivationState");
		if (m != null)
			try {
				QueryEntityActivationState ms = new QueryEntityActivationState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link QueryEntityActivationState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link QueryEntityActivationState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.QueryEntityActivationState lastQueryEntityActivationState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.QueryEntityActivationState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				QueryEntityActivationState ms = new QueryEntityActivationState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link QueryEntityActivationState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link QueryEntityActivationState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.QueryEntityActivationState pollQueryEntityActivationState(long timeoutMillis) {
		IMCMessage m = poll("QueryEntityActivationState", timeoutMillis);
		if (m != null)
			try {
				QueryEntityActivationState ms = new QueryEntityActivationState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link QueryEntityActivationState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link QueryEntityActivationState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.QueryEntityActivationState pollQueryEntityActivationState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("QueryEntityActivationState", entityName, timeoutMillis);
		if (m != null)
			try {
				QueryEntityActivationState ms = new QueryEntityActivationState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VehicleOperationalLimits} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link VehicleOperationalLimits} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VehicleOperationalLimits lastVehicleOperationalLimits() {
		IMCMessage m = get("VehicleOperationalLimits");
		if (m != null)
			try {
				VehicleOperationalLimits ms = new VehicleOperationalLimits();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VehicleOperationalLimits} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link VehicleOperationalLimits} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VehicleOperationalLimits lastVehicleOperationalLimits(String entityName) {
		IMCMessage m = get(pt.lsts.imc.VehicleOperationalLimits.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				VehicleOperationalLimits ms = new VehicleOperationalLimits();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VehicleOperationalLimits}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VehicleOperationalLimits} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VehicleOperationalLimits pollVehicleOperationalLimits(long timeoutMillis) {
		IMCMessage m = poll("VehicleOperationalLimits", timeoutMillis);
		if (m != null)
			try {
				VehicleOperationalLimits ms = new VehicleOperationalLimits();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VehicleOperationalLimits} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VehicleOperationalLimits} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VehicleOperationalLimits pollVehicleOperationalLimits(String entityName, long timeoutMillis) {
		IMCMessage m = poll("VehicleOperationalLimits", entityName, timeoutMillis);
		if (m != null)
			try {
				VehicleOperationalLimits ms = new VehicleOperationalLimits();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link MsgList} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link MsgList} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.MsgList lastMsgList() {
		IMCMessage m = get("MsgList");
		if (m != null)
			try {
				MsgList ms = new MsgList();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link MsgList} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link MsgList} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.MsgList lastMsgList(String entityName) {
		IMCMessage m = get(pt.lsts.imc.MsgList.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				MsgList ms = new MsgList();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link MsgList}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link MsgList} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.MsgList pollMsgList(long timeoutMillis) {
		IMCMessage m = poll("MsgList", timeoutMillis);
		if (m != null)
			try {
				MsgList ms = new MsgList();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link MsgList} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link MsgList} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.MsgList pollMsgList(String entityName, long timeoutMillis) {
		IMCMessage m = poll("MsgList", entityName, timeoutMillis);
		if (m != null)
			try {
				MsgList ms = new MsgList();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SimulatedState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SimulatedState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SimulatedState lastSimulatedState() {
		IMCMessage m = get("SimulatedState");
		if (m != null)
			try {
				SimulatedState ms = new SimulatedState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SimulatedState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SimulatedState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SimulatedState lastSimulatedState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SimulatedState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SimulatedState ms = new SimulatedState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SimulatedState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SimulatedState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SimulatedState pollSimulatedState(long timeoutMillis) {
		IMCMessage m = poll("SimulatedState", timeoutMillis);
		if (m != null)
			try {
				SimulatedState ms = new SimulatedState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SimulatedState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SimulatedState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SimulatedState pollSimulatedState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SimulatedState", entityName, timeoutMillis);
		if (m != null)
			try {
				SimulatedState ms = new SimulatedState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LeakSimulation} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link LeakSimulation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LeakSimulation lastLeakSimulation() {
		IMCMessage m = get("LeakSimulation");
		if (m != null)
			try {
				LeakSimulation ms = new LeakSimulation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LeakSimulation} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link LeakSimulation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LeakSimulation lastLeakSimulation(String entityName) {
		IMCMessage m = get(pt.lsts.imc.LeakSimulation.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				LeakSimulation ms = new LeakSimulation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LeakSimulation}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LeakSimulation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LeakSimulation pollLeakSimulation(long timeoutMillis) {
		IMCMessage m = poll("LeakSimulation", timeoutMillis);
		if (m != null)
			try {
				LeakSimulation ms = new LeakSimulation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LeakSimulation} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LeakSimulation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LeakSimulation pollLeakSimulation(String entityName, long timeoutMillis) {
		IMCMessage m = poll("LeakSimulation", entityName, timeoutMillis);
		if (m != null)
			try {
				LeakSimulation ms = new LeakSimulation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UASimulation} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link UASimulation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UASimulation lastUASimulation() {
		IMCMessage m = get("UASimulation");
		if (m != null)
			try {
				UASimulation ms = new UASimulation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UASimulation} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link UASimulation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UASimulation lastUASimulation(String entityName) {
		IMCMessage m = get(pt.lsts.imc.UASimulation.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				UASimulation ms = new UASimulation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UASimulation}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UASimulation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UASimulation pollUASimulation(long timeoutMillis) {
		IMCMessage m = poll("UASimulation", timeoutMillis);
		if (m != null)
			try {
				UASimulation ms = new UASimulation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UASimulation} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UASimulation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UASimulation pollUASimulation(String entityName, long timeoutMillis) {
		IMCMessage m = poll("UASimulation", entityName, timeoutMillis);
		if (m != null)
			try {
				UASimulation ms = new UASimulation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DynamicsSimParam} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DynamicsSimParam} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DynamicsSimParam lastDynamicsSimParam() {
		IMCMessage m = get("DynamicsSimParam");
		if (m != null)
			try {
				DynamicsSimParam ms = new DynamicsSimParam();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DynamicsSimParam} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DynamicsSimParam} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DynamicsSimParam lastDynamicsSimParam(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DynamicsSimParam.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DynamicsSimParam ms = new DynamicsSimParam();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DynamicsSimParam}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DynamicsSimParam} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DynamicsSimParam pollDynamicsSimParam(long timeoutMillis) {
		IMCMessage m = poll("DynamicsSimParam", timeoutMillis);
		if (m != null)
			try {
				DynamicsSimParam ms = new DynamicsSimParam();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DynamicsSimParam} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DynamicsSimParam} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DynamicsSimParam pollDynamicsSimParam(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DynamicsSimParam", entityName, timeoutMillis);
		if (m != null)
			try {
				DynamicsSimParam ms = new DynamicsSimParam();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link StorageUsage} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link StorageUsage} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.StorageUsage lastStorageUsage() {
		IMCMessage m = get("StorageUsage");
		if (m != null)
			try {
				StorageUsage ms = new StorageUsage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link StorageUsage} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link StorageUsage} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.StorageUsage lastStorageUsage(String entityName) {
		IMCMessage m = get(pt.lsts.imc.StorageUsage.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				StorageUsage ms = new StorageUsage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link StorageUsage}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link StorageUsage} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.StorageUsage pollStorageUsage(long timeoutMillis) {
		IMCMessage m = poll("StorageUsage", timeoutMillis);
		if (m != null)
			try {
				StorageUsage ms = new StorageUsage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link StorageUsage} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link StorageUsage} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.StorageUsage pollStorageUsage(String entityName, long timeoutMillis) {
		IMCMessage m = poll("StorageUsage", entityName, timeoutMillis);
		if (m != null)
			try {
				StorageUsage ms = new StorageUsage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CacheControl} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link CacheControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CacheControl lastCacheControl() {
		IMCMessage m = get("CacheControl");
		if (m != null)
			try {
				CacheControl ms = new CacheControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CacheControl} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link CacheControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CacheControl lastCacheControl(String entityName) {
		IMCMessage m = get(pt.lsts.imc.CacheControl.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				CacheControl ms = new CacheControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CacheControl}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CacheControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CacheControl pollCacheControl(long timeoutMillis) {
		IMCMessage m = poll("CacheControl", timeoutMillis);
		if (m != null)
			try {
				CacheControl ms = new CacheControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CacheControl} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CacheControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CacheControl pollCacheControl(String entityName, long timeoutMillis) {
		IMCMessage m = poll("CacheControl", entityName, timeoutMillis);
		if (m != null)
			try {
				CacheControl ms = new CacheControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LoggingControl} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link LoggingControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LoggingControl lastLoggingControl() {
		IMCMessage m = get("LoggingControl");
		if (m != null)
			try {
				LoggingControl ms = new LoggingControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LoggingControl} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link LoggingControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LoggingControl lastLoggingControl(String entityName) {
		IMCMessage m = get(pt.lsts.imc.LoggingControl.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				LoggingControl ms = new LoggingControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LoggingControl}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LoggingControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LoggingControl pollLoggingControl(long timeoutMillis) {
		IMCMessage m = poll("LoggingControl", timeoutMillis);
		if (m != null)
			try {
				LoggingControl ms = new LoggingControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LoggingControl} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LoggingControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LoggingControl pollLoggingControl(String entityName, long timeoutMillis) {
		IMCMessage m = poll("LoggingControl", entityName, timeoutMillis);
		if (m != null)
			try {
				LoggingControl ms = new LoggingControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LogBookEntry} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link LogBookEntry} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LogBookEntry lastLogBookEntry() {
		IMCMessage m = get("LogBookEntry");
		if (m != null)
			try {
				LogBookEntry ms = new LogBookEntry();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LogBookEntry} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link LogBookEntry} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LogBookEntry lastLogBookEntry(String entityName) {
		IMCMessage m = get(pt.lsts.imc.LogBookEntry.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				LogBookEntry ms = new LogBookEntry();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LogBookEntry}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LogBookEntry} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LogBookEntry pollLogBookEntry(long timeoutMillis) {
		IMCMessage m = poll("LogBookEntry", timeoutMillis);
		if (m != null)
			try {
				LogBookEntry ms = new LogBookEntry();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LogBookEntry} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LogBookEntry} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LogBookEntry pollLogBookEntry(String entityName, long timeoutMillis) {
		IMCMessage m = poll("LogBookEntry", entityName, timeoutMillis);
		if (m != null)
			try {
				LogBookEntry ms = new LogBookEntry();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LogBookControl} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link LogBookControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LogBookControl lastLogBookControl() {
		IMCMessage m = get("LogBookControl");
		if (m != null)
			try {
				LogBookControl ms = new LogBookControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LogBookControl} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link LogBookControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LogBookControl lastLogBookControl(String entityName) {
		IMCMessage m = get(pt.lsts.imc.LogBookControl.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				LogBookControl ms = new LogBookControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LogBookControl}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LogBookControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LogBookControl pollLogBookControl(long timeoutMillis) {
		IMCMessage m = poll("LogBookControl", timeoutMillis);
		if (m != null)
			try {
				LogBookControl ms = new LogBookControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LogBookControl} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LogBookControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LogBookControl pollLogBookControl(String entityName, long timeoutMillis) {
		IMCMessage m = poll("LogBookControl", entityName, timeoutMillis);
		if (m != null)
			try {
				LogBookControl ms = new LogBookControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ReplayControl} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link ReplayControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ReplayControl lastReplayControl() {
		IMCMessage m = get("ReplayControl");
		if (m != null)
			try {
				ReplayControl ms = new ReplayControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ReplayControl} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link ReplayControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ReplayControl lastReplayControl(String entityName) {
		IMCMessage m = get(pt.lsts.imc.ReplayControl.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				ReplayControl ms = new ReplayControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ReplayControl}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ReplayControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ReplayControl pollReplayControl(long timeoutMillis) {
		IMCMessage m = poll("ReplayControl", timeoutMillis);
		if (m != null)
			try {
				ReplayControl ms = new ReplayControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ReplayControl} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ReplayControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ReplayControl pollReplayControl(String entityName, long timeoutMillis) {
		IMCMessage m = poll("ReplayControl", entityName, timeoutMillis);
		if (m != null)
			try {
				ReplayControl ms = new ReplayControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ClockControl} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link ClockControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ClockControl lastClockControl() {
		IMCMessage m = get("ClockControl");
		if (m != null)
			try {
				ClockControl ms = new ClockControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ClockControl} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link ClockControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ClockControl lastClockControl(String entityName) {
		IMCMessage m = get(pt.lsts.imc.ClockControl.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				ClockControl ms = new ClockControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ClockControl}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ClockControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ClockControl pollClockControl(long timeoutMillis) {
		IMCMessage m = poll("ClockControl", timeoutMillis);
		if (m != null)
			try {
				ClockControl ms = new ClockControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ClockControl} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ClockControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ClockControl pollClockControl(String entityName, long timeoutMillis) {
		IMCMessage m = poll("ClockControl", entityName, timeoutMillis);
		if (m != null)
			try {
				ClockControl ms = new ClockControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Heartbeat} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Heartbeat} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Heartbeat lastHeartbeat() {
		IMCMessage m = get("Heartbeat");
		if (m != null)
			try {
				Heartbeat ms = new Heartbeat();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Heartbeat} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Heartbeat} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Heartbeat lastHeartbeat(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Heartbeat.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Heartbeat ms = new Heartbeat();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Heartbeat}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Heartbeat} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Heartbeat pollHeartbeat(long timeoutMillis) {
		IMCMessage m = poll("Heartbeat", timeoutMillis);
		if (m != null)
			try {
				Heartbeat ms = new Heartbeat();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Heartbeat} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Heartbeat} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Heartbeat pollHeartbeat(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Heartbeat", entityName, timeoutMillis);
		if (m != null)
			try {
				Heartbeat ms = new Heartbeat();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Announce} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Announce} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Announce lastAnnounce() {
		IMCMessage m = get("Announce");
		if (m != null)
			try {
				Announce ms = new Announce();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Announce} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Announce} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Announce lastAnnounce(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Announce.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Announce ms = new Announce();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Announce}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Announce} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Announce pollAnnounce(long timeoutMillis) {
		IMCMessage m = poll("Announce", timeoutMillis);
		if (m != null)
			try {
				Announce ms = new Announce();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Announce} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Announce} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Announce pollAnnounce(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Announce", entityName, timeoutMillis);
		if (m != null)
			try {
				Announce ms = new Announce();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AnnounceService} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link AnnounceService} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AnnounceService lastAnnounceService() {
		IMCMessage m = get("AnnounceService");
		if (m != null)
			try {
				AnnounceService ms = new AnnounceService();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AnnounceService} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link AnnounceService} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AnnounceService lastAnnounceService(String entityName) {
		IMCMessage m = get(pt.lsts.imc.AnnounceService.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				AnnounceService ms = new AnnounceService();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AnnounceService}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AnnounceService} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AnnounceService pollAnnounceService(long timeoutMillis) {
		IMCMessage m = poll("AnnounceService", timeoutMillis);
		if (m != null)
			try {
				AnnounceService ms = new AnnounceService();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AnnounceService} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AnnounceService} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AnnounceService pollAnnounceService(String entityName, long timeoutMillis) {
		IMCMessage m = poll("AnnounceService", entityName, timeoutMillis);
		if (m != null)
			try {
				AnnounceService ms = new AnnounceService();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RSSI} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link RSSI} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RSSI lastRSSI() {
		IMCMessage m = get("RSSI");
		if (m != null)
			try {
				RSSI ms = new RSSI();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RSSI} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link RSSI} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RSSI lastRSSI(String entityName) {
		IMCMessage m = get(pt.lsts.imc.RSSI.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				RSSI ms = new RSSI();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RSSI}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RSSI} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RSSI pollRSSI(long timeoutMillis) {
		IMCMessage m = poll("RSSI", timeoutMillis);
		if (m != null)
			try {
				RSSI ms = new RSSI();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RSSI} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RSSI} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RSSI pollRSSI(String entityName, long timeoutMillis) {
		IMCMessage m = poll("RSSI", entityName, timeoutMillis);
		if (m != null)
			try {
				RSSI ms = new RSSI();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VSWR} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link VSWR} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VSWR lastVSWR() {
		IMCMessage m = get("VSWR");
		if (m != null)
			try {
				VSWR ms = new VSWR();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VSWR} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link VSWR} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VSWR lastVSWR(String entityName) {
		IMCMessage m = get(pt.lsts.imc.VSWR.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				VSWR ms = new VSWR();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VSWR}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VSWR} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VSWR pollVSWR(long timeoutMillis) {
		IMCMessage m = poll("VSWR", timeoutMillis);
		if (m != null)
			try {
				VSWR ms = new VSWR();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VSWR} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VSWR} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VSWR pollVSWR(String entityName, long timeoutMillis) {
		IMCMessage m = poll("VSWR", entityName, timeoutMillis);
		if (m != null)
			try {
				VSWR ms = new VSWR();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LinkLevel} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link LinkLevel} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LinkLevel lastLinkLevel() {
		IMCMessage m = get("LinkLevel");
		if (m != null)
			try {
				LinkLevel ms = new LinkLevel();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LinkLevel} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link LinkLevel} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LinkLevel lastLinkLevel(String entityName) {
		IMCMessage m = get(pt.lsts.imc.LinkLevel.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				LinkLevel ms = new LinkLevel();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LinkLevel}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LinkLevel} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LinkLevel pollLinkLevel(long timeoutMillis) {
		IMCMessage m = poll("LinkLevel", timeoutMillis);
		if (m != null)
			try {
				LinkLevel ms = new LinkLevel();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LinkLevel} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LinkLevel} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LinkLevel pollLinkLevel(String entityName, long timeoutMillis) {
		IMCMessage m = poll("LinkLevel", entityName, timeoutMillis);
		if (m != null)
			try {
				LinkLevel ms = new LinkLevel();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Sms} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Sms} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Sms lastSms() {
		IMCMessage m = get("Sms");
		if (m != null)
			try {
				Sms ms = new Sms();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Sms} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Sms} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Sms lastSms(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Sms.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Sms ms = new Sms();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Sms}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Sms} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Sms pollSms(long timeoutMillis) {
		IMCMessage m = poll("Sms", timeoutMillis);
		if (m != null)
			try {
				Sms ms = new Sms();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Sms} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Sms} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Sms pollSms(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Sms", entityName, timeoutMillis);
		if (m != null)
			try {
				Sms ms = new Sms();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SmsTx} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SmsTx} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SmsTx lastSmsTx() {
		IMCMessage m = get("SmsTx");
		if (m != null)
			try {
				SmsTx ms = new SmsTx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SmsTx} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SmsTx} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SmsTx lastSmsTx(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SmsTx.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SmsTx ms = new SmsTx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SmsTx}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SmsTx} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SmsTx pollSmsTx(long timeoutMillis) {
		IMCMessage m = poll("SmsTx", timeoutMillis);
		if (m != null)
			try {
				SmsTx ms = new SmsTx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SmsTx} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SmsTx} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SmsTx pollSmsTx(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SmsTx", entityName, timeoutMillis);
		if (m != null)
			try {
				SmsTx ms = new SmsTx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SmsRx} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SmsRx} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SmsRx lastSmsRx() {
		IMCMessage m = get("SmsRx");
		if (m != null)
			try {
				SmsRx ms = new SmsRx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SmsRx} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SmsRx} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SmsRx lastSmsRx(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SmsRx.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SmsRx ms = new SmsRx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SmsRx}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SmsRx} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SmsRx pollSmsRx(long timeoutMillis) {
		IMCMessage m = poll("SmsRx", timeoutMillis);
		if (m != null)
			try {
				SmsRx ms = new SmsRx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SmsRx} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SmsRx} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SmsRx pollSmsRx(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SmsRx", entityName, timeoutMillis);
		if (m != null)
			try {
				SmsRx ms = new SmsRx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SmsState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SmsState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SmsState lastSmsState() {
		IMCMessage m = get("SmsState");
		if (m != null)
			try {
				SmsState ms = new SmsState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SmsState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SmsState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SmsState lastSmsState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SmsState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SmsState ms = new SmsState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SmsState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SmsState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SmsState pollSmsState(long timeoutMillis) {
		IMCMessage m = poll("SmsState", timeoutMillis);
		if (m != null)
			try {
				SmsState ms = new SmsState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SmsState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SmsState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SmsState pollSmsState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SmsState", entityName, timeoutMillis);
		if (m != null)
			try {
				SmsState ms = new SmsState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TextMessage} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link TextMessage} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TextMessage lastTextMessage() {
		IMCMessage m = get("TextMessage");
		if (m != null)
			try {
				TextMessage ms = new TextMessage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TextMessage} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link TextMessage} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TextMessage lastTextMessage(String entityName) {
		IMCMessage m = get(pt.lsts.imc.TextMessage.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				TextMessage ms = new TextMessage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TextMessage}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TextMessage} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TextMessage pollTextMessage(long timeoutMillis) {
		IMCMessage m = poll("TextMessage", timeoutMillis);
		if (m != null)
			try {
				TextMessage ms = new TextMessage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TextMessage} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TextMessage} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TextMessage pollTextMessage(String entityName, long timeoutMillis) {
		IMCMessage m = poll("TextMessage", entityName, timeoutMillis);
		if (m != null)
			try {
				TextMessage ms = new TextMessage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link IridiumMsgRx} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link IridiumMsgRx} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.IridiumMsgRx lastIridiumMsgRx() {
		IMCMessage m = get("IridiumMsgRx");
		if (m != null)
			try {
				IridiumMsgRx ms = new IridiumMsgRx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link IridiumMsgRx} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link IridiumMsgRx} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.IridiumMsgRx lastIridiumMsgRx(String entityName) {
		IMCMessage m = get(pt.lsts.imc.IridiumMsgRx.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				IridiumMsgRx ms = new IridiumMsgRx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link IridiumMsgRx}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link IridiumMsgRx} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.IridiumMsgRx pollIridiumMsgRx(long timeoutMillis) {
		IMCMessage m = poll("IridiumMsgRx", timeoutMillis);
		if (m != null)
			try {
				IridiumMsgRx ms = new IridiumMsgRx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link IridiumMsgRx} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link IridiumMsgRx} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.IridiumMsgRx pollIridiumMsgRx(String entityName, long timeoutMillis) {
		IMCMessage m = poll("IridiumMsgRx", entityName, timeoutMillis);
		if (m != null)
			try {
				IridiumMsgRx ms = new IridiumMsgRx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link IridiumMsgTx} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link IridiumMsgTx} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.IridiumMsgTx lastIridiumMsgTx() {
		IMCMessage m = get("IridiumMsgTx");
		if (m != null)
			try {
				IridiumMsgTx ms = new IridiumMsgTx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link IridiumMsgTx} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link IridiumMsgTx} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.IridiumMsgTx lastIridiumMsgTx(String entityName) {
		IMCMessage m = get(pt.lsts.imc.IridiumMsgTx.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				IridiumMsgTx ms = new IridiumMsgTx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link IridiumMsgTx}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link IridiumMsgTx} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.IridiumMsgTx pollIridiumMsgTx(long timeoutMillis) {
		IMCMessage m = poll("IridiumMsgTx", timeoutMillis);
		if (m != null)
			try {
				IridiumMsgTx ms = new IridiumMsgTx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link IridiumMsgTx} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link IridiumMsgTx} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.IridiumMsgTx pollIridiumMsgTx(String entityName, long timeoutMillis) {
		IMCMessage m = poll("IridiumMsgTx", entityName, timeoutMillis);
		if (m != null)
			try {
				IridiumMsgTx ms = new IridiumMsgTx();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link IridiumTxStatus} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link IridiumTxStatus} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.IridiumTxStatus lastIridiumTxStatus() {
		IMCMessage m = get("IridiumTxStatus");
		if (m != null)
			try {
				IridiumTxStatus ms = new IridiumTxStatus();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link IridiumTxStatus} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link IridiumTxStatus} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.IridiumTxStatus lastIridiumTxStatus(String entityName) {
		IMCMessage m = get(pt.lsts.imc.IridiumTxStatus.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				IridiumTxStatus ms = new IridiumTxStatus();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link IridiumTxStatus}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link IridiumTxStatus} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.IridiumTxStatus pollIridiumTxStatus(long timeoutMillis) {
		IMCMessage m = poll("IridiumTxStatus", timeoutMillis);
		if (m != null)
			try {
				IridiumTxStatus ms = new IridiumTxStatus();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link IridiumTxStatus} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link IridiumTxStatus} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.IridiumTxStatus pollIridiumTxStatus(String entityName, long timeoutMillis) {
		IMCMessage m = poll("IridiumTxStatus", entityName, timeoutMillis);
		if (m != null)
			try {
				IridiumTxStatus ms = new IridiumTxStatus();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link GroupMembershipState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link GroupMembershipState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.GroupMembershipState lastGroupMembershipState() {
		IMCMessage m = get("GroupMembershipState");
		if (m != null)
			try {
				GroupMembershipState ms = new GroupMembershipState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link GroupMembershipState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link GroupMembershipState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.GroupMembershipState lastGroupMembershipState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.GroupMembershipState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				GroupMembershipState ms = new GroupMembershipState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link GroupMembershipState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link GroupMembershipState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.GroupMembershipState pollGroupMembershipState(long timeoutMillis) {
		IMCMessage m = poll("GroupMembershipState", timeoutMillis);
		if (m != null)
			try {
				GroupMembershipState ms = new GroupMembershipState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link GroupMembershipState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link GroupMembershipState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.GroupMembershipState pollGroupMembershipState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("GroupMembershipState", entityName, timeoutMillis);
		if (m != null)
			try {
				GroupMembershipState ms = new GroupMembershipState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SystemGroup} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SystemGroup} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SystemGroup lastSystemGroup() {
		IMCMessage m = get("SystemGroup");
		if (m != null)
			try {
				SystemGroup ms = new SystemGroup();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SystemGroup} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SystemGroup} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SystemGroup lastSystemGroup(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SystemGroup.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SystemGroup ms = new SystemGroup();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SystemGroup}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SystemGroup} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SystemGroup pollSystemGroup(long timeoutMillis) {
		IMCMessage m = poll("SystemGroup", timeoutMillis);
		if (m != null)
			try {
				SystemGroup ms = new SystemGroup();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SystemGroup} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SystemGroup} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SystemGroup pollSystemGroup(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SystemGroup", entityName, timeoutMillis);
		if (m != null)
			try {
				SystemGroup ms = new SystemGroup();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LblRange} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link LblRange} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LblRange lastLblRange() {
		IMCMessage m = get("LblRange");
		if (m != null)
			try {
				LblRange ms = new LblRange();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LblRange} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link LblRange} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LblRange lastLblRange(String entityName) {
		IMCMessage m = get(pt.lsts.imc.LblRange.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				LblRange ms = new LblRange();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LblRange}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LblRange} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LblRange pollLblRange(long timeoutMillis) {
		IMCMessage m = poll("LblRange", timeoutMillis);
		if (m != null)
			try {
				LblRange ms = new LblRange();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LblRange} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LblRange} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LblRange pollLblRange(String entityName, long timeoutMillis) {
		IMCMessage m = poll("LblRange", entityName, timeoutMillis);
		if (m != null)
			try {
				LblRange ms = new LblRange();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LblBeacon} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link LblBeacon} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LblBeacon lastLblBeacon() {
		IMCMessage m = get("LblBeacon");
		if (m != null)
			try {
				LblBeacon ms = new LblBeacon();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LblBeacon} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link LblBeacon} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LblBeacon lastLblBeacon(String entityName) {
		IMCMessage m = get(pt.lsts.imc.LblBeacon.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				LblBeacon ms = new LblBeacon();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LblBeacon}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LblBeacon} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LblBeacon pollLblBeacon(long timeoutMillis) {
		IMCMessage m = poll("LblBeacon", timeoutMillis);
		if (m != null)
			try {
				LblBeacon ms = new LblBeacon();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LblBeacon} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LblBeacon} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LblBeacon pollLblBeacon(String entityName, long timeoutMillis) {
		IMCMessage m = poll("LblBeacon", entityName, timeoutMillis);
		if (m != null)
			try {
				LblBeacon ms = new LblBeacon();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LblConfig} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link LblConfig} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LblConfig lastLblConfig() {
		IMCMessage m = get("LblConfig");
		if (m != null)
			try {
				LblConfig ms = new LblConfig();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LblConfig} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link LblConfig} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LblConfig lastLblConfig(String entityName) {
		IMCMessage m = get(pt.lsts.imc.LblConfig.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				LblConfig ms = new LblConfig();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LblConfig}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LblConfig} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LblConfig pollLblConfig(long timeoutMillis) {
		IMCMessage m = poll("LblConfig", timeoutMillis);
		if (m != null)
			try {
				LblConfig ms = new LblConfig();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LblConfig} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LblConfig} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LblConfig pollLblConfig(String entityName, long timeoutMillis) {
		IMCMessage m = poll("LblConfig", entityName, timeoutMillis);
		if (m != null)
			try {
				LblConfig ms = new LblConfig();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AcousticMessage} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link AcousticMessage} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AcousticMessage lastAcousticMessage() {
		IMCMessage m = get("AcousticMessage");
		if (m != null)
			try {
				AcousticMessage ms = new AcousticMessage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AcousticMessage} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link AcousticMessage} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AcousticMessage lastAcousticMessage(String entityName) {
		IMCMessage m = get(pt.lsts.imc.AcousticMessage.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				AcousticMessage ms = new AcousticMessage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AcousticMessage}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AcousticMessage} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AcousticMessage pollAcousticMessage(long timeoutMillis) {
		IMCMessage m = poll("AcousticMessage", timeoutMillis);
		if (m != null)
			try {
				AcousticMessage ms = new AcousticMessage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AcousticMessage} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AcousticMessage} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AcousticMessage pollAcousticMessage(String entityName, long timeoutMillis) {
		IMCMessage m = poll("AcousticMessage", entityName, timeoutMillis);
		if (m != null)
			try {
				AcousticMessage ms = new AcousticMessage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AcousticOperation} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link AcousticOperation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AcousticOperation lastAcousticOperation() {
		IMCMessage m = get("AcousticOperation");
		if (m != null)
			try {
				AcousticOperation ms = new AcousticOperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AcousticOperation} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link AcousticOperation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AcousticOperation lastAcousticOperation(String entityName) {
		IMCMessage m = get(pt.lsts.imc.AcousticOperation.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				AcousticOperation ms = new AcousticOperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AcousticOperation}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AcousticOperation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AcousticOperation pollAcousticOperation(long timeoutMillis) {
		IMCMessage m = poll("AcousticOperation", timeoutMillis);
		if (m != null)
			try {
				AcousticOperation ms = new AcousticOperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AcousticOperation} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AcousticOperation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AcousticOperation pollAcousticOperation(String entityName, long timeoutMillis) {
		IMCMessage m = poll("AcousticOperation", entityName, timeoutMillis);
		if (m != null)
			try {
				AcousticOperation ms = new AcousticOperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AcousticSystemsQuery} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link AcousticSystemsQuery} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AcousticSystemsQuery lastAcousticSystemsQuery() {
		IMCMessage m = get("AcousticSystemsQuery");
		if (m != null)
			try {
				AcousticSystemsQuery ms = new AcousticSystemsQuery();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AcousticSystemsQuery} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link AcousticSystemsQuery} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AcousticSystemsQuery lastAcousticSystemsQuery(String entityName) {
		IMCMessage m = get(pt.lsts.imc.AcousticSystemsQuery.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				AcousticSystemsQuery ms = new AcousticSystemsQuery();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AcousticSystemsQuery}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AcousticSystemsQuery} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AcousticSystemsQuery pollAcousticSystemsQuery(long timeoutMillis) {
		IMCMessage m = poll("AcousticSystemsQuery", timeoutMillis);
		if (m != null)
			try {
				AcousticSystemsQuery ms = new AcousticSystemsQuery();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AcousticSystemsQuery} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AcousticSystemsQuery} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AcousticSystemsQuery pollAcousticSystemsQuery(String entityName, long timeoutMillis) {
		IMCMessage m = poll("AcousticSystemsQuery", entityName, timeoutMillis);
		if (m != null)
			try {
				AcousticSystemsQuery ms = new AcousticSystemsQuery();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AcousticSystems} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link AcousticSystems} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AcousticSystems lastAcousticSystems() {
		IMCMessage m = get("AcousticSystems");
		if (m != null)
			try {
				AcousticSystems ms = new AcousticSystems();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AcousticSystems} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link AcousticSystems} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AcousticSystems lastAcousticSystems(String entityName) {
		IMCMessage m = get(pt.lsts.imc.AcousticSystems.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				AcousticSystems ms = new AcousticSystems();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AcousticSystems}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AcousticSystems} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AcousticSystems pollAcousticSystems(long timeoutMillis) {
		IMCMessage m = poll("AcousticSystems", timeoutMillis);
		if (m != null)
			try {
				AcousticSystems ms = new AcousticSystems();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AcousticSystems} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AcousticSystems} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AcousticSystems pollAcousticSystems(String entityName, long timeoutMillis) {
		IMCMessage m = poll("AcousticSystems", entityName, timeoutMillis);
		if (m != null)
			try {
				AcousticSystems ms = new AcousticSystems();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Rpm} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Rpm} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Rpm lastRpm() {
		IMCMessage m = get("Rpm");
		if (m != null)
			try {
				Rpm ms = new Rpm();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Rpm} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Rpm} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Rpm lastRpm(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Rpm.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Rpm ms = new Rpm();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Rpm}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Rpm} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Rpm pollRpm(long timeoutMillis) {
		IMCMessage m = poll("Rpm", timeoutMillis);
		if (m != null)
			try {
				Rpm ms = new Rpm();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Rpm} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Rpm} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Rpm pollRpm(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Rpm", entityName, timeoutMillis);
		if (m != null)
			try {
				Rpm ms = new Rpm();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Voltage} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Voltage} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Voltage lastVoltage() {
		IMCMessage m = get("Voltage");
		if (m != null)
			try {
				Voltage ms = new Voltage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Voltage} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Voltage} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Voltage lastVoltage(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Voltage.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Voltage ms = new Voltage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Voltage}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Voltage} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Voltage pollVoltage(long timeoutMillis) {
		IMCMessage m = poll("Voltage", timeoutMillis);
		if (m != null)
			try {
				Voltage ms = new Voltage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Voltage} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Voltage} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Voltage pollVoltage(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Voltage", entityName, timeoutMillis);
		if (m != null)
			try {
				Voltage ms = new Voltage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Current} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Current} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Current lastCurrent() {
		IMCMessage m = get("Current");
		if (m != null)
			try {
				Current ms = new Current();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Current} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Current} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Current lastCurrent(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Current.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Current ms = new Current();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Current}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Current} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Current pollCurrent(long timeoutMillis) {
		IMCMessage m = poll("Current", timeoutMillis);
		if (m != null)
			try {
				Current ms = new Current();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Current} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Current} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Current pollCurrent(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Current", entityName, timeoutMillis);
		if (m != null)
			try {
				Current ms = new Current();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link GpsFix} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link GpsFix} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.GpsFix lastGpsFix() {
		IMCMessage m = get("GpsFix");
		if (m != null)
			try {
				GpsFix ms = new GpsFix();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link GpsFix} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link GpsFix} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.GpsFix lastGpsFix(String entityName) {
		IMCMessage m = get(pt.lsts.imc.GpsFix.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				GpsFix ms = new GpsFix();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link GpsFix}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link GpsFix} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.GpsFix pollGpsFix(long timeoutMillis) {
		IMCMessage m = poll("GpsFix", timeoutMillis);
		if (m != null)
			try {
				GpsFix ms = new GpsFix();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link GpsFix} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link GpsFix} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.GpsFix pollGpsFix(String entityName, long timeoutMillis) {
		IMCMessage m = poll("GpsFix", entityName, timeoutMillis);
		if (m != null)
			try {
				GpsFix ms = new GpsFix();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EulerAngles} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link EulerAngles} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EulerAngles lastEulerAngles() {
		IMCMessage m = get("EulerAngles");
		if (m != null)
			try {
				EulerAngles ms = new EulerAngles();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EulerAngles} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link EulerAngles} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EulerAngles lastEulerAngles(String entityName) {
		IMCMessage m = get(pt.lsts.imc.EulerAngles.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				EulerAngles ms = new EulerAngles();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EulerAngles}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EulerAngles} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EulerAngles pollEulerAngles(long timeoutMillis) {
		IMCMessage m = poll("EulerAngles", timeoutMillis);
		if (m != null)
			try {
				EulerAngles ms = new EulerAngles();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EulerAngles} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EulerAngles} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EulerAngles pollEulerAngles(String entityName, long timeoutMillis) {
		IMCMessage m = poll("EulerAngles", entityName, timeoutMillis);
		if (m != null)
			try {
				EulerAngles ms = new EulerAngles();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EulerAnglesDelta} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link EulerAnglesDelta} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EulerAnglesDelta lastEulerAnglesDelta() {
		IMCMessage m = get("EulerAnglesDelta");
		if (m != null)
			try {
				EulerAnglesDelta ms = new EulerAnglesDelta();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EulerAnglesDelta} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link EulerAnglesDelta} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EulerAnglesDelta lastEulerAnglesDelta(String entityName) {
		IMCMessage m = get(pt.lsts.imc.EulerAnglesDelta.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				EulerAnglesDelta ms = new EulerAnglesDelta();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EulerAnglesDelta}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EulerAnglesDelta} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EulerAnglesDelta pollEulerAnglesDelta(long timeoutMillis) {
		IMCMessage m = poll("EulerAnglesDelta", timeoutMillis);
		if (m != null)
			try {
				EulerAnglesDelta ms = new EulerAnglesDelta();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EulerAnglesDelta} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EulerAnglesDelta} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EulerAnglesDelta pollEulerAnglesDelta(String entityName, long timeoutMillis) {
		IMCMessage m = poll("EulerAnglesDelta", entityName, timeoutMillis);
		if (m != null)
			try {
				EulerAnglesDelta ms = new EulerAnglesDelta();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AngularVelocity} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link AngularVelocity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AngularVelocity lastAngularVelocity() {
		IMCMessage m = get("AngularVelocity");
		if (m != null)
			try {
				AngularVelocity ms = new AngularVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AngularVelocity} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link AngularVelocity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AngularVelocity lastAngularVelocity(String entityName) {
		IMCMessage m = get(pt.lsts.imc.AngularVelocity.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				AngularVelocity ms = new AngularVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AngularVelocity}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AngularVelocity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AngularVelocity pollAngularVelocity(long timeoutMillis) {
		IMCMessage m = poll("AngularVelocity", timeoutMillis);
		if (m != null)
			try {
				AngularVelocity ms = new AngularVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AngularVelocity} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AngularVelocity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AngularVelocity pollAngularVelocity(String entityName, long timeoutMillis) {
		IMCMessage m = poll("AngularVelocity", entityName, timeoutMillis);
		if (m != null)
			try {
				AngularVelocity ms = new AngularVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Acceleration} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Acceleration} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Acceleration lastAcceleration() {
		IMCMessage m = get("Acceleration");
		if (m != null)
			try {
				Acceleration ms = new Acceleration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Acceleration} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Acceleration} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Acceleration lastAcceleration(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Acceleration.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Acceleration ms = new Acceleration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Acceleration}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Acceleration} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Acceleration pollAcceleration(long timeoutMillis) {
		IMCMessage m = poll("Acceleration", timeoutMillis);
		if (m != null)
			try {
				Acceleration ms = new Acceleration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Acceleration} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Acceleration} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Acceleration pollAcceleration(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Acceleration", entityName, timeoutMillis);
		if (m != null)
			try {
				Acceleration ms = new Acceleration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link MagneticField} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link MagneticField} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.MagneticField lastMagneticField() {
		IMCMessage m = get("MagneticField");
		if (m != null)
			try {
				MagneticField ms = new MagneticField();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link MagneticField} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link MagneticField} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.MagneticField lastMagneticField(String entityName) {
		IMCMessage m = get(pt.lsts.imc.MagneticField.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				MagneticField ms = new MagneticField();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link MagneticField}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link MagneticField} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.MagneticField pollMagneticField(long timeoutMillis) {
		IMCMessage m = poll("MagneticField", timeoutMillis);
		if (m != null)
			try {
				MagneticField ms = new MagneticField();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link MagneticField} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link MagneticField} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.MagneticField pollMagneticField(String entityName, long timeoutMillis) {
		IMCMessage m = poll("MagneticField", entityName, timeoutMillis);
		if (m != null)
			try {
				MagneticField ms = new MagneticField();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link GroundVelocity} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link GroundVelocity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.GroundVelocity lastGroundVelocity() {
		IMCMessage m = get("GroundVelocity");
		if (m != null)
			try {
				GroundVelocity ms = new GroundVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link GroundVelocity} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link GroundVelocity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.GroundVelocity lastGroundVelocity(String entityName) {
		IMCMessage m = get(pt.lsts.imc.GroundVelocity.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				GroundVelocity ms = new GroundVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link GroundVelocity}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link GroundVelocity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.GroundVelocity pollGroundVelocity(long timeoutMillis) {
		IMCMessage m = poll("GroundVelocity", timeoutMillis);
		if (m != null)
			try {
				GroundVelocity ms = new GroundVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link GroundVelocity} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link GroundVelocity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.GroundVelocity pollGroundVelocity(String entityName, long timeoutMillis) {
		IMCMessage m = poll("GroundVelocity", entityName, timeoutMillis);
		if (m != null)
			try {
				GroundVelocity ms = new GroundVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link WaterVelocity} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link WaterVelocity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.WaterVelocity lastWaterVelocity() {
		IMCMessage m = get("WaterVelocity");
		if (m != null)
			try {
				WaterVelocity ms = new WaterVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link WaterVelocity} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link WaterVelocity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.WaterVelocity lastWaterVelocity(String entityName) {
		IMCMessage m = get(pt.lsts.imc.WaterVelocity.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				WaterVelocity ms = new WaterVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link WaterVelocity}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link WaterVelocity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.WaterVelocity pollWaterVelocity(long timeoutMillis) {
		IMCMessage m = poll("WaterVelocity", timeoutMillis);
		if (m != null)
			try {
				WaterVelocity ms = new WaterVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link WaterVelocity} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link WaterVelocity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.WaterVelocity pollWaterVelocity(String entityName, long timeoutMillis) {
		IMCMessage m = poll("WaterVelocity", entityName, timeoutMillis);
		if (m != null)
			try {
				WaterVelocity ms = new WaterVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VelocityDelta} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link VelocityDelta} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VelocityDelta lastVelocityDelta() {
		IMCMessage m = get("VelocityDelta");
		if (m != null)
			try {
				VelocityDelta ms = new VelocityDelta();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VelocityDelta} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link VelocityDelta} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VelocityDelta lastVelocityDelta(String entityName) {
		IMCMessage m = get(pt.lsts.imc.VelocityDelta.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				VelocityDelta ms = new VelocityDelta();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VelocityDelta}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VelocityDelta} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VelocityDelta pollVelocityDelta(long timeoutMillis) {
		IMCMessage m = poll("VelocityDelta", timeoutMillis);
		if (m != null)
			try {
				VelocityDelta ms = new VelocityDelta();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VelocityDelta} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VelocityDelta} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VelocityDelta pollVelocityDelta(String entityName, long timeoutMillis) {
		IMCMessage m = poll("VelocityDelta", entityName, timeoutMillis);
		if (m != null)
			try {
				VelocityDelta ms = new VelocityDelta();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Distance} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Distance} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Distance lastDistance() {
		IMCMessage m = get("Distance");
		if (m != null)
			try {
				Distance ms = new Distance();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Distance} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Distance} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Distance lastDistance(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Distance.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Distance ms = new Distance();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Distance}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Distance} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Distance pollDistance(long timeoutMillis) {
		IMCMessage m = poll("Distance", timeoutMillis);
		if (m != null)
			try {
				Distance ms = new Distance();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Distance} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Distance} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Distance pollDistance(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Distance", entityName, timeoutMillis);
		if (m != null)
			try {
				Distance ms = new Distance();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Temperature} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Temperature} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Temperature lastTemperature() {
		IMCMessage m = get("Temperature");
		if (m != null)
			try {
				Temperature ms = new Temperature();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Temperature} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Temperature} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Temperature lastTemperature(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Temperature.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Temperature ms = new Temperature();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Temperature}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Temperature} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Temperature pollTemperature(long timeoutMillis) {
		IMCMessage m = poll("Temperature", timeoutMillis);
		if (m != null)
			try {
				Temperature ms = new Temperature();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Temperature} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Temperature} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Temperature pollTemperature(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Temperature", entityName, timeoutMillis);
		if (m != null)
			try {
				Temperature ms = new Temperature();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Pressure} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Pressure} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Pressure lastPressure() {
		IMCMessage m = get("Pressure");
		if (m != null)
			try {
				Pressure ms = new Pressure();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Pressure} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Pressure} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Pressure lastPressure(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Pressure.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Pressure ms = new Pressure();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Pressure}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Pressure} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Pressure pollPressure(long timeoutMillis) {
		IMCMessage m = poll("Pressure", timeoutMillis);
		if (m != null)
			try {
				Pressure ms = new Pressure();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Pressure} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Pressure} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Pressure pollPressure(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Pressure", entityName, timeoutMillis);
		if (m != null)
			try {
				Pressure ms = new Pressure();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Depth} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Depth} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Depth lastDepth() {
		IMCMessage m = get("Depth");
		if (m != null)
			try {
				Depth ms = new Depth();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Depth} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Depth} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Depth lastDepth(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Depth.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Depth ms = new Depth();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Depth}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Depth} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Depth pollDepth(long timeoutMillis) {
		IMCMessage m = poll("Depth", timeoutMillis);
		if (m != null)
			try {
				Depth ms = new Depth();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Depth} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Depth} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Depth pollDepth(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Depth", entityName, timeoutMillis);
		if (m != null)
			try {
				Depth ms = new Depth();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DepthOffset} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DepthOffset} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DepthOffset lastDepthOffset() {
		IMCMessage m = get("DepthOffset");
		if (m != null)
			try {
				DepthOffset ms = new DepthOffset();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DepthOffset} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DepthOffset} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DepthOffset lastDepthOffset(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DepthOffset.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DepthOffset ms = new DepthOffset();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DepthOffset}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DepthOffset} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DepthOffset pollDepthOffset(long timeoutMillis) {
		IMCMessage m = poll("DepthOffset", timeoutMillis);
		if (m != null)
			try {
				DepthOffset ms = new DepthOffset();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DepthOffset} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DepthOffset} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DepthOffset pollDepthOffset(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DepthOffset", entityName, timeoutMillis);
		if (m != null)
			try {
				DepthOffset ms = new DepthOffset();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SoundSpeed} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SoundSpeed} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SoundSpeed lastSoundSpeed() {
		IMCMessage m = get("SoundSpeed");
		if (m != null)
			try {
				SoundSpeed ms = new SoundSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SoundSpeed} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SoundSpeed} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SoundSpeed lastSoundSpeed(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SoundSpeed.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SoundSpeed ms = new SoundSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SoundSpeed}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SoundSpeed} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SoundSpeed pollSoundSpeed(long timeoutMillis) {
		IMCMessage m = poll("SoundSpeed", timeoutMillis);
		if (m != null)
			try {
				SoundSpeed ms = new SoundSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SoundSpeed} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SoundSpeed} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SoundSpeed pollSoundSpeed(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SoundSpeed", entityName, timeoutMillis);
		if (m != null)
			try {
				SoundSpeed ms = new SoundSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link WaterDensity} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link WaterDensity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.WaterDensity lastWaterDensity() {
		IMCMessage m = get("WaterDensity");
		if (m != null)
			try {
				WaterDensity ms = new WaterDensity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link WaterDensity} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link WaterDensity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.WaterDensity lastWaterDensity(String entityName) {
		IMCMessage m = get(pt.lsts.imc.WaterDensity.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				WaterDensity ms = new WaterDensity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link WaterDensity}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link WaterDensity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.WaterDensity pollWaterDensity(long timeoutMillis) {
		IMCMessage m = poll("WaterDensity", timeoutMillis);
		if (m != null)
			try {
				WaterDensity ms = new WaterDensity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link WaterDensity} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link WaterDensity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.WaterDensity pollWaterDensity(String entityName, long timeoutMillis) {
		IMCMessage m = poll("WaterDensity", entityName, timeoutMillis);
		if (m != null)
			try {
				WaterDensity ms = new WaterDensity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Conductivity} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Conductivity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Conductivity lastConductivity() {
		IMCMessage m = get("Conductivity");
		if (m != null)
			try {
				Conductivity ms = new Conductivity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Conductivity} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Conductivity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Conductivity lastConductivity(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Conductivity.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Conductivity ms = new Conductivity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Conductivity}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Conductivity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Conductivity pollConductivity(long timeoutMillis) {
		IMCMessage m = poll("Conductivity", timeoutMillis);
		if (m != null)
			try {
				Conductivity ms = new Conductivity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Conductivity} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Conductivity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Conductivity pollConductivity(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Conductivity", entityName, timeoutMillis);
		if (m != null)
			try {
				Conductivity ms = new Conductivity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Salinity} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Salinity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Salinity lastSalinity() {
		IMCMessage m = get("Salinity");
		if (m != null)
			try {
				Salinity ms = new Salinity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Salinity} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Salinity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Salinity lastSalinity(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Salinity.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Salinity ms = new Salinity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Salinity}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Salinity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Salinity pollSalinity(long timeoutMillis) {
		IMCMessage m = poll("Salinity", timeoutMillis);
		if (m != null)
			try {
				Salinity ms = new Salinity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Salinity} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Salinity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Salinity pollSalinity(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Salinity", entityName, timeoutMillis);
		if (m != null)
			try {
				Salinity ms = new Salinity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link WindSpeed} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link WindSpeed} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.WindSpeed lastWindSpeed() {
		IMCMessage m = get("WindSpeed");
		if (m != null)
			try {
				WindSpeed ms = new WindSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link WindSpeed} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link WindSpeed} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.WindSpeed lastWindSpeed(String entityName) {
		IMCMessage m = get(pt.lsts.imc.WindSpeed.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				WindSpeed ms = new WindSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link WindSpeed}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link WindSpeed} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.WindSpeed pollWindSpeed(long timeoutMillis) {
		IMCMessage m = poll("WindSpeed", timeoutMillis);
		if (m != null)
			try {
				WindSpeed ms = new WindSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link WindSpeed} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link WindSpeed} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.WindSpeed pollWindSpeed(String entityName, long timeoutMillis) {
		IMCMessage m = poll("WindSpeed", entityName, timeoutMillis);
		if (m != null)
			try {
				WindSpeed ms = new WindSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RelativeHumidity} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link RelativeHumidity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RelativeHumidity lastRelativeHumidity() {
		IMCMessage m = get("RelativeHumidity");
		if (m != null)
			try {
				RelativeHumidity ms = new RelativeHumidity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RelativeHumidity} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link RelativeHumidity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RelativeHumidity lastRelativeHumidity(String entityName) {
		IMCMessage m = get(pt.lsts.imc.RelativeHumidity.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				RelativeHumidity ms = new RelativeHumidity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RelativeHumidity}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RelativeHumidity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RelativeHumidity pollRelativeHumidity(long timeoutMillis) {
		IMCMessage m = poll("RelativeHumidity", timeoutMillis);
		if (m != null)
			try {
				RelativeHumidity ms = new RelativeHumidity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RelativeHumidity} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RelativeHumidity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RelativeHumidity pollRelativeHumidity(String entityName, long timeoutMillis) {
		IMCMessage m = poll("RelativeHumidity", entityName, timeoutMillis);
		if (m != null)
			try {
				RelativeHumidity ms = new RelativeHumidity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DevDataText} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DevDataText} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DevDataText lastDevDataText() {
		IMCMessage m = get("DevDataText");
		if (m != null)
			try {
				DevDataText ms = new DevDataText();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DevDataText} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DevDataText} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DevDataText lastDevDataText(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DevDataText.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DevDataText ms = new DevDataText();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DevDataText}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DevDataText} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DevDataText pollDevDataText(long timeoutMillis) {
		IMCMessage m = poll("DevDataText", timeoutMillis);
		if (m != null)
			try {
				DevDataText ms = new DevDataText();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DevDataText} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DevDataText} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DevDataText pollDevDataText(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DevDataText", entityName, timeoutMillis);
		if (m != null)
			try {
				DevDataText ms = new DevDataText();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DevDataBinary} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DevDataBinary} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DevDataBinary lastDevDataBinary() {
		IMCMessage m = get("DevDataBinary");
		if (m != null)
			try {
				DevDataBinary ms = new DevDataBinary();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DevDataBinary} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DevDataBinary} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DevDataBinary lastDevDataBinary(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DevDataBinary.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DevDataBinary ms = new DevDataBinary();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DevDataBinary}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DevDataBinary} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DevDataBinary pollDevDataBinary(long timeoutMillis) {
		IMCMessage m = poll("DevDataBinary", timeoutMillis);
		if (m != null)
			try {
				DevDataBinary ms = new DevDataBinary();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DevDataBinary} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DevDataBinary} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DevDataBinary pollDevDataBinary(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DevDataBinary", entityName, timeoutMillis);
		if (m != null)
			try {
				DevDataBinary ms = new DevDataBinary();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SonarData} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SonarData} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SonarData lastSonarData() {
		IMCMessage m = get("SonarData");
		if (m != null)
			try {
				SonarData ms = new SonarData();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SonarData} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SonarData} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SonarData lastSonarData(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SonarData.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SonarData ms = new SonarData();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SonarData}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SonarData} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SonarData pollSonarData(long timeoutMillis) {
		IMCMessage m = poll("SonarData", timeoutMillis);
		if (m != null)
			try {
				SonarData ms = new SonarData();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SonarData} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SonarData} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SonarData pollSonarData(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SonarData", entityName, timeoutMillis);
		if (m != null)
			try {
				SonarData ms = new SonarData();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Pulse} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Pulse} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Pulse lastPulse() {
		IMCMessage m = get("Pulse");
		if (m != null)
			try {
				Pulse ms = new Pulse();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Pulse} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Pulse} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Pulse lastPulse(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Pulse.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Pulse ms = new Pulse();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Pulse}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Pulse} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Pulse pollPulse(long timeoutMillis) {
		IMCMessage m = poll("Pulse", timeoutMillis);
		if (m != null)
			try {
				Pulse ms = new Pulse();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Pulse} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Pulse} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Pulse pollPulse(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Pulse", entityName, timeoutMillis);
		if (m != null)
			try {
				Pulse ms = new Pulse();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PulseDetectionControl} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PulseDetectionControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PulseDetectionControl lastPulseDetectionControl() {
		IMCMessage m = get("PulseDetectionControl");
		if (m != null)
			try {
				PulseDetectionControl ms = new PulseDetectionControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PulseDetectionControl} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PulseDetectionControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PulseDetectionControl lastPulseDetectionControl(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PulseDetectionControl.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PulseDetectionControl ms = new PulseDetectionControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PulseDetectionControl}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PulseDetectionControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PulseDetectionControl pollPulseDetectionControl(long timeoutMillis) {
		IMCMessage m = poll("PulseDetectionControl", timeoutMillis);
		if (m != null)
			try {
				PulseDetectionControl ms = new PulseDetectionControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PulseDetectionControl} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PulseDetectionControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PulseDetectionControl pollPulseDetectionControl(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PulseDetectionControl", entityName, timeoutMillis);
		if (m != null)
			try {
				PulseDetectionControl ms = new PulseDetectionControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FuelLevel} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link FuelLevel} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FuelLevel lastFuelLevel() {
		IMCMessage m = get("FuelLevel");
		if (m != null)
			try {
				FuelLevel ms = new FuelLevel();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FuelLevel} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link FuelLevel} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FuelLevel lastFuelLevel(String entityName) {
		IMCMessage m = get(pt.lsts.imc.FuelLevel.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				FuelLevel ms = new FuelLevel();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FuelLevel}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FuelLevel} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FuelLevel pollFuelLevel(long timeoutMillis) {
		IMCMessage m = poll("FuelLevel", timeoutMillis);
		if (m != null)
			try {
				FuelLevel ms = new FuelLevel();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FuelLevel} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FuelLevel} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FuelLevel pollFuelLevel(String entityName, long timeoutMillis) {
		IMCMessage m = poll("FuelLevel", entityName, timeoutMillis);
		if (m != null)
			try {
				FuelLevel ms = new FuelLevel();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link GpsNavData} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link GpsNavData} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.GpsNavData lastGpsNavData() {
		IMCMessage m = get("GpsNavData");
		if (m != null)
			try {
				GpsNavData ms = new GpsNavData();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link GpsNavData} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link GpsNavData} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.GpsNavData lastGpsNavData(String entityName) {
		IMCMessage m = get(pt.lsts.imc.GpsNavData.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				GpsNavData ms = new GpsNavData();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link GpsNavData}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link GpsNavData} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.GpsNavData pollGpsNavData(long timeoutMillis) {
		IMCMessage m = poll("GpsNavData", timeoutMillis);
		if (m != null)
			try {
				GpsNavData ms = new GpsNavData();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link GpsNavData} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link GpsNavData} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.GpsNavData pollGpsNavData(String entityName, long timeoutMillis) {
		IMCMessage m = poll("GpsNavData", entityName, timeoutMillis);
		if (m != null)
			try {
				GpsNavData ms = new GpsNavData();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ServoPosition} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link ServoPosition} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ServoPosition lastServoPosition() {
		IMCMessage m = get("ServoPosition");
		if (m != null)
			try {
				ServoPosition ms = new ServoPosition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ServoPosition} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link ServoPosition} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ServoPosition lastServoPosition(String entityName) {
		IMCMessage m = get(pt.lsts.imc.ServoPosition.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				ServoPosition ms = new ServoPosition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ServoPosition}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ServoPosition} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ServoPosition pollServoPosition(long timeoutMillis) {
		IMCMessage m = poll("ServoPosition", timeoutMillis);
		if (m != null)
			try {
				ServoPosition ms = new ServoPosition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ServoPosition} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ServoPosition} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ServoPosition pollServoPosition(String entityName, long timeoutMillis) {
		IMCMessage m = poll("ServoPosition", entityName, timeoutMillis);
		if (m != null)
			try {
				ServoPosition ms = new ServoPosition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DeviceState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DeviceState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DeviceState lastDeviceState() {
		IMCMessage m = get("DeviceState");
		if (m != null)
			try {
				DeviceState ms = new DeviceState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DeviceState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DeviceState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DeviceState lastDeviceState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DeviceState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DeviceState ms = new DeviceState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DeviceState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DeviceState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DeviceState pollDeviceState(long timeoutMillis) {
		IMCMessage m = poll("DeviceState", timeoutMillis);
		if (m != null)
			try {
				DeviceState ms = new DeviceState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DeviceState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DeviceState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DeviceState pollDeviceState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DeviceState", entityName, timeoutMillis);
		if (m != null)
			try {
				DeviceState ms = new DeviceState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link BeamConfig} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link BeamConfig} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.BeamConfig lastBeamConfig() {
		IMCMessage m = get("BeamConfig");
		if (m != null)
			try {
				BeamConfig ms = new BeamConfig();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link BeamConfig} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link BeamConfig} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.BeamConfig lastBeamConfig(String entityName) {
		IMCMessage m = get(pt.lsts.imc.BeamConfig.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				BeamConfig ms = new BeamConfig();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link BeamConfig}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link BeamConfig} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.BeamConfig pollBeamConfig(long timeoutMillis) {
		IMCMessage m = poll("BeamConfig", timeoutMillis);
		if (m != null)
			try {
				BeamConfig ms = new BeamConfig();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link BeamConfig} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link BeamConfig} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.BeamConfig pollBeamConfig(String entityName, long timeoutMillis) {
		IMCMessage m = poll("BeamConfig", entityName, timeoutMillis);
		if (m != null)
			try {
				BeamConfig ms = new BeamConfig();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DataSanity} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DataSanity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DataSanity lastDataSanity() {
		IMCMessage m = get("DataSanity");
		if (m != null)
			try {
				DataSanity ms = new DataSanity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DataSanity} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DataSanity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DataSanity lastDataSanity(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DataSanity.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DataSanity ms = new DataSanity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DataSanity}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DataSanity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DataSanity pollDataSanity(long timeoutMillis) {
		IMCMessage m = poll("DataSanity", timeoutMillis);
		if (m != null)
			try {
				DataSanity ms = new DataSanity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DataSanity} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DataSanity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DataSanity pollDataSanity(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DataSanity", entityName, timeoutMillis);
		if (m != null)
			try {
				DataSanity ms = new DataSanity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RhodamineDye} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link RhodamineDye} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RhodamineDye lastRhodamineDye() {
		IMCMessage m = get("RhodamineDye");
		if (m != null)
			try {
				RhodamineDye ms = new RhodamineDye();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RhodamineDye} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link RhodamineDye} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RhodamineDye lastRhodamineDye(String entityName) {
		IMCMessage m = get(pt.lsts.imc.RhodamineDye.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				RhodamineDye ms = new RhodamineDye();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RhodamineDye}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RhodamineDye} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RhodamineDye pollRhodamineDye(long timeoutMillis) {
		IMCMessage m = poll("RhodamineDye", timeoutMillis);
		if (m != null)
			try {
				RhodamineDye ms = new RhodamineDye();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RhodamineDye} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RhodamineDye} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RhodamineDye pollRhodamineDye(String entityName, long timeoutMillis) {
		IMCMessage m = poll("RhodamineDye", entityName, timeoutMillis);
		if (m != null)
			try {
				RhodamineDye ms = new RhodamineDye();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CrudeOil} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link CrudeOil} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CrudeOil lastCrudeOil() {
		IMCMessage m = get("CrudeOil");
		if (m != null)
			try {
				CrudeOil ms = new CrudeOil();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CrudeOil} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link CrudeOil} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CrudeOil lastCrudeOil(String entityName) {
		IMCMessage m = get(pt.lsts.imc.CrudeOil.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				CrudeOil ms = new CrudeOil();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CrudeOil}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CrudeOil} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CrudeOil pollCrudeOil(long timeoutMillis) {
		IMCMessage m = poll("CrudeOil", timeoutMillis);
		if (m != null)
			try {
				CrudeOil ms = new CrudeOil();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CrudeOil} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CrudeOil} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CrudeOil pollCrudeOil(String entityName, long timeoutMillis) {
		IMCMessage m = poll("CrudeOil", entityName, timeoutMillis);
		if (m != null)
			try {
				CrudeOil ms = new CrudeOil();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FineOil} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link FineOil} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FineOil lastFineOil() {
		IMCMessage m = get("FineOil");
		if (m != null)
			try {
				FineOil ms = new FineOil();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FineOil} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link FineOil} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FineOil lastFineOil(String entityName) {
		IMCMessage m = get(pt.lsts.imc.FineOil.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				FineOil ms = new FineOil();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FineOil}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FineOil} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FineOil pollFineOil(long timeoutMillis) {
		IMCMessage m = poll("FineOil", timeoutMillis);
		if (m != null)
			try {
				FineOil ms = new FineOil();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FineOil} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FineOil} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FineOil pollFineOil(String entityName, long timeoutMillis) {
		IMCMessage m = poll("FineOil", entityName, timeoutMillis);
		if (m != null)
			try {
				FineOil ms = new FineOil();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CameraZoom} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link CameraZoom} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CameraZoom lastCameraZoom() {
		IMCMessage m = get("CameraZoom");
		if (m != null)
			try {
				CameraZoom ms = new CameraZoom();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CameraZoom} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link CameraZoom} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CameraZoom lastCameraZoom(String entityName) {
		IMCMessage m = get(pt.lsts.imc.CameraZoom.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				CameraZoom ms = new CameraZoom();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CameraZoom}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CameraZoom} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CameraZoom pollCameraZoom(long timeoutMillis) {
		IMCMessage m = poll("CameraZoom", timeoutMillis);
		if (m != null)
			try {
				CameraZoom ms = new CameraZoom();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CameraZoom} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CameraZoom} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CameraZoom pollCameraZoom(String entityName, long timeoutMillis) {
		IMCMessage m = poll("CameraZoom", entityName, timeoutMillis);
		if (m != null)
			try {
				CameraZoom ms = new CameraZoom();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SetThrusterActuation} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SetThrusterActuation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SetThrusterActuation lastSetThrusterActuation() {
		IMCMessage m = get("SetThrusterActuation");
		if (m != null)
			try {
				SetThrusterActuation ms = new SetThrusterActuation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SetThrusterActuation} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SetThrusterActuation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SetThrusterActuation lastSetThrusterActuation(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SetThrusterActuation.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SetThrusterActuation ms = new SetThrusterActuation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SetThrusterActuation}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SetThrusterActuation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SetThrusterActuation pollSetThrusterActuation(long timeoutMillis) {
		IMCMessage m = poll("SetThrusterActuation", timeoutMillis);
		if (m != null)
			try {
				SetThrusterActuation ms = new SetThrusterActuation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SetThrusterActuation} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SetThrusterActuation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SetThrusterActuation pollSetThrusterActuation(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SetThrusterActuation", entityName, timeoutMillis);
		if (m != null)
			try {
				SetThrusterActuation ms = new SetThrusterActuation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SetServoPosition} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SetServoPosition} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SetServoPosition lastSetServoPosition() {
		IMCMessage m = get("SetServoPosition");
		if (m != null)
			try {
				SetServoPosition ms = new SetServoPosition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SetServoPosition} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SetServoPosition} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SetServoPosition lastSetServoPosition(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SetServoPosition.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SetServoPosition ms = new SetServoPosition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SetServoPosition}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SetServoPosition} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SetServoPosition pollSetServoPosition(long timeoutMillis) {
		IMCMessage m = poll("SetServoPosition", timeoutMillis);
		if (m != null)
			try {
				SetServoPosition ms = new SetServoPosition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SetServoPosition} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SetServoPosition} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SetServoPosition pollSetServoPosition(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SetServoPosition", entityName, timeoutMillis);
		if (m != null)
			try {
				SetServoPosition ms = new SetServoPosition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SetControlSurfaceDeflection} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SetControlSurfaceDeflection} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SetControlSurfaceDeflection lastSetControlSurfaceDeflection() {
		IMCMessage m = get("SetControlSurfaceDeflection");
		if (m != null)
			try {
				SetControlSurfaceDeflection ms = new SetControlSurfaceDeflection();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SetControlSurfaceDeflection} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SetControlSurfaceDeflection} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SetControlSurfaceDeflection lastSetControlSurfaceDeflection(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SetControlSurfaceDeflection.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SetControlSurfaceDeflection ms = new SetControlSurfaceDeflection();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SetControlSurfaceDeflection}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SetControlSurfaceDeflection} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SetControlSurfaceDeflection pollSetControlSurfaceDeflection(long timeoutMillis) {
		IMCMessage m = poll("SetControlSurfaceDeflection", timeoutMillis);
		if (m != null)
			try {
				SetControlSurfaceDeflection ms = new SetControlSurfaceDeflection();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SetControlSurfaceDeflection} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SetControlSurfaceDeflection} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SetControlSurfaceDeflection pollSetControlSurfaceDeflection(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SetControlSurfaceDeflection", entityName, timeoutMillis);
		if (m != null)
			try {
				SetControlSurfaceDeflection ms = new SetControlSurfaceDeflection();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RemoteActionsRequest} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link RemoteActionsRequest} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RemoteActionsRequest lastRemoteActionsRequest() {
		IMCMessage m = get("RemoteActionsRequest");
		if (m != null)
			try {
				RemoteActionsRequest ms = new RemoteActionsRequest();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RemoteActionsRequest} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link RemoteActionsRequest} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RemoteActionsRequest lastRemoteActionsRequest(String entityName) {
		IMCMessage m = get(pt.lsts.imc.RemoteActionsRequest.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				RemoteActionsRequest ms = new RemoteActionsRequest();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RemoteActionsRequest}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RemoteActionsRequest} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RemoteActionsRequest pollRemoteActionsRequest(long timeoutMillis) {
		IMCMessage m = poll("RemoteActionsRequest", timeoutMillis);
		if (m != null)
			try {
				RemoteActionsRequest ms = new RemoteActionsRequest();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RemoteActionsRequest} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RemoteActionsRequest} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RemoteActionsRequest pollRemoteActionsRequest(String entityName, long timeoutMillis) {
		IMCMessage m = poll("RemoteActionsRequest", entityName, timeoutMillis);
		if (m != null)
			try {
				RemoteActionsRequest ms = new RemoteActionsRequest();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RemoteActions} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link RemoteActions} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RemoteActions lastRemoteActions() {
		IMCMessage m = get("RemoteActions");
		if (m != null)
			try {
				RemoteActions ms = new RemoteActions();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RemoteActions} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link RemoteActions} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RemoteActions lastRemoteActions(String entityName) {
		IMCMessage m = get(pt.lsts.imc.RemoteActions.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				RemoteActions ms = new RemoteActions();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RemoteActions}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RemoteActions} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RemoteActions pollRemoteActions(long timeoutMillis) {
		IMCMessage m = poll("RemoteActions", timeoutMillis);
		if (m != null)
			try {
				RemoteActions ms = new RemoteActions();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RemoteActions} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RemoteActions} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RemoteActions pollRemoteActions(String entityName, long timeoutMillis) {
		IMCMessage m = poll("RemoteActions", entityName, timeoutMillis);
		if (m != null)
			try {
				RemoteActions ms = new RemoteActions();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ButtonEvent} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link ButtonEvent} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ButtonEvent lastButtonEvent() {
		IMCMessage m = get("ButtonEvent");
		if (m != null)
			try {
				ButtonEvent ms = new ButtonEvent();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ButtonEvent} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link ButtonEvent} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ButtonEvent lastButtonEvent(String entityName) {
		IMCMessage m = get(pt.lsts.imc.ButtonEvent.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				ButtonEvent ms = new ButtonEvent();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ButtonEvent}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ButtonEvent} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ButtonEvent pollButtonEvent(long timeoutMillis) {
		IMCMessage m = poll("ButtonEvent", timeoutMillis);
		if (m != null)
			try {
				ButtonEvent ms = new ButtonEvent();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ButtonEvent} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ButtonEvent} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ButtonEvent pollButtonEvent(String entityName, long timeoutMillis) {
		IMCMessage m = poll("ButtonEvent", entityName, timeoutMillis);
		if (m != null)
			try {
				ButtonEvent ms = new ButtonEvent();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LcdControl} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link LcdControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LcdControl lastLcdControl() {
		IMCMessage m = get("LcdControl");
		if (m != null)
			try {
				LcdControl ms = new LcdControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LcdControl} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link LcdControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LcdControl lastLcdControl(String entityName) {
		IMCMessage m = get(pt.lsts.imc.LcdControl.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				LcdControl ms = new LcdControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LcdControl}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LcdControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LcdControl pollLcdControl(long timeoutMillis) {
		IMCMessage m = poll("LcdControl", timeoutMillis);
		if (m != null)
			try {
				LcdControl ms = new LcdControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LcdControl} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LcdControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LcdControl pollLcdControl(String entityName, long timeoutMillis) {
		IMCMessage m = poll("LcdControl", entityName, timeoutMillis);
		if (m != null)
			try {
				LcdControl ms = new LcdControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PowerOperation} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PowerOperation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PowerOperation lastPowerOperation() {
		IMCMessage m = get("PowerOperation");
		if (m != null)
			try {
				PowerOperation ms = new PowerOperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PowerOperation} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PowerOperation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PowerOperation lastPowerOperation(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PowerOperation.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PowerOperation ms = new PowerOperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PowerOperation}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PowerOperation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PowerOperation pollPowerOperation(long timeoutMillis) {
		IMCMessage m = poll("PowerOperation", timeoutMillis);
		if (m != null)
			try {
				PowerOperation ms = new PowerOperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PowerOperation} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PowerOperation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PowerOperation pollPowerOperation(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PowerOperation", entityName, timeoutMillis);
		if (m != null)
			try {
				PowerOperation ms = new PowerOperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PowerChannelControl} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PowerChannelControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PowerChannelControl lastPowerChannelControl() {
		IMCMessage m = get("PowerChannelControl");
		if (m != null)
			try {
				PowerChannelControl ms = new PowerChannelControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PowerChannelControl} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PowerChannelControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PowerChannelControl lastPowerChannelControl(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PowerChannelControl.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PowerChannelControl ms = new PowerChannelControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PowerChannelControl}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PowerChannelControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PowerChannelControl pollPowerChannelControl(long timeoutMillis) {
		IMCMessage m = poll("PowerChannelControl", timeoutMillis);
		if (m != null)
			try {
				PowerChannelControl ms = new PowerChannelControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PowerChannelControl} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PowerChannelControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PowerChannelControl pollPowerChannelControl(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PowerChannelControl", entityName, timeoutMillis);
		if (m != null)
			try {
				PowerChannelControl ms = new PowerChannelControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link QueryPowerChannelState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link QueryPowerChannelState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.QueryPowerChannelState lastQueryPowerChannelState() {
		IMCMessage m = get("QueryPowerChannelState");
		if (m != null)
			try {
				QueryPowerChannelState ms = new QueryPowerChannelState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link QueryPowerChannelState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link QueryPowerChannelState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.QueryPowerChannelState lastQueryPowerChannelState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.QueryPowerChannelState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				QueryPowerChannelState ms = new QueryPowerChannelState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link QueryPowerChannelState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link QueryPowerChannelState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.QueryPowerChannelState pollQueryPowerChannelState(long timeoutMillis) {
		IMCMessage m = poll("QueryPowerChannelState", timeoutMillis);
		if (m != null)
			try {
				QueryPowerChannelState ms = new QueryPowerChannelState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link QueryPowerChannelState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link QueryPowerChannelState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.QueryPowerChannelState pollQueryPowerChannelState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("QueryPowerChannelState", entityName, timeoutMillis);
		if (m != null)
			try {
				QueryPowerChannelState ms = new QueryPowerChannelState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PowerChannelState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PowerChannelState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PowerChannelState lastPowerChannelState() {
		IMCMessage m = get("PowerChannelState");
		if (m != null)
			try {
				PowerChannelState ms = new PowerChannelState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PowerChannelState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PowerChannelState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PowerChannelState lastPowerChannelState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PowerChannelState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PowerChannelState ms = new PowerChannelState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PowerChannelState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PowerChannelState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PowerChannelState pollPowerChannelState(long timeoutMillis) {
		IMCMessage m = poll("PowerChannelState", timeoutMillis);
		if (m != null)
			try {
				PowerChannelState ms = new PowerChannelState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PowerChannelState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PowerChannelState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PowerChannelState pollPowerChannelState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PowerChannelState", entityName, timeoutMillis);
		if (m != null)
			try {
				PowerChannelState ms = new PowerChannelState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LedBrightness} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link LedBrightness} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LedBrightness lastLedBrightness() {
		IMCMessage m = get("LedBrightness");
		if (m != null)
			try {
				LedBrightness ms = new LedBrightness();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LedBrightness} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link LedBrightness} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LedBrightness lastLedBrightness(String entityName) {
		IMCMessage m = get(pt.lsts.imc.LedBrightness.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				LedBrightness ms = new LedBrightness();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LedBrightness}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LedBrightness} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LedBrightness pollLedBrightness(long timeoutMillis) {
		IMCMessage m = poll("LedBrightness", timeoutMillis);
		if (m != null)
			try {
				LedBrightness ms = new LedBrightness();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LedBrightness} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LedBrightness} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LedBrightness pollLedBrightness(String entityName, long timeoutMillis) {
		IMCMessage m = poll("LedBrightness", entityName, timeoutMillis);
		if (m != null)
			try {
				LedBrightness ms = new LedBrightness();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link QueryLedBrightness} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link QueryLedBrightness} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.QueryLedBrightness lastQueryLedBrightness() {
		IMCMessage m = get("QueryLedBrightness");
		if (m != null)
			try {
				QueryLedBrightness ms = new QueryLedBrightness();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link QueryLedBrightness} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link QueryLedBrightness} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.QueryLedBrightness lastQueryLedBrightness(String entityName) {
		IMCMessage m = get(pt.lsts.imc.QueryLedBrightness.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				QueryLedBrightness ms = new QueryLedBrightness();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link QueryLedBrightness}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link QueryLedBrightness} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.QueryLedBrightness pollQueryLedBrightness(long timeoutMillis) {
		IMCMessage m = poll("QueryLedBrightness", timeoutMillis);
		if (m != null)
			try {
				QueryLedBrightness ms = new QueryLedBrightness();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link QueryLedBrightness} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link QueryLedBrightness} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.QueryLedBrightness pollQueryLedBrightness(String entityName, long timeoutMillis) {
		IMCMessage m = poll("QueryLedBrightness", entityName, timeoutMillis);
		if (m != null)
			try {
				QueryLedBrightness ms = new QueryLedBrightness();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SetLedBrightness} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SetLedBrightness} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SetLedBrightness lastSetLedBrightness() {
		IMCMessage m = get("SetLedBrightness");
		if (m != null)
			try {
				SetLedBrightness ms = new SetLedBrightness();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SetLedBrightness} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SetLedBrightness} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SetLedBrightness lastSetLedBrightness(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SetLedBrightness.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SetLedBrightness ms = new SetLedBrightness();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SetLedBrightness}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SetLedBrightness} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SetLedBrightness pollSetLedBrightness(long timeoutMillis) {
		IMCMessage m = poll("SetLedBrightness", timeoutMillis);
		if (m != null)
			try {
				SetLedBrightness ms = new SetLedBrightness();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SetLedBrightness} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SetLedBrightness} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SetLedBrightness pollSetLedBrightness(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SetLedBrightness", entityName, timeoutMillis);
		if (m != null)
			try {
				SetLedBrightness ms = new SetLedBrightness();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SetPWM} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SetPWM} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SetPWM lastSetPWM() {
		IMCMessage m = get("SetPWM");
		if (m != null)
			try {
				SetPWM ms = new SetPWM();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SetPWM} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SetPWM} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SetPWM lastSetPWM(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SetPWM.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SetPWM ms = new SetPWM();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SetPWM}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SetPWM} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SetPWM pollSetPWM(long timeoutMillis) {
		IMCMessage m = poll("SetPWM", timeoutMillis);
		if (m != null)
			try {
				SetPWM ms = new SetPWM();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SetPWM} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SetPWM} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SetPWM pollSetPWM(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SetPWM", entityName, timeoutMillis);
		if (m != null)
			try {
				SetPWM ms = new SetPWM();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PWM} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PWM} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PWM lastPWM() {
		IMCMessage m = get("PWM");
		if (m != null)
			try {
				PWM ms = new PWM();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PWM} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PWM} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PWM lastPWM(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PWM.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PWM ms = new PWM();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PWM}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PWM} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PWM pollPWM(long timeoutMillis) {
		IMCMessage m = poll("PWM", timeoutMillis);
		if (m != null)
			try {
				PWM ms = new PWM();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PWM} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PWM} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PWM pollPWM(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PWM", entityName, timeoutMillis);
		if (m != null)
			try {
				PWM ms = new PWM();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EstimatedState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link EstimatedState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EstimatedState lastEstimatedState() {
		IMCMessage m = get("EstimatedState");
		if (m != null)
			try {
				EstimatedState ms = new EstimatedState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EstimatedState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link EstimatedState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EstimatedState lastEstimatedState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.EstimatedState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				EstimatedState ms = new EstimatedState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EstimatedState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EstimatedState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EstimatedState pollEstimatedState(long timeoutMillis) {
		IMCMessage m = poll("EstimatedState", timeoutMillis);
		if (m != null)
			try {
				EstimatedState ms = new EstimatedState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EstimatedState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EstimatedState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EstimatedState pollEstimatedState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("EstimatedState", entityName, timeoutMillis);
		if (m != null)
			try {
				EstimatedState ms = new EstimatedState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EstimatedStreamVelocity} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link EstimatedStreamVelocity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EstimatedStreamVelocity lastEstimatedStreamVelocity() {
		IMCMessage m = get("EstimatedStreamVelocity");
		if (m != null)
			try {
				EstimatedStreamVelocity ms = new EstimatedStreamVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EstimatedStreamVelocity} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link EstimatedStreamVelocity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EstimatedStreamVelocity lastEstimatedStreamVelocity(String entityName) {
		IMCMessage m = get(pt.lsts.imc.EstimatedStreamVelocity.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				EstimatedStreamVelocity ms = new EstimatedStreamVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EstimatedStreamVelocity}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EstimatedStreamVelocity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EstimatedStreamVelocity pollEstimatedStreamVelocity(long timeoutMillis) {
		IMCMessage m = poll("EstimatedStreamVelocity", timeoutMillis);
		if (m != null)
			try {
				EstimatedStreamVelocity ms = new EstimatedStreamVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EstimatedStreamVelocity} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EstimatedStreamVelocity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EstimatedStreamVelocity pollEstimatedStreamVelocity(String entityName, long timeoutMillis) {
		IMCMessage m = poll("EstimatedStreamVelocity", entityName, timeoutMillis);
		if (m != null)
			try {
				EstimatedStreamVelocity ms = new EstimatedStreamVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link IndicatedSpeed} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link IndicatedSpeed} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.IndicatedSpeed lastIndicatedSpeed() {
		IMCMessage m = get("IndicatedSpeed");
		if (m != null)
			try {
				IndicatedSpeed ms = new IndicatedSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link IndicatedSpeed} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link IndicatedSpeed} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.IndicatedSpeed lastIndicatedSpeed(String entityName) {
		IMCMessage m = get(pt.lsts.imc.IndicatedSpeed.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				IndicatedSpeed ms = new IndicatedSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link IndicatedSpeed}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link IndicatedSpeed} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.IndicatedSpeed pollIndicatedSpeed(long timeoutMillis) {
		IMCMessage m = poll("IndicatedSpeed", timeoutMillis);
		if (m != null)
			try {
				IndicatedSpeed ms = new IndicatedSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link IndicatedSpeed} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link IndicatedSpeed} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.IndicatedSpeed pollIndicatedSpeed(String entityName, long timeoutMillis) {
		IMCMessage m = poll("IndicatedSpeed", entityName, timeoutMillis);
		if (m != null)
			try {
				IndicatedSpeed ms = new IndicatedSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrueSpeed} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link TrueSpeed} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrueSpeed lastTrueSpeed() {
		IMCMessage m = get("TrueSpeed");
		if (m != null)
			try {
				TrueSpeed ms = new TrueSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrueSpeed} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link TrueSpeed} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrueSpeed lastTrueSpeed(String entityName) {
		IMCMessage m = get(pt.lsts.imc.TrueSpeed.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				TrueSpeed ms = new TrueSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrueSpeed}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrueSpeed} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrueSpeed pollTrueSpeed(long timeoutMillis) {
		IMCMessage m = poll("TrueSpeed", timeoutMillis);
		if (m != null)
			try {
				TrueSpeed ms = new TrueSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrueSpeed} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrueSpeed} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrueSpeed pollTrueSpeed(String entityName, long timeoutMillis) {
		IMCMessage m = poll("TrueSpeed", entityName, timeoutMillis);
		if (m != null)
			try {
				TrueSpeed ms = new TrueSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link NavigationUncertainty} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link NavigationUncertainty} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.NavigationUncertainty lastNavigationUncertainty() {
		IMCMessage m = get("NavigationUncertainty");
		if (m != null)
			try {
				NavigationUncertainty ms = new NavigationUncertainty();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link NavigationUncertainty} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link NavigationUncertainty} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.NavigationUncertainty lastNavigationUncertainty(String entityName) {
		IMCMessage m = get(pt.lsts.imc.NavigationUncertainty.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				NavigationUncertainty ms = new NavigationUncertainty();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link NavigationUncertainty}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link NavigationUncertainty} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.NavigationUncertainty pollNavigationUncertainty(long timeoutMillis) {
		IMCMessage m = poll("NavigationUncertainty", timeoutMillis);
		if (m != null)
			try {
				NavigationUncertainty ms = new NavigationUncertainty();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link NavigationUncertainty} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link NavigationUncertainty} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.NavigationUncertainty pollNavigationUncertainty(String entityName, long timeoutMillis) {
		IMCMessage m = poll("NavigationUncertainty", entityName, timeoutMillis);
		if (m != null)
			try {
				NavigationUncertainty ms = new NavigationUncertainty();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link NavigationData} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link NavigationData} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.NavigationData lastNavigationData() {
		IMCMessage m = get("NavigationData");
		if (m != null)
			try {
				NavigationData ms = new NavigationData();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link NavigationData} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link NavigationData} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.NavigationData lastNavigationData(String entityName) {
		IMCMessage m = get(pt.lsts.imc.NavigationData.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				NavigationData ms = new NavigationData();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link NavigationData}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link NavigationData} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.NavigationData pollNavigationData(long timeoutMillis) {
		IMCMessage m = poll("NavigationData", timeoutMillis);
		if (m != null)
			try {
				NavigationData ms = new NavigationData();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link NavigationData} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link NavigationData} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.NavigationData pollNavigationData(String entityName, long timeoutMillis) {
		IMCMessage m = poll("NavigationData", entityName, timeoutMillis);
		if (m != null)
			try {
				NavigationData ms = new NavigationData();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link GpsFixRejection} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link GpsFixRejection} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.GpsFixRejection lastGpsFixRejection() {
		IMCMessage m = get("GpsFixRejection");
		if (m != null)
			try {
				GpsFixRejection ms = new GpsFixRejection();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link GpsFixRejection} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link GpsFixRejection} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.GpsFixRejection lastGpsFixRejection(String entityName) {
		IMCMessage m = get(pt.lsts.imc.GpsFixRejection.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				GpsFixRejection ms = new GpsFixRejection();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link GpsFixRejection}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link GpsFixRejection} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.GpsFixRejection pollGpsFixRejection(long timeoutMillis) {
		IMCMessage m = poll("GpsFixRejection", timeoutMillis);
		if (m != null)
			try {
				GpsFixRejection ms = new GpsFixRejection();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link GpsFixRejection} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link GpsFixRejection} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.GpsFixRejection pollGpsFixRejection(String entityName, long timeoutMillis) {
		IMCMessage m = poll("GpsFixRejection", entityName, timeoutMillis);
		if (m != null)
			try {
				GpsFixRejection ms = new GpsFixRejection();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LblRangeAcceptance} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link LblRangeAcceptance} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LblRangeAcceptance lastLblRangeAcceptance() {
		IMCMessage m = get("LblRangeAcceptance");
		if (m != null)
			try {
				LblRangeAcceptance ms = new LblRangeAcceptance();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LblRangeAcceptance} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link LblRangeAcceptance} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LblRangeAcceptance lastLblRangeAcceptance(String entityName) {
		IMCMessage m = get(pt.lsts.imc.LblRangeAcceptance.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				LblRangeAcceptance ms = new LblRangeAcceptance();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LblRangeAcceptance}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LblRangeAcceptance} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LblRangeAcceptance pollLblRangeAcceptance(long timeoutMillis) {
		IMCMessage m = poll("LblRangeAcceptance", timeoutMillis);
		if (m != null)
			try {
				LblRangeAcceptance ms = new LblRangeAcceptance();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LblRangeAcceptance} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LblRangeAcceptance} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LblRangeAcceptance pollLblRangeAcceptance(String entityName, long timeoutMillis) {
		IMCMessage m = poll("LblRangeAcceptance", entityName, timeoutMillis);
		if (m != null)
			try {
				LblRangeAcceptance ms = new LblRangeAcceptance();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DvlRejection} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DvlRejection} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DvlRejection lastDvlRejection() {
		IMCMessage m = get("DvlRejection");
		if (m != null)
			try {
				DvlRejection ms = new DvlRejection();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DvlRejection} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DvlRejection} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DvlRejection lastDvlRejection(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DvlRejection.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DvlRejection ms = new DvlRejection();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DvlRejection}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DvlRejection} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DvlRejection pollDvlRejection(long timeoutMillis) {
		IMCMessage m = poll("DvlRejection", timeoutMillis);
		if (m != null)
			try {
				DvlRejection ms = new DvlRejection();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DvlRejection} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DvlRejection} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DvlRejection pollDvlRejection(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DvlRejection", entityName, timeoutMillis);
		if (m != null)
			try {
				DvlRejection ms = new DvlRejection();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LblEstimate} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link LblEstimate} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LblEstimate lastLblEstimate() {
		IMCMessage m = get("LblEstimate");
		if (m != null)
			try {
				LblEstimate ms = new LblEstimate();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LblEstimate} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link LblEstimate} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LblEstimate lastLblEstimate(String entityName) {
		IMCMessage m = get(pt.lsts.imc.LblEstimate.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				LblEstimate ms = new LblEstimate();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LblEstimate}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LblEstimate} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LblEstimate pollLblEstimate(long timeoutMillis) {
		IMCMessage m = poll("LblEstimate", timeoutMillis);
		if (m != null)
			try {
				LblEstimate ms = new LblEstimate();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LblEstimate} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LblEstimate} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LblEstimate pollLblEstimate(String entityName, long timeoutMillis) {
		IMCMessage m = poll("LblEstimate", entityName, timeoutMillis);
		if (m != null)
			try {
				LblEstimate ms = new LblEstimate();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AlignmentState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link AlignmentState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AlignmentState lastAlignmentState() {
		IMCMessage m = get("AlignmentState");
		if (m != null)
			try {
				AlignmentState ms = new AlignmentState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AlignmentState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link AlignmentState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AlignmentState lastAlignmentState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.AlignmentState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				AlignmentState ms = new AlignmentState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AlignmentState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AlignmentState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AlignmentState pollAlignmentState(long timeoutMillis) {
		IMCMessage m = poll("AlignmentState", timeoutMillis);
		if (m != null)
			try {
				AlignmentState ms = new AlignmentState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AlignmentState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AlignmentState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AlignmentState pollAlignmentState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("AlignmentState", entityName, timeoutMillis);
		if (m != null)
			try {
				AlignmentState ms = new AlignmentState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link GroupStreamVelocity} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link GroupStreamVelocity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.GroupStreamVelocity lastGroupStreamVelocity() {
		IMCMessage m = get("GroupStreamVelocity");
		if (m != null)
			try {
				GroupStreamVelocity ms = new GroupStreamVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link GroupStreamVelocity} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link GroupStreamVelocity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.GroupStreamVelocity lastGroupStreamVelocity(String entityName) {
		IMCMessage m = get(pt.lsts.imc.GroupStreamVelocity.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				GroupStreamVelocity ms = new GroupStreamVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link GroupStreamVelocity}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link GroupStreamVelocity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.GroupStreamVelocity pollGroupStreamVelocity(long timeoutMillis) {
		IMCMessage m = poll("GroupStreamVelocity", timeoutMillis);
		if (m != null)
			try {
				GroupStreamVelocity ms = new GroupStreamVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link GroupStreamVelocity} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link GroupStreamVelocity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.GroupStreamVelocity pollGroupStreamVelocity(String entityName, long timeoutMillis) {
		IMCMessage m = poll("GroupStreamVelocity", entityName, timeoutMillis);
		if (m != null)
			try {
				GroupStreamVelocity ms = new GroupStreamVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredHeading} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DesiredHeading} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredHeading lastDesiredHeading() {
		IMCMessage m = get("DesiredHeading");
		if (m != null)
			try {
				DesiredHeading ms = new DesiredHeading();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredHeading} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DesiredHeading} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredHeading lastDesiredHeading(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DesiredHeading.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DesiredHeading ms = new DesiredHeading();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredHeading}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredHeading} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredHeading pollDesiredHeading(long timeoutMillis) {
		IMCMessage m = poll("DesiredHeading", timeoutMillis);
		if (m != null)
			try {
				DesiredHeading ms = new DesiredHeading();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredHeading} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredHeading} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredHeading pollDesiredHeading(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DesiredHeading", entityName, timeoutMillis);
		if (m != null)
			try {
				DesiredHeading ms = new DesiredHeading();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredZ} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DesiredZ} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredZ lastDesiredZ() {
		IMCMessage m = get("DesiredZ");
		if (m != null)
			try {
				DesiredZ ms = new DesiredZ();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredZ} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DesiredZ} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredZ lastDesiredZ(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DesiredZ.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DesiredZ ms = new DesiredZ();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredZ}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredZ} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredZ pollDesiredZ(long timeoutMillis) {
		IMCMessage m = poll("DesiredZ", timeoutMillis);
		if (m != null)
			try {
				DesiredZ ms = new DesiredZ();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredZ} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredZ} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredZ pollDesiredZ(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DesiredZ", entityName, timeoutMillis);
		if (m != null)
			try {
				DesiredZ ms = new DesiredZ();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredSpeed} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DesiredSpeed} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredSpeed lastDesiredSpeed() {
		IMCMessage m = get("DesiredSpeed");
		if (m != null)
			try {
				DesiredSpeed ms = new DesiredSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredSpeed} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DesiredSpeed} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredSpeed lastDesiredSpeed(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DesiredSpeed.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DesiredSpeed ms = new DesiredSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredSpeed}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredSpeed} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredSpeed pollDesiredSpeed(long timeoutMillis) {
		IMCMessage m = poll("DesiredSpeed", timeoutMillis);
		if (m != null)
			try {
				DesiredSpeed ms = new DesiredSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredSpeed} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredSpeed} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredSpeed pollDesiredSpeed(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DesiredSpeed", entityName, timeoutMillis);
		if (m != null)
			try {
				DesiredSpeed ms = new DesiredSpeed();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredRoll} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DesiredRoll} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredRoll lastDesiredRoll() {
		IMCMessage m = get("DesiredRoll");
		if (m != null)
			try {
				DesiredRoll ms = new DesiredRoll();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredRoll} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DesiredRoll} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredRoll lastDesiredRoll(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DesiredRoll.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DesiredRoll ms = new DesiredRoll();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredRoll}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredRoll} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredRoll pollDesiredRoll(long timeoutMillis) {
		IMCMessage m = poll("DesiredRoll", timeoutMillis);
		if (m != null)
			try {
				DesiredRoll ms = new DesiredRoll();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredRoll} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredRoll} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredRoll pollDesiredRoll(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DesiredRoll", entityName, timeoutMillis);
		if (m != null)
			try {
				DesiredRoll ms = new DesiredRoll();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredPitch} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DesiredPitch} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredPitch lastDesiredPitch() {
		IMCMessage m = get("DesiredPitch");
		if (m != null)
			try {
				DesiredPitch ms = new DesiredPitch();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredPitch} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DesiredPitch} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredPitch lastDesiredPitch(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DesiredPitch.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DesiredPitch ms = new DesiredPitch();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredPitch}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredPitch} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredPitch pollDesiredPitch(long timeoutMillis) {
		IMCMessage m = poll("DesiredPitch", timeoutMillis);
		if (m != null)
			try {
				DesiredPitch ms = new DesiredPitch();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredPitch} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredPitch} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredPitch pollDesiredPitch(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DesiredPitch", entityName, timeoutMillis);
		if (m != null)
			try {
				DesiredPitch ms = new DesiredPitch();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredVerticalRate} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DesiredVerticalRate} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredVerticalRate lastDesiredVerticalRate() {
		IMCMessage m = get("DesiredVerticalRate");
		if (m != null)
			try {
				DesiredVerticalRate ms = new DesiredVerticalRate();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredVerticalRate} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DesiredVerticalRate} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredVerticalRate lastDesiredVerticalRate(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DesiredVerticalRate.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DesiredVerticalRate ms = new DesiredVerticalRate();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredVerticalRate}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredVerticalRate} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredVerticalRate pollDesiredVerticalRate(long timeoutMillis) {
		IMCMessage m = poll("DesiredVerticalRate", timeoutMillis);
		if (m != null)
			try {
				DesiredVerticalRate ms = new DesiredVerticalRate();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredVerticalRate} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredVerticalRate} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredVerticalRate pollDesiredVerticalRate(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DesiredVerticalRate", entityName, timeoutMillis);
		if (m != null)
			try {
				DesiredVerticalRate ms = new DesiredVerticalRate();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredPath} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DesiredPath} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredPath lastDesiredPath() {
		IMCMessage m = get("DesiredPath");
		if (m != null)
			try {
				DesiredPath ms = new DesiredPath();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredPath} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DesiredPath} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredPath lastDesiredPath(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DesiredPath.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DesiredPath ms = new DesiredPath();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredPath}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredPath} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredPath pollDesiredPath(long timeoutMillis) {
		IMCMessage m = poll("DesiredPath", timeoutMillis);
		if (m != null)
			try {
				DesiredPath ms = new DesiredPath();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredPath} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredPath} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredPath pollDesiredPath(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DesiredPath", entityName, timeoutMillis);
		if (m != null)
			try {
				DesiredPath ms = new DesiredPath();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredControl} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DesiredControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredControl lastDesiredControl() {
		IMCMessage m = get("DesiredControl");
		if (m != null)
			try {
				DesiredControl ms = new DesiredControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredControl} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DesiredControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredControl lastDesiredControl(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DesiredControl.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DesiredControl ms = new DesiredControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredControl}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredControl pollDesiredControl(long timeoutMillis) {
		IMCMessage m = poll("DesiredControl", timeoutMillis);
		if (m != null)
			try {
				DesiredControl ms = new DesiredControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredControl} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredControl pollDesiredControl(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DesiredControl", entityName, timeoutMillis);
		if (m != null)
			try {
				DesiredControl ms = new DesiredControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredHeadingRate} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DesiredHeadingRate} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredHeadingRate lastDesiredHeadingRate() {
		IMCMessage m = get("DesiredHeadingRate");
		if (m != null)
			try {
				DesiredHeadingRate ms = new DesiredHeadingRate();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredHeadingRate} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DesiredHeadingRate} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredHeadingRate lastDesiredHeadingRate(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DesiredHeadingRate.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DesiredHeadingRate ms = new DesiredHeadingRate();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredHeadingRate}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredHeadingRate} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredHeadingRate pollDesiredHeadingRate(long timeoutMillis) {
		IMCMessage m = poll("DesiredHeadingRate", timeoutMillis);
		if (m != null)
			try {
				DesiredHeadingRate ms = new DesiredHeadingRate();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredHeadingRate} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredHeadingRate} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredHeadingRate pollDesiredHeadingRate(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DesiredHeadingRate", entityName, timeoutMillis);
		if (m != null)
			try {
				DesiredHeadingRate ms = new DesiredHeadingRate();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredVelocity} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link DesiredVelocity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredVelocity lastDesiredVelocity() {
		IMCMessage m = get("DesiredVelocity");
		if (m != null)
			try {
				DesiredVelocity ms = new DesiredVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link DesiredVelocity} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link DesiredVelocity} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.DesiredVelocity lastDesiredVelocity(String entityName) {
		IMCMessage m = get(pt.lsts.imc.DesiredVelocity.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				DesiredVelocity ms = new DesiredVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredVelocity}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredVelocity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredVelocity pollDesiredVelocity(long timeoutMillis) {
		IMCMessage m = poll("DesiredVelocity", timeoutMillis);
		if (m != null)
			try {
				DesiredVelocity ms = new DesiredVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link DesiredVelocity} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link DesiredVelocity} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.DesiredVelocity pollDesiredVelocity(String entityName, long timeoutMillis) {
		IMCMessage m = poll("DesiredVelocity", entityName, timeoutMillis);
		if (m != null)
			try {
				DesiredVelocity ms = new DesiredVelocity();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PathControlState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PathControlState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PathControlState lastPathControlState() {
		IMCMessage m = get("PathControlState");
		if (m != null)
			try {
				PathControlState ms = new PathControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PathControlState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PathControlState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PathControlState lastPathControlState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PathControlState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PathControlState ms = new PathControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PathControlState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PathControlState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PathControlState pollPathControlState(long timeoutMillis) {
		IMCMessage m = poll("PathControlState", timeoutMillis);
		if (m != null)
			try {
				PathControlState ms = new PathControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PathControlState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PathControlState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PathControlState pollPathControlState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PathControlState", entityName, timeoutMillis);
		if (m != null)
			try {
				PathControlState ms = new PathControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AllocatedControlTorques} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link AllocatedControlTorques} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AllocatedControlTorques lastAllocatedControlTorques() {
		IMCMessage m = get("AllocatedControlTorques");
		if (m != null)
			try {
				AllocatedControlTorques ms = new AllocatedControlTorques();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AllocatedControlTorques} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link AllocatedControlTorques} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AllocatedControlTorques lastAllocatedControlTorques(String entityName) {
		IMCMessage m = get(pt.lsts.imc.AllocatedControlTorques.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				AllocatedControlTorques ms = new AllocatedControlTorques();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AllocatedControlTorques}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AllocatedControlTorques} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AllocatedControlTorques pollAllocatedControlTorques(long timeoutMillis) {
		IMCMessage m = poll("AllocatedControlTorques", timeoutMillis);
		if (m != null)
			try {
				AllocatedControlTorques ms = new AllocatedControlTorques();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AllocatedControlTorques} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AllocatedControlTorques} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AllocatedControlTorques pollAllocatedControlTorques(String entityName, long timeoutMillis) {
		IMCMessage m = poll("AllocatedControlTorques", entityName, timeoutMillis);
		if (m != null)
			try {
				AllocatedControlTorques ms = new AllocatedControlTorques();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ControlParcel} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link ControlParcel} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ControlParcel lastControlParcel() {
		IMCMessage m = get("ControlParcel");
		if (m != null)
			try {
				ControlParcel ms = new ControlParcel();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ControlParcel} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link ControlParcel} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ControlParcel lastControlParcel(String entityName) {
		IMCMessage m = get(pt.lsts.imc.ControlParcel.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				ControlParcel ms = new ControlParcel();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ControlParcel}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ControlParcel} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ControlParcel pollControlParcel(long timeoutMillis) {
		IMCMessage m = poll("ControlParcel", timeoutMillis);
		if (m != null)
			try {
				ControlParcel ms = new ControlParcel();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ControlParcel} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ControlParcel} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ControlParcel pollControlParcel(String entityName, long timeoutMillis) {
		IMCMessage m = poll("ControlParcel", entityName, timeoutMillis);
		if (m != null)
			try {
				ControlParcel ms = new ControlParcel();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Brake} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Brake} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Brake lastBrake() {
		IMCMessage m = get("Brake");
		if (m != null)
			try {
				Brake ms = new Brake();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Brake} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Brake} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Brake lastBrake(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Brake.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Brake ms = new Brake();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Brake}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Brake} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Brake pollBrake(long timeoutMillis) {
		IMCMessage m = poll("Brake", timeoutMillis);
		if (m != null)
			try {
				Brake ms = new Brake();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Brake} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Brake} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Brake pollBrake(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Brake", entityName, timeoutMillis);
		if (m != null)
			try {
				Brake ms = new Brake();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Goto} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Goto} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Goto lastGoto() {
		IMCMessage m = get("Goto");
		if (m != null)
			try {
				Goto ms = new Goto();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Goto} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Goto} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Goto lastGoto(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Goto.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Goto ms = new Goto();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Goto}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Goto} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Goto pollGoto(long timeoutMillis) {
		IMCMessage m = poll("Goto", timeoutMillis);
		if (m != null)
			try {
				Goto ms = new Goto();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Goto} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Goto} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Goto pollGoto(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Goto", entityName, timeoutMillis);
		if (m != null)
			try {
				Goto ms = new Goto();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PopUp} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PopUp} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PopUp lastPopUp() {
		IMCMessage m = get("PopUp");
		if (m != null)
			try {
				PopUp ms = new PopUp();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PopUp} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PopUp} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PopUp lastPopUp(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PopUp.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PopUp ms = new PopUp();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PopUp}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PopUp} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PopUp pollPopUp(long timeoutMillis) {
		IMCMessage m = poll("PopUp", timeoutMillis);
		if (m != null)
			try {
				PopUp ms = new PopUp();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PopUp} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PopUp} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PopUp pollPopUp(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PopUp", entityName, timeoutMillis);
		if (m != null)
			try {
				PopUp ms = new PopUp();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Teleoperation} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Teleoperation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Teleoperation lastTeleoperation() {
		IMCMessage m = get("Teleoperation");
		if (m != null)
			try {
				Teleoperation ms = new Teleoperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Teleoperation} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Teleoperation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Teleoperation lastTeleoperation(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Teleoperation.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Teleoperation ms = new Teleoperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Teleoperation}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Teleoperation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Teleoperation pollTeleoperation(long timeoutMillis) {
		IMCMessage m = poll("Teleoperation", timeoutMillis);
		if (m != null)
			try {
				Teleoperation ms = new Teleoperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Teleoperation} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Teleoperation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Teleoperation pollTeleoperation(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Teleoperation", entityName, timeoutMillis);
		if (m != null)
			try {
				Teleoperation ms = new Teleoperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Loiter} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Loiter} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Loiter lastLoiter() {
		IMCMessage m = get("Loiter");
		if (m != null)
			try {
				Loiter ms = new Loiter();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Loiter} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Loiter} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Loiter lastLoiter(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Loiter.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Loiter ms = new Loiter();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Loiter}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Loiter} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Loiter pollLoiter(long timeoutMillis) {
		IMCMessage m = poll("Loiter", timeoutMillis);
		if (m != null)
			try {
				Loiter ms = new Loiter();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Loiter} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Loiter} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Loiter pollLoiter(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Loiter", entityName, timeoutMillis);
		if (m != null)
			try {
				Loiter ms = new Loiter();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link IdleManeuver} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link IdleManeuver} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.IdleManeuver lastIdleManeuver() {
		IMCMessage m = get("IdleManeuver");
		if (m != null)
			try {
				IdleManeuver ms = new IdleManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link IdleManeuver} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link IdleManeuver} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.IdleManeuver lastIdleManeuver(String entityName) {
		IMCMessage m = get(pt.lsts.imc.IdleManeuver.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				IdleManeuver ms = new IdleManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link IdleManeuver}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link IdleManeuver} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.IdleManeuver pollIdleManeuver(long timeoutMillis) {
		IMCMessage m = poll("IdleManeuver", timeoutMillis);
		if (m != null)
			try {
				IdleManeuver ms = new IdleManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link IdleManeuver} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link IdleManeuver} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.IdleManeuver pollIdleManeuver(String entityName, long timeoutMillis) {
		IMCMessage m = poll("IdleManeuver", entityName, timeoutMillis);
		if (m != null)
			try {
				IdleManeuver ms = new IdleManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LowLevelControl} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link LowLevelControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LowLevelControl lastLowLevelControl() {
		IMCMessage m = get("LowLevelControl");
		if (m != null)
			try {
				LowLevelControl ms = new LowLevelControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LowLevelControl} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link LowLevelControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LowLevelControl lastLowLevelControl(String entityName) {
		IMCMessage m = get(pt.lsts.imc.LowLevelControl.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				LowLevelControl ms = new LowLevelControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LowLevelControl}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LowLevelControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LowLevelControl pollLowLevelControl(long timeoutMillis) {
		IMCMessage m = poll("LowLevelControl", timeoutMillis);
		if (m != null)
			try {
				LowLevelControl ms = new LowLevelControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LowLevelControl} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LowLevelControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LowLevelControl pollLowLevelControl(String entityName, long timeoutMillis) {
		IMCMessage m = poll("LowLevelControl", entityName, timeoutMillis);
		if (m != null)
			try {
				LowLevelControl ms = new LowLevelControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Rows} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Rows} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Rows lastRows() {
		IMCMessage m = get("Rows");
		if (m != null)
			try {
				Rows ms = new Rows();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Rows} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Rows} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Rows lastRows(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Rows.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Rows ms = new Rows();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Rows}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Rows} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Rows pollRows(long timeoutMillis) {
		IMCMessage m = poll("Rows", timeoutMillis);
		if (m != null)
			try {
				Rows ms = new Rows();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Rows} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Rows} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Rows pollRows(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Rows", entityName, timeoutMillis);
		if (m != null)
			try {
				Rows ms = new Rows();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FollowPath} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link FollowPath} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FollowPath lastFollowPath() {
		IMCMessage m = get("FollowPath");
		if (m != null)
			try {
				FollowPath ms = new FollowPath();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FollowPath} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link FollowPath} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FollowPath lastFollowPath(String entityName) {
		IMCMessage m = get(pt.lsts.imc.FollowPath.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				FollowPath ms = new FollowPath();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FollowPath}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FollowPath} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FollowPath pollFollowPath(long timeoutMillis) {
		IMCMessage m = poll("FollowPath", timeoutMillis);
		if (m != null)
			try {
				FollowPath ms = new FollowPath();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FollowPath} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FollowPath} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FollowPath pollFollowPath(String entityName, long timeoutMillis) {
		IMCMessage m = poll("FollowPath", entityName, timeoutMillis);
		if (m != null)
			try {
				FollowPath ms = new FollowPath();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PathPoint} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PathPoint} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PathPoint lastPathPoint() {
		IMCMessage m = get("PathPoint");
		if (m != null)
			try {
				PathPoint ms = new PathPoint();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PathPoint} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PathPoint} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PathPoint lastPathPoint(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PathPoint.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PathPoint ms = new PathPoint();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PathPoint}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PathPoint} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PathPoint pollPathPoint(long timeoutMillis) {
		IMCMessage m = poll("PathPoint", timeoutMillis);
		if (m != null)
			try {
				PathPoint ms = new PathPoint();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PathPoint} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PathPoint} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PathPoint pollPathPoint(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PathPoint", entityName, timeoutMillis);
		if (m != null)
			try {
				PathPoint ms = new PathPoint();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link YoYo} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link YoYo} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.YoYo lastYoYo() {
		IMCMessage m = get("YoYo");
		if (m != null)
			try {
				YoYo ms = new YoYo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link YoYo} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link YoYo} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.YoYo lastYoYo(String entityName) {
		IMCMessage m = get(pt.lsts.imc.YoYo.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				YoYo ms = new YoYo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link YoYo}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link YoYo} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.YoYo pollYoYo(long timeoutMillis) {
		IMCMessage m = poll("YoYo", timeoutMillis);
		if (m != null)
			try {
				YoYo ms = new YoYo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link YoYo} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link YoYo} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.YoYo pollYoYo(String entityName, long timeoutMillis) {
		IMCMessage m = poll("YoYo", entityName, timeoutMillis);
		if (m != null)
			try {
				YoYo ms = new YoYo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TeleoperationDone} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link TeleoperationDone} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TeleoperationDone lastTeleoperationDone() {
		IMCMessage m = get("TeleoperationDone");
		if (m != null)
			try {
				TeleoperationDone ms = new TeleoperationDone();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TeleoperationDone} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link TeleoperationDone} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TeleoperationDone lastTeleoperationDone(String entityName) {
		IMCMessage m = get(pt.lsts.imc.TeleoperationDone.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				TeleoperationDone ms = new TeleoperationDone();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TeleoperationDone}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TeleoperationDone} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TeleoperationDone pollTeleoperationDone(long timeoutMillis) {
		IMCMessage m = poll("TeleoperationDone", timeoutMillis);
		if (m != null)
			try {
				TeleoperationDone ms = new TeleoperationDone();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TeleoperationDone} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TeleoperationDone} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TeleoperationDone pollTeleoperationDone(String entityName, long timeoutMillis) {
		IMCMessage m = poll("TeleoperationDone", entityName, timeoutMillis);
		if (m != null)
			try {
				TeleoperationDone ms = new TeleoperationDone();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link StationKeeping} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link StationKeeping} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.StationKeeping lastStationKeeping() {
		IMCMessage m = get("StationKeeping");
		if (m != null)
			try {
				StationKeeping ms = new StationKeeping();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link StationKeeping} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link StationKeeping} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.StationKeeping lastStationKeeping(String entityName) {
		IMCMessage m = get(pt.lsts.imc.StationKeeping.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				StationKeeping ms = new StationKeeping();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link StationKeeping}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link StationKeeping} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.StationKeeping pollStationKeeping(long timeoutMillis) {
		IMCMessage m = poll("StationKeeping", timeoutMillis);
		if (m != null)
			try {
				StationKeeping ms = new StationKeeping();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link StationKeeping} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link StationKeeping} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.StationKeeping pollStationKeeping(String entityName, long timeoutMillis) {
		IMCMessage m = poll("StationKeeping", entityName, timeoutMillis);
		if (m != null)
			try {
				StationKeeping ms = new StationKeeping();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Elevator} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Elevator} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Elevator lastElevator() {
		IMCMessage m = get("Elevator");
		if (m != null)
			try {
				Elevator ms = new Elevator();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Elevator} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Elevator} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Elevator lastElevator(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Elevator.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Elevator ms = new Elevator();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Elevator}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Elevator} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Elevator pollElevator(long timeoutMillis) {
		IMCMessage m = poll("Elevator", timeoutMillis);
		if (m != null)
			try {
				Elevator ms = new Elevator();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Elevator} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Elevator} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Elevator pollElevator(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Elevator", entityName, timeoutMillis);
		if (m != null)
			try {
				Elevator ms = new Elevator();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FollowTrajectory} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link FollowTrajectory} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FollowTrajectory lastFollowTrajectory() {
		IMCMessage m = get("FollowTrajectory");
		if (m != null)
			try {
				FollowTrajectory ms = new FollowTrajectory();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FollowTrajectory} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link FollowTrajectory} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FollowTrajectory lastFollowTrajectory(String entityName) {
		IMCMessage m = get(pt.lsts.imc.FollowTrajectory.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				FollowTrajectory ms = new FollowTrajectory();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FollowTrajectory}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FollowTrajectory} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FollowTrajectory pollFollowTrajectory(long timeoutMillis) {
		IMCMessage m = poll("FollowTrajectory", timeoutMillis);
		if (m != null)
			try {
				FollowTrajectory ms = new FollowTrajectory();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FollowTrajectory} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FollowTrajectory} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FollowTrajectory pollFollowTrajectory(String entityName, long timeoutMillis) {
		IMCMessage m = poll("FollowTrajectory", entityName, timeoutMillis);
		if (m != null)
			try {
				FollowTrajectory ms = new FollowTrajectory();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrajectoryPoint} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link TrajectoryPoint} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrajectoryPoint lastTrajectoryPoint() {
		IMCMessage m = get("TrajectoryPoint");
		if (m != null)
			try {
				TrajectoryPoint ms = new TrajectoryPoint();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrajectoryPoint} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link TrajectoryPoint} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrajectoryPoint lastTrajectoryPoint(String entityName) {
		IMCMessage m = get(pt.lsts.imc.TrajectoryPoint.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				TrajectoryPoint ms = new TrajectoryPoint();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrajectoryPoint}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrajectoryPoint} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrajectoryPoint pollTrajectoryPoint(long timeoutMillis) {
		IMCMessage m = poll("TrajectoryPoint", timeoutMillis);
		if (m != null)
			try {
				TrajectoryPoint ms = new TrajectoryPoint();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrajectoryPoint} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrajectoryPoint} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrajectoryPoint pollTrajectoryPoint(String entityName, long timeoutMillis) {
		IMCMessage m = poll("TrajectoryPoint", entityName, timeoutMillis);
		if (m != null)
			try {
				TrajectoryPoint ms = new TrajectoryPoint();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CustomManeuver} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link CustomManeuver} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CustomManeuver lastCustomManeuver() {
		IMCMessage m = get("CustomManeuver");
		if (m != null)
			try {
				CustomManeuver ms = new CustomManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CustomManeuver} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link CustomManeuver} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CustomManeuver lastCustomManeuver(String entityName) {
		IMCMessage m = get(pt.lsts.imc.CustomManeuver.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				CustomManeuver ms = new CustomManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CustomManeuver}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CustomManeuver} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CustomManeuver pollCustomManeuver(long timeoutMillis) {
		IMCMessage m = poll("CustomManeuver", timeoutMillis);
		if (m != null)
			try {
				CustomManeuver ms = new CustomManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CustomManeuver} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CustomManeuver} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CustomManeuver pollCustomManeuver(String entityName, long timeoutMillis) {
		IMCMessage m = poll("CustomManeuver", entityName, timeoutMillis);
		if (m != null)
			try {
				CustomManeuver ms = new CustomManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VehicleFormation} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link VehicleFormation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VehicleFormation lastVehicleFormation() {
		IMCMessage m = get("VehicleFormation");
		if (m != null)
			try {
				VehicleFormation ms = new VehicleFormation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VehicleFormation} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link VehicleFormation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VehicleFormation lastVehicleFormation(String entityName) {
		IMCMessage m = get(pt.lsts.imc.VehicleFormation.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				VehicleFormation ms = new VehicleFormation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VehicleFormation}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VehicleFormation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VehicleFormation pollVehicleFormation(long timeoutMillis) {
		IMCMessage m = poll("VehicleFormation", timeoutMillis);
		if (m != null)
			try {
				VehicleFormation ms = new VehicleFormation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VehicleFormation} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VehicleFormation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VehicleFormation pollVehicleFormation(String entityName, long timeoutMillis) {
		IMCMessage m = poll("VehicleFormation", entityName, timeoutMillis);
		if (m != null)
			try {
				VehicleFormation ms = new VehicleFormation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VehicleFormationParticipant} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link VehicleFormationParticipant} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VehicleFormationParticipant lastVehicleFormationParticipant() {
		IMCMessage m = get("VehicleFormationParticipant");
		if (m != null)
			try {
				VehicleFormationParticipant ms = new VehicleFormationParticipant();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VehicleFormationParticipant} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link VehicleFormationParticipant} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VehicleFormationParticipant lastVehicleFormationParticipant(String entityName) {
		IMCMessage m = get(pt.lsts.imc.VehicleFormationParticipant.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				VehicleFormationParticipant ms = new VehicleFormationParticipant();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VehicleFormationParticipant}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VehicleFormationParticipant} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VehicleFormationParticipant pollVehicleFormationParticipant(long timeoutMillis) {
		IMCMessage m = poll("VehicleFormationParticipant", timeoutMillis);
		if (m != null)
			try {
				VehicleFormationParticipant ms = new VehicleFormationParticipant();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VehicleFormationParticipant} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VehicleFormationParticipant} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VehicleFormationParticipant pollVehicleFormationParticipant(String entityName, long timeoutMillis) {
		IMCMessage m = poll("VehicleFormationParticipant", entityName, timeoutMillis);
		if (m != null)
			try {
				VehicleFormationParticipant ms = new VehicleFormationParticipant();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link StopManeuver} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link StopManeuver} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.StopManeuver lastStopManeuver() {
		IMCMessage m = get("StopManeuver");
		if (m != null)
			try {
				StopManeuver ms = new StopManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link StopManeuver} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link StopManeuver} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.StopManeuver lastStopManeuver(String entityName) {
		IMCMessage m = get(pt.lsts.imc.StopManeuver.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				StopManeuver ms = new StopManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link StopManeuver}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link StopManeuver} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.StopManeuver pollStopManeuver(long timeoutMillis) {
		IMCMessage m = poll("StopManeuver", timeoutMillis);
		if (m != null)
			try {
				StopManeuver ms = new StopManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link StopManeuver} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link StopManeuver} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.StopManeuver pollStopManeuver(String entityName, long timeoutMillis) {
		IMCMessage m = poll("StopManeuver", entityName, timeoutMillis);
		if (m != null)
			try {
				StopManeuver ms = new StopManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RegisterManeuver} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link RegisterManeuver} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RegisterManeuver lastRegisterManeuver() {
		IMCMessage m = get("RegisterManeuver");
		if (m != null)
			try {
				RegisterManeuver ms = new RegisterManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RegisterManeuver} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link RegisterManeuver} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RegisterManeuver lastRegisterManeuver(String entityName) {
		IMCMessage m = get(pt.lsts.imc.RegisterManeuver.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				RegisterManeuver ms = new RegisterManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RegisterManeuver}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RegisterManeuver} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RegisterManeuver pollRegisterManeuver(long timeoutMillis) {
		IMCMessage m = poll("RegisterManeuver", timeoutMillis);
		if (m != null)
			try {
				RegisterManeuver ms = new RegisterManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RegisterManeuver} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RegisterManeuver} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RegisterManeuver pollRegisterManeuver(String entityName, long timeoutMillis) {
		IMCMessage m = poll("RegisterManeuver", entityName, timeoutMillis);
		if (m != null)
			try {
				RegisterManeuver ms = new RegisterManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ManeuverControlState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link ManeuverControlState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ManeuverControlState lastManeuverControlState() {
		IMCMessage m = get("ManeuverControlState");
		if (m != null)
			try {
				ManeuverControlState ms = new ManeuverControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ManeuverControlState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link ManeuverControlState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ManeuverControlState lastManeuverControlState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.ManeuverControlState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				ManeuverControlState ms = new ManeuverControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ManeuverControlState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ManeuverControlState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ManeuverControlState pollManeuverControlState(long timeoutMillis) {
		IMCMessage m = poll("ManeuverControlState", timeoutMillis);
		if (m != null)
			try {
				ManeuverControlState ms = new ManeuverControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ManeuverControlState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ManeuverControlState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ManeuverControlState pollManeuverControlState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("ManeuverControlState", entityName, timeoutMillis);
		if (m != null)
			try {
				ManeuverControlState ms = new ManeuverControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FollowSystem} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link FollowSystem} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FollowSystem lastFollowSystem() {
		IMCMessage m = get("FollowSystem");
		if (m != null)
			try {
				FollowSystem ms = new FollowSystem();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FollowSystem} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link FollowSystem} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FollowSystem lastFollowSystem(String entityName) {
		IMCMessage m = get(pt.lsts.imc.FollowSystem.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				FollowSystem ms = new FollowSystem();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FollowSystem}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FollowSystem} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FollowSystem pollFollowSystem(long timeoutMillis) {
		IMCMessage m = poll("FollowSystem", timeoutMillis);
		if (m != null)
			try {
				FollowSystem ms = new FollowSystem();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FollowSystem} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FollowSystem} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FollowSystem pollFollowSystem(String entityName, long timeoutMillis) {
		IMCMessage m = poll("FollowSystem", entityName, timeoutMillis);
		if (m != null)
			try {
				FollowSystem ms = new FollowSystem();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CommsRelay} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link CommsRelay} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CommsRelay lastCommsRelay() {
		IMCMessage m = get("CommsRelay");
		if (m != null)
			try {
				CommsRelay ms = new CommsRelay();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CommsRelay} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link CommsRelay} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CommsRelay lastCommsRelay(String entityName) {
		IMCMessage m = get(pt.lsts.imc.CommsRelay.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				CommsRelay ms = new CommsRelay();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CommsRelay}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CommsRelay} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CommsRelay pollCommsRelay(long timeoutMillis) {
		IMCMessage m = poll("CommsRelay", timeoutMillis);
		if (m != null)
			try {
				CommsRelay ms = new CommsRelay();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CommsRelay} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CommsRelay} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CommsRelay pollCommsRelay(String entityName, long timeoutMillis) {
		IMCMessage m = poll("CommsRelay", entityName, timeoutMillis);
		if (m != null)
			try {
				CommsRelay ms = new CommsRelay();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CoverArea} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link CoverArea} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CoverArea lastCoverArea() {
		IMCMessage m = get("CoverArea");
		if (m != null)
			try {
				CoverArea ms = new CoverArea();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CoverArea} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link CoverArea} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CoverArea lastCoverArea(String entityName) {
		IMCMessage m = get(pt.lsts.imc.CoverArea.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				CoverArea ms = new CoverArea();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CoverArea}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CoverArea} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CoverArea pollCoverArea(long timeoutMillis) {
		IMCMessage m = poll("CoverArea", timeoutMillis);
		if (m != null)
			try {
				CoverArea ms = new CoverArea();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CoverArea} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CoverArea} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CoverArea pollCoverArea(String entityName, long timeoutMillis) {
		IMCMessage m = poll("CoverArea", entityName, timeoutMillis);
		if (m != null)
			try {
				CoverArea ms = new CoverArea();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PolygonVertex} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PolygonVertex} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PolygonVertex lastPolygonVertex() {
		IMCMessage m = get("PolygonVertex");
		if (m != null)
			try {
				PolygonVertex ms = new PolygonVertex();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PolygonVertex} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PolygonVertex} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PolygonVertex lastPolygonVertex(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PolygonVertex.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PolygonVertex ms = new PolygonVertex();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PolygonVertex}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PolygonVertex} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PolygonVertex pollPolygonVertex(long timeoutMillis) {
		IMCMessage m = poll("PolygonVertex", timeoutMillis);
		if (m != null)
			try {
				PolygonVertex ms = new PolygonVertex();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PolygonVertex} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PolygonVertex} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PolygonVertex pollPolygonVertex(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PolygonVertex", entityName, timeoutMillis);
		if (m != null)
			try {
				PolygonVertex ms = new PolygonVertex();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CompassCalibration} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link CompassCalibration} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CompassCalibration lastCompassCalibration() {
		IMCMessage m = get("CompassCalibration");
		if (m != null)
			try {
				CompassCalibration ms = new CompassCalibration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CompassCalibration} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link CompassCalibration} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CompassCalibration lastCompassCalibration(String entityName) {
		IMCMessage m = get(pt.lsts.imc.CompassCalibration.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				CompassCalibration ms = new CompassCalibration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CompassCalibration}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CompassCalibration} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CompassCalibration pollCompassCalibration(long timeoutMillis) {
		IMCMessage m = poll("CompassCalibration", timeoutMillis);
		if (m != null)
			try {
				CompassCalibration ms = new CompassCalibration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CompassCalibration} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CompassCalibration} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CompassCalibration pollCompassCalibration(String entityName, long timeoutMillis) {
		IMCMessage m = poll("CompassCalibration", entityName, timeoutMillis);
		if (m != null)
			try {
				CompassCalibration ms = new CompassCalibration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FormationParameters} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link FormationParameters} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FormationParameters lastFormationParameters() {
		IMCMessage m = get("FormationParameters");
		if (m != null)
			try {
				FormationParameters ms = new FormationParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FormationParameters} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link FormationParameters} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FormationParameters lastFormationParameters(String entityName) {
		IMCMessage m = get(pt.lsts.imc.FormationParameters.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				FormationParameters ms = new FormationParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FormationParameters}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FormationParameters} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FormationParameters pollFormationParameters(long timeoutMillis) {
		IMCMessage m = poll("FormationParameters", timeoutMillis);
		if (m != null)
			try {
				FormationParameters ms = new FormationParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FormationParameters} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FormationParameters} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FormationParameters pollFormationParameters(String entityName, long timeoutMillis) {
		IMCMessage m = poll("FormationParameters", entityName, timeoutMillis);
		if (m != null)
			try {
				FormationParameters ms = new FormationParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FormationPlanExecution} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link FormationPlanExecution} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FormationPlanExecution lastFormationPlanExecution() {
		IMCMessage m = get("FormationPlanExecution");
		if (m != null)
			try {
				FormationPlanExecution ms = new FormationPlanExecution();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FormationPlanExecution} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link FormationPlanExecution} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FormationPlanExecution lastFormationPlanExecution(String entityName) {
		IMCMessage m = get(pt.lsts.imc.FormationPlanExecution.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				FormationPlanExecution ms = new FormationPlanExecution();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FormationPlanExecution}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FormationPlanExecution} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FormationPlanExecution pollFormationPlanExecution(long timeoutMillis) {
		IMCMessage m = poll("FormationPlanExecution", timeoutMillis);
		if (m != null)
			try {
				FormationPlanExecution ms = new FormationPlanExecution();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FormationPlanExecution} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FormationPlanExecution} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FormationPlanExecution pollFormationPlanExecution(String entityName, long timeoutMillis) {
		IMCMessage m = poll("FormationPlanExecution", entityName, timeoutMillis);
		if (m != null)
			try {
				FormationPlanExecution ms = new FormationPlanExecution();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FollowReference} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link FollowReference} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FollowReference lastFollowReference() {
		IMCMessage m = get("FollowReference");
		if (m != null)
			try {
				FollowReference ms = new FollowReference();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FollowReference} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link FollowReference} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FollowReference lastFollowReference(String entityName) {
		IMCMessage m = get(pt.lsts.imc.FollowReference.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				FollowReference ms = new FollowReference();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FollowReference}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FollowReference} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FollowReference pollFollowReference(long timeoutMillis) {
		IMCMessage m = poll("FollowReference", timeoutMillis);
		if (m != null)
			try {
				FollowReference ms = new FollowReference();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FollowReference} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FollowReference} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FollowReference pollFollowReference(String entityName, long timeoutMillis) {
		IMCMessage m = poll("FollowReference", entityName, timeoutMillis);
		if (m != null)
			try {
				FollowReference ms = new FollowReference();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Reference} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Reference} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Reference lastReference() {
		IMCMessage m = get("Reference");
		if (m != null)
			try {
				Reference ms = new Reference();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Reference} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Reference} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Reference lastReference(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Reference.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Reference ms = new Reference();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Reference}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Reference} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Reference pollReference(long timeoutMillis) {
		IMCMessage m = poll("Reference", timeoutMillis);
		if (m != null)
			try {
				Reference ms = new Reference();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Reference} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Reference} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Reference pollReference(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Reference", entityName, timeoutMillis);
		if (m != null)
			try {
				Reference ms = new Reference();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FollowRefState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link FollowRefState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FollowRefState lastFollowRefState() {
		IMCMessage m = get("FollowRefState");
		if (m != null)
			try {
				FollowRefState ms = new FollowRefState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FollowRefState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link FollowRefState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FollowRefState lastFollowRefState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.FollowRefState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				FollowRefState ms = new FollowRefState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FollowRefState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FollowRefState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FollowRefState pollFollowRefState(long timeoutMillis) {
		IMCMessage m = poll("FollowRefState", timeoutMillis);
		if (m != null)
			try {
				FollowRefState ms = new FollowRefState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FollowRefState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FollowRefState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FollowRefState pollFollowRefState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("FollowRefState", entityName, timeoutMillis);
		if (m != null)
			try {
				FollowRefState ms = new FollowRefState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FormationMonitor} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link FormationMonitor} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FormationMonitor lastFormationMonitor() {
		IMCMessage m = get("FormationMonitor");
		if (m != null)
			try {
				FormationMonitor ms = new FormationMonitor();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FormationMonitor} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link FormationMonitor} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FormationMonitor lastFormationMonitor(String entityName) {
		IMCMessage m = get(pt.lsts.imc.FormationMonitor.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				FormationMonitor ms = new FormationMonitor();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FormationMonitor}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FormationMonitor} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FormationMonitor pollFormationMonitor(long timeoutMillis) {
		IMCMessage m = poll("FormationMonitor", timeoutMillis);
		if (m != null)
			try {
				FormationMonitor ms = new FormationMonitor();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FormationMonitor} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FormationMonitor} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FormationMonitor pollFormationMonitor(String entityName, long timeoutMillis) {
		IMCMessage m = poll("FormationMonitor", entityName, timeoutMillis);
		if (m != null)
			try {
				FormationMonitor ms = new FormationMonitor();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RelativeState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link RelativeState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RelativeState lastRelativeState() {
		IMCMessage m = get("RelativeState");
		if (m != null)
			try {
				RelativeState ms = new RelativeState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RelativeState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link RelativeState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RelativeState lastRelativeState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.RelativeState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				RelativeState ms = new RelativeState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RelativeState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RelativeState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RelativeState pollRelativeState(long timeoutMillis) {
		IMCMessage m = poll("RelativeState", timeoutMillis);
		if (m != null)
			try {
				RelativeState ms = new RelativeState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RelativeState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RelativeState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RelativeState pollRelativeState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("RelativeState", entityName, timeoutMillis);
		if (m != null)
			try {
				RelativeState ms = new RelativeState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Dislodge} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Dislodge} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Dislodge lastDislodge() {
		IMCMessage m = get("Dislodge");
		if (m != null)
			try {
				Dislodge ms = new Dislodge();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Dislodge} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Dislodge} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Dislodge lastDislodge(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Dislodge.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Dislodge ms = new Dislodge();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Dislodge}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Dislodge} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Dislodge pollDislodge(long timeoutMillis) {
		IMCMessage m = poll("Dislodge", timeoutMillis);
		if (m != null)
			try {
				Dislodge ms = new Dislodge();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Dislodge} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Dislodge} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Dislodge pollDislodge(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Dislodge", entityName, timeoutMillis);
		if (m != null)
			try {
				Dislodge ms = new Dislodge();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VehicleState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link VehicleState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VehicleState lastVehicleState() {
		IMCMessage m = get("VehicleState");
		if (m != null)
			try {
				VehicleState ms = new VehicleState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VehicleState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link VehicleState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VehicleState lastVehicleState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.VehicleState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				VehicleState ms = new VehicleState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VehicleState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VehicleState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VehicleState pollVehicleState(long timeoutMillis) {
		IMCMessage m = poll("VehicleState", timeoutMillis);
		if (m != null)
			try {
				VehicleState ms = new VehicleState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VehicleState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VehicleState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VehicleState pollVehicleState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("VehicleState", entityName, timeoutMillis);
		if (m != null)
			try {
				VehicleState ms = new VehicleState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VehicleCommand} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link VehicleCommand} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VehicleCommand lastVehicleCommand() {
		IMCMessage m = get("VehicleCommand");
		if (m != null)
			try {
				VehicleCommand ms = new VehicleCommand();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VehicleCommand} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link VehicleCommand} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VehicleCommand lastVehicleCommand(String entityName) {
		IMCMessage m = get(pt.lsts.imc.VehicleCommand.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				VehicleCommand ms = new VehicleCommand();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VehicleCommand}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VehicleCommand} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VehicleCommand pollVehicleCommand(long timeoutMillis) {
		IMCMessage m = poll("VehicleCommand", timeoutMillis);
		if (m != null)
			try {
				VehicleCommand ms = new VehicleCommand();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VehicleCommand} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VehicleCommand} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VehicleCommand pollVehicleCommand(String entityName, long timeoutMillis) {
		IMCMessage m = poll("VehicleCommand", entityName, timeoutMillis);
		if (m != null)
			try {
				VehicleCommand ms = new VehicleCommand();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link MonitorEntityState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link MonitorEntityState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.MonitorEntityState lastMonitorEntityState() {
		IMCMessage m = get("MonitorEntityState");
		if (m != null)
			try {
				MonitorEntityState ms = new MonitorEntityState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link MonitorEntityState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link MonitorEntityState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.MonitorEntityState lastMonitorEntityState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.MonitorEntityState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				MonitorEntityState ms = new MonitorEntityState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link MonitorEntityState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link MonitorEntityState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.MonitorEntityState pollMonitorEntityState(long timeoutMillis) {
		IMCMessage m = poll("MonitorEntityState", timeoutMillis);
		if (m != null)
			try {
				MonitorEntityState ms = new MonitorEntityState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link MonitorEntityState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link MonitorEntityState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.MonitorEntityState pollMonitorEntityState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("MonitorEntityState", entityName, timeoutMillis);
		if (m != null)
			try {
				MonitorEntityState ms = new MonitorEntityState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EntityMonitoringState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link EntityMonitoringState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EntityMonitoringState lastEntityMonitoringState() {
		IMCMessage m = get("EntityMonitoringState");
		if (m != null)
			try {
				EntityMonitoringState ms = new EntityMonitoringState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EntityMonitoringState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link EntityMonitoringState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EntityMonitoringState lastEntityMonitoringState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.EntityMonitoringState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				EntityMonitoringState ms = new EntityMonitoringState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EntityMonitoringState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EntityMonitoringState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EntityMonitoringState pollEntityMonitoringState(long timeoutMillis) {
		IMCMessage m = poll("EntityMonitoringState", timeoutMillis);
		if (m != null)
			try {
				EntityMonitoringState ms = new EntityMonitoringState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EntityMonitoringState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EntityMonitoringState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EntityMonitoringState pollEntityMonitoringState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("EntityMonitoringState", entityName, timeoutMillis);
		if (m != null)
			try {
				EntityMonitoringState ms = new EntityMonitoringState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link OperationalLimits} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link OperationalLimits} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.OperationalLimits lastOperationalLimits() {
		IMCMessage m = get("OperationalLimits");
		if (m != null)
			try {
				OperationalLimits ms = new OperationalLimits();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link OperationalLimits} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link OperationalLimits} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.OperationalLimits lastOperationalLimits(String entityName) {
		IMCMessage m = get(pt.lsts.imc.OperationalLimits.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				OperationalLimits ms = new OperationalLimits();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link OperationalLimits}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link OperationalLimits} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.OperationalLimits pollOperationalLimits(long timeoutMillis) {
		IMCMessage m = poll("OperationalLimits", timeoutMillis);
		if (m != null)
			try {
				OperationalLimits ms = new OperationalLimits();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link OperationalLimits} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link OperationalLimits} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.OperationalLimits pollOperationalLimits(String entityName, long timeoutMillis) {
		IMCMessage m = poll("OperationalLimits", entityName, timeoutMillis);
		if (m != null)
			try {
				OperationalLimits ms = new OperationalLimits();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link GetOperationalLimits} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link GetOperationalLimits} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.GetOperationalLimits lastGetOperationalLimits() {
		IMCMessage m = get("GetOperationalLimits");
		if (m != null)
			try {
				GetOperationalLimits ms = new GetOperationalLimits();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link GetOperationalLimits} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link GetOperationalLimits} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.GetOperationalLimits lastGetOperationalLimits(String entityName) {
		IMCMessage m = get(pt.lsts.imc.GetOperationalLimits.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				GetOperationalLimits ms = new GetOperationalLimits();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link GetOperationalLimits}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link GetOperationalLimits} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.GetOperationalLimits pollGetOperationalLimits(long timeoutMillis) {
		IMCMessage m = poll("GetOperationalLimits", timeoutMillis);
		if (m != null)
			try {
				GetOperationalLimits ms = new GetOperationalLimits();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link GetOperationalLimits} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link GetOperationalLimits} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.GetOperationalLimits pollGetOperationalLimits(String entityName, long timeoutMillis) {
		IMCMessage m = poll("GetOperationalLimits", entityName, timeoutMillis);
		if (m != null)
			try {
				GetOperationalLimits ms = new GetOperationalLimits();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Calibration} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Calibration} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Calibration lastCalibration() {
		IMCMessage m = get("Calibration");
		if (m != null)
			try {
				Calibration ms = new Calibration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Calibration} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Calibration} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Calibration lastCalibration(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Calibration.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Calibration ms = new Calibration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Calibration}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Calibration} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Calibration pollCalibration(long timeoutMillis) {
		IMCMessage m = poll("Calibration", timeoutMillis);
		if (m != null)
			try {
				Calibration ms = new Calibration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Calibration} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Calibration} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Calibration pollCalibration(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Calibration", entityName, timeoutMillis);
		if (m != null)
			try {
				Calibration ms = new Calibration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ControlLoops} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link ControlLoops} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ControlLoops lastControlLoops() {
		IMCMessage m = get("ControlLoops");
		if (m != null)
			try {
				ControlLoops ms = new ControlLoops();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ControlLoops} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link ControlLoops} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ControlLoops lastControlLoops(String entityName) {
		IMCMessage m = get(pt.lsts.imc.ControlLoops.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				ControlLoops ms = new ControlLoops();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ControlLoops}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ControlLoops} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ControlLoops pollControlLoops(long timeoutMillis) {
		IMCMessage m = poll("ControlLoops", timeoutMillis);
		if (m != null)
			try {
				ControlLoops ms = new ControlLoops();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ControlLoops} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ControlLoops} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ControlLoops pollControlLoops(String entityName, long timeoutMillis) {
		IMCMessage m = poll("ControlLoops", entityName, timeoutMillis);
		if (m != null)
			try {
				ControlLoops ms = new ControlLoops();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VehicleMedium} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link VehicleMedium} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VehicleMedium lastVehicleMedium() {
		IMCMessage m = get("VehicleMedium");
		if (m != null)
			try {
				VehicleMedium ms = new VehicleMedium();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VehicleMedium} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link VehicleMedium} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VehicleMedium lastVehicleMedium(String entityName) {
		IMCMessage m = get(pt.lsts.imc.VehicleMedium.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				VehicleMedium ms = new VehicleMedium();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VehicleMedium}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VehicleMedium} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VehicleMedium pollVehicleMedium(long timeoutMillis) {
		IMCMessage m = poll("VehicleMedium", timeoutMillis);
		if (m != null)
			try {
				VehicleMedium ms = new VehicleMedium();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VehicleMedium} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VehicleMedium} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VehicleMedium pollVehicleMedium(String entityName, long timeoutMillis) {
		IMCMessage m = poll("VehicleMedium", entityName, timeoutMillis);
		if (m != null)
			try {
				VehicleMedium ms = new VehicleMedium();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Collision} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Collision} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Collision lastCollision() {
		IMCMessage m = get("Collision");
		if (m != null)
			try {
				Collision ms = new Collision();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Collision} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Collision} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Collision lastCollision(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Collision.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Collision ms = new Collision();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Collision}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Collision} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Collision pollCollision(long timeoutMillis) {
		IMCMessage m = poll("Collision", timeoutMillis);
		if (m != null)
			try {
				Collision ms = new Collision();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Collision} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Collision} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Collision pollCollision(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Collision", entityName, timeoutMillis);
		if (m != null)
			try {
				Collision ms = new Collision();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FormState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link FormState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FormState lastFormState() {
		IMCMessage m = get("FormState");
		if (m != null)
			try {
				FormState ms = new FormState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FormState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link FormState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FormState lastFormState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.FormState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				FormState ms = new FormState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FormState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FormState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FormState pollFormState(long timeoutMillis) {
		IMCMessage m = poll("FormState", timeoutMillis);
		if (m != null)
			try {
				FormState ms = new FormState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FormState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FormState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FormState pollFormState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("FormState", entityName, timeoutMillis);
		if (m != null)
			try {
				FormState ms = new FormState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AutopilotMode} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link AutopilotMode} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AutopilotMode lastAutopilotMode() {
		IMCMessage m = get("AutopilotMode");
		if (m != null)
			try {
				AutopilotMode ms = new AutopilotMode();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link AutopilotMode} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link AutopilotMode} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.AutopilotMode lastAutopilotMode(String entityName) {
		IMCMessage m = get(pt.lsts.imc.AutopilotMode.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				AutopilotMode ms = new AutopilotMode();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AutopilotMode}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AutopilotMode} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AutopilotMode pollAutopilotMode(long timeoutMillis) {
		IMCMessage m = poll("AutopilotMode", timeoutMillis);
		if (m != null)
			try {
				AutopilotMode ms = new AutopilotMode();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link AutopilotMode} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link AutopilotMode} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.AutopilotMode pollAutopilotMode(String entityName, long timeoutMillis) {
		IMCMessage m = poll("AutopilotMode", entityName, timeoutMillis);
		if (m != null)
			try {
				AutopilotMode ms = new AutopilotMode();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Abort} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Abort} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Abort lastAbort() {
		IMCMessage m = get("Abort");
		if (m != null)
			try {
				Abort ms = new Abort();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Abort} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Abort} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Abort lastAbort(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Abort.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Abort ms = new Abort();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Abort}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Abort} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Abort pollAbort(long timeoutMillis) {
		IMCMessage m = poll("Abort", timeoutMillis);
		if (m != null)
			try {
				Abort ms = new Abort();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Abort} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Abort} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Abort pollAbort(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Abort", entityName, timeoutMillis);
		if (m != null)
			try {
				Abort ms = new Abort();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanSpecification} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PlanSpecification} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanSpecification lastPlanSpecification() {
		IMCMessage m = get("PlanSpecification");
		if (m != null)
			try {
				PlanSpecification ms = new PlanSpecification();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanSpecification} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PlanSpecification} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanSpecification lastPlanSpecification(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PlanSpecification.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PlanSpecification ms = new PlanSpecification();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanSpecification}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanSpecification} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanSpecification pollPlanSpecification(long timeoutMillis) {
		IMCMessage m = poll("PlanSpecification", timeoutMillis);
		if (m != null)
			try {
				PlanSpecification ms = new PlanSpecification();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanSpecification} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanSpecification} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanSpecification pollPlanSpecification(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PlanSpecification", entityName, timeoutMillis);
		if (m != null)
			try {
				PlanSpecification ms = new PlanSpecification();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanManeuver} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PlanManeuver} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanManeuver lastPlanManeuver() {
		IMCMessage m = get("PlanManeuver");
		if (m != null)
			try {
				PlanManeuver ms = new PlanManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanManeuver} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PlanManeuver} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanManeuver lastPlanManeuver(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PlanManeuver.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PlanManeuver ms = new PlanManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanManeuver}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanManeuver} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanManeuver pollPlanManeuver(long timeoutMillis) {
		IMCMessage m = poll("PlanManeuver", timeoutMillis);
		if (m != null)
			try {
				PlanManeuver ms = new PlanManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanManeuver} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanManeuver} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanManeuver pollPlanManeuver(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PlanManeuver", entityName, timeoutMillis);
		if (m != null)
			try {
				PlanManeuver ms = new PlanManeuver();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanTransition} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PlanTransition} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanTransition lastPlanTransition() {
		IMCMessage m = get("PlanTransition");
		if (m != null)
			try {
				PlanTransition ms = new PlanTransition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanTransition} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PlanTransition} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanTransition lastPlanTransition(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PlanTransition.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PlanTransition ms = new PlanTransition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanTransition}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanTransition} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanTransition pollPlanTransition(long timeoutMillis) {
		IMCMessage m = poll("PlanTransition", timeoutMillis);
		if (m != null)
			try {
				PlanTransition ms = new PlanTransition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanTransition} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanTransition} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanTransition pollPlanTransition(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PlanTransition", entityName, timeoutMillis);
		if (m != null)
			try {
				PlanTransition ms = new PlanTransition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EmergencyControl} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link EmergencyControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EmergencyControl lastEmergencyControl() {
		IMCMessage m = get("EmergencyControl");
		if (m != null)
			try {
				EmergencyControl ms = new EmergencyControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EmergencyControl} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link EmergencyControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EmergencyControl lastEmergencyControl(String entityName) {
		IMCMessage m = get(pt.lsts.imc.EmergencyControl.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				EmergencyControl ms = new EmergencyControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EmergencyControl}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EmergencyControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EmergencyControl pollEmergencyControl(long timeoutMillis) {
		IMCMessage m = poll("EmergencyControl", timeoutMillis);
		if (m != null)
			try {
				EmergencyControl ms = new EmergencyControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EmergencyControl} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EmergencyControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EmergencyControl pollEmergencyControl(String entityName, long timeoutMillis) {
		IMCMessage m = poll("EmergencyControl", entityName, timeoutMillis);
		if (m != null)
			try {
				EmergencyControl ms = new EmergencyControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EmergencyControlState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link EmergencyControlState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EmergencyControlState lastEmergencyControlState() {
		IMCMessage m = get("EmergencyControlState");
		if (m != null)
			try {
				EmergencyControlState ms = new EmergencyControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EmergencyControlState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link EmergencyControlState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EmergencyControlState lastEmergencyControlState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.EmergencyControlState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				EmergencyControlState ms = new EmergencyControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EmergencyControlState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EmergencyControlState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EmergencyControlState pollEmergencyControlState(long timeoutMillis) {
		IMCMessage m = poll("EmergencyControlState", timeoutMillis);
		if (m != null)
			try {
				EmergencyControlState ms = new EmergencyControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EmergencyControlState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EmergencyControlState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EmergencyControlState pollEmergencyControlState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("EmergencyControlState", entityName, timeoutMillis);
		if (m != null)
			try {
				EmergencyControlState ms = new EmergencyControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanDB} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PlanDB} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanDB lastPlanDB() {
		IMCMessage m = get("PlanDB");
		if (m != null)
			try {
				PlanDB ms = new PlanDB();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanDB} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PlanDB} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanDB lastPlanDB(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PlanDB.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PlanDB ms = new PlanDB();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanDB}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanDB} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanDB pollPlanDB(long timeoutMillis) {
		IMCMessage m = poll("PlanDB", timeoutMillis);
		if (m != null)
			try {
				PlanDB ms = new PlanDB();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanDB} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanDB} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanDB pollPlanDB(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PlanDB", entityName, timeoutMillis);
		if (m != null)
			try {
				PlanDB ms = new PlanDB();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanDBState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PlanDBState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanDBState lastPlanDBState() {
		IMCMessage m = get("PlanDBState");
		if (m != null)
			try {
				PlanDBState ms = new PlanDBState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanDBState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PlanDBState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanDBState lastPlanDBState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PlanDBState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PlanDBState ms = new PlanDBState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanDBState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanDBState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanDBState pollPlanDBState(long timeoutMillis) {
		IMCMessage m = poll("PlanDBState", timeoutMillis);
		if (m != null)
			try {
				PlanDBState ms = new PlanDBState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanDBState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanDBState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanDBState pollPlanDBState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PlanDBState", entityName, timeoutMillis);
		if (m != null)
			try {
				PlanDBState ms = new PlanDBState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanDBInformation} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PlanDBInformation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanDBInformation lastPlanDBInformation() {
		IMCMessage m = get("PlanDBInformation");
		if (m != null)
			try {
				PlanDBInformation ms = new PlanDBInformation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanDBInformation} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PlanDBInformation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanDBInformation lastPlanDBInformation(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PlanDBInformation.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PlanDBInformation ms = new PlanDBInformation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanDBInformation}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanDBInformation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanDBInformation pollPlanDBInformation(long timeoutMillis) {
		IMCMessage m = poll("PlanDBInformation", timeoutMillis);
		if (m != null)
			try {
				PlanDBInformation ms = new PlanDBInformation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanDBInformation} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanDBInformation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanDBInformation pollPlanDBInformation(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PlanDBInformation", entityName, timeoutMillis);
		if (m != null)
			try {
				PlanDBInformation ms = new PlanDBInformation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanControl} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PlanControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanControl lastPlanControl() {
		IMCMessage m = get("PlanControl");
		if (m != null)
			try {
				PlanControl ms = new PlanControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanControl} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PlanControl} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanControl lastPlanControl(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PlanControl.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PlanControl ms = new PlanControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanControl}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanControl pollPlanControl(long timeoutMillis) {
		IMCMessage m = poll("PlanControl", timeoutMillis);
		if (m != null)
			try {
				PlanControl ms = new PlanControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanControl} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanControl} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanControl pollPlanControl(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PlanControl", entityName, timeoutMillis);
		if (m != null)
			try {
				PlanControl ms = new PlanControl();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanControlState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PlanControlState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanControlState lastPlanControlState() {
		IMCMessage m = get("PlanControlState");
		if (m != null)
			try {
				PlanControlState ms = new PlanControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanControlState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PlanControlState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanControlState lastPlanControlState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PlanControlState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PlanControlState ms = new PlanControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanControlState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanControlState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanControlState pollPlanControlState(long timeoutMillis) {
		IMCMessage m = poll("PlanControlState", timeoutMillis);
		if (m != null)
			try {
				PlanControlState ms = new PlanControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanControlState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanControlState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanControlState pollPlanControlState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PlanControlState", entityName, timeoutMillis);
		if (m != null)
			try {
				PlanControlState ms = new PlanControlState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanVariable} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PlanVariable} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanVariable lastPlanVariable() {
		IMCMessage m = get("PlanVariable");
		if (m != null)
			try {
				PlanVariable ms = new PlanVariable();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanVariable} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PlanVariable} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanVariable lastPlanVariable(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PlanVariable.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PlanVariable ms = new PlanVariable();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanVariable}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanVariable} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanVariable pollPlanVariable(long timeoutMillis) {
		IMCMessage m = poll("PlanVariable", timeoutMillis);
		if (m != null)
			try {
				PlanVariable ms = new PlanVariable();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanVariable} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanVariable} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanVariable pollPlanVariable(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PlanVariable", entityName, timeoutMillis);
		if (m != null)
			try {
				PlanVariable ms = new PlanVariable();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanGeneration} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PlanGeneration} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanGeneration lastPlanGeneration() {
		IMCMessage m = get("PlanGeneration");
		if (m != null)
			try {
				PlanGeneration ms = new PlanGeneration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanGeneration} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PlanGeneration} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanGeneration lastPlanGeneration(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PlanGeneration.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PlanGeneration ms = new PlanGeneration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanGeneration}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanGeneration} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanGeneration pollPlanGeneration(long timeoutMillis) {
		IMCMessage m = poll("PlanGeneration", timeoutMillis);
		if (m != null)
			try {
				PlanGeneration ms = new PlanGeneration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanGeneration} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanGeneration} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanGeneration pollPlanGeneration(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PlanGeneration", entityName, timeoutMillis);
		if (m != null)
			try {
				PlanGeneration ms = new PlanGeneration();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LeaderState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link LeaderState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LeaderState lastLeaderState() {
		IMCMessage m = get("LeaderState");
		if (m != null)
			try {
				LeaderState ms = new LeaderState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link LeaderState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link LeaderState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.LeaderState lastLeaderState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.LeaderState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				LeaderState ms = new LeaderState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LeaderState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LeaderState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LeaderState pollLeaderState(long timeoutMillis) {
		IMCMessage m = poll("LeaderState", timeoutMillis);
		if (m != null)
			try {
				LeaderState ms = new LeaderState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link LeaderState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link LeaderState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.LeaderState pollLeaderState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("LeaderState", entityName, timeoutMillis);
		if (m != null)
			try {
				LeaderState ms = new LeaderState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanStatistics} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PlanStatistics} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanStatistics lastPlanStatistics() {
		IMCMessage m = get("PlanStatistics");
		if (m != null)
			try {
				PlanStatistics ms = new PlanStatistics();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PlanStatistics} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PlanStatistics} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PlanStatistics lastPlanStatistics(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PlanStatistics.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PlanStatistics ms = new PlanStatistics();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanStatistics}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanStatistics} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanStatistics pollPlanStatistics(long timeoutMillis) {
		IMCMessage m = poll("PlanStatistics", timeoutMillis);
		if (m != null)
			try {
				PlanStatistics ms = new PlanStatistics();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PlanStatistics} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PlanStatistics} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PlanStatistics pollPlanStatistics(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PlanStatistics", entityName, timeoutMillis);
		if (m != null)
			try {
				PlanStatistics ms = new PlanStatistics();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ReportedState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link ReportedState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ReportedState lastReportedState() {
		IMCMessage m = get("ReportedState");
		if (m != null)
			try {
				ReportedState ms = new ReportedState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ReportedState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link ReportedState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ReportedState lastReportedState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.ReportedState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				ReportedState ms = new ReportedState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ReportedState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ReportedState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ReportedState pollReportedState(long timeoutMillis) {
		IMCMessage m = poll("ReportedState", timeoutMillis);
		if (m != null)
			try {
				ReportedState ms = new ReportedState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ReportedState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ReportedState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ReportedState pollReportedState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("ReportedState", entityName, timeoutMillis);
		if (m != null)
			try {
				ReportedState ms = new ReportedState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RemoteSensorInfo} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link RemoteSensorInfo} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RemoteSensorInfo lastRemoteSensorInfo() {
		IMCMessage m = get("RemoteSensorInfo");
		if (m != null)
			try {
				RemoteSensorInfo ms = new RemoteSensorInfo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RemoteSensorInfo} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link RemoteSensorInfo} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RemoteSensorInfo lastRemoteSensorInfo(String entityName) {
		IMCMessage m = get(pt.lsts.imc.RemoteSensorInfo.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				RemoteSensorInfo ms = new RemoteSensorInfo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RemoteSensorInfo}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RemoteSensorInfo} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RemoteSensorInfo pollRemoteSensorInfo(long timeoutMillis) {
		IMCMessage m = poll("RemoteSensorInfo", timeoutMillis);
		if (m != null)
			try {
				RemoteSensorInfo ms = new RemoteSensorInfo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RemoteSensorInfo} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RemoteSensorInfo} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RemoteSensorInfo pollRemoteSensorInfo(String entityName, long timeoutMillis) {
		IMCMessage m = poll("RemoteSensorInfo", entityName, timeoutMillis);
		if (m != null)
			try {
				RemoteSensorInfo ms = new RemoteSensorInfo();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Map} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Map} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Map lastMap() {
		IMCMessage m = get("Map");
		if (m != null)
			try {
				Map ms = new Map();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Map} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Map} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Map lastMap(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Map.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Map ms = new Map();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Map}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Map} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Map pollMap(long timeoutMillis) {
		IMCMessage m = poll("Map", timeoutMillis);
		if (m != null)
			try {
				Map ms = new Map();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Map} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Map} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Map pollMap(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Map", entityName, timeoutMillis);
		if (m != null)
			try {
				Map ms = new Map();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link MapFeature} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link MapFeature} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.MapFeature lastMapFeature() {
		IMCMessage m = get("MapFeature");
		if (m != null)
			try {
				MapFeature ms = new MapFeature();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link MapFeature} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link MapFeature} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.MapFeature lastMapFeature(String entityName) {
		IMCMessage m = get(pt.lsts.imc.MapFeature.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				MapFeature ms = new MapFeature();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link MapFeature}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link MapFeature} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.MapFeature pollMapFeature(long timeoutMillis) {
		IMCMessage m = poll("MapFeature", timeoutMillis);
		if (m != null)
			try {
				MapFeature ms = new MapFeature();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link MapFeature} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link MapFeature} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.MapFeature pollMapFeature(String entityName, long timeoutMillis) {
		IMCMessage m = poll("MapFeature", entityName, timeoutMillis);
		if (m != null)
			try {
				MapFeature ms = new MapFeature();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link MapPoint} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link MapPoint} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.MapPoint lastMapPoint() {
		IMCMessage m = get("MapPoint");
		if (m != null)
			try {
				MapPoint ms = new MapPoint();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link MapPoint} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link MapPoint} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.MapPoint lastMapPoint(String entityName) {
		IMCMessage m = get(pt.lsts.imc.MapPoint.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				MapPoint ms = new MapPoint();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link MapPoint}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link MapPoint} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.MapPoint pollMapPoint(long timeoutMillis) {
		IMCMessage m = poll("MapPoint", timeoutMillis);
		if (m != null)
			try {
				MapPoint ms = new MapPoint();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link MapPoint} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link MapPoint} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.MapPoint pollMapPoint(String entityName, long timeoutMillis) {
		IMCMessage m = poll("MapPoint", entityName, timeoutMillis);
		if (m != null)
			try {
				MapPoint ms = new MapPoint();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CcuEvent} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link CcuEvent} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CcuEvent lastCcuEvent() {
		IMCMessage m = get("CcuEvent");
		if (m != null)
			try {
				CcuEvent ms = new CcuEvent();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CcuEvent} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link CcuEvent} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CcuEvent lastCcuEvent(String entityName) {
		IMCMessage m = get(pt.lsts.imc.CcuEvent.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				CcuEvent ms = new CcuEvent();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CcuEvent}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CcuEvent} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CcuEvent pollCcuEvent(long timeoutMillis) {
		IMCMessage m = poll("CcuEvent", timeoutMillis);
		if (m != null)
			try {
				CcuEvent ms = new CcuEvent();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CcuEvent} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CcuEvent} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CcuEvent pollCcuEvent(String entityName, long timeoutMillis) {
		IMCMessage m = poll("CcuEvent", entityName, timeoutMillis);
		if (m != null)
			try {
				CcuEvent ms = new CcuEvent();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VehicleLinks} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link VehicleLinks} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VehicleLinks lastVehicleLinks() {
		IMCMessage m = get("VehicleLinks");
		if (m != null)
			try {
				VehicleLinks ms = new VehicleLinks();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link VehicleLinks} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link VehicleLinks} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.VehicleLinks lastVehicleLinks(String entityName) {
		IMCMessage m = get(pt.lsts.imc.VehicleLinks.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				VehicleLinks ms = new VehicleLinks();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VehicleLinks}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VehicleLinks} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VehicleLinks pollVehicleLinks(long timeoutMillis) {
		IMCMessage m = poll("VehicleLinks", timeoutMillis);
		if (m != null)
			try {
				VehicleLinks ms = new VehicleLinks();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link VehicleLinks} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link VehicleLinks} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.VehicleLinks pollVehicleLinks(String entityName, long timeoutMillis) {
		IMCMessage m = poll("VehicleLinks", entityName, timeoutMillis);
		if (m != null)
			try {
				VehicleLinks ms = new VehicleLinks();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrexObservation} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link TrexObservation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrexObservation lastTrexObservation() {
		IMCMessage m = get("TrexObservation");
		if (m != null)
			try {
				TrexObservation ms = new TrexObservation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrexObservation} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link TrexObservation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrexObservation lastTrexObservation(String entityName) {
		IMCMessage m = get(pt.lsts.imc.TrexObservation.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				TrexObservation ms = new TrexObservation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrexObservation}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrexObservation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrexObservation pollTrexObservation(long timeoutMillis) {
		IMCMessage m = poll("TrexObservation", timeoutMillis);
		if (m != null)
			try {
				TrexObservation ms = new TrexObservation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrexObservation} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrexObservation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrexObservation pollTrexObservation(String entityName, long timeoutMillis) {
		IMCMessage m = poll("TrexObservation", entityName, timeoutMillis);
		if (m != null)
			try {
				TrexObservation ms = new TrexObservation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrexCommand} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link TrexCommand} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrexCommand lastTrexCommand() {
		IMCMessage m = get("TrexCommand");
		if (m != null)
			try {
				TrexCommand ms = new TrexCommand();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrexCommand} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link TrexCommand} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrexCommand lastTrexCommand(String entityName) {
		IMCMessage m = get(pt.lsts.imc.TrexCommand.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				TrexCommand ms = new TrexCommand();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrexCommand}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrexCommand} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrexCommand pollTrexCommand(long timeoutMillis) {
		IMCMessage m = poll("TrexCommand", timeoutMillis);
		if (m != null)
			try {
				TrexCommand ms = new TrexCommand();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrexCommand} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrexCommand} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrexCommand pollTrexCommand(String entityName, long timeoutMillis) {
		IMCMessage m = poll("TrexCommand", entityName, timeoutMillis);
		if (m != null)
			try {
				TrexCommand ms = new TrexCommand();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrexOperation} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link TrexOperation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrexOperation lastTrexOperation() {
		IMCMessage m = get("TrexOperation");
		if (m != null)
			try {
				TrexOperation ms = new TrexOperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrexOperation} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link TrexOperation} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrexOperation lastTrexOperation(String entityName) {
		IMCMessage m = get(pt.lsts.imc.TrexOperation.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				TrexOperation ms = new TrexOperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrexOperation}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrexOperation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrexOperation pollTrexOperation(long timeoutMillis) {
		IMCMessage m = poll("TrexOperation", timeoutMillis);
		if (m != null)
			try {
				TrexOperation ms = new TrexOperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrexOperation} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrexOperation} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrexOperation pollTrexOperation(String entityName, long timeoutMillis) {
		IMCMessage m = poll("TrexOperation", entityName, timeoutMillis);
		if (m != null)
			try {
				TrexOperation ms = new TrexOperation();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrexAttribute} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link TrexAttribute} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrexAttribute lastTrexAttribute() {
		IMCMessage m = get("TrexAttribute");
		if (m != null)
			try {
				TrexAttribute ms = new TrexAttribute();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrexAttribute} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link TrexAttribute} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrexAttribute lastTrexAttribute(String entityName) {
		IMCMessage m = get(pt.lsts.imc.TrexAttribute.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				TrexAttribute ms = new TrexAttribute();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrexAttribute}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrexAttribute} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrexAttribute pollTrexAttribute(long timeoutMillis) {
		IMCMessage m = poll("TrexAttribute", timeoutMillis);
		if (m != null)
			try {
				TrexAttribute ms = new TrexAttribute();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrexAttribute} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrexAttribute} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrexAttribute pollTrexAttribute(String entityName, long timeoutMillis) {
		IMCMessage m = poll("TrexAttribute", entityName, timeoutMillis);
		if (m != null)
			try {
				TrexAttribute ms = new TrexAttribute();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrexToken} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link TrexToken} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrexToken lastTrexToken() {
		IMCMessage m = get("TrexToken");
		if (m != null)
			try {
				TrexToken ms = new TrexToken();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrexToken} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link TrexToken} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrexToken lastTrexToken(String entityName) {
		IMCMessage m = get(pt.lsts.imc.TrexToken.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				TrexToken ms = new TrexToken();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrexToken}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrexToken} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrexToken pollTrexToken(long timeoutMillis) {
		IMCMessage m = poll("TrexToken", timeoutMillis);
		if (m != null)
			try {
				TrexToken ms = new TrexToken();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrexToken} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrexToken} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrexToken pollTrexToken(String entityName, long timeoutMillis) {
		IMCMessage m = poll("TrexToken", entityName, timeoutMillis);
		if (m != null)
			try {
				TrexToken ms = new TrexToken();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrexPlan} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link TrexPlan} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrexPlan lastTrexPlan() {
		IMCMessage m = get("TrexPlan");
		if (m != null)
			try {
				TrexPlan ms = new TrexPlan();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link TrexPlan} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link TrexPlan} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.TrexPlan lastTrexPlan(String entityName) {
		IMCMessage m = get(pt.lsts.imc.TrexPlan.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				TrexPlan ms = new TrexPlan();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrexPlan}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrexPlan} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrexPlan pollTrexPlan(long timeoutMillis) {
		IMCMessage m = poll("TrexPlan", timeoutMillis);
		if (m != null)
			try {
				TrexPlan ms = new TrexPlan();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link TrexPlan} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link TrexPlan} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.TrexPlan pollTrexPlan(String entityName, long timeoutMillis) {
		IMCMessage m = poll("TrexPlan", entityName, timeoutMillis);
		if (m != null)
			try {
				TrexPlan ms = new TrexPlan();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Event} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Event} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Event lastEvent() {
		IMCMessage m = get("Event");
		if (m != null)
			try {
				Event ms = new Event();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Event} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Event} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Event lastEvent(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Event.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Event ms = new Event();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Event}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Event} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Event pollEvent(long timeoutMillis) {
		IMCMessage m = poll("Event", timeoutMillis);
		if (m != null)
			try {
				Event ms = new Event();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Event} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Event} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Event pollEvent(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Event", entityName, timeoutMillis);
		if (m != null)
			try {
				Event ms = new Event();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CompressedImage} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link CompressedImage} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CompressedImage lastCompressedImage() {
		IMCMessage m = get("CompressedImage");
		if (m != null)
			try {
				CompressedImage ms = new CompressedImage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CompressedImage} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link CompressedImage} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CompressedImage lastCompressedImage(String entityName) {
		IMCMessage m = get(pt.lsts.imc.CompressedImage.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				CompressedImage ms = new CompressedImage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CompressedImage}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CompressedImage} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CompressedImage pollCompressedImage(long timeoutMillis) {
		IMCMessage m = poll("CompressedImage", timeoutMillis);
		if (m != null)
			try {
				CompressedImage ms = new CompressedImage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CompressedImage} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CompressedImage} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CompressedImage pollCompressedImage(String entityName, long timeoutMillis) {
		IMCMessage m = poll("CompressedImage", entityName, timeoutMillis);
		if (m != null)
			try {
				CompressedImage ms = new CompressedImage();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ImageTxSettings} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link ImageTxSettings} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ImageTxSettings lastImageTxSettings() {
		IMCMessage m = get("ImageTxSettings");
		if (m != null)
			try {
				ImageTxSettings ms = new ImageTxSettings();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link ImageTxSettings} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link ImageTxSettings} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.ImageTxSettings lastImageTxSettings(String entityName) {
		IMCMessage m = get(pt.lsts.imc.ImageTxSettings.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				ImageTxSettings ms = new ImageTxSettings();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ImageTxSettings}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ImageTxSettings} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ImageTxSettings pollImageTxSettings(long timeoutMillis) {
		IMCMessage m = poll("ImageTxSettings", timeoutMillis);
		if (m != null)
			try {
				ImageTxSettings ms = new ImageTxSettings();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link ImageTxSettings} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link ImageTxSettings} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.ImageTxSettings pollImageTxSettings(String entityName, long timeoutMillis) {
		IMCMessage m = poll("ImageTxSettings", entityName, timeoutMillis);
		if (m != null)
			try {
				ImageTxSettings ms = new ImageTxSettings();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RemoteState} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link RemoteState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RemoteState lastRemoteState() {
		IMCMessage m = get("RemoteState");
		if (m != null)
			try {
				RemoteState ms = new RemoteState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link RemoteState} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link RemoteState} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.RemoteState lastRemoteState(String entityName) {
		IMCMessage m = get(pt.lsts.imc.RemoteState.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				RemoteState ms = new RemoteState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RemoteState}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RemoteState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RemoteState pollRemoteState(long timeoutMillis) {
		IMCMessage m = poll("RemoteState", timeoutMillis);
		if (m != null)
			try {
				RemoteState ms = new RemoteState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link RemoteState} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link RemoteState} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.RemoteState pollRemoteState(String entityName, long timeoutMillis) {
		IMCMessage m = poll("RemoteState", entityName, timeoutMillis);
		if (m != null)
			try {
				RemoteState ms = new RemoteState();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Target} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Target} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Target lastTarget() {
		IMCMessage m = get("Target");
		if (m != null)
			try {
				Target ms = new Target();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Target} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Target} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Target lastTarget(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Target.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Target ms = new Target();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Target}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Target} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Target pollTarget(long timeoutMillis) {
		IMCMessage m = poll("Target", timeoutMillis);
		if (m != null)
			try {
				Target ms = new Target();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Target} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Target} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Target pollTarget(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Target", entityName, timeoutMillis);
		if (m != null)
			try {
				Target ms = new Target();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EntityParameter} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link EntityParameter} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EntityParameter lastEntityParameter() {
		IMCMessage m = get("EntityParameter");
		if (m != null)
			try {
				EntityParameter ms = new EntityParameter();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EntityParameter} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link EntityParameter} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EntityParameter lastEntityParameter(String entityName) {
		IMCMessage m = get(pt.lsts.imc.EntityParameter.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				EntityParameter ms = new EntityParameter();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EntityParameter}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EntityParameter} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EntityParameter pollEntityParameter(long timeoutMillis) {
		IMCMessage m = poll("EntityParameter", timeoutMillis);
		if (m != null)
			try {
				EntityParameter ms = new EntityParameter();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EntityParameter} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EntityParameter} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EntityParameter pollEntityParameter(String entityName, long timeoutMillis) {
		IMCMessage m = poll("EntityParameter", entityName, timeoutMillis);
		if (m != null)
			try {
				EntityParameter ms = new EntityParameter();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EntityParameters} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link EntityParameters} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EntityParameters lastEntityParameters() {
		IMCMessage m = get("EntityParameters");
		if (m != null)
			try {
				EntityParameters ms = new EntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link EntityParameters} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link EntityParameters} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.EntityParameters lastEntityParameters(String entityName) {
		IMCMessage m = get(pt.lsts.imc.EntityParameters.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				EntityParameters ms = new EntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EntityParameters}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EntityParameters} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EntityParameters pollEntityParameters(long timeoutMillis) {
		IMCMessage m = poll("EntityParameters", timeoutMillis);
		if (m != null)
			try {
				EntityParameters ms = new EntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link EntityParameters} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link EntityParameters} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.EntityParameters pollEntityParameters(String entityName, long timeoutMillis) {
		IMCMessage m = poll("EntityParameters", entityName, timeoutMillis);
		if (m != null)
			try {
				EntityParameters ms = new EntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link QueryEntityParameters} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link QueryEntityParameters} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.QueryEntityParameters lastQueryEntityParameters() {
		IMCMessage m = get("QueryEntityParameters");
		if (m != null)
			try {
				QueryEntityParameters ms = new QueryEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link QueryEntityParameters} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link QueryEntityParameters} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.QueryEntityParameters lastQueryEntityParameters(String entityName) {
		IMCMessage m = get(pt.lsts.imc.QueryEntityParameters.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				QueryEntityParameters ms = new QueryEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link QueryEntityParameters}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link QueryEntityParameters} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.QueryEntityParameters pollQueryEntityParameters(long timeoutMillis) {
		IMCMessage m = poll("QueryEntityParameters", timeoutMillis);
		if (m != null)
			try {
				QueryEntityParameters ms = new QueryEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link QueryEntityParameters} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link QueryEntityParameters} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.QueryEntityParameters pollQueryEntityParameters(String entityName, long timeoutMillis) {
		IMCMessage m = poll("QueryEntityParameters", entityName, timeoutMillis);
		if (m != null)
			try {
				QueryEntityParameters ms = new QueryEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SetEntityParameters} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SetEntityParameters} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SetEntityParameters lastSetEntityParameters() {
		IMCMessage m = get("SetEntityParameters");
		if (m != null)
			try {
				SetEntityParameters ms = new SetEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SetEntityParameters} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SetEntityParameters} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SetEntityParameters lastSetEntityParameters(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SetEntityParameters.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SetEntityParameters ms = new SetEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SetEntityParameters}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SetEntityParameters} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SetEntityParameters pollSetEntityParameters(long timeoutMillis) {
		IMCMessage m = poll("SetEntityParameters", timeoutMillis);
		if (m != null)
			try {
				SetEntityParameters ms = new SetEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SetEntityParameters} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SetEntityParameters} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SetEntityParameters pollSetEntityParameters(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SetEntityParameters", entityName, timeoutMillis);
		if (m != null)
			try {
				SetEntityParameters ms = new SetEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SaveEntityParameters} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SaveEntityParameters} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SaveEntityParameters lastSaveEntityParameters() {
		IMCMessage m = get("SaveEntityParameters");
		if (m != null)
			try {
				SaveEntityParameters ms = new SaveEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SaveEntityParameters} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SaveEntityParameters} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SaveEntityParameters lastSaveEntityParameters(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SaveEntityParameters.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SaveEntityParameters ms = new SaveEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SaveEntityParameters}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SaveEntityParameters} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SaveEntityParameters pollSaveEntityParameters(long timeoutMillis) {
		IMCMessage m = poll("SaveEntityParameters", timeoutMillis);
		if (m != null)
			try {
				SaveEntityParameters ms = new SaveEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SaveEntityParameters} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SaveEntityParameters} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SaveEntityParameters pollSaveEntityParameters(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SaveEntityParameters", entityName, timeoutMillis);
		if (m != null)
			try {
				SaveEntityParameters ms = new SaveEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CreateSession} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link CreateSession} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CreateSession lastCreateSession() {
		IMCMessage m = get("CreateSession");
		if (m != null)
			try {
				CreateSession ms = new CreateSession();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CreateSession} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link CreateSession} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CreateSession lastCreateSession(String entityName) {
		IMCMessage m = get(pt.lsts.imc.CreateSession.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				CreateSession ms = new CreateSession();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CreateSession}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CreateSession} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CreateSession pollCreateSession(long timeoutMillis) {
		IMCMessage m = poll("CreateSession", timeoutMillis);
		if (m != null)
			try {
				CreateSession ms = new CreateSession();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CreateSession} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CreateSession} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CreateSession pollCreateSession(String entityName, long timeoutMillis) {
		IMCMessage m = poll("CreateSession", entityName, timeoutMillis);
		if (m != null)
			try {
				CreateSession ms = new CreateSession();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CloseSession} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link CloseSession} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CloseSession lastCloseSession() {
		IMCMessage m = get("CloseSession");
		if (m != null)
			try {
				CloseSession ms = new CloseSession();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link CloseSession} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link CloseSession} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.CloseSession lastCloseSession(String entityName) {
		IMCMessage m = get(pt.lsts.imc.CloseSession.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				CloseSession ms = new CloseSession();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CloseSession}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CloseSession} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CloseSession pollCloseSession(long timeoutMillis) {
		IMCMessage m = poll("CloseSession", timeoutMillis);
		if (m != null)
			try {
				CloseSession ms = new CloseSession();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link CloseSession} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link CloseSession} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.CloseSession pollCloseSession(String entityName, long timeoutMillis) {
		IMCMessage m = poll("CloseSession", entityName, timeoutMillis);
		if (m != null)
			try {
				CloseSession ms = new CloseSession();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SessionSubscription} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SessionSubscription} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SessionSubscription lastSessionSubscription() {
		IMCMessage m = get("SessionSubscription");
		if (m != null)
			try {
				SessionSubscription ms = new SessionSubscription();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SessionSubscription} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SessionSubscription} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SessionSubscription lastSessionSubscription(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SessionSubscription.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SessionSubscription ms = new SessionSubscription();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SessionSubscription}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SessionSubscription} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SessionSubscription pollSessionSubscription(long timeoutMillis) {
		IMCMessage m = poll("SessionSubscription", timeoutMillis);
		if (m != null)
			try {
				SessionSubscription ms = new SessionSubscription();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SessionSubscription} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SessionSubscription} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SessionSubscription pollSessionSubscription(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SessionSubscription", entityName, timeoutMillis);
		if (m != null)
			try {
				SessionSubscription ms = new SessionSubscription();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SessionKeepAlive} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SessionKeepAlive} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SessionKeepAlive lastSessionKeepAlive() {
		IMCMessage m = get("SessionKeepAlive");
		if (m != null)
			try {
				SessionKeepAlive ms = new SessionKeepAlive();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SessionKeepAlive} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SessionKeepAlive} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SessionKeepAlive lastSessionKeepAlive(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SessionKeepAlive.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SessionKeepAlive ms = new SessionKeepAlive();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SessionKeepAlive}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SessionKeepAlive} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SessionKeepAlive pollSessionKeepAlive(long timeoutMillis) {
		IMCMessage m = poll("SessionKeepAlive", timeoutMillis);
		if (m != null)
			try {
				SessionKeepAlive ms = new SessionKeepAlive();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SessionKeepAlive} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SessionKeepAlive} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SessionKeepAlive pollSessionKeepAlive(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SessionKeepAlive", entityName, timeoutMillis);
		if (m != null)
			try {
				SessionKeepAlive ms = new SessionKeepAlive();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SessionStatus} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link SessionStatus} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SessionStatus lastSessionStatus() {
		IMCMessage m = get("SessionStatus");
		if (m != null)
			try {
				SessionStatus ms = new SessionStatus();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link SessionStatus} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link SessionStatus} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.SessionStatus lastSessionStatus(String entityName) {
		IMCMessage m = get(pt.lsts.imc.SessionStatus.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				SessionStatus ms = new SessionStatus();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SessionStatus}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SessionStatus} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SessionStatus pollSessionStatus(long timeoutMillis) {
		IMCMessage m = poll("SessionStatus", timeoutMillis);
		if (m != null)
			try {
				SessionStatus ms = new SessionStatus();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link SessionStatus} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link SessionStatus} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.SessionStatus pollSessionStatus(String entityName, long timeoutMillis) {
		IMCMessage m = poll("SessionStatus", entityName, timeoutMillis);
		if (m != null)
			try {
				SessionStatus ms = new SessionStatus();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PushEntityParameters} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PushEntityParameters} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PushEntityParameters lastPushEntityParameters() {
		IMCMessage m = get("PushEntityParameters");
		if (m != null)
			try {
				PushEntityParameters ms = new PushEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PushEntityParameters} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PushEntityParameters} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PushEntityParameters lastPushEntityParameters(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PushEntityParameters.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PushEntityParameters ms = new PushEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PushEntityParameters}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PushEntityParameters} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PushEntityParameters pollPushEntityParameters(long timeoutMillis) {
		IMCMessage m = poll("PushEntityParameters", timeoutMillis);
		if (m != null)
			try {
				PushEntityParameters ms = new PushEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PushEntityParameters} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PushEntityParameters} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PushEntityParameters pollPushEntityParameters(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PushEntityParameters", entityName, timeoutMillis);
		if (m != null)
			try {
				PushEntityParameters ms = new PushEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PopEntityParameters} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link PopEntityParameters} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PopEntityParameters lastPopEntityParameters() {
		IMCMessage m = get("PopEntityParameters");
		if (m != null)
			try {
				PopEntityParameters ms = new PopEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link PopEntityParameters} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link PopEntityParameters} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.PopEntityParameters lastPopEntityParameters(String entityName) {
		IMCMessage m = get(pt.lsts.imc.PopEntityParameters.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				PopEntityParameters ms = new PopEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PopEntityParameters}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PopEntityParameters} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PopEntityParameters pollPopEntityParameters(long timeoutMillis) {
		IMCMessage m = poll("PopEntityParameters", timeoutMillis);
		if (m != null)
			try {
				PopEntityParameters ms = new PopEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link PopEntityParameters} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link PopEntityParameters} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.PopEntityParameters pollPopEntityParameters(String entityName, long timeoutMillis) {
		IMCMessage m = poll("PopEntityParameters", entityName, timeoutMillis);
		if (m != null)
			try {
				PopEntityParameters ms = new PopEntityParameters();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link IoEvent} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link IoEvent} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.IoEvent lastIoEvent() {
		IMCMessage m = get("IoEvent");
		if (m != null)
			try {
				IoEvent ms = new IoEvent();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link IoEvent} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link IoEvent} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.IoEvent lastIoEvent(String entityName) {
		IMCMessage m = get(pt.lsts.imc.IoEvent.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				IoEvent ms = new IoEvent();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link IoEvent}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link IoEvent} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.IoEvent pollIoEvent(long timeoutMillis) {
		IMCMessage m = poll("IoEvent", timeoutMillis);
		if (m != null)
			try {
				IoEvent ms = new IoEvent();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link IoEvent} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link IoEvent} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.IoEvent pollIoEvent(String entityName, long timeoutMillis) {
		IMCMessage m = poll("IoEvent", entityName, timeoutMillis);
		if (m != null)
			try {
				IoEvent ms = new IoEvent();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UamTxFrame} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link UamTxFrame} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UamTxFrame lastUamTxFrame() {
		IMCMessage m = get("UamTxFrame");
		if (m != null)
			try {
				UamTxFrame ms = new UamTxFrame();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UamTxFrame} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link UamTxFrame} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UamTxFrame lastUamTxFrame(String entityName) {
		IMCMessage m = get(pt.lsts.imc.UamTxFrame.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				UamTxFrame ms = new UamTxFrame();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UamTxFrame}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UamTxFrame} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UamTxFrame pollUamTxFrame(long timeoutMillis) {
		IMCMessage m = poll("UamTxFrame", timeoutMillis);
		if (m != null)
			try {
				UamTxFrame ms = new UamTxFrame();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UamTxFrame} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UamTxFrame} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UamTxFrame pollUamTxFrame(String entityName, long timeoutMillis) {
		IMCMessage m = poll("UamTxFrame", entityName, timeoutMillis);
		if (m != null)
			try {
				UamTxFrame ms = new UamTxFrame();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UamRxFrame} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link UamRxFrame} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UamRxFrame lastUamRxFrame() {
		IMCMessage m = get("UamRxFrame");
		if (m != null)
			try {
				UamRxFrame ms = new UamRxFrame();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UamRxFrame} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link UamRxFrame} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UamRxFrame lastUamRxFrame(String entityName) {
		IMCMessage m = get(pt.lsts.imc.UamRxFrame.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				UamRxFrame ms = new UamRxFrame();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UamRxFrame}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UamRxFrame} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UamRxFrame pollUamRxFrame(long timeoutMillis) {
		IMCMessage m = poll("UamRxFrame", timeoutMillis);
		if (m != null)
			try {
				UamRxFrame ms = new UamRxFrame();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UamRxFrame} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UamRxFrame} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UamRxFrame pollUamRxFrame(String entityName, long timeoutMillis) {
		IMCMessage m = poll("UamRxFrame", entityName, timeoutMillis);
		if (m != null)
			try {
				UamRxFrame ms = new UamRxFrame();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UamTxStatus} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link UamTxStatus} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UamTxStatus lastUamTxStatus() {
		IMCMessage m = get("UamTxStatus");
		if (m != null)
			try {
				UamTxStatus ms = new UamTxStatus();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UamTxStatus} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link UamTxStatus} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UamTxStatus lastUamTxStatus(String entityName) {
		IMCMessage m = get(pt.lsts.imc.UamTxStatus.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				UamTxStatus ms = new UamTxStatus();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UamTxStatus}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UamTxStatus} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UamTxStatus pollUamTxStatus(long timeoutMillis) {
		IMCMessage m = poll("UamTxStatus", timeoutMillis);
		if (m != null)
			try {
				UamTxStatus ms = new UamTxStatus();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UamTxStatus} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UamTxStatus} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UamTxStatus pollUamTxStatus(String entityName, long timeoutMillis) {
		IMCMessage m = poll("UamTxStatus", entityName, timeoutMillis);
		if (m != null)
			try {
				UamTxStatus ms = new UamTxStatus();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UamRxRange} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link UamRxRange} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UamRxRange lastUamRxRange() {
		IMCMessage m = get("UamRxRange");
		if (m != null)
			try {
				UamRxRange ms = new UamRxRange();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UamRxRange} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link UamRxRange} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UamRxRange lastUamRxRange(String entityName) {
		IMCMessage m = get(pt.lsts.imc.UamRxRange.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				UamRxRange ms = new UamRxRange();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UamRxRange}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UamRxRange} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UamRxRange pollUamRxRange(long timeoutMillis) {
		IMCMessage m = poll("UamRxRange", timeoutMillis);
		if (m != null)
			try {
				UamRxRange ms = new UamRxRange();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UamRxRange} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UamRxRange} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UamRxRange pollUamRxRange(String entityName, long timeoutMillis) {
		IMCMessage m = poll("UamRxRange", entityName, timeoutMillis);
		if (m != null)
			try {
				UamRxRange ms = new UamRxRange();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FormCtrlParam} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link FormCtrlParam} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FormCtrlParam lastFormCtrlParam() {
		IMCMessage m = get("FormCtrlParam");
		if (m != null)
			try {
				FormCtrlParam ms = new FormCtrlParam();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FormCtrlParam} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link FormCtrlParam} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FormCtrlParam lastFormCtrlParam(String entityName) {
		IMCMessage m = get(pt.lsts.imc.FormCtrlParam.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				FormCtrlParam ms = new FormCtrlParam();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FormCtrlParam}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FormCtrlParam} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FormCtrlParam pollFormCtrlParam(long timeoutMillis) {
		IMCMessage m = poll("FormCtrlParam", timeoutMillis);
		if (m != null)
			try {
				FormCtrlParam ms = new FormCtrlParam();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FormCtrlParam} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FormCtrlParam} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FormCtrlParam pollFormCtrlParam(String entityName, long timeoutMillis) {
		IMCMessage m = poll("FormCtrlParam", entityName, timeoutMillis);
		if (m != null)
			try {
				FormCtrlParam ms = new FormCtrlParam();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FormationEval} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link FormationEval} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FormationEval lastFormationEval() {
		IMCMessage m = get("FormationEval");
		if (m != null)
			try {
				FormationEval ms = new FormationEval();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link FormationEval} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link FormationEval} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.FormationEval lastFormationEval(String entityName) {
		IMCMessage m = get(pt.lsts.imc.FormationEval.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				FormationEval ms = new FormationEval();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FormationEval}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FormationEval} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FormationEval pollFormationEval(long timeoutMillis) {
		IMCMessage m = poll("FormationEval", timeoutMillis);
		if (m != null)
			try {
				FormationEval ms = new FormationEval();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link FormationEval} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link FormationEval} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.FormationEval pollFormationEval(String entityName, long timeoutMillis) {
		IMCMessage m = poll("FormationEval", entityName, timeoutMillis);
		if (m != null)
			try {
				FormationEval ms = new FormationEval();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link MessagePart} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link MessagePart} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.MessagePart lastMessagePart() {
		IMCMessage m = get("MessagePart");
		if (m != null)
			try {
				MessagePart ms = new MessagePart();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link MessagePart} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link MessagePart} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.MessagePart lastMessagePart(String entityName) {
		IMCMessage m = get(pt.lsts.imc.MessagePart.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				MessagePart ms = new MessagePart();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link MessagePart}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link MessagePart} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.MessagePart pollMessagePart(long timeoutMillis) {
		IMCMessage m = poll("MessagePart", timeoutMillis);
		if (m != null)
			try {
				MessagePart ms = new MessagePart();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link MessagePart} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link MessagePart} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.MessagePart pollMessagePart(String entityName, long timeoutMillis) {
		IMCMessage m = poll("MessagePart", entityName, timeoutMillis);
		if (m != null)
			try {
				MessagePart ms = new MessagePart();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link NeptusBlob} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link NeptusBlob} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.NeptusBlob lastNeptusBlob() {
		IMCMessage m = get("NeptusBlob");
		if (m != null)
			try {
				NeptusBlob ms = new NeptusBlob();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link NeptusBlob} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link NeptusBlob} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.NeptusBlob lastNeptusBlob(String entityName) {
		IMCMessage m = get(pt.lsts.imc.NeptusBlob.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				NeptusBlob ms = new NeptusBlob();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link NeptusBlob}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link NeptusBlob} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.NeptusBlob pollNeptusBlob(long timeoutMillis) {
		IMCMessage m = poll("NeptusBlob", timeoutMillis);
		if (m != null)
			try {
				NeptusBlob ms = new NeptusBlob();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link NeptusBlob} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link NeptusBlob} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.NeptusBlob pollNeptusBlob(String entityName, long timeoutMillis) {
		IMCMessage m = poll("NeptusBlob", entityName, timeoutMillis);
		if (m != null)
			try {
				NeptusBlob ms = new NeptusBlob();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Aborted} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link Aborted} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Aborted lastAborted() {
		IMCMessage m = get("Aborted");
		if (m != null)
			try {
				Aborted ms = new Aborted();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link Aborted} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link Aborted} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.Aborted lastAborted(String entityName) {
		IMCMessage m = get(pt.lsts.imc.Aborted.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				Aborted ms = new Aborted();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Aborted}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Aborted} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Aborted pollAborted(long timeoutMillis) {
		IMCMessage m = poll("Aborted", timeoutMillis);
		if (m != null)
			try {
				Aborted ms = new Aborted();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link Aborted} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link Aborted} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.Aborted pollAborted(String entityName, long timeoutMillis) {
		IMCMessage m = poll("Aborted", entityName, timeoutMillis);
		if (m != null)
			try {
				Aborted ms = new Aborted();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UsblAngles} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link UsblAngles} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UsblAngles lastUsblAngles() {
		IMCMessage m = get("UsblAngles");
		if (m != null)
			try {
				UsblAngles ms = new UsblAngles();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UsblAngles} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link UsblAngles} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UsblAngles lastUsblAngles(String entityName) {
		IMCMessage m = get(pt.lsts.imc.UsblAngles.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				UsblAngles ms = new UsblAngles();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UsblAngles}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UsblAngles} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UsblAngles pollUsblAngles(long timeoutMillis) {
		IMCMessage m = poll("UsblAngles", timeoutMillis);
		if (m != null)
			try {
				UsblAngles ms = new UsblAngles();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UsblAngles} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UsblAngles} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UsblAngles pollUsblAngles(String entityName, long timeoutMillis) {
		IMCMessage m = poll("UsblAngles", entityName, timeoutMillis);
		if (m != null)
			try {
				UsblAngles ms = new UsblAngles();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UsblPosition} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link UsblPosition} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UsblPosition lastUsblPosition() {
		IMCMessage m = get("UsblPosition");
		if (m != null)
			try {
				UsblPosition ms = new UsblPosition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UsblPosition} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link UsblPosition} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UsblPosition lastUsblPosition(String entityName) {
		IMCMessage m = get(pt.lsts.imc.UsblPosition.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				UsblPosition ms = new UsblPosition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UsblPosition}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UsblPosition} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UsblPosition pollUsblPosition(long timeoutMillis) {
		IMCMessage m = poll("UsblPosition", timeoutMillis);
		if (m != null)
			try {
				UsblPosition ms = new UsblPosition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UsblPosition} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UsblPosition} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UsblPosition pollUsblPosition(String entityName, long timeoutMillis) {
		IMCMessage m = poll("UsblPosition", entityName, timeoutMillis);
		if (m != null)
			try {
				UsblPosition ms = new UsblPosition();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UsblFix} or <b>null</b> if no message of that type was received yet.
	 * @return last {@link UsblFix} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UsblFix lastUsblFix() {
		IMCMessage m = get("UsblFix");
		if (m != null)
			try {
				UsblFix ms = new UsblFix();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Retrieve the last {@link UsblFix} generated by the given entityName or <b>null</b> if no such message was received yet.
	 * @param entityName The name of the entity that generated the message
	 * @return last {@link UsblFix} on this state or <b>null</b> if no message of that type was received yet.
	 */
	public pt.lsts.imc.UsblFix lastUsblFix(String entityName) {
		IMCMessage m = get(pt.lsts.imc.UsblFix.ID_STATIC, entitiesInverted.get(entityName));
		if (m != null)
			try {
				UsblFix ms = new UsblFix();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UsblFix}.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UsblFix} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UsblFix pollUsblFix(long timeoutMillis) {
		IMCMessage m = poll("UsblFix", timeoutMillis);
		if (m != null)
			try {
				UsblFix ms = new UsblFix();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

	/**
	 * Wait and retrieve the next {@link UsblFix} generated by given entity.
	 * @param entityName The name of the generating entity.
	 * @param timeoutMillis Maximum ammount of time to block, in milliseconds.
	 * @return The received {@link UsblFix} or <b>null</b> if no such message was received for <strong>timeoutMillis</strong> milliseconds
	 */
	public pt.lsts.imc.UsblFix pollUsblFix(String entityName, long timeoutMillis) {
		IMCMessage m = poll("UsblFix", entityName, timeoutMillis);
		if (m != null)
			try {
				UsblFix ms = new UsblFix();
				ms.copyFrom(m);
				return ms;
			}
			catch (Exception e) { }
		return null;
	}

}
