package com.rickyclarkson.java.awt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.HashMap;

public class PercentLayout implements LayoutManager2
{
	HashMap constraints=new HashMap();
	
	public static class Constraint
	{
		private final double left,top,width,height;
		
		public Constraint
			(double left,double top,double width,double height)
		{
			this.left=left;
			this.top=top;
			this.width=width;
			this.height=height;
		}
		
		public double getHeight()
		{
			return height;
		}

		public double getLeft()
		{
			return left;
		}

		public double getTop()
		{
			return top;
		}

		public double getWidth()
		{
			return width;
		}
	}
	
	public void addLayoutComponent(Component component,Object constraint)
	{
		if (!(constraint instanceof Constraint))
			throw new IllegalArgumentException
			(
				"constraint must be of type "+
				"PercentLayout.Constraint"
			);
		
		constraints.put(component,constraint);
	}
	
	public void addLayoutComponent(String string,Component component)
	{
		throw new UnsupportedOperationException
			("use addLayoutComponent(Component,Object)");
	}

	public float getLayoutAlignmentX(Container container)
	{
		return 0.5f;
	}
	
	public float getLayoutAlignmentY(Container container)
	{
		return 0.5f;
	}
	
	public void invalidateLayout(Container container)
	{
		//throw away cached information (there isn't any).
	}

	public void layoutContainer(Container container)
	{	
		Component[] components=container.getComponents();

		int containerWidth=container.getWidth();
		int containerHeight=container.getHeight();
				
		for (int a=0;a<components.length;a++)
		{
			Constraint constraint=
				(Constraint)constraints.get(components[a]);

			if (constraint==null)
				continue;
			
			int x=(int)(containerWidth*constraint.getLeft()/100);
			int y=(int)(containerHeight*constraint.getTop()/100);
			int width=
				(int)
				(containerWidth*constraint.getWidth()/100);
			
			int height=
				(int)
				(containerHeight*constraint.getHeight()/100);
			
			components[a].setLocation(x,y);
			components[a].setSize(width,height);
		}
	}

	public Dimension maximumLayoutSize(Container container)
	{
		Component[] components=container.getComponents();
		
		double maxWidth=0,maxHeight=0;
		
		for (int a=0;a<components.length;a++)
		{
			Constraint constraint=
				(Constraint)constraints.get(components[a]);
			
			if (constraint==null)
				continue;
			
			Dimension currentMax=components[a].getMaximumSize();
			
			/*
			 * A component 50 pixels wide, taking up 5% of the
			 * screen would need 50*20=1000 pixels.
			 * Or 50*100/5.*/
			double currentMaxWidth=
				currentMax.width*100/constraint.getWidth();
				
			double currentMaxHeight=
				currentMax.height*100/constraint.getHeight();
			
			maxWidth=Math.max(maxWidth,currentMaxWidth);
			maxHeight=Math.max(maxHeight,currentMaxHeight);
		}
		
		return new Dimension((int)maxWidth,(int)maxHeight);
	}	
		
	public Dimension minimumLayoutSize(Container container)
	{
		Component[] components=container.getComponents();
		
		double maxWidth=0,maxHeight=0;
		
		for (int a=0;a<components.length;a++)
		{
			Constraint constraint=
				(Constraint)constraints.get(components[a]);
			
			if (constraint==null)
				continue;
			
			Dimension currentMax=components[a].getMinimumSize();
			
			double currentMaxWidth=
				currentMax.width*100/constraint.getWidth();
				
			double currentMaxHeight=
				currentMax.height*100/constraint.getHeight();
			
			maxWidth=Math.max(maxWidth,currentMaxWidth);
			maxHeight=Math.max(maxHeight,currentMaxHeight);
		}
		
		return new Dimension((int)maxWidth,(int)maxHeight);
	}	
	
	public Dimension preferredLayoutSize(Container container)
	{
		Component[] components=container.getComponents();
		
		double maxWidth=0,maxHeight=0;
		
		for (int a=0;a<components.length;a++)
		{
			Constraint constraint=
				(Constraint)constraints.get(components[a]);
			
			if (constraint==null)
				continue;
			
			Dimension currentMax=components[a].getPreferredSize();
			
			double currentMaxWidth=
				currentMax.width*100/constraint.getWidth();
				
			double currentMaxHeight=
				currentMax.height*100/constraint.getHeight();
			
			maxWidth=Math.max(maxWidth,currentMaxWidth);
			maxHeight=Math.max(maxHeight,currentMaxHeight);
		}
		
		return new Dimension((int)maxWidth,(int)maxHeight);
	}	
	
	public void removeLayoutComponent(Component component)
	{
		constraints.remove(component);
	}
}
