/*
 * Below is the copyright agreement for IMCJava.
 * 
 * Copyright (c) 2010-2014, Laboratório de Sistemas e Tecnologia Subaquática
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     - Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     - Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     - Neither the names of IMC, LSTS, IMCJava nor the names of its 
 *       contributors may be used to endorse or promote products derived from 
 *       this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL LABORATORIO DE SISTEMAS E TECNOLOGIA SUBAQUATICA
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
package pt.lsts.imc;

public class ImcStringDefs {

	public static final String IMC_SHA = "550440cbc77abde0ea5a85a3f78fd60caac980f6";
	public static final String IMC_BRANCH = "2014-09-18 550440c (HEAD, tag: imc-5.4.3, origin/master, origin/HEAD, master)";
	public static final String IMC_COMMIT = "Ricardo Martins (rasm@lsts.pt), Thu Sep 18 22:13:03 WEST 2014, IMC v5.4.3\n\nChanges since IMC v5.4.2:\n\n- Added units PPM and PPB.\n\n- Increased maximum message id of GroupDevelopment from 849 to 900.\n\n- Added messages RhodamineDye, CrudeOil, FineOil, PlanStatistics, UsblAngles,\n  UsblPosition, and UsblFix\n\n- Removed obsolete message NavigationReset.";

	public static java.util.Map<String, Integer> IMC_ADDRESSES = new java.util.LinkedHashMap<String, Integer>();

	static {
		IMC_ADDRESSES.put("*", 65535);
		IMC_ADDRESSES.put("announce", 0);
		IMC_ADDRESSES.put("isurus", 1);
		IMC_ADDRESSES.put("nauv", 2);
		IMC_ADDRESSES.put("lauv-blue", 16);
		IMC_ADDRESSES.put("lauv-green", 18);
		IMC_ADDRESSES.put("lauv-seacon-1", 21);
		IMC_ADDRESSES.put("lauv-seacon-2", 22);
		IMC_ADDRESSES.put("lauv-seacon-3", 23);
		IMC_ADDRESSES.put("lauv-xtreme-2", 24);
		IMC_ADDRESSES.put("lauv-noptilus-1", 26);
		IMC_ADDRESSES.put("lauv-noptilus-2", 27);
		IMC_ADDRESSES.put("lauv-noptilus-3", 28);
		IMC_ADDRESSES.put("lauv-lsts-1", 29);
		IMC_ADDRESSES.put("lauv-xplore-1", 30);
		IMC_ADDRESSES.put("lauv-simulator-1", 209);
		IMC_ADDRESSES.put("lauv-dolphin-1", 257);
		IMC_ADDRESSES.put("lauv-lupis-1", 258);
		IMC_ADDRESSES.put("lauv-dolphin-2", 259);
		IMC_ADDRESSES.put("lauv-dolphin-3", 260);
		IMC_ADDRESSES.put("rov-ies", 1025);
		IMC_ADDRESSES.put("adamastor", 1026);
		IMC_ADDRESSES.put("swordfish", 2049);
		IMC_ADDRESSES.put("hermes", 2241);
		IMC_ADDRESSES.put("hermes-desired", 2242);
		IMC_ADDRESSES.put("hermes-target", 2243);
		IMC_ADDRESSES.put("tex-wg", 2244);
		IMC_ADDRESSES.put("doam", 24576);
		IMC_ADDRESSES.put("lauv-dolphin-1-doam", 24577);
		IMC_ADDRESSES.put("lauv-seacon-1-aux", 24578);
		IMC_ADDRESSES.put("lauv-noptilus-3-aux", 24579);
		IMC_ADDRESSES.put("star", 32768);
		IMC_ADDRESSES.put("benthos-mgateway", 32784);
		IMC_ADDRESSES.put("manta-1", 32786);
		IMC_ADDRESSES.put("manta-2", 32787);
		IMC_ADDRESSES.put("manta-3", 32788);
		IMC_ADDRESSES.put("manta-4", 32789);
		IMC_ADDRESSES.put("manta-5", 32790);
		IMC_ADDRESSES.put("manta-9", 32794);
		IMC_ADDRESSES.put("manta-10", 32795);
		IMC_ADDRESSES.put("manta-11", 32796);
		IMC_ADDRESSES.put("manta-12", 32797);
		IMC_ADDRESSES.put("piccolo-gs1", 32832);
		IMC_ADDRESSES.put("piccolo-gs2", 32833);
		IMC_ADDRESSES.put("piccolo-gs3", 32834);
		IMC_ADDRESSES.put("ais-1", 32880);
		IMC_ADDRESSES.put("ais-2", 32881);
		IMC_ADDRESSES.put("spot-01", 33793);
		IMC_ADDRESSES.put("spot-02", 33794);
		IMC_ADDRESSES.put("spot-03", 33795);
		IMC_ADDRESSES.put("spot-04", 33796);
		IMC_ADDRESSES.put("spot-05", 33797);
		IMC_ADDRESSES.put("spot-06", 33798);
		IMC_ADDRESSES.put("spot-07", 33799);
		IMC_ADDRESSES.put("spot-08", 33800);
		IMC_ADDRESSES.put("spot-09", 33801);
		IMC_ADDRESSES.put("spot-10", 33802);
		IMC_ADDRESSES.put("spot-11", 33803);
		IMC_ADDRESSES.put("spot-12", 33804);
		IMC_ADDRESSES.put("spot-13", 33805);
		IMC_ADDRESSES.put("spot-14", 33806);
		IMC_ADDRESSES.put("spot-15", 33807);
		IMC_ADDRESSES.put("spot-16", 33808);
		IMC_ADDRESSES.put("spot-17", 33809);
		IMC_ADDRESSES.put("spot-18", 33810);
		IMC_ADDRESSES.put("spot-19", 33811);
		IMC_ADDRESSES.put("spot-20", 33812);
		IMC_ADDRESSES.put("spot-21", 33813);
		IMC_ADDRESSES.put("spot-22", 33814);
		IMC_ADDRESSES.put("spot-23", 33815);
		IMC_ADDRESSES.put("spot-24", 33816);
		IMC_ADDRESSES.put("spot-25", 33817);
		IMC_ADDRESSES.put("spot-26", 33818);
		IMC_ADDRESSES.put("carson", 33957);
		IMC_ADDRESSES.put("paragon", 33958);
		IMC_ADDRESSES.put("dorado", 33959);
		IMC_ADDRESSES.put("esp-mack", 33960);
		IMC_ADDRESSES.put("esp-bruce", 33961);
		IMC_ADDRESSES.put("wavy-0", 34048);
		IMC_ADDRESSES.put("wavy-1", 34049);
		IMC_ADDRESSES.put("wavy-2", 34050);
		IMC_ADDRESSES.put("lusitania", 3073);
		IMC_ADDRESSES.put("sedona", 3074);
		IMC_ADDRESSES.put("x8-00", 3075);
		IMC_ADDRESSES.put("x8-01", 3076);
		IMC_ADDRESSES.put("x8-02", 3077);
		IMC_ADDRESSES.put("x8-03", 3078);
		IMC_ADDRESSES.put("x8-04", 3079);
		IMC_ADDRESSES.put("hexa-00", 3091);
		IMC_ADDRESSES.put("alfa-02", 3106);
		IMC_ADDRESSES.put("alfa-03", 3107);
		IMC_ADDRESSES.put("alfa-04", 3108);
		IMC_ADDRESSES.put("alfa-05", 3109);
		IMC_ADDRESSES.put("alfa-06", 3110);
		IMC_ADDRESSES.put("alfa-07", 3111);
		IMC_ADDRESSES.put("alfa-08", 3112);
		IMC_ADDRESSES.put("alfa-09", 3113);
		IMC_ADDRESSES.put("piccolo-testbed", 3120);
		IMC_ADDRESSES.put("cularis-03", 3155);
		IMC_ADDRESSES.put("cularis-04", 3156);
		IMC_ADDRESSES.put("cularis-05", 3157);
		IMC_ADDRESSES.put("cularis-06", 3158);
		IMC_ADDRESSES.put("cularis-07", 3159);
		IMC_ADDRESSES.put("cularis-08", 3160);
		IMC_ADDRESSES.put("pilatus-03", 3187);
		IMC_ADDRESSES.put("pilatus-04", 3188);
		IMC_ADDRESSES.put("pilatus-05", 3189);
		IMC_ADDRESSES.put("pilatus-06", 3190);
		IMC_ADDRESSES.put("extended", 3216);
		IMC_ADDRESSES.put("form-leader-01", 3313);
		IMC_ADDRESSES.put("form-leader-02", 3314);
		IMC_ADDRESSES.put("form-leader-03", 3315);
		IMC_ADDRESSES.put("form-leader-04", 3316);
		IMC_ADDRESSES.put("form-leader-05", 3317);
		IMC_ADDRESSES.put("form-leader-06", 3318);
		IMC_ADDRESSES.put("ntnu-hexa-001", 3329);
		IMC_ADDRESSES.put("ntnu-hexa-002", 3330);
		IMC_ADDRESSES.put("ntnu-hexa-003", 3331);
		IMC_ADDRESSES.put("ntnu-hexa-004", 3332);
		IMC_ADDRESSES.put("ntnu-x8-001", 3361);
		IMC_ADDRESSES.put("ntnu-x8-002", 3362);
		IMC_ADDRESSES.put("ntnu-x8-003", 3363);
		IMC_ADDRESSES.put("ntnu-x8-004", 3364);
		IMC_ADDRESSES.put("ntnu-penguin-001", 3393);
		IMC_ADDRESSES.put("ntnu-penguin-002", 3394);
		IMC_ADDRESSES.put("ntnu-penguin-003", 3395);
		IMC_ADDRESSES.put("ntnu-penguin-004", 3396);
		IMC_ADDRESSES.put("ccu-lsts-1-1", 16641);
		IMC_ADDRESSES.put("ccu-zp-1-106", 16746);
		IMC_ADDRESSES.put("ccu-pitvant-laptop-01-1-10", 16650);
		IMC_ADDRESSES.put("ccu-lsts-0-108", 16492);
		IMC_ADDRESSES.put("broadcast", 65520);
		IMC_ADDRESSES.put("null", 65535);

		IMC_ADDRESSES = java.util.Collections.unmodifiableMap(IMC_ADDRESSES);
	}

	public static String getDefinitions() {

		StringBuilder sb = new StringBuilder();
		sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
		sb.append("<!--\n");
		sb.append("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
		sb.append("+ Copyright (C) 2007-2014 Laborat\u00F3rio de Sistemas e Tecnologia Subaqu\u00E1tica   +\n");
		sb.append("+ Departamento de Engenharia Electrot\u00E9cnica e de Computadores                +\n");
		sb.append("+ Rua Dr. Roberto Frias, 4200-465 Porto, Portugal                            +\n");
		sb.append("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
		sb.append("-->\n");
		sb.append("<messages xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
		sb.append("          xsi:noNamespaceSchemaLocation=\"IMC.xsd\"\n");
		sb.append("          name=\"IMC\"\n");
		sb.append("          long-name=\"Inter Module Communication\"\n");
		sb.append("          version=\"5.4.3\">\n");
		sb.append("\n");
		sb.append("  <description>\n");
		sb.append("    This document describes the communications protocol associated\n");
		sb.append("    with the LSTS software framework. Concepts such as *message*,\n");
		sb.append("    *field* and *packet* are explained in detail in the subsequent\n");
		sb.append("    chapters.\n");
		sb.append("\n");
		sb.append("    Inter module communication is achieved by the exchange of messages\n");
		sb.append("    that can be recognized and interpreted by all participating\n");
		sb.append("    modules. A message is a self-contained collection of data fields\n");
		sb.append("    conveying relevant information about a given subject. The mean by\n");
		sb.append("    which the messages are exchanged is not described in this\n");
		sb.append("    document, but the reader can assume that at least the UDP Internet\n");
		sb.append("    protocol is available at all ends of the communications channel.\n");
		sb.append("\n");
		sb.append("    The Neptus Command and Control Unit (CCU), currently being used at\n");
		sb.append("    LSTS, supports mission planning and control, using the described\n");
		sb.append("    messaging API. This software entity can be used to define a plan\n");
		sb.append("    before execution and monitor the plan's execution by presenting an\n");
		sb.append("    operating console. For further details on this software contact\n");
		sb.append("    the LSTS.\n");
		sb.append("\n");
		sb.append("    A CCU exercises authority over a vehicle (real or\n");
		sb.append("    simulated). Usually this term is applied to software in the class\n");
		sb.append("    of LSTS Neptus, but can also be applied to software modules\n");
		sb.append("    extending the vehicle core control software.\n");
		sb.append("\n");
		sb.append("    The LSTS reserves itself the right to use message identification\n");
		sb.append("    numbers up to 999. Thus if a third party needs to extend this API\n");
		sb.append("    it must use identification numbers starting at 1000. The\n");
		sb.append("    identification number 65535 has a special meaning and must not be\n");
		sb.append("    used to extend the IMC protocol.\n");
		sb.append("  </description>\n");
		sb.append("\n");
		sb.append("  <types>\n");
		sb.append("    <description>\n");
		sb.append("      Messages and packets can be viewed as a finite collection of\n");
		sb.append("      fields. The list of valid field types is presented below.\n");
		sb.append("    </description>\n");
		sb.append("    <type name=\"int8_t\" size=\"1\">\n");
		sb.append("      <description>\n");
		sb.append("        8 bit signed integer.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"uint8_t\" size=\"1\">\n");
		sb.append("      <description>\n");
		sb.append("        8 bit unsigned integer.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"int16_t\" size=\"2\">\n");
		sb.append("      <description>\n");
		sb.append("        16 bit signed integer.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"uint16_t\" size=\"2\">\n");
		sb.append("      <description>\n");
		sb.append("        16 bit unsigned integer.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"int32_t\" size=\"4\">\n");
		sb.append("      <description>\n");
		sb.append("        32 bit signed integer.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"uint32_t\" size=\"4\">\n");
		sb.append("      <description>\n");
		sb.append("        32 bit unsigned integer.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"int64_t\" size=\"8\">\n");
		sb.append("      <description>\n");
		sb.append("        A 64 bit signed integer\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"fp32_t\" size=\"4\">\n");
		sb.append("      <description>\n");
		sb.append("        32 bit single precision floating point number in IEEE 754 format.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"fp64_t\" size=\"8\">\n");
		sb.append("      <description>\n");
		sb.append("        64 bit double precision floating point number in IEEE 754 format.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"rawdata\">\n");
		sb.append("      <description>\n");
		sb.append("        Variable length byte stream.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Variable length ASCII character stream.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"message\">\n");
		sb.append("      <description>\n");
		sb.append("        An inline message. Useful for encapsulating other messages.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"message-list\">\n");
		sb.append("      <description>\n");
		sb.append("        A list of messages.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("  </types>\n");
		sb.append("\n");
		sb.append("  <serialization>\n");
		sb.append("    <description>\n");
		sb.append("      To ensure accurate transportation some field types may require\n");
		sb.append("      special treatment on transmission and reception. The operation\n");
		sb.append("      of preparing a field type for transmission is called\n");
		sb.append("      serialization, the inverse action is called deserialization. No\n");
		sb.append("      special serialization is required for types that are not\n");
		sb.append("      described in the table below, their values should be used as is.\n");
		sb.append("    </description>\n");
		sb.append("    <type name=\"rawdata\">\n");
		sb.append("      <description>\n");
		sb.append("        A sequence of type *rawdata* is serialized by prepending a\n");
		sb.append("        value of type *uint16_t*, representing the length of the\n");
		sb.append("        sequence, to the stream of bytes. On deserialization the\n");
		sb.append("        prepended value is used to retrieve the correct size of data\n");
		sb.append("        bytes. The *rawdata* type length is limited only by the\n");
		sb.append("        communication protocol in use.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        A sequence of type *plaintext* is serialized by prepending a\n");
		sb.append("        value of type *uint16_t*, representing the length of the\n");
		sb.append("        sequence, to the stream of ASCII characters. On\n");
		sb.append("        deserialization the prepended value is used to retrieve the\n");
		sb.append("        correct ASCII character sequence size. The *plaintext* type\n");
		sb.append("        length is limited only by the communication protocol in use.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"message\">\n");
		sb.append("      <description>\n");
		sb.append("        A field of type *message* is serialized by prepending a value\n");
		sb.append("        of type *uint16_t*, representing the identification number of\n");
		sb.append("        the message, to the serialized message payload. The special\n");
		sb.append("        identification number 65535 must be used when no message is\n");
		sb.append("        present. On deserialization the prepended value is used to\n");
		sb.append("        retrieve the correct message identification number. The\n");
		sb.append("        *message* type length is limited only by the communication\n");
		sb.append("        protocol in use.\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("    <type name=\"message-list\">\n");
		sb.append("      <description>\n");
		sb.append("        A field of type *message-list* is serialized by prepending a\n");
		sb.append("        value of type *uint16_t*, representing the number of messages\n");
		sb.append("        in the list, to the serialized message payload. On\n");
		sb.append("        deserialization the prepended value is used to retrieve the\n");
		sb.append("        correct number of messages\n");
		sb.append("      </description>\n");
		sb.append("    </type>\n");
		sb.append("  </serialization>\n");
		sb.append("\n");
		sb.append("  <units>\n");
		sb.append("    <description>\n");
		sb.append("      The following table lists the units used in the subsequent\n");
		sb.append("      chapters.\n");
		sb.append("    </description>\n");
		sb.append("    <unit abbrev=\"A\" name=\"Ampere\"/>\n");
		sb.append("    <unit abbrev=\"bit\" name=\"Bit\"/>\n");
		sb.append("    <unit abbrev=\"bps\" name=\"Bits per second\"/>\n");
		sb.append("    <unit abbrev=\"byte\" name=\"Byte\"/>\n");
		sb.append("    <unit abbrev=\"g\" name=\"Gravity acceleration\"/>\n");
		sb.append("    <unit abbrev=\"dB\" name=\"Decibel\"/>\n");
		sb.append("    <unit abbrev=\"dB/m\" name=\"Decibel per meter\"/>\n");
		sb.append("    <unit abbrev=\"dBHz\" name=\"Decibel hertz\"/>\n");
		sb.append("    <unit abbrev=\"\u00B0\" name=\"Degree\"/>\n");
		sb.append("    <unit abbrev=\"\u00B0C\" name=\"Degree Celsius\"/>\n");
		sb.append("    <unit abbrev=\"G\" name=\"Gauss\"/>\n");
		sb.append("    <unit abbrev=\"hPa\" name=\"Hectopascal\"/>\n");
		sb.append("    <unit abbrev=\"Hz\" name=\"Hertz\"/>\n");
		sb.append("    <unit abbrev=\"kg/m/m/m\" name=\"Kilogram per cubic metre\"/>\n");
		sb.append("    <unit abbrev=\"MiB\" name=\"Mebibyte\"/>\n");
		sb.append("    <unit abbrev=\"m\" name=\"Meter\"/>\n");
		sb.append("    <unit abbrev=\"m/s\" name=\"Meter per second\"/>\n");
		sb.append("    <unit abbrev=\"m/s/s\" name=\"Meter per second^2\"/>\n");
		sb.append("    <unit abbrev=\"ms\" name=\"Millisecond\"/>\n");
		sb.append("    <unit abbrev=\"\u00B5s\" name=\"Microsecond\"/>\n");
		sb.append("    <unit abbrev=\"S/m\" name=\"Siemens per meter\"/>\n");
		sb.append("    <unit abbrev=\"Nm\" name=\"Newton meter\"/>\n");
		sb.append("    <unit abbrev=\"N\" name=\"Newton\"/>\n");
		sb.append("    <unit abbrev=\"Pa\" name=\"Pascal\"/>\n");
		sb.append("    <unit abbrev=\"%\" name=\"Percent\"/>\n");
		sb.append("    <unit abbrev=\"PPM\" name=\"Parts per million\"/>\n");
		sb.append("    <unit abbrev=\"PPB\" name=\"Parts per billion\"/>\n");
		sb.append("    <unit abbrev=\"PSU\" name=\"Pratical Salinity Unit\"/>\n");
		sb.append("    <unit abbrev=\"rad\" name=\"Radian\"/>\n");
		sb.append("    <unit abbrev=\"rad/s\" name=\"Radian per second\"/>\n");
		sb.append("    <unit abbrev=\"rpm\" name=\"Revolutions per minute\"/>\n");
		sb.append("    <unit abbrev=\"rpm/s\" name=\"Revolutions per minute per second\"/>\n");
		sb.append("    <unit abbrev=\"s\" name=\"Second\"/>\n");
		sb.append("    <unit abbrev=\"V\" name=\"Volt\"/>\n");
		sb.append("    <unit abbrev=\"Enumerated\" name=\"Enumeration of integer values\"/>\n");
		sb.append("    <unit abbrev=\"List\" name=\"Comma separated list of values\"/>\n");
		sb.append("    <unit abbrev=\"Bitfield\" name=\"Bit field\"/>\n");
		sb.append("    <unit abbrev=\"TupleList\" name=\"List of key/value tuples\">\n");
		sb.append("      <description>\n");
		sb.append("        This unit is a list of label/value tuples and is only valid in\n");
		sb.append("        plaintext fields. The label and value portions of a tuple are\n");
		sb.append("        separated using the equal sign (=) and tuples are separated\n");
		sb.append("        using the semicolon character (;). These delimiting characters\n");
		sb.append("        must not be used elsewhere. Leading and trailing semicolons\n");
		sb.append("        must be removed.\n");
		sb.append("        Examples: \"label1=12;label2=3\" or \"label1=12\" or \"label1=test_2\".\n");
		sb.append("      </description>\n");
		sb.append("    </unit>\n");
		sb.append("  </units>\n");
		sb.append("\n");
		sb.append("  <enumerations>\n");
		sb.append("    <def name=\"Boolean Value\" abbrev=\"Boolean\" prefix=\"BOOL\">\n");
		sb.append("      <value id=\"0\" name=\"False\" abbrev=\"FALSE\"/>\n");
		sb.append("      <value id=\"1\" name=\"True\" abbrev=\"TRUE\"/>\n");
		sb.append("    </def>\n");
		sb.append("\n");
		sb.append("    <def name=\"Controlled Mode\" abbrev=\"ControlledMode\" prefix=\"CTLMD\">\n");
		sb.append("      <value id=\"0\" name=\"Relinquish / Handoff Control\" abbrev=\"RELINQUISH_HANDOFF_CTL\"/>\n");
		sb.append("      <value id=\"1\" name=\"Request Control\" abbrev=\"REQUEST_CTL\"/>\n");
		sb.append("      <value id=\"2\" name=\"Override Control\" abbrev=\"OVERRIDE_CTL\"/>\n");
		sb.append("    </def>\n");
		sb.append("\n");
		sb.append("    <def name=\"Speed Units\" abbrev=\"SpeedUnits\" prefix=\"SUNITS\">\n");
		sb.append("      <value id=\"0\" name=\"Meters per second\" abbrev=\"METERS_PS\"/>\n");
		sb.append("      <value id=\"1\" name=\"RPM\" abbrev=\"RPM\"/>\n");
		sb.append("      <value id=\"2\" name=\"Percentage\" abbrev=\"PERCENTAGE\"/>\n");
		sb.append("    </def>\n");
		sb.append("\n");
		sb.append("    <def name=\"System Type\" abbrev=\"SystemType\" prefix=\"SYSTEMTYPE\">\n");
		sb.append("      <value id=\"0\" name=\"CCU\" abbrev=\"CCU\"/>\n");
		sb.append("      <value id=\"1\" name=\"Human-portable Sensor\" abbrev=\"HUMANSENSOR\"/>\n");
		sb.append("      <value id=\"2\" name=\"UUV\" abbrev=\"UUV\"/>\n");
		sb.append("      <value id=\"3\" name=\"USV\" abbrev=\"USV\"/>\n");
		sb.append("      <value id=\"4\" name=\"UAV\" abbrev=\"UAV\"/>\n");
		sb.append("      <value id=\"5\" name=\"UGV\" abbrev=\"UGV\"/>\n");
		sb.append("      <value id=\"6\" name=\"Static sensor\" abbrev=\"STATICSENSOR\"/>\n");
		sb.append("      <value id=\"7\" name=\"Mobile sensor\" abbrev=\"MOBILESENSOR\"/>\n");
		sb.append("      <value id=\"8\" name=\"Wireless Sensor Network\" abbrev=\"WSN\"/>\n");
		sb.append("    </def>\n");
		sb.append("\n");
		sb.append("    <def name=\"Z Units\" abbrev=\"ZUnits\" prefix=\"Z\" >\n");
		sb.append("      <value id=\"0\" name=\"None\" abbrev=\"NONE\"/>\n");
		sb.append("      <value id=\"1\" name=\"Depth\" abbrev=\"DEPTH\"/>\n");
		sb.append("      <value id=\"2\" name=\"Altitude\" abbrev=\"ALTITUDE\"/>\n");
		sb.append("      <value id=\"3\" name=\"Height\" abbrev=\"HEIGHT\"/>\n");
		sb.append("    </def>\n");
		sb.append("  </enumerations>\n");
		sb.append("\n");
		sb.append("  <bitfields>\n");
		sb.append("    <def prefix=\"CL\" name=\"Control Loops Mask\" abbrev=\"CLoopsMask\">\n");
		sb.append("      <value id=\"0x00000000\" abbrev=\"NONE\" name=\"None\"/>\n");
		sb.append("      <value id=\"0x00000001\" abbrev=\"PATH\" name=\"Path Control\"/>\n");
		sb.append("      <value id=\"0x00000002\" abbrev=\"TELEOPERATION\" name=\"Teleoperation Control\"/>\n");
		sb.append("      <value id=\"0x00000004\" abbrev=\"ALTITUDE\" name=\"Altitude Control\"/>\n");
		sb.append("      <value id=\"0x00000008\" abbrev=\"DEPTH\" name=\"Depth Control\"/>\n");
		sb.append("      <value id=\"0x00000010\" abbrev=\"ROLL\" name=\"Roll Control\"/>\n");
		sb.append("      <value id=\"0x00000020\" abbrev=\"PITCH\" name=\"Pitch Control\"/>\n");
		sb.append("      <value id=\"0x00000040\" abbrev=\"YAW\" name=\"Yaw Control\"/>\n");
		sb.append("      <value id=\"0x00000080\" abbrev=\"SPEED\" name=\"Speed Control\"/>\n");
		sb.append("      <value id=\"0x00000100\" abbrev=\"YAW_RATE\" name=\"Yaw Rate Control\"/>\n");
		sb.append("      <value id=\"0x00000200\" abbrev=\"VERTICAL_RATE\" name=\"Vertical Rate Control\"/>\n");
		sb.append("      <value id=\"0x00000400\" abbrev=\"TORQUE\" name=\"Torque Control\"/>\n");
		sb.append("      <value id=\"0x00000800\" abbrev=\"FORCE\" name=\"Force Control\"/>\n");
		sb.append("      <value id=\"0x40000000\" abbrev=\"EXTERNAL\" name=\"Unspecified External Control\"/>\n");
		sb.append("      <value id=\"0x80000000\" abbrev=\"NO_OVERRIDE\" name=\"Non-overridable control\"/>\n");
		sb.append("      <value id=\"0xFFFFFFFF\" abbrev=\"ALL\" name=\"All\"/>\n");
		sb.append("    </def>\n");
		sb.append("\n");
		sb.append("    <def prefix=\"OPL\" name=\"Operational Limits Mask\" abbrev=\"OpLimitsMask\">\n");
		sb.append("      <value id=\"0x01\" name=\"Maximum Depth\" abbrev=\"MAX_DEPTH\"/>\n");
		sb.append("      <value id=\"0x02\" name=\"Minimum Altitude\" abbrev=\"MIN_ALT\"/>\n");
		sb.append("      <value id=\"0x04\" name=\"Maximum Altitude\" abbrev=\"MAX_ALT\"/>\n");
		sb.append("      <value id=\"0x08\" name=\"Minimum Speed\" abbrev=\"MIN_SPEED\"/>\n");
		sb.append("      <value id=\"0x10\" name=\"Maximum Speed\" abbrev=\"MAX_SPEED\"/>\n");
		sb.append("      <value id=\"0x20\" name=\"Maximum Vertical Rate\" abbrev=\"MAX_VRATE\"/>\n");
		sb.append("      <value id=\"0x40\" name=\"Operation Area\" abbrev=\"AREA\"/>\n");
		sb.append("    </def>\n");
		sb.append("  </bitfields>\n");
		sb.append("\n");
		sb.append("  <message-groups>\n");
		sb.append("    <message-group name=\"Maneuver\" abbrev=\"Maneuver\">\n");
		sb.append("      <message-type abbrev=\"Goto\"/>\n");
		sb.append("      <message-type abbrev=\"PopUp\"/>\n");
		sb.append("      <message-type abbrev=\"Teleoperation\"/>\n");
		sb.append("      <message-type abbrev=\"Loiter\"/>\n");
		sb.append("      <message-type abbrev=\"IdleManeuver\"/>\n");
		sb.append("      <message-type abbrev=\"LowLevelControl\"/>\n");
		sb.append("      <message-type abbrev=\"Rows\"/>\n");
		sb.append("      <message-type abbrev=\"FollowPath\"/>\n");
		sb.append("      <message-type abbrev=\"YoYo\"/>\n");
		sb.append("      <message-type abbrev=\"StationKeeping\"/>\n");
		sb.append("      <message-type abbrev=\"Elevator\"/>\n");
		sb.append("      <message-type abbrev=\"FollowTrajectory\"/>\n");
		sb.append("      <message-type abbrev=\"CustomManeuver\"/>\n");
		sb.append("      <message-type abbrev=\"VehicleFormation\"/>\n");
		sb.append("      <message-type abbrev=\"CompassCalibration\"/>\n");
		sb.append("      <message-type abbrev=\"CoverArea\"/>\n");
		sb.append("      <message-type abbrev=\"FollowReference\"/>\n");
		sb.append("      <message-type abbrev=\"CommsRelay\"/>\n");
		sb.append("      <message-type abbrev=\"FormationPlanExecution\"/>\n");
		sb.append("      <message-type abbrev=\"Dislodge\"/>\n");
		sb.append("    </message-group>\n");
		sb.append("\n");
		sb.append("    <message-group name=\"Control Command\" abbrev=\"ControlCommand\">\n");
		sb.append("      <message-type abbrev=\"DesiredZ\"/>\n");
		sb.append("      <message-type abbrev=\"DesiredHeading\"/>\n");
		sb.append("      <message-type abbrev=\"DesiredRoll\"/>\n");
		sb.append("      <message-type abbrev=\"DesiredPitch\"/>\n");
		sb.append("      <message-type abbrev=\"DesiredSpeed\"/>\n");
		sb.append("      <message-type abbrev=\"DesiredPath\"/>\n");
		sb.append("    </message-group>\n");
		sb.append("  </message-groups>\n");
		sb.append("\n");
		sb.append("  <flags>\n");
		sb.append("    <flag abbrev=\"periodic\" name=\"Periodic\"/>\n");
		sb.append("    <flag abbrev=\"deprecated\" name=\"Deprecated\"/>\n");
		sb.append("  </flags>\n");
		sb.append("\n");
		sb.append("  <header>\n");
		sb.append("    <description>\n");
		sb.append("      The packet header contains handling information in the form of\n");
		sb.append("      supplemental fields, it is always placed at the beginning of a\n");
		sb.append("      packet.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Synchronization Number\" abbrev=\"sync\" type=\"uint16_t\" value=\"0xFE54\" fixed=\"true\">\n");
		sb.append("      <description>\n");
		sb.append("        The synchronization number marks the beginning of a packet.\n");
		sb.append("\n");
		sb.append("        It denotes the packet API version and can be used to deduce\n");
		sb.append("        the byte order of the sending host.\n");
		sb.append("\n");
		sb.append("        It encodes value 0xFE[major][minor] where [major] equals the\n");
		sb.append("        major version number of the protocol and [minor] equals the\n");
		sb.append("        minor version of the protocol.\n");
		sb.append("\n");
		sb.append("        The packet recipient is responsible for the correct\n");
		sb.append("        interpretation of the synchronization number and byte order\n");
		sb.append("        conversions.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Message Identification Number\" abbrev=\"mgid\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The identification number of the message contained in the\n");
		sb.append("        packet. This field is used for correct message interpretation\n");
		sb.append("        and deserialization.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Message size\" abbrev=\"size\" type=\"uint16_t\" unit=\"byte\">\n");
		sb.append("      <description>\n");
		sb.append("        The size of the message data in the packet.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Time stamp\" abbrev=\"timestamp\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The time when the packet was sent, as seen by the packet\n");
		sb.append("        dispatcher. The number of seconds is represented in Universal\n");
		sb.append("        Coordinated Time (UCT) in seconds since Jan 1, 1970 using IEEE\n");
		sb.append("        double precision floating point numbers.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Source Address\" abbrev=\"src\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The Source IMC system ID.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Source Entity\" abbrev=\"src_ent\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The entity generating this message at the source address.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Destination Address\" abbrev=\"dst\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The Destination IMC system ID.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Destination Entity\" abbrev=\"dst_ent\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The entity that should process this message at the destination\n");
		sb.append("        address.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </header>\n");
		sb.append("\n");
		sb.append("  <footer>\n");
		sb.append("    <description>\n");
		sb.append("      The packet footer contains validation information in the form of\n");
		sb.append("      supplemental fields, it is always placed at the end of a packet.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Check Sum (CRC-16-IBM)\" abbrev=\"crc16\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The check sum field is computed using the CRC-16-IBM with\n");
		sb.append("        polynomial 0x8005 (x^16 + x^15 + x^2 + 1). The data\n");
		sb.append("        contributing for the CRC includes all preceding header and\n");
		sb.append("        message bytes.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </footer>\n");
		sb.append("\n");
		sb.append("  <groups>\n");
		sb.append("    <group name=\"Core\" abbrev=\"GroupCore\" min=\"0\" max=\"49\"/>\n");
		sb.append("    <group name=\"Simulation\" abbrev=\"GroupSimulation\" min=\"50\" max=\"99\"/>\n");
		sb.append("    <group name=\"Storage\" abbrev=\"GroupStorage\" min=\"100\" max=\"149\"/>\n");
		sb.append("    <group name=\"Networking\" abbrev=\"GroupNetworking\" min=\"150\" max=\"199\"/>\n");
		sb.append("    <group name=\"Acoustic Networking\" abbrev=\"GroupAcousticNetworking\" min=\"200\" max=\"249\"/>\n");
		sb.append("    <group name=\"Sensors\" abbrev=\"GroupSensors\" min=\"250\" max=\"299\"/>\n");
		sb.append("    <group name=\"Actuation\" abbrev=\"GroupActuation\" min=\"300\" max=\"349\"/>\n");
		sb.append("    <group name=\"Navigation\" abbrev=\"GroupNavigation\" min=\"350\" max=\"399\"/>\n");
		sb.append("    <group name=\"Guidance\" abbrev=\"GroupGuidance\" min=\"400\" max=\"449\"/>\n");
		sb.append("    <group name=\"Maneuvering\" abbrev=\"GroupManeuvering\" min=\"450\" max=\"499\"/>\n");
		sb.append("    <group name=\"Vehicle Supervision\" abbrev=\"GroupVehicleSupervision\" min=\"500\" max=\"549\"/>\n");
		sb.append("    <group name=\"Plan Supervision\" abbrev=\"GroupPlanSupervision\" min=\"550\" max=\"599\"/>\n");
		sb.append("    <group name=\"CCU\" abbrev=\"GroupCcu\" min=\"600\" max=\"649\"/>\n");
		sb.append("    <group name=\"Autonomy\" abbrev=\"GroupAutonomy\" min=\"650\" max=\"699\"/>\n");
		sb.append("    <group name=\"Vision\" abbrev=\"GroupVision\" min=\"700\" max=\"749\"/>\n");
		sb.append("    <group name=\"External\" abbrev=\"GroupExternal\" min=\"750\" max=\"799\"/>\n");
		sb.append("    <group name=\"Development\" abbrev=\"GroupDevelopment\" min=\"800\" max=\"900\"/>\n");
		sb.append("    <group name=\"Custom\" abbrev=\"GroupCustom\" min=\"1000\" max=\"65534\"/>\n");
		sb.append("  </groups>\n");
		sb.append("\n");
		sb.append("  <!-- Core -->\n");
		sb.append("  <message id=\"1\" name=\"Entity State\" abbrev=\"EntityState\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      State reported by an entity in the vehicle. The source entity is\n");
		sb.append("      identified in the message header.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"State\" abbrev=\"state\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"ESTA\">\n");
		sb.append("      <description>\n");
		sb.append("        State of entity.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Bootstrapping\" abbrev=\"BOOT\"/>\n");
		sb.append("      <value id=\"1\" name=\"Normal Operation\" abbrev=\"NORMAL\"/>\n");
		sb.append("      <value id=\"2\" name=\"Fault\" abbrev=\"FAULT\"/>\n");
		sb.append("      <value id=\"3\" name=\"Error\" abbrev=\"ERROR\"/>\n");
		sb.append("      <value id=\"4\" name=\"Failure\" abbrev=\"FAILURE\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Flags\" abbrev=\"flags\" type=\"uint8_t\" unit=\"Bitfield\" prefix=\"EFLA\">\n");
		sb.append("      <description>\n");
		sb.append("        Complementary entity state flags.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x01\" abbrev=\"HUMAN_INTERVENTION\" name=\"Human Intervention Required\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Complementary description\" type=\"plaintext\" abbrev=\"description\">\n");
		sb.append("      <description>\n");
		sb.append("        Complementary human-readable description of entity state.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"2\" name=\"Query Entity State\" abbrev=\"QueryEntityState\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Request entities to report their state. Entities should respond\n");
		sb.append("      by issuing an appropriate EntityState message.\n");
		sb.append("    </description>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"3\" name=\"Entity Information\" abbrev=\"EntityInfo\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      This message describes an entity.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Entity Identifier\" abbrev=\"id\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Entity identifier.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Label\" abbrev=\"label\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Entity label or empty if the entity id is not valid.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Component name\" abbrev=\"component\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Name of the plugin/component/subsystem associated with this\n");
		sb.append("        entity.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Activation Time\" abbrev=\"act_time\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Amount of time needed to properly activate the entity.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Deactivation Time\" abbrev=\"deact_time\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Amount of time needed to properly deactivate the entity.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"4\" name=\"Query Entity Information\" abbrev=\"QueryEntityInfo\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Request information about an entity identifier. The receiving\n");
		sb.append("      system shall reply with an EntityInfo message with the details\n");
		sb.append("      of that entity.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Entity Identifier\" abbrev=\"id\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Entity identifier.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"5\" name=\"Entity List\" abbrev=\"EntityList\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      This message describes the names and identification numbers of\n");
		sb.append("      all entities in the system.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"OP\">\n");
		sb.append("      <description>\n");
		sb.append("        Operation to perform.\n");
		sb.append("      </description>\n");
		sb.append("      <value abbrev=\"REPORT\" name=\"Report\" id=\"0\"/>\n");
		sb.append("      <value abbrev=\"QUERY\" name=\"Query\" id=\"1\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"list\" abbrev=\"list\" type=\"plaintext\" unit=\"TupleList\">\n");
		sb.append("      <description>\n");
		sb.append("        Example: \"Battery=11;CTD=3\"\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"7\" name=\"CPU Usage\" abbrev=\"CpuUsage\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of software CPU usage.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Usage percentage\" abbrev=\"value\" type=\"uint8_t\" min=\"0\" max=\"100\" unit=\"%\">\n");
		sb.append("      <description>\n");
		sb.append("        The CPU usage, in percentage, of the sending software.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"8\" name=\"Transport Bindings\" abbrev=\"TransportBindings\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Message generated when tasks bind to messages.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Consumer name\" abbrev=\"consumer\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        The name of the consumer (e.g. task name).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Message Identifier\" abbrev=\"message_id\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The id of the message to be listened to.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"9\" name=\"Restart System\" abbrev=\"RestartSystem\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Request the destination system to restart itself.\n");
		sb.append("    </description>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"12\" name=\"Device Calibration Control\" abbrev=\"DevCalibrationControl\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      This message controls the calibration procedure of a given\n");
		sb.append("      device. The destination device is selected using the destination\n");
		sb.append("      entity identification number.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"DCAL\">\n");
		sb.append("      <description>\n");
		sb.append("        Operation to perform.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Start\" abbrev=\"START\">\n");
		sb.append("        <description>\n");
		sb.append("          Start calibration procedure.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Stop\" abbrev=\"STOP\">\n");
		sb.append("        <description>\n");
		sb.append("          Stop calibration procedure.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Perform Next Calibration Step\" abbrev=\"STEP_NEXT\">\n");
		sb.append("        <description>\n");
		sb.append("          Perform next step of the calibration procedure.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Perform Previous Calibration Step\" abbrev=\"STEP_PREVIOUS\">\n");
		sb.append("        <description>\n");
		sb.append("          Perform previous step of the calibration procedure.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"13\" name=\"Device Calibration State\" abbrev=\"DevCalibrationState\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      State of the calibration procedure.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Total Steps\" abbrev=\"total_steps\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Total number of steps of the calibration procedure.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Current Step Number\" abbrev=\"step_number\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Number of the current step being performed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Description\" abbrev=\"step\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Human-readable description of the current step.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Flags\" abbrev=\"flags\" type=\"uint8_t\" unit=\"Bitfield\" prefix=\"DCS\">\n");
		sb.append("      <description>\n");
		sb.append("        Additional flags.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x01\" abbrev=\"PREVIOUS_NOT_SUPPORTED\" name=\"Previous Step Not Supported\">\n");
		sb.append("        <description>\n");
		sb.append("          Jumping to the previous calibration step is not supported.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x02\" abbrev=\"NEXT_NOT_SUPPORTED\" name=\"Next Step Not Supported\">\n");
		sb.append("        <description>\n");
		sb.append("          Jumping to the next calibration step is not supported.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x04\" abbrev=\"WAITING_CONTROL\" name=\"Waiting Device Calibration Control\">\n");
		sb.append("        <description>\n");
		sb.append("          The calibration procedure was suspended and must be resumed or\n");
		sb.append("          cancelled with a DeviceCalibrationControl message.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x08\" abbrev=\"ERROR\" name=\"Calibration Error\">\n");
		sb.append("        <description>\n");
		sb.append("          Calibration was interrupted due to an error and must be\n");
		sb.append("          restarted or cancelled with a DeviceCalibrationControl\n");
		sb.append("          message.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x10\" abbrev=\"COMPLETED\" name=\"Calibration Procedure Completed\">\n");
		sb.append("        <description>\n");
		sb.append("          The calibration procedure was completed.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"14\" name=\"Entity Activation State\" abbrev=\"EntityActivationState\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      State of entity activation/deactivation.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"State\" abbrev=\"state\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"EAS\">\n");
		sb.append("      <description>\n");
		sb.append("        Current state.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" abbrev=\"INACTIVE\" name=\"Entity is Inactive\">\n");
		sb.append("        <description>\n");
		sb.append("          Entity is inactive.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" abbrev=\"ACTIVE\" name=\"Entity is Active\">\n");
		sb.append("        <description>\n");
		sb.append("          Entity is active.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" abbrev=\"ACT_IP\" name=\"Activation in Progress\">\n");
		sb.append("        <description>\n");
		sb.append("          Activation is in progress.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" abbrev=\"ACT_DONE\" name=\"Activation Completed\">\n");
		sb.append("        <description>\n");
		sb.append("          Activation is completed.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"4\" abbrev=\"ACT_FAIL\" name=\"Activation Failed\">\n");
		sb.append("        <description>\n");
		sb.append("          The activation procedure failed and the field 'error' contains the error message.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"5\" abbrev=\"DEACT_IP\" name=\"Deactivation In Progress\">\n");
		sb.append("        <description>\n");
		sb.append("          Deactivation is in progress.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"6\" abbrev=\"DEACT_DONE\" name=\"Deactivation Completed\">\n");
		sb.append("        <description>\n");
		sb.append("          Deactivation is in progress.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"7\" abbrev=\"DEACT_FAIL\" name=\"Deactivation Failed\">\n");
		sb.append("        <description>\n");
		sb.append("          The deactivation procedure failed and the field 'error' contains the error message.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Error\" abbrev=\"error\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Human-readable error message.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"15\" name=\"Query Entity Activation State\" abbrev=\"QueryEntityActivationState\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Query the activation/deactivation state of an entity. The\n");
		sb.append("      recipient shall reply with an EntityActivationState message.\n");
		sb.append("    </description>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"16\" name=\"Vehicle Operational Limits\" abbrev=\"VehicleOperationalLimits\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Vehicle opertional limits.\n");
		sb.append("      For aircraft this should represent the flight envelope and the dynamic contraints.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Action on the vehicle operational limits\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"OP\">\n");
		sb.append("      <description>\n");
		sb.append("        Action on the vehicle operation limits\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Request\" abbrev=\"REQUEST\"/>\n");
		sb.append("      <value id=\"1\" name=\"Set\" abbrev=\"SET\"/>\n");
		sb.append("      <value id=\"2\" name=\"Report\" abbrev=\"REPORT\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Minimum speed\" abbrev=\"speed_min\" type=\"fp32_t\" unit=\"m/s\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Minimum operation speed.\n");
		sb.append("        For aircraft this is equal or larger then the stall speed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maximum speed\" abbrev=\"speed_max\" type=\"fp32_t\" unit=\"m/s\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Maximum operation speed.\n");
		sb.append("        For aircraft this is limited by the engine power or structural contrains.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitudinal maximum acceleration\" abbrev=\"long_accel\" type=\"fp32_t\" unit=\"m/s/s\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Maximum longitudinal acceleration.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maximum MSL altitude\" abbrev=\"alt_max_msl\" type=\"fp32_t\" unit=\"m\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Maximum altitude above mean-sea-level.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maximum Dive Rate Speed Fraction\" abbrev=\"dive_fraction_max\" type=\"fp32_t\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Maximum dive rate (negative vertical speed) as a fraction of the longitudinal speed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maximum Climb Rate Speed Fraction\" abbrev=\"climb_fraction_max\" type=\"fp32_t\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Maximum climb rate (positive vertical speed) as a fraction of the longitudinal speed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Bank limit\" abbrev=\"bank_max\" type=\"fp32_t\" unit=\"rad\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Limit to the bank angle (roll; angle over the xx body-axis).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Bank rate limit\" abbrev=\"p_max\" type=\"fp32_t\" unit=\"rad/s\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Limit to the bank angular rate (roll; angle over the xx body-axis).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Minimum pitch angle\" abbrev=\"pitch_min\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Minimum pitch angle (angle over the xx body-axis).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maximum pitch angle\" abbrev=\"pitch_max\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Maximum pitch angle (angle over the xx body-axis).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maximum pitch rate\" abbrev=\"q_max\" type=\"fp32_t\" unit=\"rad/s\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Maximum pitch angular rate (angle over the xx body-axis).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Minimum load factor\" abbrev=\"g_min\" type=\"fp32_t\" unit=\"g\" max=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Minimum load factor, i.e., maximum positive acceleration in the zz body-axis\n");
		sb.append("        as a factor of the gravity acceleration at mean-sea-level.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maximum load factor\" abbrev=\"g_max\" type=\"fp32_t\" unit=\"g\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Maximum load factor, i.e., maximum negative acceleration in the zz body-axis\n");
		sb.append("        as a factor of the gravity acceleration at mean-sea-level.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maximum lateral load factor\" abbrev=\"g_lat_max\" type=\"fp32_t\" unit=\"g\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Maximum lateral load factor, i.e., maximum acceleration in the yy body-axis\n");
		sb.append("        as a factor of the gravity acceleration at mean-sea-level.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Minimum RPMs\" abbrev=\"rpm_min\" type=\"fp32_t\" unit=\"rpm\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Minimum motor RPMs.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maximum RPMs\" abbrev=\"rpm_max\" type=\"fp32_t\" unit=\"rpm\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Maximum motor RPMs.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maximum RPM rate\" abbrev=\"rpm_rate_max\" type=\"fp32_t\" unit=\"rpm/s\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Maximum motor RPMs' rate of change.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"20\" name=\"Message List\" abbrev=\"MsgList\" >\n");
		sb.append("    <field name=\"Messages\" abbrev=\"msgs\" type=\"message-list\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!-- Simulation -->\n");
		sb.append("  <message id=\"50\" name=\"Simulated State\" abbrev=\"SimulatedState\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      This message presents the simulated state of the vehicle. The simulated\n");
		sb.append("      state attempts to provide a realistic state interpretation of operating\n");
		sb.append("      various kinds of vehicles.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Latitude (WGS-84)\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude (WGS-84)\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Height (WGS-84)\" abbrev=\"height\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Height above the WGS-84 ellipsoid.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Offset north (m)\" abbrev=\"x\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The North offset of the North/East/Down field.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Offset east (m)\" abbrev=\"y\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The East offset of the North/East/Down field.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Offset down (m)\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The Down offset of the North/East/Down field.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Rotation over x axis\" abbrev=\"phi\" type=\"fp32_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The phi Euler angle from the vehicle's attitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Rotation over y axis\" abbrev=\"theta\" type=\"fp32_t\" unit=\"rad\" min=\"-1.57079632679490\" max=\"1.57079632679490\">\n");
		sb.append("      <description>\n");
		sb.append("        The theta Euler angle from the vehicle's attitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Rotation over z axis\" abbrev=\"psi\" type=\"fp32_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The psi Euler angle from the vehicle's attitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Body-Fixed xx Linear Velocity\" abbrev=\"u\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Body-fixed frame xx axis linear velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Body-Fixed yy Linear Velocity\" abbrev=\"v\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Body-fixed frame yy axis linear velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Body-Fixed zz Linear Velocity\" abbrev=\"w\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Body-fixed frame zz axis linear velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Angular Velocity in x\" abbrev=\"p\" type=\"fp32_t\" unit=\"rad/s\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The angular velocity over body-fixed xx axis (roll rate).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Angular Velocity in y\" abbrev=\"q\" type=\"fp32_t\" unit=\"rad/s\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The angular velocity over body-fixed yy axis (pitch rate).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Angular Velocity in z\" abbrev=\"r\" type=\"fp32_t\" unit=\"rad/s\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The angular velocity over body-fixed zz axis (yaw rate).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Stream Velocity X (North)\" abbrev=\"svx\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Stream Velocity xx axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Stream Velocity Y (East)\" abbrev=\"svy\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Stream Velocity yy axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Stream Velocity Z (Down)\" abbrev=\"svz\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Stream Velocity zz axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"51\" name=\"Leak Simulation\" abbrev=\"LeakSimulation\">\n");
		sb.append("    <description>\n");
		sb.append("      Simulate leak behavior.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" type=\"uint8_t\" prefix=\"LSIM\" unit=\"Enumerated\">\n");
		sb.append("      <description>\n");
		sb.append("        Indicates whether leaks have been detected or not.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" abbrev=\"OFF\" name=\"Leaks Off\"/>\n");
		sb.append("      <value id=\"1\" abbrev=\"ON\" name=\"Leaks On\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Leak Entities\" abbrev=\"entities\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Comma separated list of leak entities (empty for all leaks\n");
		sb.append("        configured).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"52\" name=\"Underwater Acoustics Simulation\" abbrev=\"UASimulation\">\n");
		sb.append("    <description>\n");
		sb.append("      Underwater acoustics simulation request.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Type\" abbrev=\"type\" type=\"uint8_t\" prefix=\"UAS\" unit=\"Enumerated\">\n");
		sb.append("      <description>Type of request.</description>\n");
		sb.append("      <value id=\"0\" abbrev=\"DATA\" name=\"Data Transmission\"/>\n");
		sb.append("      <value id=\"1\" abbrev=\"PING\" name=\"Ping\"/>\n");
		sb.append("      <value id=\"2\" abbrev=\"PING_REPLY\" name=\"Ping Reply\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Transmission Speed\" abbrev=\"speed\" unit=\"bps\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Transmission speed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Data\" abbrev=\"data\" type=\"rawdata\">\n");
		sb.append("      <description>\n");
		sb.append("        Data for transmission requests.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"53\" name=\"Dynamics Simulation Parameters\" abbrev=\"DynamicsSimParam\">\n");
		sb.append("    <description>\n");
		sb.append("      Vehicle dynamics parameters for 3DOF, 4DOF or 5DOF simulations.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Action on the Vehicle Simulation Parameters\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"OP\">\n");
		sb.append("      <description>\n");
		sb.append("        Action on the vehicle simulation parameters for the formation control\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Request\" abbrev=\"REQUEST\"/>\n");
		sb.append("      <value id=\"1\" name=\"Set\" abbrev=\"SET\"/>\n");
		sb.append("      <value id=\"2\" name=\"Report\" abbrev=\"REPORT\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"TAS to Longitudinal Acceleration Gain\" abbrev=\"tas2acc_pgain\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Proportional gain from the TAS (True Airspeed) error to the longitudinal acceleration.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Bank to Bank Rate Gain\" abbrev=\"bank2p_pgain\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Proportional gain from the bank angle error to the bank angular rate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!-- Storage -->\n");
		sb.append("  <message id=\"100\" name=\"Storage Usage\" abbrev=\"StorageUsage\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of storage usage.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Available\" abbrev=\"available\" type=\"uint32_t\" unit=\"MiB\">\n");
		sb.append("      <description>\n");
		sb.append("        The available storage of the reporting device.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Usage\" abbrev=\"value\" type=\"uint8_t\" min=\"0\" max=\"100\" unit=\"%\">\n");
		sb.append("      <description>\n");
		sb.append("        The percentage of storage used by the reporting device.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"101\" name=\"Cache Control\" abbrev=\"CacheControl\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Control caching of messages to persistent storage.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Control Operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"COP\">\n");
		sb.append("      <description>\n");
		sb.append("        Operation to perform.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Store\" abbrev=\"STORE\"/>\n");
		sb.append("      <value id=\"1\" name=\"Load\" abbrev=\"LOAD\"/>\n");
		sb.append("      <value id=\"2\" name=\"Clear\" abbrev=\"CLEAR\"/>\n");
		sb.append("      <value id=\"3\" name=\"Copy Snapshot\" abbrev=\"COPY\"/>\n");
		sb.append("      <value id=\"4\" name=\"Snapshot Copy Complete\" abbrev=\"COPY_COMPLETE\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Snapshot destination\" abbrev=\"snapshot\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Destination for the cache snapshot file.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Message\" abbrev=\"message\" type=\"message\">\n");
		sb.append("      <description>\n");
		sb.append("        Message to store.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"102\" name=\"Logging Control\" abbrev=\"LoggingControl\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Control logging of messages to persistent storage.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Control Operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"COP\">\n");
		sb.append("      <description>\n");
		sb.append("        Operation to perform.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Request Start of Logging\" abbrev=\"REQUEST_START\">\n");
		sb.append("        <description>\n");
		sb.append("          Request the logging manager to start logging. The logging\n");
		sb.append("          manager will reply with a STARTED operation. If logging is\n");
		sb.append("          already in progress the current log will be closed and a new\n");
		sb.append("          one will be opened (therefore the logging manager will send\n");
		sb.append("          two messages - STOPPED and STARTED). The field 'name'\n");
		sb.append("          represents the label that will be appended to the log path.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Logging Started\" abbrev=\"STARTED\">\n");
		sb.append("        <description>\n");
		sb.append("          The logging manager will send a message with this operation\n");
		sb.append("          everytime a log is successfully started. The field 'name'\n");
		sb.append("          contains the complete name of the log.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Request Logging Stop\" abbrev=\"REQUEST_STOP\">\n");
		sb.append("        <description>\n");
		sb.append("          Request the logging manager to stop logging messages. The\n");
		sb.append("          logging manager will reply with a STOPPED operation and\n");
		sb.append("          logging will be suspended until a message with operation\n");
		sb.append("          START is received. If logging is already stoppped the\n");
		sb.append("          logging manager will ignore this operation and will not\n");
		sb.append("          reply with a STOPPED operation. The field 'name' with this\n");
		sb.append("          operation type has no meaning.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Logging Stopped\" abbrev=\"STOPPED\">\n");
		sb.append("        <description>\n");
		sb.append("          The logging manager will send a message with this operation\n");
		sb.append("          when logging is successfully stopped. The field 'name'\n");
		sb.append("          contains the complete name of the log that was closed.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"4\" name=\"Request Current Log Name\" abbrev=\"REQUEST_CURRENT_NAME\">\n");
		sb.append("        <description>\n");
		sb.append("          This operation instructs the logging manager to send a\n");
		sb.append("          message with operation CURRENT_NAME containing the complete\n");
		sb.append("          name of the current log in the field 'name'. The field\n");
		sb.append("          'name' with this operation type has no meaning.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"5\" name=\"Current Log Name\" abbrev=\"CURRENT_NAME\">\n");
		sb.append("        <description>\n");
		sb.append("          The logging manager will send a message with this operation\n");
		sb.append("          when asked via the REQUEST_CURRENT_NAME operation. The field\n");
		sb.append("          'name' contains the complete name of the log.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Log Label / Path\" abbrev=\"name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        The meaning of this field depends on the operation and is\n");
		sb.append("        explained in the operation's description.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"103\" name=\"Log Book Entry\" abbrev=\"LogBookEntry\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Human readable message reporting an event of interest.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Type\" abbrev=\"type\" type=\"uint8_t\" prefix=\"LBET\" unit=\"Enumerated\">\n");
		sb.append("      <description>\n");
		sb.append("        Type of message.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" abbrev=\"INFO\" name=\"Information\"/>\n");
		sb.append("      <value id=\"1\" abbrev=\"WARNING\" name=\"Warning\"/>\n");
		sb.append("      <value id=\"2\" abbrev=\"ERROR\" name=\"Error\"/>\n");
		sb.append("      <value id=\"3\" abbrev=\"CRITICAL\" name=\"Critical\"/>\n");
		sb.append("      <value id=\"4\" abbrev=\"DEBUG\" name=\"Debug\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Timestamp\" abbrev=\"htime\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Timestamp (Epoch time).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Context\" abbrev=\"context\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Message context.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Text\" abbrev=\"text\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Message text.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"104\" name=\"Log Book Control\" abbrev=\"LogBookControl\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Control history log.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Command\" abbrev=\"command\" prefix=\"LBC\" type=\"uint8_t\" unit=\"Enumerated\">\n");
		sb.append("      <description>\n");
		sb.append("        Command to perform.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Get\" abbrev=\"GET\">\n");
		sb.append("        <description>\n");
		sb.append("          Retrieve log book entries.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Clear\" abbrev=\"CLEAR\">\n");
		sb.append("        <description>\n");
		sb.append("          Clear log book entries.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Get Errors\" abbrev=\"GET_ERR\">\n");
		sb.append("        <description>\n");
		sb.append("          Retrieve log book entries corresponding to errors.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Reply\" abbrev=\"REPLY\">\n");
		sb.append("        <description>\n");
		sb.append("          Reply to a GET command. Message argument is a MessageList\n");
		sb.append("          instance containing LogBookEntry messages.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Timestamp\" abbrev=\"htime\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Timestamp for command (Epoch time).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Messages\" abbrev=\"msg\" type=\"message-list\" message-type=\"LogBookEntry\">\n");
		sb.append("      <description>\n");
		sb.append("        Argument, currently used only for 'REPLY'.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"105\" name=\"Replay Control\" abbrev=\"ReplayControl\">\n");
		sb.append("    <description>Control replay of LSF logged data.</description>\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" prefix=\"ROP\" type=\"uint8_t\" unit=\"Enumerated\">\n");
		sb.append("      <description>\n");
		sb.append("        Operation to perform.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" abbrev=\"START\" name=\"Start\"/>\n");
		sb.append("      <value id=\"1\" abbrev=\"STOP\" name=\"Stop\"/>\n");
		sb.append("      <value id=\"2\" abbrev=\"PAUSE\" name=\"Pause\"/>\n");
		sb.append("      <value id=\"3\" abbrev=\"RESUME\" name=\"Resume\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"File To Replay\" abbrev=\"file\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Pathname of file to replay.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"106\" name=\"Clock Control\" abbrev=\"ClockControl\" used-by=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Clock control.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" type=\"uint8_t\" prefix=\"COP\" unit=\"Enumerated\">\n");
		sb.append("      <description>\n");
		sb.append("        Operation to perform.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Execute Sync.\" abbrev=\"SYNC_EXEC\">\n");
		sb.append("        <description>\n");
		sb.append("          Synchronize clock according to given clock value.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Request Sync.\" abbrev=\"SYNC_REQUEST\">\n");
		sb.append("        <description>\n");
		sb.append("          Request autonomous clock synchronization.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Sync. Started\" abbrev=\"SYNC_STARTED\">\n");
		sb.append("        <description>\n");
		sb.append("          Synchronization start notification.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Sync. done\" abbrev=\"SYNC_DONE\">\n");
		sb.append("        <description>\n");
		sb.append("          Synchronization completion notification.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"4\" name=\"Set Timezone \" abbrev=\"SET_TZ\">\n");
		sb.append("        <description>\n");
		sb.append("          Set timezone.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"5\" name=\"Timezone Setup\" abbrev=\"SET_TZ_DONE\">\n");
		sb.append("        <description>\n");
		sb.append("          Notification due to timezone modification.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Clock\" abbrev=\"clock\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Clock value (Epoch time).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Timezone\" abbrev=\"tz\" type=\"int8_t\" min=\"-23\" max=\"23\">\n");
		sb.append("      <description>\n");
		sb.append("        Timezone.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!--  Networking Messages -->\n");
		sb.append("  <message id=\"150\" name=\"Heartbeat\" abbrev=\"Heartbeat\" source=\"vehicle,ccu\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      The Heartbeat message is used to inform other modules that the\n");
		sb.append("      sending entity's system is running normally and communications\n");
		sb.append("      are alive.\n");
		sb.append("    </description>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"151\" name=\"Announce\" abbrev=\"Announce\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      A system description that is to be broadcasted to other systems.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"System Name\" abbrev=\"sys_name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        System name.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"System Type\" abbrev=\"sys_type\" type=\"uint8_t\" unit=\"Enumerated\" enum-def=\"SystemType\">\n");
		sb.append("      <description>\n");
		sb.append("        System type.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Control Owner\" abbrev=\"owner\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The owner IMC system ID.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude. If lat=0 and lon=0 means location value is unknown.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude. If lat=0 and lon=0 means location value is unknown.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Height WGS-84\" abbrev=\"height\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Height above WGS-84 ellipsoid.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Services\" abbrev=\"services\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Semicolon separated list of URLs. Examples of such URLs are\n");
		sb.append("        - *imc+udp://192.168.106.34:6002/*\n");
		sb.append("        - *dune://0.0.0.0/uid/1294925553839635/*\n");
		sb.append("        - *http://192.168.106.34/dune/*.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"152\" name=\"Announce Service\" abbrev=\"AnnounceService\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Announcement about the existence of a service.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Service\" abbrev=\"service\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Semicolon separated list of URLs (see :ref:`Announce`).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"ServiceType\" abbrev=\"service_type\" type=\"uint8_t\" unit=\"Bitfield\" prefix=\"SRV_TYPE\">\n");
		sb.append("      <description>\n");
		sb.append("        Informs about the availability of the service on internal and\n");
		sb.append("        external networks.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x01\" name=\"External\" abbrev=\"EXTERNAL\"/>\n");
		sb.append("      <value id=\"0x02\" name=\"Local\" abbrev=\"LOCAL\"/>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"153\" name=\"Receive Signal Strength Information\" abbrev=\"RSSI\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Measure of the RSSI by a networking device.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp32_t\" max=\"100\" unit=\"%\">\n");
		sb.append("      <description>\n");
		sb.append("        RSSI measurement.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"154\" name=\"Voltage Standing Wave Ratio\" abbrev=\"VSWR\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Measure of the VSWR by a networking device.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        VSWR measurement.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"155\" name=\"Link Level\" abbrev=\"LinkLevel\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Measurement of link level quality. For instance, this may\n");
		sb.append("      correspond to the acknowledgment ratio of a link. But,\n");
		sb.append("      generally, the measure is link-dependent.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Link level value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"156\" name=\"SMS\" abbrev=\"Sms\" source=\"vehicle\" flags=\"deprecated\">\n");
		sb.append("    <description>\n");
		sb.append("      Send a SMS message.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Number\" abbrev=\"number\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Target mobile device number.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Timeout\" abbrev=\"timeout\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Timeout for sending message.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Contents\" abbrev=\"contents\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Message contents.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"157\" name=\"SMS Transmit\" abbrev=\"SmsTx\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Request to send SMS.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Sequence Number\" abbrev=\"seq\" type=\"uint32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Sequence number.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Destination\" abbrev=\"destination\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Number or name of the recipient.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Timeout\" abbrev=\"timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Timeout for sending message.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Data\" abbrev=\"data\" type=\"rawdata\">\n");
		sb.append("      <description>\n");
		sb.append("        Message data.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"158\" name=\"SMS Receive\" abbrev=\"SmsRx\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Received SMS data.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Source\" abbrev=\"source\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Number of name of the sender.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Data\" abbrev=\"data\" type=\"rawdata\">\n");
		sb.append("      <description>\n");
		sb.append("        Message data.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"159\" name=\"SMS State\" abbrev=\"SmsState\" source=\"vehicle\">\n");
		sb.append("    <field name=\"Sequence Number\" abbrev=\"seq\" type=\"uint32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Sequence number.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"State\" abbrev=\"state\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"SMS\">\n");
		sb.append("      <description>\n");
		sb.append("        Current state of an SMS transaction.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Accepted\" abbrev=\"ACCEPTED\"/>\n");
		sb.append("      <value id=\"1\" name=\"Rejected\" abbrev=\"REJECTED\"/>\n");
		sb.append("      <value id=\"2\" name=\"Interrupted\" abbrev=\"INTERRUPTED\"/>\n");
		sb.append("      <value id=\"3\" name=\"Completed\" abbrev=\"COMPLETED\"/>\n");
		sb.append("      <value id=\"4\" name=\"Idle\" abbrev=\"IDLE\"/>\n");
		sb.append("      <value id=\"5\" name=\"Transmitting\" abbrev=\"TRANSMITTING\"/>\n");
		sb.append("      <value id=\"6\" name=\"Receiving\" abbrev=\"RECEIVING\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Error Message\" abbrev=\"error\" type=\"plaintext\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"160\" name=\"Text Message\" abbrev=\"TextMessage\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      A text message has been received.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Origin\" abbrev=\"origin\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Message origin (if known).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Text\" abbrev=\"text\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Message contents.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"170\" name=\"Received Iridium Message\" abbrev=\"IridiumMsgRx\" source=\"vehicle,ccu\">\n");
		sb.append("    <field name=\"Origin Identifier\" abbrev=\"origin\" type=\"plaintext\">\n");
		sb.append("      <description>The unique identifier of this message's origin device (e.g. lauv-xtreme-2, manta-0).</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Timestamp\" abbrev=\"htime\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>Timestamp (Epoch time).</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude Reference\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" />\n");
		sb.append("    <field name=\"Longitude Reference\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" />\n");
		sb.append("    <field name=\"Data\" abbrev=\"data\" type=\"rawdata\">\n");
		sb.append("      <description>\n");
		sb.append("        Message data.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"171\" name=\"Transmit Iridium Message\" abbrev=\"IridiumMsgTx\" source=\"vehicle,ccu\">\n");
		sb.append("    <field name=\"Request Identifier\" abbrev=\"req_id\" type=\"uint16_t\">\n");
		sb.append("      <description>The request identifier used to receive transmission updates.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Time to live\" abbrev=\"ttl\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>Time, in seconds, after which there will be no more atempts to transmit the message.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Destination Identifier\" abbrev=\"destination\" type=\"plaintext\">\n");
		sb.append("      <description>The unique identifier of this message's destination (e.g. lauv-xtreme-2, manta-0).</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Data\" abbrev=\"data\" type=\"rawdata\">\n");
		sb.append("      <description>\n");
		sb.append("        Message data.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"172\" name=\"Iridium Transmission Status\" abbrev=\"IridiumTxStatus\" source=\"vehicle,ccu\">\n");
		sb.append("    <field name=\"Request Identifier\" abbrev=\"req_id\" type=\"uint16_t\">\n");
		sb.append("      <description>The request identifier used to receive transmission updates</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Status Code\" abbrev=\"status\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"TXSTATUS\">\n");
		sb.append("      <value abbrev=\"OK\" name=\"Successfull transmission\" id=\"1\"/>\n");
		sb.append("      <value abbrev=\"ERROR\" name=\"Error while trying to transmit message\" id=\"2\"/>\n");
		sb.append("      <value abbrev=\"QUEUED\" name=\"Message has been queued for transmission\" id=\"3\"/>\n");
		sb.append("      <value abbrev=\"TRANSMIT\" name=\"Message is currently being transmitted\" id=\"4\"/>\n");
		sb.append("      <value abbrev=\"EXPIRED\" name=\"Message's TTL has expired. Transmition cancelled.\" id=\"5\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Status Text\" abbrev=\"text\" type=\"plaintext\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"180\" name=\"Group Membership State\" abbrev=\"GroupMembershipState\" source=\"ccu,vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Group communication link assertion.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Group Name\" abbrev=\"group_name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Name of the group of systems.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Communication Links Assertion\" abbrev=\"links\" type=\"uint32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Communication link assertion for each group member.\n");
		sb.append("        One bit to assert each system communication link state.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"181\" name=\"System Group\" abbrev=\"SystemGroup\">\n");
		sb.append("    <description>\n");
		sb.append("      Group of systems configuration.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Group Name\" abbrev=\"GroupName\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Name of the group of systems.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Group List Action\" abbrev=\"Action\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"OP\">\n");
		sb.append("      <description>\n");
		sb.append("        Actions on the group list.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Disband\" abbrev=\"Dis\"/>\n");
		sb.append("      <value id=\"1\" name=\"Set\" abbrev=\"Set\"/>\n");
		sb.append("      <value id=\"2\" name=\"Request\" abbrev=\"Req\"/>\n");
		sb.append("      <value id=\"3\" name=\"Change\" abbrev=\"Chg\"/>\n");
		sb.append("      <value id=\"4\" name=\"Report\" abbrev=\"Rep\"/>\n");
		sb.append("      <value id=\"5\" name=\"Force\" abbrev=\"Frc\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Systems Name List\" abbrev=\"GroupList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        List of names of system in the group, separated by commas.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("\n");
		sb.append("  <!-- Acoustic Networking -->\n");
		sb.append("  <message id=\"200\" name=\"LBL Range\" abbrev=\"LblRange\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      When the vehicle uses Long Base Line navigation, this message\n");
		sb.append("      notifies that a new range was received from one of the acoustics\n");
		sb.append("      transponders. The message fields are used to identify the range\n");
		sb.append("      value and the transponder name.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Beacon Identification Number\" abbrev=\"id\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Identification number of the acoustic transponder from which\n");
		sb.append("        the range information was received.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Range\" abbrev=\"range\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Distance to the acoustic transponder.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"202\" name=\"LBL Beacon Configuration\" abbrev=\"LblBeacon\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Position and configuration of an LBL transponder (beacon).\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Beacon Name\" abbrev=\"beacon\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Name/Label of the acoustic transponder.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude coordinate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude coordinate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Depth\" abbrev=\"depth\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The beacon's depth.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Interrogation channel\" abbrev=\"query_channel\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Interrogation channel.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Reply channel\" abbrev=\"reply_channel\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Reply channel.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Transponder delay\" abbrev=\"transponder_delay\" type=\"uint8_t\" unit=\"ms\">\n");
		sb.append("      <description>\n");
		sb.append("        Transponder delay.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"203\" name=\"LBL Configuration\" abbrev=\"LblConfig\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Long Base Line configuration.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"OP\">\n");
		sb.append("      <description>\n");
		sb.append("        Used to define the type of the operation this message holds.\n");
		sb.append("      </description>\n");
		sb.append("      <value abbrev=\"SET_CFG\" name=\"Set LBL Configuration\" id=\"0\">\n");
		sb.append("        <description>Set the beacons configuration aboard the vehicle.</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value abbrev=\"GET_CFG\" name=\"Retrieve LBL Configuration\" id=\"1\">\n");
		sb.append("        <description>Request the vehicle to send its current beacons configuration.</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value abbrev=\"CUR_CFG\" name=\"Reply to a GET command\" id=\"2\"></value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Beacons\" abbrev=\"beacons\" type=\"message-list\" message-type=\"LblBeacon\">\n");
		sb.append("      <description>\n");
		sb.append("        A list of LBL beacon configuration messages.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"206\" name=\"Acoustic Message\" abbrev=\"AcousticMessage\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Send an acoustic message.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Message to send\" abbrev=\"message\" type=\"message\">\n");
		sb.append("      <description>\n");
		sb.append("        Message to send.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"211\" name=\"Acoustic Operation\" abbrev=\"AcousticOperation\">\n");
		sb.append("    <description>\n");
		sb.append("      Acoustic operation.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"AOP\">\n");
		sb.append("      <description>\n");
		sb.append("        Operation type.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Abort\" abbrev=\"ABORT\">\n");
		sb.append("        <description>\n");
		sb.append("          Send an abort through the acoustic channel to the system\n");
		sb.append("          specified in the field 'system'.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Abort in Progress\" abbrev=\"ABORT_IP\">\n");
		sb.append("        <description>\n");
		sb.append("          The latest abort request to the system specified in the\n");
		sb.append("          field 'system' is in progress.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Abort Timeout\" abbrev=\"ABORT_TIMEOUT\">\n");
		sb.append("        <description>\n");
		sb.append("          The latest abort operation expired without acknowledgment\n");
		sb.append("          from the system specified in the field 'system'.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Abort Acknowledged\" abbrev=\"ABORT_ACKED\">\n");
		sb.append("        <description>\n");
		sb.append("          The latest abort operation was acknowledged by the system\n");
		sb.append("          specified in the field 'system'.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"4\" name=\"Range Request\" abbrev=\"RANGE\">\n");
		sb.append("        <description>\n");
		sb.append("          Request a range through the acoustic channel to the system\n");
		sb.append("          specified in the field 'system'.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"5\" name=\"Range in Progress\" abbrev=\"RANGE_IP\">\n");
		sb.append("        <description>\n");
		sb.append("          The latest range request to the system specified in the\n");
		sb.append("          field 'system' is in progress.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"6\" name=\"Range Timeout\" abbrev=\"RANGE_TIMEOUT\">\n");
		sb.append("        <description>\n");
		sb.append("          The latest range request operation expired without reply\n");
		sb.append("          from the system specified in the field 'system'.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"7\" name=\"Range Received\" abbrev=\"RANGE_RECVED\">\n");
		sb.append("        <description>\n");
		sb.append("          The latest range request operation to the system specified\n");
		sb.append("          in the field 'system' was successful and the range is\n");
		sb.append("          specified in the field 'range'.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"8\" name=\"Modem is Busy\" abbrev=\"BUSY\">\n");
		sb.append("        <description>\n");
		sb.append("          The acoustic modem is busy and cannot execute the requested\n");
		sb.append("          operation.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"9\" name=\"Unsupported operation\" abbrev=\"UNSUPPORTED\">\n");
		sb.append("        <description>\n");
		sb.append("          The latest requested operation is not supported.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"10\" name=\"Transducer Not Detected\" abbrev=\"NO_TXD\">\n");
		sb.append("        <description>\n");
		sb.append("          The transducer was not detected.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"11\" name=\"Send Message\" abbrev=\"MSG\">\n");
		sb.append("        <description>\n");
		sb.append("          Request message over acoustic channel. The message to send\n");
		sb.append("          is specified by the 'msg' field.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"12\" name=\"Message Send -- Queued\" abbrev=\"MSG_QUEUED\">\n");
		sb.append("        <description>\n");
		sb.append("          Message send request has been queued.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"13\" name=\"Message Send -- In progress\" abbrev=\"MSG_IP\">\n");
		sb.append("        <description>\n");
		sb.append("          Message send request is in progress.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"14\" name=\"Message Send -- Done\" abbrev=\"MSG_DONE\">\n");
		sb.append("        <description>\n");
		sb.append("          Message send request has been fulfilled.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"15\" name=\"Message Send -- Failure\" abbrev=\"MSG_FAILURE\">\n");
		sb.append("        <description>\n");
		sb.append("          Message send request could not be fulfilled.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"16\" name=\"Send Short Message\" abbrev=\"MSG_SHORT\">\n");
		sb.append("        <description>\n");
		sb.append("          Request message over acoustic channel. The message to send\n");
		sb.append("          is specified by the 'msg' field.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"System\" abbrev=\"system\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        The meaning of this field depends on the operation and is\n");
		sb.append("        explained in the operation's description.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Range\" abbrev=\"range\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The meaning of this field depends on the operation and is\n");
		sb.append("        explained in the operation's description.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Message To Send\" abbrev=\"msg\" type=\"message\">\n");
		sb.append("      <description>\n");
		sb.append("        Argument for message send ('MSG') requests.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"212\" name=\"Acoustic Systems Query\" abbrev=\"AcousticSystemsQuery\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Request a list of known underwater acoustic systems. The\n");
		sb.append("      recipient of this message shall reply with an AcousticSystems\n");
		sb.append("      message.\n");
		sb.append("    </description>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"213\" name=\"Acoustic Systems\" abbrev=\"AcousticSystems\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      This message is sent in reply to an AcousticSystemsQuery message\n");
		sb.append("      and lists all known underwater acoustic systems (modems, narrow\n");
		sb.append("      band transponders, etc).\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"System List\" abbrev=\"list\" type=\"plaintext\" unit=\"List\">\n");
		sb.append("      <description>\n");
		sb.append("        Comma separated list of known acoustic system names.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!-- Sensors -->\n");
		sb.append("  <message id=\"250\" name=\"Revolutions Per Minute\" abbrev=\"Rpm\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Number of revolutions per minute.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"int16_t\" unit=\"rpm\">\n");
		sb.append("      <description>\n");
		sb.append("        Number of revolutions per minute.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"251\" name=\"Voltage\" abbrev=\"Voltage\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of electrical voltage.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Measured Voltage Value\" abbrev=\"value\" type=\"fp32_t\" unit=\"V\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the internal electrical voltage as measured by\n");
		sb.append("        the sensor.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"252\" name=\"Current\" abbrev=\"Current\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of electrical current.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Measured Current Value\" abbrev=\"value\" type=\"fp32_t\" unit=\"A\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the internal electrical current as measured by\n");
		sb.append("        the sensor.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"253\" name=\"GPS Fix\" abbrev=\"GpsFix\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of a GPS fix.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Validity\" abbrev=\"validity\" type=\"uint16_t\" unit=\"Bitfield\" prefix=\"GFV\">\n");
		sb.append("      <description>\n");
		sb.append("        Validity of fields.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x0001\" name=\"Valid Date\" abbrev=\"VALID_DATE\">\n");
		sb.append("        <description>\n");
		sb.append("          Fields 'utc_year', 'utc_month' and 'utc_day' are valid.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x0002\" name=\"Valid Time\" abbrev=\"VALID_TIME\">\n");
		sb.append("        <description>\n");
		sb.append("          Field 'utc_time' is valid.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x0004\" name=\"Valid Position\" abbrev=\"VALID_POS\">\n");
		sb.append("        <description>\n");
		sb.append("          Fields 'lat', 'lon', 'altitude' and 'satellites' are valid.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x0008\" name=\"Valid Course Over Ground\" abbrev=\"VALID_COG\">\n");
		sb.append("        <description>\n");
		sb.append("          Field 'cog' is valid.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x0010\" name=\"Valid Speed Over Ground\" abbrev=\"VALID_SOG\">\n");
		sb.append("        <description>\n");
		sb.append("          Field 'sog' is valid.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x0020\" name=\"Valid Horizontal Accuracy Estimate\" abbrev=\"VALID_HACC\">\n");
		sb.append("        <description>\n");
		sb.append("          Field 'hacc' is valid.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x0040\" name=\"Valid Vertical Accuracy Estimate\" abbrev=\"VALID_VACC\">\n");
		sb.append("        <description>\n");
		sb.append("          Field 'vacc' is valid.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x0080\" name=\"Valid Horizontal Dilution of Precision\" abbrev=\"VALID_HDOP\">\n");
		sb.append("        <description>\n");
		sb.append("          Field 'hdop' is valid.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x0100\" name=\"Valid Vertical Dilution of Precision\" abbrev=\"VALID_VDOP\">\n");
		sb.append("        <description>\n");
		sb.append("          Field 'vdop' is valid.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Type\" abbrev=\"type\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"GFT\">\n");
		sb.append("      <description>\n");
		sb.append("        Type of fix.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x00\" name=\"Stand Alone\" abbrev=\"STANDALONE\">\n");
		sb.append("        <description>\n");
		sb.append("          Stand alone solution.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x01\" name=\"Differential\" abbrev=\"DIFFERENTIAL\">\n");
		sb.append("        <description>\n");
		sb.append("          Differential solution.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x02\" name=\"Dead Reckoning\" abbrev=\"DEAD_RECKONING\">\n");
		sb.append("        <description>\n");
		sb.append("          Dead reckoning solution.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x03\" name=\"Manual Input\" abbrev=\"MANUAL_INPUT\">\n");
		sb.append("        <description>\n");
		sb.append("          Manual solution.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x04\" name=\"Simulation\" abbrev=\"SIMULATION\">\n");
		sb.append("        <description>\n");
		sb.append("          Simulated solution.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"UTC Year\" abbrev=\"utc_year\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        UTC year.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"UTC Month\" abbrev=\"utc_month\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        UTC month.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"UTC Day\" abbrev=\"utc_day\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        UTC day.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"UTC Time of Fix\" abbrev=\"utc_time\" type=\"fp32_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        UTC time of the GPS fix measured in seconds since 00:00:00 (midnight).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude coordinate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude coordinate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Height above WGS-84 ellipsoid\" abbrev=\"height\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Height above WGS-84 ellipsoid.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Number of Satellites\" abbrev=\"satellites\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Number of satellites used by the GPS device to compute the\n");
		sb.append("        solution.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Course Over Ground\" abbrev=\"cog\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Course Over Ground (true).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Over Ground\" abbrev=\"sog\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Speed Over Ground.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Horizontal Dilution of Precision\" abbrev=\"hdop\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Horizontal dilution of precision.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Vertical Dilution of Precision\" abbrev=\"vdop\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Vertical dilution of precision.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Horizontal Accuracy Estimate\" abbrev=\"hacc\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Horizontal Accuracy Estimate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Vertical Accuracy Estimate\" abbrev=\"vacc\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Vertical Accuracy Estimate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"254\" name=\"Euler Angles\" abbrev=\"EulerAngles\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of spatial orientation according to SNAME's notation\n");
		sb.append("      (1950).\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Device Time\" abbrev=\"time\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The device time.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Roll Angle\" abbrev=\"phi\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        Rotation around the vehicle longitudinal axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Pitch Angle\" abbrev=\"theta\" type=\"fp64_t\" unit=\"rad\" min=\"-1.57079632679490\" max=\"1.57079632679490\">\n");
		sb.append("      <description>\n");
		sb.append("        Rotation around the vehicle lateral or transverse axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Yaw Angle (True)\" abbrev=\"psi\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        Rotation around the vehicle vertical axis. A value of 0 means\n");
		sb.append("        the vehicle is oriented towards true north. In cases where the\n");
		sb.append("        sensor cannot measure the true heading, this field will have\n");
		sb.append("        the same value as Yaw (Magnetic).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Yaw Angle (Magnetic)\" abbrev=\"psi_magnetic\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        Rotation around the vehicle vertical axis. A value of 0 means\n");
		sb.append("        the vehicle is oriented towards magnetic north. In cases where\n");
		sb.append("        the sensor cannot measure the magnetic heading, this field\n");
		sb.append("        will have the same value as Yaw (True).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"255\" name=\"Euler Angles Delta\" abbrev=\"EulerAnglesDelta\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Component of incremetal orientation vector over a period of time.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Device Time\" abbrev=\"time\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The device time.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X\" abbrev=\"x\" type=\"fp64_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        X component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y\" abbrev=\"y\" type=\"fp64_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Y component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z\" abbrev=\"z\" type=\"fp64_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Z component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Timestep\" abbrev=\"timestep\" type=\"fp32_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Period of time of the orientation vector increments.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"256\" name=\"Angular Velocity\" abbrev=\"AngularVelocity\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Vector quantifying the direction and magnitude of the measured\n");
		sb.append("      angular velocity that a device is exposed to.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Device Time\" abbrev=\"time\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The device time.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X\" abbrev=\"x\" type=\"fp64_t\" unit=\"rad/s\">\n");
		sb.append("      <description>\n");
		sb.append("        X component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y\" abbrev=\"y\" type=\"fp64_t\" unit=\"rad/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Y component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z\" abbrev=\"z\" type=\"fp64_t\" unit=\"rad/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Z component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"257\" name=\"Acceleration\" abbrev=\"Acceleration\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Vector quantifying the direction and magnitude of the measured\n");
		sb.append("      acceleration that a device is exposed to.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Device Time\" abbrev=\"time\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The device time.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X\" abbrev=\"x\" type=\"fp64_t\" unit=\"m/s/s\">\n");
		sb.append("      <description>\n");
		sb.append("        X component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y\" abbrev=\"y\" type=\"fp64_t\" unit=\"m/s/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Y component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z\" abbrev=\"z\" type=\"fp64_t\" unit=\"m/s/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Z component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"258\" name=\"Magnetic Field\" abbrev=\"MagneticField\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Vector quantifying the direction and magnitude of the measured\n");
		sb.append("      magnetic field that a device is exposed to.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Device Time\" abbrev=\"time\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The device time.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X\" abbrev=\"x\" type=\"fp64_t\" unit=\"G\">\n");
		sb.append("      <description>\n");
		sb.append("        X component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y\" abbrev=\"y\" type=\"fp64_t\" unit=\"G\">\n");
		sb.append("      <description>\n");
		sb.append("        Y component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z\" abbrev=\"z\" type=\"fp64_t\" unit=\"G\">\n");
		sb.append("      <description>\n");
		sb.append("        Z component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"259\" name=\"Ground Velocity\" abbrev=\"GroundVelocity\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Vector quantifying the direction and magnitude of the measured\n");
		sb.append("      velocity relative to the ground that a device is exposed to.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Validity\" abbrev=\"validity\" unit=\"Bitfield\" type=\"uint8_t\" prefix=\"VAL\">\n");
		sb.append("      <description>\n");
		sb.append("        Each bit of this field represents if a given velocity\n");
		sb.append("        component is valid.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x01\" abbrev=\"VEL_X\" name=\"X component is valid\"/>\n");
		sb.append("      <value id=\"0x02\" abbrev=\"VEL_Y\" name=\"Y component is valid\"/>\n");
		sb.append("      <value id=\"0x04\" abbrev=\"VEL_Z\" name=\"Z component is valid\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X\" abbrev=\"x\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        X component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y\" abbrev=\"y\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Y component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z\" abbrev=\"z\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Z component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"260\" name=\"Water Velocity\" abbrev=\"WaterVelocity\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Vector quantifying the direction and magnitude of the measured\n");
		sb.append("      velocity relative to the water that a device is exposed to.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Validity\" abbrev=\"validity\" unit=\"Bitfield\" type=\"uint8_t\" prefix=\"VAL\">\n");
		sb.append("      <description>\n");
		sb.append("        Each bit of this field represents if a given velocity\n");
		sb.append("        component is valid.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x01\" abbrev=\"VEL_X\" name=\"X component is valid\"/>\n");
		sb.append("      <value id=\"0x02\" abbrev=\"VEL_Y\" name=\"Y component is valid\"/>\n");
		sb.append("      <value id=\"0x04\" abbrev=\"VEL_Z\" name=\"Z component is valid\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X\" abbrev=\"x\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        X component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y\" abbrev=\"y\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Y component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z\" abbrev=\"z\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Z component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"261\" name=\"Velocity Delta\" abbrev=\"VelocityDelta\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Component of incremetal velocity vector.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Device Time\" abbrev=\"time\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The device time.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X\" abbrev=\"x\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        X component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y\" abbrev=\"y\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Y component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z\" abbrev=\"z\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Z component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"262\" name=\"Distance\" abbrev=\"Distance\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Distance measurement detected by the device.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Validity\" abbrev=\"validity\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"DV\">\n");
		sb.append("      <description>\n");
		sb.append("        Validity of the measurement.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Invalid\" abbrev=\"INVALID\">\n");
		sb.append("        <description>\n");
		sb.append("          Measurement is invalid.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Valid\" abbrev=\"VALID\">\n");
		sb.append("        <description>\n");
		sb.append("          Measurement is valid.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Location\" abbrev=\"location\" type=\"message-list\" message-type=\"DeviceState\">\n");
		sb.append("      <description>\n");
		sb.append("        Device Location in the system.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Beam Configuration\" abbrev=\"beam_config\" type=\"message-list\" message-type=\"BeamConfig\">\n");
		sb.append("      <description>\n");
		sb.append("        Beam configuration of the device.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Measured Distance\" abbrev=\"value\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Measured distance.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"263\" name=\"Temperature\" abbrev=\"Temperature\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of temperature.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Measured Temperature\" abbrev=\"value\" type=\"fp32_t\" unit=\"\u00B0C\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the temperature as measured by the sensor.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"264\" name=\"Pressure\" abbrev=\"Pressure\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of external pressure.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Measured Pressure\" abbrev=\"value\" type=\"fp64_t\" unit=\"hPa\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the pressure as measured by the sensor.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"265\" name=\"Depth\" abbrev=\"Depth\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Depth report.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Measured Depth\" abbrev=\"value\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Depth value measured by a sensor.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"266\" name=\"Depth Offset\" abbrev=\"DepthOffset\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of Depth Offset.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Measured Offset\" abbrev=\"value\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Depth offset.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"267\" name=\"Sound Speed\" abbrev=\"SoundSpeed\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Sound Speed report.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Computed Sound Speed\" abbrev=\"value\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Estimated sound speed. Negative values denote invalid estimates.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"268\" name=\"Water Density\" abbrev=\"WaterDensity\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Water Density report.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Computed Water Density\" abbrev=\"value\" type=\"fp32_t\" unit=\"kg/m/m/m\">\n");
		sb.append("      <description>\n");
		sb.append("        Computed Water Density.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"269\" name=\"Conductivity\" abbrev=\"Conductivity\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of conductivity.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Measured Conductivity\" abbrev=\"value\" type=\"fp32_t\" unit=\"S/m\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the conductivity as measured by the sensor.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"270\" name=\"Salinity\" abbrev=\"Salinity\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of salinity.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Measured Salinity\" abbrev=\"value\" type=\"fp32_t\" unit=\"PSU\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the salinity as measured by the sensor.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"271\" name=\"Wind Speed\" abbrev=\"WindSpeed\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Measurement of wind speed.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Direction\" abbrev=\"direction\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Direction of the measured wind speed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the wind speed as measured by the sensor.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Turbulence\" abbrev=\"turbulence\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Wind turbulence intensity.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"272\" name=\"Relative Humidity\" abbrev=\"RelativeHumidity\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Measurement of relative humidity.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Relative Humidity Value\" abbrev=\"value\" type=\"fp32_t\" min=\"0\" max=\"100\">\n");
		sb.append("      <description>\n");
		sb.append("        Value of relative humidity.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"273\" name=\"Device Data (Text)\" abbrev=\"DevDataText\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Verbatim representation of device data in plain text format.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Plain text data as extracted directly from the device.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"274\" name=\"Device Data (Binary)\" abbrev=\"DevDataBinary\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Verbatim representation of device data in binary format.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"rawdata\">\n");
		sb.append("      <description>\n");
		sb.append("        Raw binary data as extracted directly from the device.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"276\" name=\"Sonar Data\" abbrev=\"SonarData\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      This message contains the data acquired by a single sonar\n");
		sb.append("      measurement.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Type\" abbrev=\"type\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"ST\">\n");
		sb.append("      <description>\n");
		sb.append("        Type of sonar.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Sidescan\" abbrev=\"SIDESCAN\"/>\n");
		sb.append("      <value id=\"1\" name=\"Echo Sounder\" abbrev=\"ECHOSOUNDER\"/>\n");
		sb.append("      <value id=\"2\" name=\"Multibeam\" abbrev=\"MULTIBEAM\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Frequency\" abbrev=\"frequency\" type=\"uint32_t\" unit=\"Hz\">\n");
		sb.append("      <description>\n");
		sb.append("        Operating frequency.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Minimum Range\" abbrev=\"min_range\" type=\"uint16_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Minimum range.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maximum Range\" abbrev=\"max_range\" type=\"uint16_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Maximum range.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Bits Per Data Point\" abbrev=\"bits_per_point\" type=\"uint8_t\" unit=\"bit\">\n");
		sb.append("      <description>\n");
		sb.append("        Size of the data unit.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Scaling Factor\" abbrev=\"scale_factor\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Scaling factor used to multiply each data unit to restore the\n");
		sb.append("        original floating point value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Beam Configuration\" abbrev=\"beam_config\" type=\"message-list\" message-type=\"BeamConfig\">\n");
		sb.append("      <description>\n");
		sb.append("        Beam configuration of the device.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Data\" abbrev=\"data\" type=\"rawdata\">\n");
		sb.append("      <description>\n");
		sb.append("        Data acquired by the measurement.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"277\" name=\"Pulse\" abbrev=\"Pulse\" source=\"vehicle,ccu\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Hardware pulse detection.\n");
		sb.append("    </description>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"278\" name=\"Pulse Detection Control\" abbrev=\"PulseDetectionControl\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Control of hardware pulse detection.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" type=\"uint8_t\" prefix=\"POP\" unit=\"Enumerated\">\n");
		sb.append("      <description>\n");
		sb.append("        Activate or deactivate hardware pulse detection.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" abbrev=\"OFF\" name=\"Pulse Detection OFF\"/>\n");
		sb.append("      <value id=\"1\" abbrev=\"ON\" name=\"Pulse Detection ON\"/>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"279\" name=\"Fuel Level\" abbrev=\"FuelLevel\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of fuel level.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp32_t\" unit=\"%\" min=\"0\" max=\"100\">\n");
		sb.append("      <description>\n");
		sb.append("        Fuel level percentage of the system.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Confidence Level\" abbrev=\"confidence\" type=\"fp32_t\" unit=\"%\" min=\"0\" max=\"100\">\n");
		sb.append("      <description>\n");
		sb.append("        Percentage level of confidence in the estimation of the amount\n");
		sb.append("        of energy in the batteries.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Operation Modes\" abbrev=\"opmodes\" type=\"plaintext\" unit=\"TupleList\">\n");
		sb.append("      <description>\n");
		sb.append("        Operation mode name and the estimated time available in that\n");
		sb.append("        mode in hours. Example: \"Motion=1.5\"\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"280\" name=\"GPS Navigation Data\" abbrev=\"GpsNavData\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of GPS navigation data.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"GPS Millisecond Time of Week\" abbrev=\"itow\" type=\"uint32_t\" unit=\"ms\">\n");
		sb.append("      <description>\n");
		sb.append("        GPS Millisecond Time of Week.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Latitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Longitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Height above ellipsoid\" abbrev=\"height_ell\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Height Above Ellipsoid.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Height above sea level\" abbrev=\"height_sea\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Height Above Sea Level.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Horizontal Accuracy Estimate\" abbrev=\"hacc\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Horizontal Accuracy Estimate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Vertical Accuracy Estimate\" abbrev=\"vacc\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Vertical Accuracy Estimate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"NED North Velocity\" abbrev=\"vel_n\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        NED North Velocity.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"NED East Velocity\" abbrev=\"vel_e\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        NED East Velocity.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"NED Down Velocity\" abbrev=\"vel_d\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        NED Down Velocity.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed (3D)\" abbrev=\"speed\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        NED Down Velocity.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Ground Speed (2D)\" abbrev=\"gspeed\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        NED Down Velocity.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Heading (2D)\" abbrev=\"heading\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        NED Down Velocity.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Accuracy Estimate\" abbrev=\"sacc\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        NED Down Velocity.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Course / Heading Accuracy Estimate\" abbrev=\"cacc\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Course / Heading Accuracy Estimate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"281\" name=\"Servo Position\" abbrev=\"ServoPosition\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Actual position of a servo.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Identifier\" abbrev=\"id\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Servo identifier.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Position\" abbrev=\"value\" type=\"fp32_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        Value of the servo position.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"282\" name=\"Device State\" abbrev=\"DeviceState\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Location of a specific device in the system infrastructure.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Device Position - X\" abbrev=\"x\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Device's position over the X axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Device Position - Y\" abbrev=\"y\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Device's position over the Y axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Device Position - Z\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Device's position over the Z axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Device Rotation - X\" abbrev=\"phi\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Device's rotation over the X axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Device Rotation - Y\" abbrev=\"theta\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Device's rotation over the Y axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Device Rotation - Z\" abbrev=\"psi\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Device's rotation over the Z axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"283\" name=\"Beam Configuration\" abbrev=\"BeamConfig\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Beam configuration of the device.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Beam Width\" abbrev=\"beam_width\" type=\"fp32_t\" unit=\"rad\" min=\"0\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        Beam width of the instrument. A negative number denotes that\n");
		sb.append("        this information is not available or is not applicable.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Beam Height\" abbrev=\"beam_height\" type=\"fp32_t\" unit=\"rad\" min=\"0\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        Beam height of the instrument. A negative number denotes that\n");
		sb.append("        this information is not available or is not applicable.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"284\" name=\"Data Sanity\" abbrev=\"DataSanity\">\n");
		sb.append("    <description>\n");
		sb.append("      Report sanity or lack of it in the data output by a sensor.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Sanity\" abbrev=\"sane\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"DS\">\n");
		sb.append("      <description>\n");
		sb.append("        Whether the data is sane or not sane.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" abbrev=\"SANE\" name=\"Sane\">\n");
		sb.append("        <description>\n");
		sb.append("          Data is sane.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" abbrev=\"NOT_SANE\" name=\"Not Sane\">\n");
		sb.append("        <description>\n");
		sb.append("          Data is not sane.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"285\" name=\"Rhodamine Dye\" abbrev=\"RhodamineDye\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Rhodamine Dye measurement.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp32_t\" unit=\"PPB\">\n");
		sb.append("      <description>\n");
		sb.append("        Amount of rhodamine dye detected.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"286\" name=\"Crude Oil\" abbrev=\"CrudeOil\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Crude oil measurement.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp32_t\" unit=\"PPB\">\n");
		sb.append("      <description>\n");
		sb.append("        Amount of crude oil detected.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"287\" name=\"Fine Oil\" abbrev=\"FineOil\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      Fine oil measurement.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp32_t\" unit=\"PPB\">\n");
		sb.append("      <description>\n");
		sb.append("        Amount of fine oil detected.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("\n");
		sb.append("  <!-- Actuation -->\n");
		sb.append("  <message id=\"300\" name=\"Camera Zoom\" abbrev=\"CameraZoom\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Camera Zoom.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Camera Number\" abbrev=\"id\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The identification number of the destination camera.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Absolute Zoom Level\" abbrev=\"zoom\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Absolute zoom level.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Action\" abbrev=\"action\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"ACTION\">\n");
		sb.append("      <description>\n");
		sb.append("        The zoom action to perform.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Reset Zoom\" abbrev=\"ZOOM_RESET\"/>\n");
		sb.append("      <value id=\"1\" name=\"Zoom In\" abbrev=\"ZOOM_IN\"/>\n");
		sb.append("      <value id=\"2\" name=\"Zoom Out\" abbrev=\"ZOOM_OUT\"/>\n");
		sb.append("      <value id=\"3\" name=\"Stop Zooming\" abbrev=\"ZOOM_STOP\"/>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"301\" name=\"Set Thruster Actuation\" abbrev=\"SetThrusterActuation\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Actuate directly on a thruster.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Thruster Number\" abbrev=\"id\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The identification number of the destination thruster.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Actuation Value\" abbrev=\"value\" type=\"fp32_t\" min=\"-1\" max=\"1\">\n");
		sb.append("      <description>\n");
		sb.append("        Actuation magnitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"302\" name=\"Set Servo Position\" abbrev=\"SetServoPosition\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Set the position of a servo.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Identifier\" abbrev=\"id\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The identification number of the destination servo.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Position\" abbrev=\"value\" type=\"fp32_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        Actuation magnitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"303\" name=\"Set Control Surface Deflection\" abbrev=\"SetControlSurfaceDeflection\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Set the deflection angle of a control surface.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Identifier\" abbrev=\"id\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The identification number of the destination control surface.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Angle\" abbrev=\"angle\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Actuation magnitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"304\" name=\"Remote Actions Request\" abbrev=\"RemoteActionsRequest\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      This message is used as query to request for the possible remote\n");
		sb.append("      actions (operation=QUERY and the list is empty in this\n");
		sb.append("      case). The vehicle responds using the same message type\n");
		sb.append("      returning the tuplelist with the pairs: Action,Type\n");
		sb.append("      (operation=REPORT). The type of action can be Axis, Hat or\n");
		sb.append("      Button.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"OP\">\n");
		sb.append("      <description>\n");
		sb.append("        Operation to perform.\n");
		sb.append("      </description>\n");
		sb.append("      <value abbrev=\"REPORT\" name=\"Report\" id=\"0\"/>\n");
		sb.append("      <value abbrev=\"QUERY\" name=\"Query\" id=\"1\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Actions\" abbrev=\"actions\" type=\"plaintext\" unit=\"TupleList\">\n");
		sb.append("      <description>\n");
		sb.append("        Example: \"Propulsion=Axis,PanTilt=Hat,Lights=Button\"\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"305\" name=\"Remote Actions\" abbrev=\"RemoteActions\" source=\"ccu\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      This message is used to send a periodic update of values for\n");
		sb.append("      each remote action. If the action is not on the list the assumed\n");
		sb.append("      value is 0.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Actions\" abbrev=\"actions\" type=\"plaintext\" unit=\"TupleList\">\n");
		sb.append("      <description>\n");
		sb.append("        List of values for each remote action (e.g: \"Propeler=0.6,PanTilt=0.75,Lights=1\").\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"306\" name=\"Button Event\" abbrev=\"ButtonEvent\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Event of a specific hardware button.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Button\" abbrev=\"button\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Button identifier.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Value of the button.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"307\" name=\"LCD Control\" abbrev=\"LcdControl\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Control LCD.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"OP\">\n");
		sb.append("      <description>\n");
		sb.append("        The LCD action to perform\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Turn off display\" abbrev=\"TURN_OFF\"/>\n");
		sb.append("      <value id=\"1\" name=\"Turn on display\" abbrev=\"TURN_ON\"/>\n");
		sb.append("      <value id=\"2\" name=\"Clear display\" abbrev=\"CLEAR\"/>\n");
		sb.append("      <value id=\"3\" name=\"Write Line #0\" abbrev=\"WRITE0\"/>\n");
		sb.append("      <value id=\"4\" name=\"Write Line #1\" abbrev=\"WRITE1\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Text\" abbrev=\"text\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Text to be written (if defined write operation).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"308\" name=\"Power Operation\" abbrev=\"PowerOperation\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      This message allows controlling the system's power lines.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"POP\">\n");
		sb.append("      <description>\n");
		sb.append("        Operation type.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Power Down\" abbrev=\"PWR_DOWN\">\n");
		sb.append("        <description>\n");
		sb.append("          Request the destination entity of this message to power down\n");
		sb.append("          it's devices immediately. If the destination entity is the\n");
		sb.append("          special entity '0' the whole system will power down.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Power Down in Progress\" abbrev=\"PWR_DOWN_IP\">\n");
		sb.append("        <description>\n");
		sb.append("          The latest power down request is in progress and the time\n");
		sb.append("          remaining until power down is given in field 'time_remain'.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Power Down Aborted\" abbrev=\"PWR_DOWN_ABORTED\">\n");
		sb.append("        <description>\n");
		sb.append("          The latest power down request was aborted.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Schedule Power Down\" abbrev=\"SCHED_PWR_DOWN\">\n");
		sb.append("        <description>\n");
		sb.append("          Request the destination entity of this message to power down\n");
		sb.append("          it's devices at the time given in the field 'sched_time'. If\n");
		sb.append("          the destination entity is the special entity '0' the whole\n");
		sb.append("          system will power down.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"4\" name=\"Power Up\" abbrev=\"PWR_UP\">\n");
		sb.append("        <description>\n");
		sb.append("          Request the destination entity of this message to power up\n");
		sb.append("          it's devices.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"5\" name=\"Power Up in Progress\" abbrev=\"PWR_UP_IP\">\n");
		sb.append("        <description>\n");
		sb.append("          The latest power up request is in progress.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"6\" name=\"Schedule Power Up\" abbrev=\"SCHED_PWR_UP\">\n");
		sb.append("        <description>\n");
		sb.append("          Request the destination entity of this message to power up\n");
		sb.append("          it's devices at the time given in the field 'sched_time'. If\n");
		sb.append("          the destination entity is the special entity '0' the whole\n");
		sb.append("          system will power up.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Time Remaining\" abbrev=\"time_remain\" type=\"fp32_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Time remaining to complete operation.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Scheduled Time\" abbrev=\"sched_time\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Scheduled time of operation.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"309\" name=\"Power Channel Control\" abbrev=\"PowerChannelControl\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      This message allows controlling power channels.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Channel Name\" abbrev=\"name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        The name of the power channel.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" min=\"0\" max=\"6\" prefix=\"PCC_OP\">\n");
		sb.append("      <description>\n");
		sb.append("        Operation to perform.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Turn Off\" abbrev=\"TURN_OFF\">\n");
		sb.append("        <description>\n");
		sb.append("          Turn off power channel specified in field 'id'.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Turn On\" abbrev=\"TURN_ON\">\n");
		sb.append("        <description>\n");
		sb.append("          Turn on power channel specified in field 'id'.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Toggle\" abbrev=\"TOGGLE\">\n");
		sb.append("        <description>\n");
		sb.append("          Toggle power channel specified in field 'id'.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Schedule Turn On\" abbrev=\"SCHED_ON\">\n");
		sb.append("        <description>\n");
		sb.append("          Turn on power channel specified in field 'id' in\n");
		sb.append("          'sched_time' seconds.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"4\" name=\"Schedule Turn Off\" abbrev=\"SCHED_OFF\">\n");
		sb.append("        <description>\n");
		sb.append("          Turn off power channel specified in field 'id' in\n");
		sb.append("          'sched_time' seconds.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"5\" name=\"Reset Schedules\" abbrev=\"SCHED_RESET\">\n");
		sb.append("        <description>\n");
		sb.append("          Reset all scheduled operations for the channel specified in\n");
		sb.append("          field 'id'.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"6\" name=\"Save Current State\" abbrev=\"SAVE\">\n");
		sb.append("        <description>\n");
		sb.append("          Save the current state of the channel 'id' to persistent\n");
		sb.append("          storage.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Scheduled Time\" abbrev=\"sched_time\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Scheduled time of operation.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"310\" name=\"Query Power Channel State\" abbrev=\"QueryPowerChannelState\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Request the state of power channels.\n");
		sb.append("    </description>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"311\" name=\"Power Channel State\" abbrev=\"PowerChannelState\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Message conveying the state of a power channel.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Name\" abbrev=\"name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Power Channel Name.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"State\" abbrev=\"state\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"PCS\">\n");
		sb.append("      <description>\n");
		sb.append("        State of the Power Channel.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Off\" abbrev=\"OFF\">\n");
		sb.append("        <description>\n");
		sb.append("          Power channel is off.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"On\" abbrev=\"ON\">\n");
		sb.append("        <description>\n");
		sb.append("          Power channel is on.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"312\" name=\"LED Brightness\" abbrev=\"LedBrightness\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Brightness value of an LED (Light-Emitting Diode).\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Name\" abbrev=\"name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        LED name.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Brightness value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"313\" name=\"Query LED Brightness\" abbrev=\"QueryLedBrightness\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Query the brightness of an LED (Light-Emitting Diode). The\n");
		sb.append("      recipient of this message shall reply with 'LedBrightness'.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Name\" abbrev=\"name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        LED name.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"314\" name=\"Set LED Brightness\" abbrev=\"SetLedBrightness\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Control the brightness of an LED (Light-Emitting Diode). The\n");
		sb.append("      recipient of this message shall set the intensity of the LED to\n");
		sb.append("      the desired 'value' and reply with 'LedBrightness'.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Name\" abbrev=\"name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        LED name.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired brightness value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"315\" name=\"Set PWM\" abbrev=\"SetPWM\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Set properties of a PWM signal channel.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Channel Identifier\" abbrev=\"id\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        PWM channel identifier.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Period\" abbrev=\"period\" type=\"uint32_t\" unit=\"\u00B5s\">\n");
		sb.append("      <description>\n");
		sb.append("        The total period of the PWM signal (sum of active and inactive\n");
		sb.append("        time of the PWM).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Duty Cycle\" abbrev=\"duty_cycle\" type=\"uint32_t\" unit=\"\u00B5s\">\n");
		sb.append("      <description>\n");
		sb.append("        The active time of the PWM signal. The duty cycle value must\n");
		sb.append("        be less or equal to the period.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"316\" name=\"PWM\" abbrev=\"PWM\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Properties of a PWM signal channel.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Channel Identifier\" abbrev=\"id\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        PWM channel identifier.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Period\" abbrev=\"period\" type=\"uint32_t\" unit=\"\u00B5s\">\n");
		sb.append("      <description>\n");
		sb.append("        The total period of the PWM signal (sum of active and inactive\n");
		sb.append("        time of the PWM).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Duty Cycle\" abbrev=\"duty_cycle\" type=\"uint32_t\" unit=\"\u00B5s\">\n");
		sb.append("      <description>\n");
		sb.append("        The active time of the PWM signal. The duty cycle value is\n");
		sb.append("        less or equal to the period.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!-- Navigation -->\n");
		sb.append("  <message id=\"350\" name=\"Estimated State\" abbrev=\"EstimatedState\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      This message presents the estimated state of the vehicle.\n");
		sb.append("\n");
		sb.append("      EstimatedState is a complete description of the system\n");
		sb.append("      in terms of parameters such as position, orientation and\n");
		sb.append("      velocities at a particular moment in time.\n");
		sb.append("\n");
		sb.append("      The system position is given by a North-East-Down (NED)\n");
		sb.append("      local tangent plane displacement (x, y, z) relative to\n");
		sb.append("      an absolute WGS-84 coordinate (latitude, longitude,\n");
		sb.append("      height above ellipsoid).\n");
		sb.append("\n");
		sb.append("      The symbols for position and attitude as well as linear and\n");
		sb.append("      angular velocities were chosen according to SNAME's notation (1950).\n");
		sb.append("      The body-fixed reference frame and Euler angles are depicted\n");
		sb.append("      next:\n");
		sb.append("\n");
		sb.append("      .. figure:: ../images/euler-lauv.png\n");
		sb.append("\n");
		sb.append("      :align:  center\n");
		sb.append("\n");
		sb.append("      Euler angles\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Latitude (WGS-84)\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude (WGS-84)\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Height (WGS-84)\" abbrev=\"height\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Height above the WGS-84 ellipsoid.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Offset north\" abbrev=\"x\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The North offset of the North/East/Down field with respect to\n");
		sb.append("        LLH.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Offset east\" abbrev=\"y\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The East offset of the North/East/Down field with respect to\n");
		sb.append("        LLH.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Offset down\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The Down offset of the North/East/Down field with respect to\n");
		sb.append("        LLH.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Rotation over x axis\" abbrev=\"phi\" type=\"fp32_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The phi Euler angle from the vehicle's attitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Rotation over y axis\" abbrev=\"theta\" type=\"fp32_t\" unit=\"rad\" min=\"-1.57079632679490\" max=\"1.57079632679490\">\n");
		sb.append("      <description>\n");
		sb.append("        The theta Euler angle from the vehicle's attitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Rotation over z axis\" abbrev=\"psi\" type=\"fp32_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The psi Euler angle from the vehicle's attitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Body-Fixed xx Velocity\" abbrev=\"u\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Body-fixed frame xx axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Body-Fixed yy Velocity\" abbrev=\"v\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Body-fixed frame yy axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Body-Fixed zz Velocity\" abbrev=\"w\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Body-fixed frame zz axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Ground Velocity X (North)\" abbrev=\"vx\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Ground Velocity xx axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Ground Velocity Y (East)\" abbrev=\"vy\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Ground Velocity yy axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Ground Velocity Z (Down)\" abbrev=\"vz\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Ground Velocity zz axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Angular Velocity in x\" abbrev=\"p\" type=\"fp32_t\" unit=\"rad/s\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The angular velocity over body-fixed xx axis (roll).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Angular Velocity in y\" abbrev=\"q\" type=\"fp32_t\" unit=\"rad/s\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The angular velocity over body-fixed yy axis (pitch).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Angular Velocity in z\" abbrev=\"r\" type=\"fp32_t\" unit=\"rad/s\"  min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The angular velocity over body-fixed zz axis (yaw).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Depth\" abbrev=\"depth\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Depth, in meters. To be used by underwater vehicles. Negative\n");
		sb.append("        values denote invalid estimates.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Altitude\" abbrev=\"alt\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Altitude, in meters. Negative values denote invalid estimates.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"351\" name=\"Estimated Stream Velocity\" abbrev=\"EstimatedStreamVelocity\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      The estimated stream velocity, typically for water or air\n");
		sb.append("      streams.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"X component (North)\" abbrev=\"x\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        X component (North).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y component (East)\" abbrev=\"y\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Y component (East).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z component (Down)\" abbrev=\"z\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Z component (Down).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"352\" name=\"Indicated Speed\" abbrev=\"IndicatedSpeed\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Speed measured by the navigation filter.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Measured speed\" abbrev=\"value\" unit=\"m/s\" type=\"fp64_t\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"353\" name=\"True Speed\" abbrev=\"TrueSpeed\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Ground true speed.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Estimated value\" abbrev=\"value\" unit=\"m/s\" type=\"fp64_t\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"354\" name=\"Navigation Uncertainty\" abbrev=\"NavigationUncertainty\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of navigation uncertainty.\n");
		sb.append("      This is usually given by the output of the state\n");
		sb.append("      covariance matrix of an Extended Kalman Filter.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Variance - x Position\" abbrev=\"x\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>The North offset variance of the North/East/Down\n");
		sb.append("      field with respect to LLH.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - y Position\" abbrev=\"y\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>The East offset variance of the North/East/Down\n");
		sb.append("      field with respect to LLH.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - z Position\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>The Down offset variance of the North/East/Down\n");
		sb.append("      field with respect to LLH.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - Roll\" abbrev=\"phi\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        The phi Euler angle variance from the vehicle's attitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - Pitch\" abbrev=\"theta\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        The theta Euler angle variance from the vehicle's attitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - Yaw\" abbrev=\"psi\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        The psi Euler angle variance from the vehicle's attitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - Gyro. Roll Rate\" abbrev=\"p\" type=\"fp32_t\" unit=\"rad/s\">\n");
		sb.append("      <description>\n");
		sb.append("        The angular velocity variance over body-fixed xx axis (roll).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - Gyro. Pitch Rate\" abbrev=\"q\" type=\"fp32_t\" unit=\"rad/s\">\n");
		sb.append("      <description>\n");
		sb.append("        The angular velocity variance over body-fixed yy axis (pitch).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - Gyro. Yaw Rate\" abbrev=\"r\" type=\"fp32_t\" unit=\"rad/s\">\n");
		sb.append("      <description>\n");
		sb.append("        The angular velocity variance over body-fixed zz axis (yaw).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - Body-Fixed xx Velocity\" abbrev=\"u\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Body-fixed frame xx axis velocity variance component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - Body-Fixed yy Velocity\" abbrev=\"v\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Body-fixed frame yy axis velocity variance component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - Body-Fixed ww Velocity\" abbrev=\"w\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Body-fixed frame zz axis velocity variance component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - Yaw Bias\" abbrev=\"bias_psi\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        The psi Euler angle bias variance from the vehicle's sensed attitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - Gyro. Yaw Rate Bias\" abbrev=\"bias_r\" type=\"fp32_t\" unit=\"rad/s\">\n");
		sb.append("      <description>\n");
		sb.append("        The angular velocity over body-fixed zz axis bias variance from sensor.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"355\" name=\"Navigation Data\" abbrev=\"NavigationData\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of navigation data.\n");
		sb.append("      This is constituted by data which is not\n");
		sb.append("      part of the vehicle estimated state but\n");
		sb.append("      that the user may refer for more information.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Yaw Bias\" abbrev=\"bias_psi\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        The psi Euler angle bias from the vehicle's sensed attitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Gyro. Yaw Rate Bias\" abbrev=\"bias_r\" type=\"fp32_t\" unit=\"rad/s\">\n");
		sb.append("      <description>\n");
		sb.append("        The angular velocity over body-fixed zz axis bias from sensor.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Course Over Ground\" abbrev=\"cog\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Course over ground given by NED ground velocity vectors.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Continuous Yaw\" abbrev=\"cyaw\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Continuous psi Euler angle (without normalizations).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"GPS Rejection Filter Level\" abbrev=\"lbl_rej_level\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        GPS rejection filter level.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"LBL Rejection Filter Level\" abbrev=\"gps_rej_level\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        LBL rejection filter level.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - Custom Variable X\" abbrev=\"custom_x\" type=\"fp32_t\">\n");
		sb.append("      <description>Custom variable.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - Custom Variable Y\" abbrev=\"custom_y\" type=\"fp32_t\">\n");
		sb.append("      <description>Custom variable.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Variance - Custom Variable Z\" abbrev=\"custom_z\" type=\"fp32_t\">\n");
		sb.append("      <description>Custom variable.</description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"356\" name=\"GPS Fix Rejection\" abbrev=\"GpsFixRejection\" source=\"vehicle\">\n");
		sb.append("    <field name=\"UTC Time of Fix\" abbrev=\"utc_time\" type=\"fp32_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        UTC time of the rejected GPS fix measured in seconds since\n");
		sb.append("        00:00:00 (midnight).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Reason\" abbrev=\"reason\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"RR\">\n");
		sb.append("      <description>\n");
		sb.append("        Reason for rejection.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Above Threshold\" abbrev=\"ABOVE_THRESHOLD\">\n");
		sb.append("        <description>\n");
		sb.append("          New GPS Fix position is above a computed threshold.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Invalid Fix\" abbrev=\"INVALID\">\n");
		sb.append("        <description>\n");
		sb.append("          Invalid measurement.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Above Maximum HDOP\" abbrev=\"ABOVE_MAX_HDOP\">\n");
		sb.append("        <description>\n");
		sb.append("          Above maximum horizontal dilution of precision.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Above Maximum HACC\" abbrev=\"ABOVE_MAX_HACC\">\n");
		sb.append("        <description>\n");
		sb.append("          Above maximum horizontal accuracy index.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"4\" name=\"Lost Validity Bit\" abbrev=\"LOST_VAL_BIT\">\n");
		sb.append("        <description>\n");
		sb.append("          Lost one of the validity bits between consecutive GPS fixes.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"357\" name=\"LBL Range Acceptance\" abbrev=\"LblRangeAcceptance\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      When the vehicle uses Long Base Line navigation, this message\n");
		sb.append("      notifies that a new range was received from one of the acoustics\n");
		sb.append("      transponders. The message fields are used to identify the range\n");
		sb.append("      value and the transponder name. Also, this message has an\n");
		sb.append("      acceptance field that indicates whether a LBL range was accepted\n");
		sb.append("      or rejected, and if rejected, the reason why.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Beacon Identification Number\" abbrev=\"id\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Identification number of the acoustic transponder from which\n");
		sb.append("        the range information was received.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Range\" abbrev=\"range\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Distance to the acoustic transponder.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Acceptance\" abbrev=\"acceptance\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"RR\">\n");
		sb.append("      <description>\n");
		sb.append("        Reason for acceptance/rejection.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Accepted\" abbrev=\"ACCEPTED\">\n");
		sb.append("        <description>\n");
		sb.append("          This LBL range is accepted by the navigation filter.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Rejected - Above Threshold\" abbrev=\"ABOVE_THRESHOLD\">\n");
		sb.append("        <description>\n");
		sb.append("          New LBL Range is above a computed threshold.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Rejected - Singular Point\" abbrev=\"SINGULAR\">\n");
		sb.append("        <description>\n");
		sb.append("          Singular point.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Rejected - Not Enough Information\" abbrev=\"NO_INFO\">\n");
		sb.append("        <description>\n");
		sb.append("          The filter lacks information to properly use the received LBL range.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"4\" name=\"Rejected - Vehicle At Surface\" abbrev=\"AT_SURFACE\">\n");
		sb.append("        <description>\n");
		sb.append("          Vehicle is using only GPS fix when it is at surface.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"358\" name=\"DVL Rejection\" abbrev=\"DvlRejection\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      When the vehicle uses Doppler Velocity Log sensor, this message\n");
		sb.append("      notifies that a new measurement was locally rejected by the\n");
		sb.append("      navigation filter.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Type of velocity\" abbrev=\"type\" unit=\"Bitfield\" type=\"uint8_t\" prefix=\"TYPE\">\n");
		sb.append("      <description>\n");
		sb.append("        This field represents the type of the rejected velocity.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x01\" abbrev=\"GV\" name=\"Ground velocity\"/>\n");
		sb.append("      <value id=\"0x02\" abbrev=\"WV\" name=\"Water velocity\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Reason\" abbrev=\"reason\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"RR\">\n");
		sb.append("      <description>\n");
		sb.append("        Reason for rejection. There are two types of DVL measurement\n");
		sb.append("        filters. An Innovation filter checks the innovation between\n");
		sb.append("        the current measurement and the previous measurement within a\n");
		sb.append("        certain amount of time and an Absolute filter compares the\n");
		sb.append("        measurement with an absolute threshold value. Those filters\n");
		sb.append("        are tested using horizontal speed measurements, i.e.,\n");
		sb.append("        measurements in the x-axis and in the y-axis.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Innovation Threshold - X\" abbrev=\"INNOV_THRESHOLD_X\">\n");
		sb.append("        <description>\n");
		sb.append("          The current DVL x-axis measurement is discarded\n");
		sb.append("          because the absolute difference between the\n");
		sb.append("          value and the previous accepted DVL measurement\n");
		sb.append("          with a given time window is above a configurable\n");
		sb.append("          threshold.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Innovation Threshold - Y\" abbrev=\"INNOV_THRESHOLD_Y\">\n");
		sb.append("        <description>\n");
		sb.append("          The current DVL y-axis measurement is discarded\n");
		sb.append("          because the absolute difference between the\n");
		sb.append("          value and the previous accepted DVL measurement\n");
		sb.append("          with a given time window is above a configurable\n");
		sb.append("          threshold.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Absolute Threshold - X\" abbrev=\"ABS_THRESHOLD_X\">\n");
		sb.append("        <description>\n");
		sb.append("          The current DVL x-axis measurement is discarded\n");
		sb.append("          because the the absolute value is above a\n");
		sb.append("          configurable threshold.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Absolute Threshold - Y\" abbrev=\"ABS_THRESHOLD_Y\">\n");
		sb.append("        <description>\n");
		sb.append("          The current DVL y-axis measurement is discarded\n");
		sb.append("          because the the absolute value is above a\n");
		sb.append("          configurable threshold.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Value of the rejection.\n");
		sb.append("        If it is an innovation rejection the value is\n");
		sb.append("        the absolute difference between the previous\n");
		sb.append("        accepted DVL measurement and the current one.\n");
		sb.append("        If it is an absolute rejection the value is\n");
		sb.append("        the current DVL measurement.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Timestep\" abbrev=\"timestep\" type=\"fp32_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Timestep of the rejection.\n");
		sb.append("        The timestep is 0 for an absolute rejection\n");
		sb.append("        since it is an instantaneous reading. For\n");
		sb.append("        innovation rejection it is the time difference\n");
		sb.append("        between the previous accepted DVL measurement\n");
		sb.append("        and the current one.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"360\" name=\"LBL Beacon Position Estimate\" abbrev=\"LblEstimate\">\n");
		sb.append("    <description>\n");
		sb.append("      LBL Beacon position estimate.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"LBL Beacon Configuration\" abbrev=\"beacon\" type=\"message\" message-type=\"LblBeacon\">\n");
		sb.append("      <description>\n");
		sb.append("        LBL Beacon configuration estimate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"North position\" abbrev=\"x\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The North position offset of the NED field with respect to origin.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"East position\" abbrev=\"y\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The East position offset of the NED field with respect to origin.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"North position variance\" abbrev=\"var_x\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The North offset variance of the North/East/Down\n");
		sb.append("        field with respect to LLH.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"East position variance\" abbrev=\"var_y\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The East offset variance of the North/East/Down\n");
		sb.append("        field with respect to LLH.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Distance\" abbrev=\"distance\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Distance between current LBL Beacon position and filter estimation.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"361\" name=\"Alignment State\" abbrev=\"AlignmentState\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      This message notifies the vehicle is ready for dead-reckoning missions.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"State\" abbrev=\"state\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"AS\">\n");
		sb.append("      <description>\n");
		sb.append("        Alignment State.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Not Aligned\" abbrev=\"NOT_ALIGNED\"/>\n");
		sb.append("      <value id=\"1\" name=\"Aligned\" abbrev=\"ALIGNED\"/>\n");
		sb.append("      <value id=\"2\" name=\"Not Supported\" abbrev=\"NOT_SUPPORTED\"/>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"362\" name=\"GroupStreamVelocity\" abbrev=\"GroupStreamVelocity\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      The stream velocity estimated by a group of systems.\n");
		sb.append("      Typically for water or air streams.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"X component (North)\" abbrev=\"x\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        X component (North).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y component (East)\" abbrev=\"y\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Y component (East).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z component (Down)\" abbrev=\"z\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Z component (Down).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!-- Guidance -->\n");
		sb.append("  <message id=\"400\" name=\"Desired Heading\" abbrev=\"DesiredHeading\"  source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Desired Heading angle reference value for the control layer.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp64_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the desired heading angle, relative to true\n");
		sb.append("        north, in radians.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"401\" name=\"Desired Z\" abbrev=\"DesiredZ\"  source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Desired Z reference value for the control layer.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the desired z reference in meters.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"402\" name=\"Desired Speed\" abbrev=\"DesiredSpeed\"  source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Desired Speed reference value for the control layer.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp64_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the desired speed, in the scale specified by the\n");
		sb.append("        \"Speed Units\" field.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Indicates the units used for the speed value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"403\" name=\"Desired Roll\" abbrev=\"DesiredRoll\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Desired Roll angle reference value for the control layer.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp64_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the desired roll angle.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"404\" name=\"Desired Pitch\" abbrev=\"DesiredPitch\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Desired Pitch angle reference value for the control layer.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp64_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the desired pitch angle.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"405\" name=\"Desired Vertical Rate\" abbrev=\"DesiredVerticalRate\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Desired Vertical Rate speed reference value for the control layer.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the desired vertical rate speed in meters per\n");
		sb.append("        second.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"406\" name=\"Desired Path\" abbrev=\"DesiredPath\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Perform path control.\n");
		sb.append("\n");
		sb.append("      The path is specified by two WGS-84 waypoints, respective\n");
		sb.append("      altitude / depth settings, optional loitering at the end point,\n");
		sb.append("      and some control flags.\n");
		sb.append("\n");
		sb.append("      The start and end waypoints are defined by the specified end point fields\n");
		sb.append("      ('end_{lat/lon/z}') plus:\n");
		sb.append("\n");
		sb.append("      1. the start waypoint fields ('start_{lat|lon|z}') if the\n");
		sb.append("      'START' flag (bit in 'flags' field) is set; or\n");
		sb.append("      2. the end point of the previous path recently tracked; or\n");
		sb.append("      3. the current location is the 'DIRECT' flag is set or if\n");
		sb.append("      the tracker has been idle for some time.\n");
		sb.append("\n");
		sb.append("      Altitude and depth control can be performed as follows:\n");
		sb.append("\n");
		sb.append("      1. by default, the tracker will just transmit an altitude/depth\n");
		sb.append("      reference value equal to 'end_z' to the appropriate controller;\n");
		sb.append("      2. if the 'NO_Z' flag is set no altitude/depth control will take\n");
		sb.append("      place, hence they can be controlled independently;\n");
		sb.append("      3. if the '3DTRACK' flag is set, 3D-tracking will be done\n");
		sb.append("      (if supported by the active controller).\n");
		sb.append("\n");
		sb.append("      Loitering can be specified at the end point with a certain\n");
		sb.append("      radius ('lradius'), duration ('lduration'), and clockwise or\n");
		sb.append("      counter-clockwise direction ('CCLOCKW' flag).\n");
		sb.append("    </description>\n");
		sb.append("    <field name = \"Path Reference\" abbrev=\"path_ref\" type=\"uint32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Unsigned integer reference for the scope of the desired path message.\n");
		sb.append("        Path reference should only be set by a maneuver.\n");
		sb.append("        Should be set to an always increasing reference at the time of dispatching this message.\n");
		sb.append("        Lower level path controllers must inherit the same path reference sent by maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Start Point -- Latitude WGS-84\" abbrev=\"start_lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 latitude of start point. This will be ignored unless\n");
		sb.append("        the 'START' flag is set.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Start Point -- WGS-84 Longitude\" abbrev=\"start_lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 longitude of start point. This will be ignored unless\n");
		sb.append("        the 'START' flag is set.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Start Point -- Z Reference\" abbrev=\"start_z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Altitude or depth of start point. This parameter will be\n");
		sb.append("        ignored if the 'NO_Z' flag is set, or if the 'START' flag is\n");
		sb.append("        not set.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Start Point -- Z Units\" abbrev=\"start_z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the start point's z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"End Point -- WGS84 Latitude\" abbrev=\"end_lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 latitude of end point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"End Point -- WGS-84 Longitude\" abbrev=\"end_lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 longitude of end point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"End Point -- Z Reference\" abbrev=\"end_z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Depth or altitude for the end point. This parameter will be\n");
		sb.append("        ignored if the 'NO_Z' flag is set.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"End Point -- Z Units\" abbrev=\"end_z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the end point's z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver speed reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Speed units.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Loiter -- Radius\" abbrev=\"lradius\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Radius for loitering at end point. Specify less or equal to 0\n");
		sb.append("        for no loitering.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Flags\" abbrev=\"flags\" type=\"uint8_t\" unit=\"Bitfield\" prefix=\"FL\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired Path flags.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x01\" abbrev=\"START\" name=\"Start Point\">\n");
		sb.append("        <description>\n");
		sb.append("          Indicates that the start point specification is given,\n");
		sb.append("          therefore it should be considered for tracking.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x02\" abbrev=\"DIRECT\" name=\"Direct\">\n");
		sb.append("        <description>\n");
		sb.append("          If start point is not given, ignore also the previous path's\n");
		sb.append("          endpoint and take the start point to be the current vehicle\n");
		sb.append("          location.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x04\" abbrev=\"NO_Z\" name=\"No Altitude/Depth control\">\n");
		sb.append("        <description>\n");
		sb.append("          Ignore altitude/depth setting and let them be controlled\n");
		sb.append("          independently.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x08\" abbrev=\"3DTRACK\" name=\"3D Tracking\">\n");
		sb.append("        <description>\n");
		sb.append("          Perform 3D-tracking, i.e., consider the path formed in the\n");
		sb.append("          XYZ plane taking into account both the 'start_z' and 'end_z'\n");
		sb.append("          values.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x10\" abbrev=\"CCLOCKW\" name=\"Counter-Clockwise loiter\">\n");
		sb.append("        <description>\n");
		sb.append("          Indicates that loitering, if defined, should be done\n");
		sb.append("          counter-clockwise. Clockwise loitering will apply\n");
		sb.append("          otherwise.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x20\" abbrev=\"LOITER_CURR\" name=\"Loiter from current position\">\n");
		sb.append("        <description>\n");
		sb.append("          Indicates that loitering, if defined, should be done from\n");
		sb.append("          the current vehicle position. The end_lat and end_lon\n");
		sb.append("          fields will be ignored.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x40\" abbrev=\"TAKEOFF\" name=\"Takeoff\">\n");
		sb.append("        <description>\n");
		sb.append("          Indicates that takeoff should be done before going to the end position.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x80\" abbrev=\"LAND\" name=\"Land\">\n");
		sb.append("        <description>\n");
		sb.append("          Indicates that the system should land at the end position.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"407\" name=\"Desired Control\" abbrev=\"DesiredControl\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Set the desired virtual forces and torques to be applied to the\n");
		sb.append("      vehicle.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Force along the x axis\" abbrev=\"x\" type=\"fp64_t\" unit=\"N\">\n");
		sb.append("      <description>\n");
		sb.append("        Force X along the vehicle's x axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Force along the y axis\" abbrev=\"y\" type=\"fp64_t\" unit=\"N\">\n");
		sb.append("      <description>\n");
		sb.append("        Force Y along the vehicle's y axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Force along the z axis\" abbrev=\"z\" type=\"fp64_t\" unit=\"N\">\n");
		sb.append("      <description>\n");
		sb.append("        Force Z along the vehicle's z axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Torque about the x axis\" abbrev=\"k\" type=\"fp64_t\" unit=\"Nm\">\n");
		sb.append("      <description>\n");
		sb.append("        Torque K about the vehicle's x axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Torque about the y axis\" abbrev=\"m\" type=\"fp64_t\" unit=\"Nm\">\n");
		sb.append("      <description>\n");
		sb.append("        Torque M about the vehicle's y axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Torque about the z axis\" abbrev=\"n\" type=\"fp64_t\" unit=\"Nm\">\n");
		sb.append("      <description>\n");
		sb.append("        Torque N about the vehicle's z axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Flags\" abbrev=\"flags\" type=\"uint8_t\" unit=\"Bitfield\" prefix=\"FL\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired Control flags.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x01\" abbrev=\"X\" name=\"Value of X is meaningful\">\n");
		sb.append("        <description>\n");
		sb.append("          If enabled then field X has a meaningful value.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x02\" abbrev=\"Y\" name=\"Value of Y is meaningful\">\n");
		sb.append("        <description>\n");
		sb.append("          If enabled then field Y has a meaningful value.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x04\" abbrev=\"Z\" name=\"Value of Z is meaningful\">\n");
		sb.append("        <description>\n");
		sb.append("          If enabled then field Z has a meaningful value.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x08\" abbrev=\"K\" name=\"Value of K is meaningful\">\n");
		sb.append("        <description>\n");
		sb.append("          If enabled then field K has a meaningful value.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x10\" abbrev=\"M\" name=\"Value of M is meaningful\">\n");
		sb.append("        <description>\n");
		sb.append("          If enabled then field M has a meaningful value.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x20\" abbrev=\"N\" name=\"Value of N is meaningful\">\n");
		sb.append("        <description>\n");
		sb.append("          If enabled then field N has a meaningful value.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"408\" name=\"Desired Heading Rate\" abbrev=\"DesiredHeadingRate\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Desired Heading Rate speed reference value for the control layer.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp64_t\" unit=\"rad/s\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the desired heading rate speed in radians per\n");
		sb.append("        second.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"409\" name=\"Desired Velocity\" abbrev=\"DesiredVelocity\" source=\"Vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Desired value for each linear and angular speeds.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Desired Linear Speed in xx\" abbrev=\"u\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired speed along the vehicle's x axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Desired Linear Speed in yy\" abbrev=\"v\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired speed along the vehicle's y axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Desired Linear Speed in zz\" abbrev=\"w\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired speed along the vehicle's z axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Desired Angular Speed in xx\" abbrev=\"p\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired speed about the vehicle's x axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Desired Angular Speed in yy\" abbrev=\"q\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired speed about the vehicle's y axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Desired Angular Speed in zz\" abbrev=\"r\" type=\"fp64_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired speed about the vehicle's z axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Flags\" abbrev=\"flags\" type=\"uint8_t\" unit=\"Bitfield\" prefix=\"FL\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired Velocity flags.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x01\" abbrev=\"SURGE\" name=\"Value of u is meaningful\">\n");
		sb.append("        <description>\n");
		sb.append("          If enabled then field u has a meaningful value.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x02\" abbrev=\"SWAY\" name=\"Value of v is meaningful\">\n");
		sb.append("        <description>\n");
		sb.append("          If enabled then field u has a meaningful value.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x04\" abbrev=\"HEAVE\" name=\"Value of w is meaningful\">\n");
		sb.append("        <description>\n");
		sb.append("          If enabled then field w has a meaningful value.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x08\" abbrev=\"ROLL\" name=\"Value of p is meaningful\">\n");
		sb.append("        <description>\n");
		sb.append("          If enabled then field p has a meaningful value.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x10\" abbrev=\"PITCH\" name=\"Value of q is meaningful\">\n");
		sb.append("        <description>\n");
		sb.append("          If enabled then field q has a meaningful value.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x20\" abbrev=\"YAW\" name=\"Value of r is meaningful\">\n");
		sb.append("        <description>\n");
		sb.append("          If enabled then field r has a meaningful value.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"410\" name=\"Path Control State\" abbrev=\"PathControlState\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Path control state issued by Path Controller.\n");
		sb.append("    </description>\n");
		sb.append("    <field name = \"Path Reference\" abbrev=\"path_ref\" type=\"uint32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Unsigned integer reference of the desired path message to which this\n");
		sb.append("        PathControlState message refers to.\n");
		sb.append("        Path reference should only be set by a maneuver, not by path controllers.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Start Point -- Latitude WGS-84\" abbrev=\"start_lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 latitude of start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Start Point -- WGS-84 Longitude\" abbrev=\"start_lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 longitude of start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Start Point -- Z Reference\" abbrev=\"start_z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Altitude or depth of start point. This parameter will be\n");
		sb.append("        ignored if the 'NO_Z' flag is set, or if the 'START' flag is\n");
		sb.append("        not set.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Start Point -- Z Units\" abbrev=\"start_z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the start point's z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"End Point -- Latitude WGS-84\" abbrev=\"end_lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 latitude of end point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"End Point -- WGS-84 Longitude\" abbrev=\"end_lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 longitude of end point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"End Point -- Z Reference\" abbrev=\"end_z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Depth or altitude for the end point. This parameter should be\n");
		sb.append("        ignored if the 'NO_Z' flag is set.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"End Point -- Z Units\" abbrev=\"end_z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the end point's z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Loiter -- Radius\" abbrev=\"lradius\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Radius for loitering at end point.\n");
		sb.append("        Will be 0 if no loitering is active.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Flags\" abbrev=\"flags\" type=\"uint8_t\" unit=\"Bitfield\" prefix=\"FL\">\n");
		sb.append("      <description>\n");
		sb.append("        Path control state flags.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x01\" abbrev=\"NEAR\" name=\"Near Endpoint\">\n");
		sb.append("        <description>\n");
		sb.append("          Set if near the target endpoint.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x02\" abbrev=\"LOITERING\" name=\"Loitering\">\n");
		sb.append("        <description>\n");
		sb.append("          Set if loitering.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x04\" abbrev=\"NO_Z\" name=\"No Altitude/Depth control\">\n");
		sb.append("        <description>\n");
		sb.append("          Altitude/depth being controlled independently.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x08\" abbrev=\"3DTRACK\" name=\"3D Tracking\">\n");
		sb.append("        <description>\n");
		sb.append("          3D-tracking is active.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x10\" abbrev=\"CCLOCKW\" name=\"Counter-Clockwise loiter\">\n");
		sb.append("        <description>\n");
		sb.append("          Indicates that loitering, if active, is being done\n");
		sb.append("          counter-clockwise. Otherwise, clockwise loitering should be\n");
		sb.append("          assumed.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Along Track Position\" abbrev=\"x\" unit=\"m\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Along-Track position value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Cross Track Position\" abbrev=\"y\" unit=\"m\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Cross-Track position value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Vertical Track Position\" abbrev=\"z\" unit=\"m\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Vertical-Track position value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Along Track Velocity\" abbrev=\"vx\" unit=\"m/s\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Along-Track velocity value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Cross Track Velocity\" abbrev=\"vy\" unit=\"m/s\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Cross-Track velocity value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Vertical Track Velocity\" abbrev=\"vz\" unit=\"m/s\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Vertical-Track velocity value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Course Error\" abbrev=\"course_error\" unit=\"rad\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Course error value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Estimated Time to Arrival (ETA)\" abbrev=\"eta\" unit=\"s\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Estimated time to reach target waypoint. The value will be\n");
		sb.append("        65535 if the time is unknown or undefined, and 0 when\n");
		sb.append("        loitering.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"411\" name=\"Allocated Control Torques\" abbrev=\"AllocatedControlTorques\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Control torques allocated to the actuators.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Torque about the x axis\" abbrev=\"k\" type=\"fp64_t\" unit=\"Nm\">\n");
		sb.append("      <description>\n");
		sb.append("        Torque K about the vehicle's x axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Torque about the y axis\" abbrev=\"m\" type=\"fp64_t\" unit=\"Nm\">\n");
		sb.append("      <description>\n");
		sb.append("        Torque M about the vehicle's y axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Torque about the x axis\" abbrev=\"n\" type=\"fp64_t\" unit=\"Nm\">\n");
		sb.append("      <description>\n");
		sb.append("        Torque N about the vehicle's z axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"412\" name=\"Control Parcel\" abbrev=\"ControlParcel\">\n");
		sb.append("    <description>\n");
		sb.append("      Report of PID control parcels.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Proportional Parcel\" abbrev=\"p\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Proportional parcel value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Integrative Parcel\" abbrev=\"i\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Integral parcel value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Derivative Parcel\" abbrev=\"d\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Derivative parcel value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Anti-Windup Parcel\" abbrev=\"a\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Anti-windup parcel value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"413\" name=\"Brake\" abbrev=\"Brake\">\n");
		sb.append("    <description>\n");
		sb.append("      Brake the vehicle in some way, i. e., reduce forward speed.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"OP\">\n");
		sb.append("      <description>\n");
		sb.append("        Brake operation.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" abbrev=\"STOP\" name=\"Stop Braking\">\n");
		sb.append("        <description>\n");
		sb.append("          Stop braking procedures.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" abbrev=\"START\" name=\"Start Braking\">\n");
		sb.append("        <description>\n");
		sb.append("          Start braking procedures.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!-- Maneuvering -->\n");
		sb.append("  <message id=\"450\" name=\"Goto Maneuver\" abbrev=\"Goto\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      A \"Goto\" is a maneuver specifying a movement of the vehicle to a\n");
		sb.append("      target waypoint. The waypoint is described by the WGS-84\n");
		sb.append("      waypoint coordinate and target Z reference.\n");
		sb.append("\n");
		sb.append("      Mandatory parameters defined for a \"Goto\" are\n");
		sb.append("      timeout, speed and speed units.\n");
		sb.append("\n");
		sb.append("      Optional parameters may be defined for the target Euler\n");
		sb.append("      Angles (roll, pitch and yaw) though these parameters may\n");
		sb.append("      not be considered by all maneuver controllers in charge\n");
		sb.append("      of the execution of this type of maneuver.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Timeout\" abbrev=\"timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The amount of time the maneuver is allowed to run.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude of target waypoint.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude of target waypoint.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Reference\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Target reference in the z axis. Use z_units to specify\n");
		sb.append("        whether z represents depth, altitude or other.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver speed reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Speed units.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Roll\" abbrev=\"roll\" type=\"fp64_t\" unit=\"rad\" min=\"-1\" max=\"6.283185307179586\">\n");
		sb.append("      <description>\n");
		sb.append("        The phi Euler angle in which the vehicle should set its\n");
		sb.append("        attitude. Use '-1' for this field to be\n");
		sb.append("        unconsidered. Otherwise the value spans from 0 to 2 Pi.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Pitch\" abbrev=\"pitch\" type=\"fp64_t\" unit=\"rad\" min=\"-1\" max=\"6.283185307179586\">\n");
		sb.append("      <description>\n");
		sb.append("        The theta Euler angle in which the vehicle should set its\n");
		sb.append("        attitude. Use '-1' for this field to be\n");
		sb.append("        disconcerted. Otherwise the value spans from 0 to 2 Pi.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Yaw\" abbrev=\"yaw\" type=\"fp64_t\" unit=\"rad\" min=\"-1\" max=\"6.283185307179586\">\n");
		sb.append("      <description>\n");
		sb.append("        The psi Euler angle in which the vehicle should set its\n");
		sb.append("        attitude. Use '-1' for this field to be considered. Otherwise\n");
		sb.append("        the value spans from 0 to 2 Pi.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"451\" name=\"PopUp Maneuver\" abbrev=\"PopUp\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      The Pop Up maneuver makes the vehicle come to the surface at a\n");
		sb.append("      specific waypoint. This maneuver is restricted to underwater vehicles.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Timeout\" abbrev=\"timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The amount of time the maneuver is allowed to run. If the\n");
		sb.append("        maneuver is not completed in the amount of time specified an\n");
		sb.append("        error will be generated.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Reference\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver reference in the z axis. Use z_units to specify\n");
		sb.append("        whether z represents depth, altitude or other.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver speed reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Speed units.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Duration\" abbrev=\"duration\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The duration of this maneuver at surface level.\n");
		sb.append("        Only used if flag WAIT_AT_SURFACE is on.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Radius\" abbrev=\"radius\" type=\"fp32_t\" unit=\"m\" min=\"1\" max=\"100000\">\n");
		sb.append("      <description>\n");
		sb.append("        Radius of the maneuver.\n");
		sb.append("        Only used if flag STATION_KEEP is on.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Flags\" abbrev=\"flags\" prefix=\"FLG\" type=\"uint8_t\" unit=\"Bitfield\">\n");
		sb.append("      <description>\n");
		sb.append("        Flags of the maneuver.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x01\" abbrev=\"CURR_POS\" name=\"Start from current position\">\n");
		sb.append("        <description>\n");
		sb.append("          If this flag is set, lat/lon/start_z fields should be\n");
		sb.append("          ignored and current vehicle position should be considered as\n");
		sb.append("          starting point for ascent/descent.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x02\" abbrev=\"WAIT_AT_SURFACE\" name=\"Wait at surface\">\n");
		sb.append("        <description>\n");
		sb.append("          If this flag is set, duration field is used to hold position at surface\n");
		sb.append("          for that amount of time.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x04\" abbrev=\"STATION_KEEP\" name=\"Station keeping\">\n");
		sb.append("        <description>\n");
		sb.append("          This flag will only make sense if WAIT_AT_SURFACE is also set.\n");
		sb.append("          While holding position at surface the vehicle will assume a\n");
		sb.append("          station keeping behavior.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"452\" name=\"Teleoperation Maneuver\" abbrev=\"Teleoperation\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      The Teleoperation Maneuver lets the vehicle be controlled by an\n");
		sb.append("      external human operator.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"453\" name=\"Loiter Maneuver\" abbrev=\"Loiter\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      The Loiter maneuver makes the vehicle circle around a specific\n");
		sb.append("      waypoint with fixed depth reference.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Timeout\" abbrev=\"timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The timeout indicates the time that an error should occur if\n");
		sb.append("        exceeded.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude coordinate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude coordinate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Reference\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver reference in the z axis. Use z_units to specify\n");
		sb.append("        whether z represents depth, altitude or other.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Duration\" abbrev=\"duration\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The duration of this maneuver. Use '0' for unlimited duration\n");
		sb.append("        time.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver speed reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Speed units.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Loiter Type\" abbrev=\"type\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"LT\" min=\"0\" max=\"4\">\n");
		sb.append("      <description>\n");
		sb.append("        Loiter maneuver type.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Default\" abbrev=\"DEFAULT\"/>\n");
		sb.append("      <value id=\"1\" name=\"Circular\" abbrev=\"CIRCULAR\"/>\n");
		sb.append("      <value id=\"2\" name=\"Race track\" abbrev=\"RACETRACK\"/>\n");
		sb.append("      <value id=\"3\" name=\"Figure 8\" abbrev=\"EIGHT\"/>\n");
		sb.append("      <value id=\"4\" name=\"Hover\" abbrev=\"HOVER\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Radius\" abbrev=\"radius\" type=\"fp32_t\" unit=\"m\" min=\"1\" max=\"100000\">\n");
		sb.append("      <description>\n");
		sb.append("        Radius of the maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Length\" abbrev=\"length\" type=\"fp32_t\" unit=\"m\" min=\"1\" max=\"100000\">\n");
		sb.append("      <description>\n");
		sb.append("        Length of the maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Bearing\" abbrev=\"bearing\" type=\"fp64_t\" unit=\"rad\" min=\"0\" max=\"6.283185307179586\">\n");
		sb.append("      <description>\n");
		sb.append("        Bearing of the maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Direction\" abbrev=\"direction\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"LD\" min=\"0\" max=\"3\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired direction.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Vehicle Dependent\" abbrev=\"VDEP\"/>\n");
		sb.append("      <value id=\"1\" name=\"Clockwise\" abbrev=\"CLOCKW\"/>\n");
		sb.append("      <value id=\"2\" name=\"Counter Clockwise\" abbrev=\"CCLOCKW\"/>\n");
		sb.append("      <value id=\"3\" name=\"Into the wind/current\" abbrev=\"IWINDCURR\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"454\" name=\"Idle Maneuver\" abbrev=\"IdleManeuver\" source=\"\">\n");
		sb.append("    <description>\n");
		sb.append("      Causes the vehicle to stay idle for some time.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Duration\" abbrev=\"duration\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Optional duration of the Idle maneuver. Use '0' for unlimited\n");
		sb.append("        duration time (maneuver will have to be explicitly stopped).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"455\" name=\"Low Level Control Maneuver\" abbrev=\"LowLevelControl\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Low level maneuver that sends a (heading, roll, speed, ...)\n");
		sb.append("      reference to a controller of the vehicle and then optionally\n");
		sb.append("      lingers for some time.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Control\" abbrev=\"control\" type=\"message\" message-type=\"ControlCommand\">\n");
		sb.append("      <description>\n");
		sb.append("        Control command: can be of type DesiredZ, DesiredHeading,\n");
		sb.append("        DesiredRoll, DesiredPitch, DesiredSpeed, or DesiredPath.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Duration\" abbrev=\"duration\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Duration of the control.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"456\" name=\"Rows Maneuver\" abbrev=\"Rows\" source=\"ccu\">\n");
		sb.append("    <description>Rows maneuver (i.e: lawn mower type maneuver)</description>\n");
		sb.append("    <field name=\"Timeout\" abbrev=\"timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The amount of time the maneuver is allowed to run.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude of target waypoint.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude of target waypoint.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Reference\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver reference in the z axis. Use z_units to specify\n");
		sb.append("        whether z represents depth, altitude or other.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver speed reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Speed units.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Bearing\" abbrev=\"bearing\" type=\"fp64_t\" unit=\"rad\" min=\"0\" max=\"6.283185307179586\">\n");
		sb.append("      <description>\n");
		sb.append("        Rows bearing angle.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Cross Angle\" abbrev=\"cross_angle\" type=\"fp64_t\" unit=\"rad\" min=\"-1.047197551197\" max=\"1.047197551197\">\n");
		sb.append("      <description>\n");
		sb.append("        Rows cross angle reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Width\" abbrev=\"width\" min=\"0\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Width of the maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Length\" abbrev=\"length\" min=\"0\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Length of the maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Horizontal Step\" abbrev=\"hstep\" type=\"fp32_t\" unit=\"m\" min=\"0\" value=\"30\">\n");
		sb.append("      <description>\n");
		sb.append("        Horizontal step.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Curve Offset\" abbrev=\"coff\" type=\"uint8_t\" unit=\"m\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired curve offset.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Alternation Parameter\" abbrev=\"alternation\" type=\"uint8_t\" unit=\"%\" min=\"0\" max=\"100\" value=\"50\">\n");
		sb.append("      <description>\n");
		sb.append("        Alternation parameter.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Flags\" abbrev=\"flags\" type=\"uint8_t\" unit=\"Bitfield\" prefix=\"FLG\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver flags.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x0001\" name=\"Square Curve\" abbrev=\"SQUARE_CURVE\"/>\n");
		sb.append("      <value id=\"0x0002\" name=\"First Curve Right\" abbrev=\"CURVE_RIGHT\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"457\" name=\"Follow Path Maneuver\" abbrev=\"FollowPath\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Maneuver constituted by a list of Path Points.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Timeout\" abbrev=\"timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The amount of time the maneuver is allowed to run.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>WGS-84 Latitude of start point.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>WGS-84 Longitude of start point.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Reference\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver reference in the z axis. Use z_units to specify\n");
		sb.append("        whether z represents depth, altitude or other.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver speed reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Speed units.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Path Points\" abbrev=\"points\" type=\"message-list\" message-type=\"PathPoint\">\n");
		sb.append("      <description>\n");
		sb.append("        List of PathPoint messages, encoding the path points.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"458\" name=\"Path Point\" abbrev=\"PathPoint\">\n");
		sb.append("    <description>\n");
		sb.append("      Waypoint coordinate of a Follow Path maneuver.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"North Offset (m)\" abbrev=\"x\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The North offset of the North/East/Down coordinate of this\n");
		sb.append("        point in relation to the path start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"East Offset (m)\" abbrev=\"y\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The East offset of the North/East/Down coordinate of this\n");
		sb.append("        point in relation to the path start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Down Offset (m)\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The Down offset of the North/East/Down coordinate of this\n");
		sb.append("        point in relation to the path start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"459\" name=\"Yo-Yo Maneuver\" abbrev=\"YoYo\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      A \"yo-yo\" is a maneuver specifying a vehicle movement to a\n");
		sb.append("      target waypoint in which depth/altitude varies along the way\n");
		sb.append("      between two values with a desired pitch angle.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Timeout\" abbrev=\"timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The amount of time the maneuver is allowed to run.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude of target waypoint.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude of target waypoint.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Reference\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver reference in the z axis.\n");
		sb.append("        Use z_units to specify whether z represents depth, altitude or other.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Amplitude\" abbrev=\"amplitude\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Amplitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Pitch Angle\" abbrev=\"pitch\" type=\"fp32_t\" unit=\"rad\" min=\"0\" max=\"0.78539816\">\n");
		sb.append("      <description>\n");
		sb.append("        Pitch angle for use in ascent/descent.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver speed reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Speed units.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"460\" name=\"Teleoperation Done\" abbrev=\"TeleoperationDone\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Notification of completion of a Teleoperation maneuver.\n");
		sb.append("    </description>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"461\" name=\"Station Keeping\" abbrev=\"StationKeeping\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      The Station Keeping maneuver makes the vehicle come to the surface\n");
		sb.append("      and then enter a given circular perimeter around a waypoint coordinate\n");
		sb.append("      for a certain amount of time.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Reference\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver reference in the z axis. Use z_units to specify\n");
		sb.append("        whether z represents depth, altitude or other.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Radius\" abbrev=\"radius\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>Radius.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Duration\" abbrev=\"duration\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>Duration (0 for unlimited).</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The value of the desired speed, in the scale specified\n");
		sb.append("        by the \"Speed Units\" field.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>Indicates the units used for the speed value.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"462\" name=\"Elevator Maneuver\" abbrev=\"Elevator\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      The Elevator maneuver specifies a vehicle to reach a target\n");
		sb.append("      waypoint using a cruise altitude/depth and then ascend or\n");
		sb.append("      descend to another target altitude/depth. The ascent/descent\n");
		sb.append("      slope and radius can also be optionally specified.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Timeout\" abbrev=\"timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The amount of time the maneuver is allowed to run. If the\n");
		sb.append("        maneuver is not completed in the amount of time specified an\n");
		sb.append("        error will be generated.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Flags\" abbrev=\"flags\" prefix=\"FLG\" type=\"uint8_t\" unit=\"Bitfield\">\n");
		sb.append("      <description>\n");
		sb.append("        Flags of the maneuver.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x01\" abbrev=\"CURR_POS\" name=\"Start from current position\">\n");
		sb.append("        <description>\n");
		sb.append("          If this flag is set, lat/lon/start_z fields should be\n");
		sb.append("          ignored and current vehicle position should be considered as\n");
		sb.append("          starting point for ascent/descent.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Start Point -- Z Reference\" abbrev=\"start_z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Altitude or depth of start point. This parameter will be\n");
		sb.append("        ignored if the 'NO_Z' flag is set, or if the 'START' flag is\n");
		sb.append("        not set.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Start Point -- Z Units\" abbrev=\"start_z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the start point's z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"End Point -- Z Reference\" abbrev=\"end_z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Depth or altitude for the end point.  This parameter will be\n");
		sb.append("        ignored if the 'NO_Z' flag is set.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"End Point -- Z Units\" abbrev=\"end_z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the end point's z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Radius\" abbrev=\"radius\" type=\"fp32_t\" unit=\"m\" min=\"0\">\n");
		sb.append("      <description>\n");
		sb.append("        Radius for use in ascent/descent. If 0 the controller to\n");
		sb.append("        should use a custom control strategy.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver speed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Speed units.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"463\" name=\"Follow Trajectory\" abbrev=\"FollowTrajectory\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Maneuver constituted by a list of Trajectory Points.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Timeout\" abbrev=\"timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The amount of time the maneuver is allowed to run.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude for start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude for start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Reference\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver reference in the z axis. Use z_units to specify\n");
		sb.append("        whether z represents depth, altitude or other.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver speed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Speed units.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Trajectory Points\" abbrev=\"points\" type=\"message-list\" message-type=\"TrajectoryPoint\">\n");
		sb.append("      <description>\n");
		sb.append("        List of trajectory points.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"464\" name=\"Trajectory Point\" abbrev=\"TrajectoryPoint\">\n");
		sb.append("    <description>\n");
		sb.append("      Waypoint coordinate of a Follow Trajectory maneuver.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"North Offset (m)\" abbrev=\"x\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The North offset of the North/East/Down coordinate of this\n");
		sb.append("        point in relation to the trajectory start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"East Offset (m)\" abbrev=\"y\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The East offset of the North/East/Down coordinate of this\n");
		sb.append("        point in relation to the trajectory start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Down Offset (m)\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The Down offset of the North/East/Down coordinate of this\n");
		sb.append("        point in relation to the trajectory start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Time Offset (s)\" abbrev=\"t\" type=\"fp32_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The time offset relative to the previous trajectory point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"465\" name=\"Custom Maneuver\" abbrev=\"CustomManeuver\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      The Custom Maneuver message may be used as specification of a\n");
		sb.append("      very specific maneuver not covered by the IMC scope. The\n");
		sb.append("      settings of the maneuver are just its id, timeout and other\n");
		sb.append("      settings encoded as a tuple list.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Timeout\" abbrev=\"timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The amount of time the maneuver is allowed to run. If the\n");
		sb.append("        maneuver is not completed in the amount of time specified an\n");
		sb.append("        error will be generated.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maneuver Name\" abbrev=\"name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        The maneuver name, used as key by an implementation to bind\n");
		sb.append("        the maneuver to the corresponding controller.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"466\" name=\"Vehicle Formation\" abbrev=\"VehicleFormation\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Coordinate maneuver using two or more cooperating systems.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude for start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude for start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Reference\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver reference in the z axis. Use z_units to specify\n");
		sb.append("        whether z represents depth, altitude or other.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Reference speed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Reference speed units.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Trajectory Points\" abbrev=\"points\" type=\"message-list\" message-type=\"TrajectoryPoint\">\n");
		sb.append("      <description>\n");
		sb.append("        List of trajectory points.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Formation Participants\" abbrev=\"participants\" type=\"message-list\" message-type=\"VehicleFormationParticipant\">\n");
		sb.append("      <description>\n");
		sb.append("        List of formation participants.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Start Time\" abbrev=\"start_time\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Optional start time hint for vehicle formation.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"467\" name=\"Vehicle Formation Participant\" abbrev=\"VehicleFormationParticipant\">\n");
		sb.append("    <description>\n");
		sb.append("      Definition of a vehicle participant in a VehicleFormation maneuver.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"ID (IMC address)\" abbrev=\"vid\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        IMC address of vehicle.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Formation offset -- Along-track\" abbrev=\"off_x\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Distance that the system must respect along the xx axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Formation offset -- Cross-track\" abbrev=\"off_y\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Distance that the system must respect along the yy axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Formation offset -- Depth/Altitude\" abbrev=\"off_z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Distance that the system must respect along the zz axis.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"468\" name=\"Stop Maneuver\" abbrev=\"StopManeuver\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Command used to stop currently executing maneuver.\n");
		sb.append("    </description>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"469\" name=\"Register Maneuver\" abbrev=\"RegisterManeuver\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Command used to indicate maneuver can be executed in the\n");
		sb.append("      vehicle.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Maneuver ID\" type=\"uint16_t\" abbrev=\"mid\">\n");
		sb.append("      <description>\n");
		sb.append("        IMC serialization ID of maneuver type.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"470\" name=\"Maneuver Control State\" abbrev=\"ManeuverControlState\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Maneuver control state.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"State\" abbrev=\"state\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"MCS\">\n");
		sb.append("      <description>\n");
		sb.append("        Code indicating maneuver state.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Maneuver in progress\" abbrev=\"EXECUTING\">\n");
		sb.append("        <description>\n");
		sb.append("          Maneuver in progress.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Maneuver completed\" abbrev=\"DONE\">\n");
		sb.append("        <description>\n");
		sb.append("          Maneuver completed.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Maneuver error\" abbrev=\"ERROR\">\n");
		sb.append("        <description>\n");
		sb.append("          Maneuver error.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Maneuver stopped\" abbrev=\"STOPPED\">\n");
		sb.append("        <description>\n");
		sb.append("          Maneuver stopped.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Completion Time\" abbrev=\"eta\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Estimated time to completion of the maneuver, when executing.\n");
		sb.append("        The value will be 65535 if the time is unknown or undefined.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Info\" abbrev=\"info\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Complementary information, e.g., regarding errors.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"471\" name=\"Follow System\" abbrev=\"FollowSystem\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      System-following maneuver.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"System To Follow\" abbrev=\"system\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        IMC address of system to follow.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Duration\" abbrev=\"duration\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Duration of maneuver, 0 for unlimited duration.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Reference speed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Reference speed units.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Offset -- X\" abbrev=\"x\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Along-track offset.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Offset -- Y\" abbrev=\"y\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Cross-track offset.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Coordinate -- Z\" abbrev=\"z\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Coordinate z during follow maneuver. Use z_units to specify\n");
		sb.append("        whether z represents depth, altitude or other.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"472\" abbrev=\"CommsRelay\" name=\"Communications Relay\" >\n");
		sb.append("    <description>\n");
		sb.append("      In this maneuver, a vehicle drives to the center of two other\n");
		sb.append("      systems (a, b) in order to be used as a communications relay.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude for start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude for start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Reference speed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Reference speed units.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Duration\" abbrev=\"duration\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Duration of maneuver, 0 for unlimited duration.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"System A\" abbrev=\"sys_a\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The IMC id of the system A.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"System B\" abbrev=\"sys_b\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The IMC id of the system B.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Move threshold\" abbrev=\"move_threshold\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Move only if the distance to the target is bigger than this\n");
		sb.append("        threshold.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"473\" abbrev=\"CoverArea\" name=\"Cover Area\">\n");
		sb.append("    <description>\n");
		sb.append("      Given a polygonal area, generates trajectories to cover the\n");
		sb.append("      area.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude for start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude for start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Reference\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver reference in the z axis. Use z_units to specify\n");
		sb.append("        whether z represents depth, altitude or other.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Reference speed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Reference speed units.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Polygon\" abbrev=\"polygon\" type=\"message-list\" message-type=\"PolygonVertex\">\n");
		sb.append("      <description>\n");
		sb.append("        Message list of type PolygonVertex.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"CustomParameters\" abbrev=\"custom\" type=\"plaintext\" unit=\"TupleList\">\n");
		sb.append("      <description>\n");
		sb.append("        Additional parameters to be used by the controller.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"474\" abbrev=\"PolygonVertex\" name=\"Polygon Vertex\">\n");
		sb.append("    <description>\n");
		sb.append("      This message is used to store the various polygon vertices for\n");
		sb.append("      CoverArea maneuvers.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude for start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude for start point.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"475\" name=\"Compass Calibration Maneuver\" abbrev=\"CompassCalibration\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      This maneuver is a mix between the Loiter maneuver and the YoYo maneuver.\n");
		sb.append("      The vehicle cirlcles around a specific waypoint with a variable Z\n");
		sb.append("      reference between a minimum and maximum value.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Timeout\" abbrev=\"timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The timeout indicates the time that an error should occur if\n");
		sb.append("        exceeded.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude coordinate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude coordinate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Reference\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver reference in the z axis. Use z_units to specify\n");
		sb.append("        whether z represents depth, altitude or other.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Pitch\" abbrev=\"pitch\" type=\"fp32_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        Pitch angle used to perform the maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Amplitude\" abbrev=\"amplitude\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Yoyo motion amplitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Duration\" abbrev=\"duration\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The duration of this maneuver. Use '0' for unlimited duration time.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver speed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Units\" abbrev=\"speed_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"SpeedUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Speed units.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Radius\" abbrev=\"radius\" type=\"fp32_t\" unit=\"m\" min=\"1\" max=\"100000\">\n");
		sb.append("      <description>\n");
		sb.append("        Radius of the maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Direction\" abbrev=\"direction\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"LD\" min=\"0\" max=\"3\">\n");
		sb.append("      <description>\n");
		sb.append("        Direction of the maneuver.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Vehicle Dependent\" abbrev=\"VDEP\"/>\n");
		sb.append("      <value id=\"1\" name=\"Clockwise\" abbrev=\"CLOCKW\"/>\n");
		sb.append("      <value id=\"2\" name=\"Counter Clockwise\" abbrev=\"CCLOCKW\"/>\n");
		sb.append("      <value id=\"3\" name=\"Into the wind/current\" abbrev=\"IWINDCURR\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"476\" name=\"Formation Parameters\" abbrev=\"FormationParameters\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      A \"Formation\" is defined by the relative positions of the vehicles\n");
		sb.append("      inside the formation, and the reference frame where this positions are defined.\n");
		sb.append("\n");
		sb.append("      The formation reference frame may be:\n");
		sb.append("      - Earth Fixed: Where the vehicles relative position do not depend on the followed path.\n");
		sb.append("      This results in all UAVs following the same path with an offset relative to each other;\n");
		sb.append("      - Path Fixed:  Where the vehicles relative position depends on the followed path,\n");
		sb.append("      changing the inter-vehicle offset direction with the path direction.\n");
		sb.append("      - Path Curved:  Where the vehicles relative position depends on the followed path,\n");
		sb.append("      changing the inter-vehicle offset direction with the path direction and direction\n");
		sb.append("      change rate.\n");
		sb.append("      An offset in the xx axis results in a distance over the curved path line.\n");
		sb.append("      An offset in the yy axis results in an offset of the vehicle path line relative to the\n");
		sb.append("      formation center path line.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Formation Name\" abbrev=\"formation_name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Name of the formation configuration.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Formation Reference Frame\" abbrev=\"reference_frame\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"OP\">\n");
		sb.append("      <description>\n");
		sb.append("        Formation reference frame\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Earth Fixed\" abbrev=\"EARTH_FIXED\"/>\n");
		sb.append("      <value id=\"1\" name=\"Path Fixed\" abbrev=\"PATH_FIXED\"/>\n");
		sb.append("      <value id=\"2\" name=\"Path Curved\" abbrev=\"PATH_CURVED\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Formation Participants\" abbrev=\"participants\" type=\"message-list\" message-type=\"VehicleFormationParticipant\">\n");
		sb.append("      <description>\n");
		sb.append("        List of formation participants.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for formation\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for the formation configuration.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"477\" name=\"Formation Plan Execution\" abbrev=\"FormationPlanExecution\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      A \"Formation Plan\" is a maneuver specifying a plan for a team of vehicles.\n");
		sb.append("      The maneuver defines:\n");
		sb.append("      - Vehicles included in the formation group\n");
		sb.append("      - Formation shape configuration\n");
		sb.append("      - Plan (set of maneuvers) to be followed by the formation center\n");
		sb.append("      - Speed at which that plan is followed\n");
		sb.append("      - Path contrains (virtual leader bank limit)\n");
		sb.append("      - Supervision settings\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Target Group Name\" abbrev=\"group_name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Target group for the formation plan.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Formation Name\" abbrev=\"formation_name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Name of the formation configuration.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Formation Plan ID\" abbrev=\"plan_id\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        The flight plan's identifier.\n");
		sb.append("        Flight plan defined to be tracked by the formation leader.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Plan Description\" abbrev=\"description\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Verbose text description of plan.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Formation Leader Flight Airspeed\" abbrev=\"leader_speed\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Formation leader flight airspeed during the plan tracking.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Formation leader flight bank limit\" abbrev=\"leader_bank_lim\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Formation leader flight bank limit during the plan tracking.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Position mismatch limit\" abbrev=\"pos_sim_err_lim\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Limit for the position mismatch between real and simulated position, before a maneuver abort is asserted.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Position mismatch threshold\" abbrev=\"pos_sim_err_wrn\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Warning threshold for the position mismatch between real and simulated position.\n");
		sb.append("        Above this threshold a time-out limit is evaluated to assert a maneuver abort state.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Position mismatch time-out\" abbrev=\"pos_sim_err_timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The amount of time the maneuver is allowed to run after the position mismatch threshold is surpassed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Convergence threshold\" abbrev=\"converg_max\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Threshold for the convergence measure, above which a time-out limit\n");
		sb.append("        is evaluated to assert a maneuver abort state.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Convergence time-out\" abbrev=\"converg_timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The amount of time the maneuver is allowed to run after the convergence threshold is surpassed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Communications time-out\" abbrev=\"comms_timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The amount of time the maneuver is allowed to run without any update on the other formation vehicles states.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Turbulence limit\" abbrev=\"turb_lim\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Turbulence limit above which a maneuver abort is asserted.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"478\" name=\"Follow Reference Maneuver\" abbrev=\"FollowReference\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      This maneuver follows a reference given by an external entity.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Controlling Source\" abbrev=\"control_src\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The IMC identifier of the source system that is allowed to provide references to this maneuver.\n");
		sb.append("        If the value ''0xFFFF'' is used, any system is allowed to command references.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Controlling Entity\" abbrev=\"control_ent\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The entity identifier of the entity that is allowed to provide references to this maneuver.\n");
		sb.append("        If the value ''0xFF'' is used, any entity is allowed to command references.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Reference Update Timeout\" abbrev=\"timeout\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The ammount of time, in seconds, after which the maneuver will be terminated if no reference has\n");
		sb.append("        been received. In other words, the controlling entity should send reference updates in shorter periods than\n");
		sb.append("        'timeout'.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Loiter Radius\" abbrev=\"loiter_radius\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Whenever an intended reference is achieved, this maneuver will maintain the vehicle in vaticiny of that\n");
		sb.append("        location. The loiter radius is used to define the radius of this (xy) area.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Altitude Interval\" abbrev=\"altitude_interval\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Similarly to Loiter Radius, this field is used to define the \"z\" distance considered to be inside the vacitiny of\n");
		sb.append("        the target location. An AUV may, for instance, be floating until it more than z units above the current reference,\n");
		sb.append("        in which case it actively changes its position in order to achieve the desired depth / altitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"479\" name=\"Reference To Follow\" abbrev=\"Reference\" source=\"ccu,vehicle\">\n");
		sb.append("    <field name=\"Flags\" abbrev=\"flags\" type=\"uint8_t\" unit=\"Bitfield\" prefix=\"FLAG\">\n");
		sb.append("      <value abbrev=\"LOCATION\" name=\"Use Location Reference\" id=\"0x01\"/>\n");
		sb.append("      <value abbrev=\"SPEED\" name=\"Use Speed Reference\" id=\"0x02\"/>\n");
		sb.append("      <value abbrev=\"Z\" name=\"Use Z Reference\" id=\"0x04\"/>\n");
		sb.append("      <value abbrev=\"RADIUS\" name=\"Use Radius Reference\" id=\"0x08\"/>\n");
		sb.append("      <value abbrev=\"MANDONE\" name=\"Flag Maneuver Completion\" id=\"0x80\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Reference\" abbrev=\"speed\" type=\"message\" message-type=\"DesiredSpeed\"/>\n");
		sb.append("    <field name=\"Z Reference\" abbrev=\"z\" type=\"message\" message-type=\"DesiredZ\"/>\n");
		sb.append("    <field name=\"Latitude Reference\" abbrev=\"lat\" type=\"fp64_t\"/>\n");
		sb.append("    <field name=\"Longitude Reference\" abbrev=\"lon\" type=\"fp64_t\"/>\n");
		sb.append("    <field name=\"Radius\" abbrev=\"radius\" type=\"fp32_t\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"480\" name=\"Follow Reference State\" abbrev=\"FollowRefState\" source=\"vehicle\">\n");
		sb.append("    <field name=\"Controlling Source\" abbrev=\"control_src\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The IMC identifier of the source system that is allowed to control the vehicle.\n");
		sb.append("        If the value ''0xFFFF'' is used, any system is allowed to command references.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Controlling Entity\" abbrev=\"control_ent\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        The entity identifier of the entity that is allowed to control the vehicle.\n");
		sb.append("        If the value ''0xFF'' is used, any entity is allowed to command references.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Reference\" abbrev=\"reference\" type=\"message\" message-type=\"Reference\">\n");
		sb.append("      <description>Reference currently being followed.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"State\" abbrev=\"state\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"FR\">\n");
		sb.append("      <value abbrev=\"WAIT\" name=\"Waiting for first reference\" id=\"1\"/>\n");
		sb.append("      <value abbrev=\"GOTO\" name=\"Going towards received reference\" id=\"2\"/>\n");
		sb.append("      <value abbrev=\"LOITER\" name=\"Loitering after arriving at the reference\" id=\"3\"/>\n");
		sb.append("      <value abbrev=\"HOVER\" name=\"Hovering after arriving at the reference\" id=\"4\"/>\n");
		sb.append("      <value abbrev=\"ELEVATOR\" name=\"Moving in z after arriving at the target cylinder\" id=\"5\"/>\n");
		sb.append("      <value abbrev=\"TIMEOUT\" name=\"Controlling system timed out\" id=\"6\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Proximity\" abbrev=\"proximity\" type=\"uint8_t\" unit=\"Bitfield\" prefix=\"PROX\">\n");
		sb.append("      <value abbrev=\"FAR\" name=\"Far from the destination\" id=\"0x01\"/>\n");
		sb.append("      <value abbrev=\"XY_NEAR\" name=\"Near in the horizontal plane\" id=\"0x02\"/>\n");
		sb.append("      <value abbrev=\"Z_NEAR\" name=\"Near in the vertical plane\" id=\"0x04\"/>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"481\" name=\"Formation Monitoring Data\" abbrev=\"FormationMonitor\">\n");
		sb.append("    <description>\n");
		sb.append("      Monitoring variables for the formation state and performance.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Commanded X Acceleration (North)\" abbrev=\"ax_cmd\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Commanded acceleration computed by the formation controller: northward direction.\n");
		sb.append("        On the vehicle directional reference frame.\n");
		sb.append("        Constrained by the vehicle operational limits.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Commanded Y Acceleration (East)\" abbrev=\"ay_cmd\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Commanded acceleration computed by the formation controller: eastward direction.\n");
		sb.append("        On the vehicle directional reference frame.\n");
		sb.append("        Constrained by the vehicle operational limits.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Commanded Z Acceleration (Down)\" abbrev=\"az_cmd\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Commanded acceleration computed by the formation controller: downward direction.\n");
		sb.append("        On the vehicle directional reference frame.\n");
		sb.append("        Constrained by the vehicle operational limits.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Desired X Acceleration (North)\" abbrev=\"ax_des\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired acceleration computed by the formation controller: northward direction.\n");
		sb.append("        On the fixed reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Desired Y Acceleration (East)\" abbrev=\"ay_des\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired acceleration computed by the formation controller: eastward direction.\n");
		sb.append("        On the fixed reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Desired Z Acceleration (Down)\" abbrev=\"az_des\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Desired acceleration computed by the formation controller: downward direction.\n");
		sb.append("        On the fixed reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X Virtual Error (North)\" abbrev=\"virt_err_x\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Components of the vehicle desired acceleration.\n");
		sb.append("        Overall formation combined virtual error: northward direction.\n");
		sb.append("        On the fixed reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y Virtual Error (East)\" abbrev=\"virt_err_y\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Components of the vehicle desired acceleration.\n");
		sb.append("        Overall formation combined virtual error: eastward direction.\n");
		sb.append("        On the fixed reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Virtual Error (Down)\" abbrev=\"virt_err_z\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Components of the vehicle desired acceleration.\n");
		sb.append("        Overall formation combined virtual error: downward direction.\n");
		sb.append("        On the fixed reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X Sliding Surface Feedback (North)\" abbrev=\"surf_fdbk_x\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Components of the vehicle desired acceleration.\n");
		sb.append("        Overall formation combined sliding surface feedback: northward direction.\n");
		sb.append("        On the fixed reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y Sliding Surface Feedback (East)\" abbrev=\"surf_fdbk_y\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Components of the vehicle desired acceleration.\n");
		sb.append("        Overall formation combined sliding surface feedback: eastward direction.\n");
		sb.append("        On the fixed reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Sliding Surface Feedback (Down)\" abbrev=\"surf_fdbk_z\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Components of the vehicle desired acceleration.\n");
		sb.append("        Overall formation combined sliding surface feedback: downward direction.\n");
		sb.append("        On the fixed reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X Uncertainty Compensation (North)\" abbrev=\"surf_unkn_x\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Components of the vehicle desired acceleration.\n");
		sb.append("        Dynamics uncertainty compensation: northward direction.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y Uncertainty Compensation (East)\" abbrev=\"surf_unkn_y\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Components of the vehicle desired acceleration.\n");
		sb.append("        Dynamics uncertainty compensation: eastward direction.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Uncertainty Compensation (Down)\" abbrev=\"surf_unkn_z\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Components of the vehicle desired acceleration.\n");
		sb.append("        Dynamics uncertainty compensation: downward direction.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X Convergence Deviation (North)\" abbrev=\"ss_x\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Combined deviation from convergence (sliding surface): North component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y Convergence Deviation (East)\" abbrev=\"ss_y\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Combined deviation from convergence (sliding surface): East component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Convergence Deviation (Down)\" abbrev=\"ss_z\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Combined deviation from convergence (sliding surface): Down component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Relative State\" abbrev=\"rel_state\" type=\"message-list\" message-type=\"RelativeState\">\n");
		sb.append("      <description>\n");
		sb.append("        List of RelativeState messages, encoding the inter-vehicle formation state.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"482\" name=\"Relative State\" abbrev=\"RelativeState\">\n");
		sb.append("    <description>\n");
		sb.append("      Inter-vehicle formation state.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"System Identifier\" abbrev=\"s_id\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        The identifier of the vehicle whose relative state is being reported.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Distance\" abbrev=\"dist\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Distance between vehicles.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Position Error\" abbrev=\"err\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Relative position error norm.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Control Importance\" abbrev=\"ctrl_imp\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Weight in the computation of the desired acceleration.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Relative Direction X (North)\" abbrev=\"rel_dir_x\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Inter-vehicle direction vector: North component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Relative Direction Y (East)\" abbrev=\"rel_dir_y\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Inter-vehicle direction vector: East component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Relative Direction Z (Down)\" abbrev=\"rel_dir_z\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Inter-vehicle direction vector: Down component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X Position Error (North)\" abbrev=\"err_x\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Relative position error: North component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y Position Error (East)\" abbrev=\"err_y\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Relative position error: East component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Position Error (Down)\" abbrev=\"err_z\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Relative position error: Down component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X Position Error In Relative Frame (North)\" abbrev=\"rf_err_x\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Relative position error: X component on the inter-vehicle reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y Position Error In Relative Frame (East)\" abbrev=\"rf_err_y\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Relative position error: Y component on the inter-vehicle reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Position Error In Relative Frame (Down)\" abbrev=\"rf_err_z\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Relative position error: Z component on the inter-vehicle reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X Velocity Error In Relative Frame (North)\" abbrev=\"rf_err_vx\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Relative veloctity error: X component in the inter-vehicle reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y Velocity Error In Relative Frame (East)\" abbrev=\"rf_err_vy\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Relative velocity error: Y component on the inter-vehicle reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Velocity Error In Relative Frame (Down)\" abbrev=\"rf_err_vz\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Relative velocity error: Z component on the inter-vehicle reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X Convergence Deviation (North)\" abbrev=\"ss_x\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Deviation from convergence (sliding surface): X component on the inter-vehicle reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y Convergence Deviation (East)\" abbrev=\"ss_y\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Deviation from convergence (sliding surface): Y component on the inter-vehicle reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Convergence Deviation (Down)\" abbrev=\"ss_z\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Deviation from convergence (sliding surface): Z component on the inter-vehicle reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X Virtual Error (North)\" abbrev=\"virt_err_x\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Components of the vehicle desired acceleration.\n");
		sb.append("        Relative virtual error: northward direction.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y Virtual Error (East)\" abbrev=\"virt_err_y\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Components of the vehicle desired acceleration.\n");
		sb.append("        Relative virtual error: eastward direction.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Virtual Error (Down)\" abbrev=\"virt_err_z\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Components of the vehicle desired acceleration.\n");
		sb.append("        Relative virtual error: downward direction.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"483\" name=\"Dislodge Maneuver\" abbrev=\"Dislodge\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      A \"Dislodge\" is a maneuver ordering the vehicle to attempt a\n");
		sb.append("      series of thruster operations that will hopefully get it\n");
		sb.append("      unstuck from an entangled condition.\n");
		sb.append("\n");
		sb.append("      Parameters are RPMs for the motor when attempting dislodge and\n");
		sb.append("      and a flag specifying whether the thrust burst should be attempted\n");
		sb.append("      forward, backward or auto (letting the vehicle decide).\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Timeout\" abbrev=\"timeout\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        The amount of time the maneuver is allowed to run.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"RPM\" abbrev=\"rpm\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver RPM reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Direction\" abbrev=\"direction\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"DIR\">\n");
		sb.append("      <description>\n");
		sb.append("        Direction to which the vehicle should attempt to unstuck.\n");
		sb.append("      </description>\n");
		sb.append("      <value abbrev=\"AUTO\" name=\"Let the vehicle decide\" id=\"0\"/>\n");
		sb.append("      <value abbrev=\"FORWARD\" name=\"Attempt to move forward\" id=\"1\"/>\n");
		sb.append("      <value abbrev=\"BACKWARD\" name=\"Attempt to move backward\" id=\"2\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Custom settings for maneuver\" abbrev=\"custom\" unit=\"TupleList\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Custom settings for maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!-- Vehicle Supervision -->\n");
		sb.append("  <message id=\"500\" name=\"Vehicle State\" abbrev=\"VehicleState\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      This message summarizes the overall state of the vehicle. It can\n");
		sb.append("      contains information regarding:\n");
		sb.append("\n");
		sb.append("      - The overall operation mode.\n");
		sb.append("      - Any error conditions.\n");
		sb.append("      - Current maneuver execution.\n");
		sb.append("      - Active control loops.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Operation Mode\" abbrev=\"op_mode\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"VS\">\n");
		sb.append("      <description>\n");
		sb.append("        The overall operation mode.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Service\" abbrev=\"SERVICE\">\n");
		sb.append("        <description>\n");
		sb.append("          Ready to service requests.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Calibration\" abbrev=\"CALIBRATION\">\n");
		sb.append("        <description>\n");
		sb.append("          Ongoing vehicle calibration.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Error\" abbrev=\"ERROR\">\n");
		sb.append("        <description>\n");
		sb.append("          Errors are set.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Maneuver\" abbrev=\"MANEUVER\">\n");
		sb.append("        <description>\n");
		sb.append("          A maneuver is executing.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"4\" name=\"External Control\" abbrev=\"EXTERNAL\">\n");
		sb.append("        <description>\n");
		sb.append("          External control is active.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"5\" name=\"Boot\" abbrev=\"BOOT\">\n");
		sb.append("        <description>\n");
		sb.append("          Booting system.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Errors -- Count\" abbrev=\"error_count\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Error count for monitored entitites.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Errors -- Entities\" abbrev=\"error_ents\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        The monitored entities with error conditions. This is a comma\n");
		sb.append("        separated list of entity names.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maneuver -- Type\" abbrev=\"maneuver_type\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Type of maneuver being executed, when in MANEUVER mode. The\n");
		sb.append("        value is the IMC serialization ID of the corresponding\n");
		sb.append("        maneuver.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maneuver -- Start Time\" abbrev=\"maneuver_stime\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Start time of maneuver being executed (Epoch time), when in\n");
		sb.append("        MANEUVER mode.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maneuver -- ETA\" abbrev=\"maneuver_eta\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Estimated time for maneuver completion. The value will be\n");
		sb.append("        65535 if the time is unknown or undefined.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Control Loops\" abbrev=\"control_loops\" type=\"uint32_t\" unit=\"Bitfield\" bitfield-def=\"CLoopsMask\">\n");
		sb.append("      <description>\n");
		sb.append("        Enabled control loops.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Flags\" abbrev=\"flags\" type=\"uint8_t\" prefix=\"VFLG\" unit=\"Bitfield\">\n");
		sb.append("      <value id=\"0x01\" abbrev=\"MANEUVER_DONE\" name=\"Maneuver Done\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Last Error -- Description\" abbrev=\"last_error\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Description of last error.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Last Error -- Time\" abbrev=\"last_error_time\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Time of last error (Epoch time).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"501\" name=\"Vehicle Command\" abbrev=\"VehicleCommand\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Vehicle command.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Type\" abbrev=\"type\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"VC\">\n");
		sb.append("      <value id=\"0\" abbrev=\"REQUEST\" name=\"Request\"/>\n");
		sb.append("      <value id=\"1\" abbrev=\"SUCCESS\" name=\"Reply -- Success\"/>\n");
		sb.append("      <value id=\"2\" abbrev=\"IN_PROGRESS\" name=\"Reply -- In Progress\"/>\n");
		sb.append("      <value id=\"3\" abbrev=\"FAILURE\" name=\"Reply -- Failure\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Request ID\" abbrev=\"request_id\" type=\"uint16_t\">\n");
		sb.append("      <description>Request ID</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Command\" abbrev=\"command\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"VC\">\n");
		sb.append("      <description>The type of command/action to be performed</description>\n");
		sb.append("      <value id=\"0\" name=\"Execute Maneuver\" abbrev=\"EXEC_MANEUVER\">\n");
		sb.append("        <description>Execute the maneuver specified in 'maneuver' field.</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Stop Maneuver\" abbrev=\"STOP_MANEUVER\">\n");
		sb.append("        <description>Stop 'maneuver' being executed.</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Start Calibration\" abbrev=\"START_CALIBRATION\">\n");
		sb.append("        <description>Start calibrating vehicle.</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Stop Calibration\" abbrev=\"STOP_CALIBRATION\">\n");
		sb.append("        <description>Stop calibrating vehicle.</description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maneuver\" abbrev=\"maneuver\" type=\"message\" message-type=\"Maneuver\">\n");
		sb.append("      <description>Maneuver to be executed (for 'EXEC_MANEUVER' command)</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Calibration Time\" abbrev=\"calib_time\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>Amount of time to calibrate</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Info\" abbrev=\"info\" type=\"plaintext\">\n");
		sb.append("      <description>Complementary human-readable information for replies.</description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"502\" name=\"Monitor Entity State\" abbrev=\"MonitorEntityState\" source=\"vehicle\">\n");
		sb.append("    <description>Controls monitoring of entity states in the vehicle.</description>\n");
		sb.append("    <field name=\"Command\" abbrev=\"command\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"MES\">\n");
		sb.append("      <description>Command.</description>\n");
		sb.append("      <value id=\"0\" abbrev=\"RESET\" name=\"Reset to defaults\"/>\n");
		sb.append("      <value id=\"1\" abbrev=\"ENABLE\" name=\"Enable Monitoring\"/>\n");
		sb.append("      <value id=\"2\" abbrev=\"DISABLE\" name=\"Disable Monitoring\"/>\n");
		sb.append("      <value id=\"3\" abbrev=\"ENABLE_EXCLUSIVE\" name=\"Enable Monitoring (exclusive - disables all others)\"/>\n");
		sb.append("      <value id=\"4\" abbrev=\"STATUS\" name=\"Status Report\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Entity Names\" abbrev=\"entities\" type=\"plaintext\">\n");
		sb.append("      <description>Comma separated list of entity names.</description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"503\" name=\"Entity Monitoring State\" abbrev=\"EntityMonitoringState\" source=\"vehicle\">\n");
		sb.append("    <field name=\"Entities monitored - Count\" abbrev=\"mcount\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Number of entitities being monitored.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Entities monitored - Names\" abbrev=\"mnames\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Comma separated list of all entity names being monitored.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Entities with errors - Count\" abbrev=\"ecount\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Number of entitities with non-critical errors.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Entities with errors - Names\" abbrev=\"enames\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Comma separated list of all entity names with non-critical\n");
		sb.append("        errors.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Entities with critical errors - Count\" abbrev=\"ccount\" type=\"uint8_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Number of entitities with critical errors.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Entities with critical errors - Names\" abbrev=\"cnames\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Comma separated list of all entity names with critical errors.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Last Error -- Description\" abbrev=\"last_error\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Description of last error.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Last Error -- Time\" abbrev=\"last_error_time\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Time of last error (Epoch time).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"504\" name=\"Operational Limits\" abbrev=\"OperationalLimits\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Definition of operational limits.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Field Indicator Mask\" abbrev=\"mask\" type=\"uint8_t\" unit=\"Bitfield\" bitfield-def=\"OpLimitsMask\"/>\n");
		sb.append("    <field name=\"Maximum Depth\" abbrev=\"max_depth\" type=\"fp32_t\" unit=\"m\" min=\"0\"/>\n");
		sb.append("    <field name=\"Minimum Altitude\" abbrev=\"min_altitude\" type=\"fp32_t\" unit=\"m\" min=\"0\"/>\n");
		sb.append("    <field name=\"Maximum Altitude\" abbrev=\"max_altitude\" type=\"fp32_t\" unit=\"m\" min=\"0\"/>\n");
		sb.append("    <field name=\"Minimum Speed\" abbrev=\"min_speed\" type=\"fp32_t\" unit=\"m/s\" min=\"0\"/>\n");
		sb.append("    <field name=\"Maximum Speed\" abbrev=\"max_speed\" type=\"fp32_t\" unit=\"m/s\" min=\"0\"/>\n");
		sb.append("    <field name=\"Maximum Vertical Rate\" abbrev=\"max_vrate\" type=\"fp32_t\" unit=\"m/s\" min=\"0\"/>\n");
		sb.append("    <field name=\"Area -- WGS-84 Latitude\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\"/>\n");
		sb.append("    <field name=\"Area -- WGS-84 Longitude\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\"/>\n");
		sb.append("    <field name=\"Area -- Orientation\" abbrev=\"orientation\" type=\"fp32_t\" unit=\"rad\"/>\n");
		sb.append("    <field name=\"Area -- Width\" abbrev=\"width\" type=\"fp32_t\" unit=\"m\"/>\n");
		sb.append("    <field name=\"Area -- Length\" abbrev=\"length\" type=\"fp32_t\" unit=\"m\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"505\" name=\"Get Operational Limits\" abbrev=\"GetOperationalLimits\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Command to obtain the operational limits in use by the vehicle.\n");
		sb.append("    </description>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"506\" name=\"Calibration\" abbrev=\"Calibration\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Initiate overall calibration of a vehicle.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Duration\" abbrev=\"duration\" type=\"uint16_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Duration of calibration.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"507\" name=\"Control Loops\" abbrev=\"ControlLoops\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Enable or disable control loops.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Enable\" abbrev=\"enable\" type=\"uint8_t\" prefix=\"CL\" unit=\"Enumerated\">\n");
		sb.append("      <value id=\"0\" abbrev=\"DISABLE\" name=\"Disable\"/>\n");
		sb.append("      <value id=\"1\" abbrev=\"ENABLE\"  name=\"Enable\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Control Loop Mask\" abbrev=\"mask\" type=\"uint32_t\" unit=\"Bitfield\" bitfield-def=\"CLoopsMask\">\n");
		sb.append("      <description>\n");
		sb.append("        Control loop mask.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Scope Time Reference\" abbrev=\"scope_ref\" type=\"uint32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Unsigned integer reference for the scope of the control loop message.\n");
		sb.append("        Scope reference should only be set by a maneuver.\n");
		sb.append("        Should be set to an always increasing reference at the time of dispatching this message.\n");
		sb.append("        Lower level controllers must inherit the same scope reference sent by maneuver.\n");
		sb.append("        This same scope reference must be sent down to lower control layers.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"508\" name=\"Vehicle Medium\" abbrev=\"VehicleMedium\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Detect current vehicle medium.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Medium\" abbrev=\"medium\" type=\"uint8_t\" prefix=\"VM\" unit=\"Enumerated\">\n");
		sb.append("      <description>\n");
		sb.append("        Current medium.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" abbrev=\"GROUND\" name=\"Ground\">\n");
		sb.append("        <description>Vehicle is on the ground</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" abbrev=\"AIR\" name=\"Air\">\n");
		sb.append("        <description>Vehicle is airborne</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" abbrev=\"WATER\" name=\"Water\">\n");
		sb.append("        <description>Vehicle is at water surface</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" abbrev=\"UNDERWATER\" name=\"Underwater\">\n");
		sb.append("        <description>Vehicle is underwater</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"4\" abbrev=\"UNKNOWN\" name=\"Unknown\">\n");
		sb.append("        <description>Vehicle medium is unknown</description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"509\" name=\"Collision\" abbrev=\"Collision\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Detected collision.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Collision value\" abbrev=\"value\" type=\"fp32_t\" unit=\"m/s/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Estimated collision acceleration value.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Type\" abbrev=\"type\" type=\"uint8_t\" unit=\"Bitfield\" prefix=\"CD\">\n");
		sb.append("      <description>\n");
		sb.append("        Collision flags.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0x01\" abbrev=\"X\" name=\"X-axis\">\n");
		sb.append("        <description>Collision detected in the x-axis</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x02\" abbrev=\"Y\" name=\"Y-axis\">\n");
		sb.append("        <description>Collision detected in the y-axis</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x04\" abbrev=\"Z\" name=\"Z-axis\">\n");
		sb.append("        <description>Collision detected in the z-axis</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x08\" abbrev=\"IMPACT\" name=\"Impact\">\n");
		sb.append("        <description>Sudden impact detected</description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"510\" name=\"Formation Tracking State\" abbrev=\"FormState\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Monitoring variables to assert the formation tracking state, i.e., the mismatch between the real and the simulated aircraft position, the convergence state, etc.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Position Mismatch\" abbrev=\"PosSimErr\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Mismatch between the real and the simulated aircraft position.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Convergence\" abbrev=\"Converg\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Convergence evalution variable.\n");
		sb.append("        Value indicates the position error to which the system is converging, tacking into account the aircraft current position error and velocity.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Stream Turbulence\" abbrev=\"Turbulence\" type=\"fp32_t\" unit=\"m/s/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Evaluation of the stream turbulence level, through the stream acceleration.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Position Mismatch Monitor\" abbrev=\"PosSimMon\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"POS\">\n");
		sb.append("      <description>\n");
		sb.append("        Position mismatch monitoring flag.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Ok\" abbrev=\"OK\"/>\n");
		sb.append("      <value id=\"1\" name=\"Warning threshold\" abbrev=\"WRN\"/>\n");
		sb.append("      <value id=\"2\" name=\"Limit threshold\" abbrev=\"LIM\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Communications Monitor\" abbrev=\"CommMon\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"COMMS\">\n");
		sb.append("      <description>\n");
		sb.append("        Communications monitoring flag.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Ok\" abbrev=\"OK\"/>\n");
		sb.append("      <value id=\"1\" name=\"Timeout\" abbrev=\"TIMEOUT\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Convergence\" abbrev=\"ConvergMon\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"CONV\">\n");
		sb.append("      <description>\n");
		sb.append("        Convergence monitoring flag.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Ok\" abbrev=\"OK\"/>\n");
		sb.append("      <value id=\"1\" name=\"Timeout\" abbrev=\"TIMEOUT\"/>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"511\" name=\"Autopilot Mode\" abbrev=\"AutopilotMode\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Reports autopilot mode.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Autonomy Level\" abbrev=\"autonomy\" type=\"uint8_t\" prefix=\"AL\" unit=\"Enumerated\">\n");
		sb.append("      <description>\n");
		sb.append("        Current mode autonomy level.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" abbrev=\"MANUAL\" name=\"Manual\">\n");
		sb.append("        <description>Autopilot has no control</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" abbrev=\"ASSISTED\" name=\"Assisted\">\n");
		sb.append("        <description>Autopilot has some control</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" abbrev=\"AUTO\" name=\"Auto\">\n");
		sb.append("        <description>Autopilot has full control</description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Mode\" abbrev=\"mode\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Current mode name.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!-- Plan Supervision -->\n");
		sb.append("  <message id=\"550\" name=\"Abort\" abbrev=\"Abort\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Stops any executing actions and put the system in a standby mode.\n");
		sb.append("    </description>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"551\" name=\"Plan Specification\" abbrev=\"PlanSpecification\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Identity and description of a plan's general parameters,\n");
		sb.append("      associated with plan loading (i.e. load plan command in\n");
		sb.append("      *PlanCommand*).\n");
		sb.append("\n");
		sb.append("      A plan specification is defined by a plan identifier, a set of\n");
		sb.append("      maneuver specifications and a start maneuver from that set.\n");
		sb.append("\n");
		sb.append("      See the :ref:`PlanManeuver` message for details on maneuver\n");
		sb.append("      specification.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Plan ID\" abbrev=\"plan_id\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        The plan's identifier.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Plan Description\" abbrev=\"description\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Verbose text description of plan.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Namespace\" abbrev=\"vnamespace\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Namespace for plan variables.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Plan Variables\" abbrev=\"variables\" type=\"message-list\" message-type=\"PlanVariable\">\n");
		sb.append("      <description>\n");
		sb.append("        Plan variables.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Starting maneuver\" abbrev=\"start_man_id\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Indicates the id of the starting maneuver for this plan.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maneuvers\" abbrev=\"maneuvers\" type=\"message-list\" message-type=\"PlanManeuver\">\n");
		sb.append("      <description>\n");
		sb.append("        List of maneuver specifications.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Transitions\" abbrev=\"transitions\" type=\"message-list\" message-type=\"PlanTransition\">\n");
		sb.append("      <description>\n");
		sb.append("        List of maneuver specifications.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Start Actions\" abbrev=\"start_actions\" type=\"message-list\">\n");
		sb.append("      <description>\n");
		sb.append("        Contains an optionally defined 'MessageList' for actions fired\n");
		sb.append("        on plan activation.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"End Actions\" abbrev=\"end_actions\" type=\"message-list\">\n");
		sb.append("      <description>\n");
		sb.append("        Contains an optionally defined 'MessageList' for actions fired\n");
		sb.append("        on plan termination.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"552\" name=\"Plan Maneuver\" abbrev=\"PlanManeuver\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Named plan maneuver.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Maneuver ID\" abbrev=\"maneuver_id\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        The maneuver ID.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maneuver Specification\" abbrev=\"data\" type=\"message\" message-type=\"Maneuver\">\n");
		sb.append("      <description>\n");
		sb.append("        The maneuver specification.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Start Actions\" abbrev=\"start_actions\" type=\"message-list\">\n");
		sb.append("      <description>\n");
		sb.append("        Contains an optionally defined 'MessageList' for actions fired\n");
		sb.append("        on plan activation.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"End Actions\" abbrev=\"end_actions\" type=\"message-list\">\n");
		sb.append("      <description>\n");
		sb.append("        Contains an optionally defined 'MessageList' for actions fired\n");
		sb.append("        on plan termination.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"553\" name=\"Plan Transition\" abbrev=\"PlanTransition\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Describes a plan transition within a plan specification. A\n");
		sb.append("      transition states the vehicle conditions that must be met to\n");
		sb.append("      signal the transition, the maneuver that should be started as a\n");
		sb.append("      result, and an optional set of actions triggered by the\n");
		sb.append("      transition.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Source\" abbrev=\"source_man\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Comma separated list of maneuver IDs, or the special value '.'\n");
		sb.append("        to identify a global plan transition.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Destination Maneuver Name\" abbrev=\"dest_man\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Target maneuver name.\n");
		sb.append("        If it equals the special value '_done_' then plan should\n");
		sb.append("        terminate with a success status.\n");
		sb.append("        If it equals the special value '_error_' then the plan should\n");
		sb.append("        terminate with an error status.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Transition conditions\" abbrev=\"conditions\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Comma separated list of conditions for transition. Each\n");
		sb.append("        condition identifier corresponds to a known predicate which is\n");
		sb.append("        interpreted and tested internally by the vehicle.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Transition actions\" abbrev=\"actions\" type=\"message-list\">\n");
		sb.append("      <description>\n");
		sb.append("        Messages processed when the transition is triggered.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"554\" name=\"Emergency Control\" abbrev=\"EmergencyControl\" source=\"ccu\">\n");
		sb.append("    <field name=\"Command\" abbrev=\"command\" type=\"uint8_t\" prefix=\"ECTL\" unit=\"Enumerated\">\n");
		sb.append("      <value id=\"0\" name=\"Enable\" abbrev=\"ENABLE\"/>\n");
		sb.append("      <value id=\"1\" name=\"Disable\" abbrev=\"DISABLE\"/>\n");
		sb.append("      <value id=\"2\" name=\"Start\" abbrev=\"START\"/>\n");
		sb.append("      <value id=\"3\" name=\"Stop\" abbrev=\"STOP\"/>\n");
		sb.append("      <value id=\"4\" name=\"Query\" abbrev=\"QUERY\"/>\n");
		sb.append("      <value id=\"5\" name=\"Set Plan\" abbrev=\"SET_PLAN\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Plan Specification\" abbrev=\"plan\" type=\"message\" message-type=\"PlanSpecification\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"555\" name=\"Emergency Control State\" abbrev=\"EmergencyControlState\" source=\"vehicle\">\n");
		sb.append("    <field name=\"State\" abbrev=\"state\" type=\"uint8_t\" prefix=\"ECS\" unit=\"Enumerated\">\n");
		sb.append("      <value id=\"0\" name=\"Not Configured\" abbrev=\"NOT_CONFIGURED\"/>\n");
		sb.append("      <value id=\"1\" name=\"Disabled\" abbrev=\"DISABLED\"/>\n");
		sb.append("      <value id=\"2\" name=\"Enabled\" abbrev=\"ENABLED\"/>\n");
		sb.append("      <value id=\"3\" name=\"Armed\" abbrev=\"ARMED\"/>\n");
		sb.append("      <value id=\"4\" name=\"Active\" abbrev=\"ACTIVE\"/>\n");
		sb.append("      <value id=\"5\" name=\"Stopping\" abbrev=\"STOPPING\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Plan Id\" abbrev=\"plan_id\" type=\"plaintext\"/>\n");
		sb.append("    <field name=\"Communications Level\" abbrev=\"comm_level\" type=\"uint8_t\" unit=\"%\" min=\"0\" max=\"100\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"556\" name=\"Plan DB\" abbrev=\"PlanDB\">\n");
		sb.append("    <description>\n");
		sb.append("      Request/reply to plan database.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Type\" abbrev=\"type\" unit=\"Enumerated\" type=\"uint8_t\" prefix=\"DBT\">\n");
		sb.append("      <description>\n");
		sb.append("        Indicates if the message is a request, or a reply to a\n");
		sb.append("        previous request.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Request\" abbrev=\"REQUEST\"/>\n");
		sb.append("      <value id=\"1\" name=\"Reply -- Success\" abbrev=\"SUCCESS\"/>\n");
		sb.append("      <value id=\"2\" name=\"Reply -- Failure\" abbrev=\"FAILURE\"/>\n");
		sb.append("      <value id=\"3\" name=\"Reply -- In Progress\" abbrev=\"IN_PROGRESS\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"DBOP\">\n");
		sb.append("      <description>\n");
		sb.append("        Indicates the operation affecting the DB.\n");
		sb.append("\n");
		sb.append("        The operation may relate to a single plan or the entire plan DB.\n");
		sb.append("        For each request,  a plan DB may reply with any number of 'in progress'\n");
		sb.append("        replies followed by a success or a failure reply.\n");
		sb.append("\n");
		sb.append("        The 'op', 'request_id' and 'plan_id' fields of a request will be echoed\n");
		sb.append("        in one or more responses to that request.\n");
		sb.append("        The operation at stake also determines a certain type of the 'arg' field,\n");
		sb.append("        and whether or not the 'plan_id' field needs to be set.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Set Plan\" abbrev=\"SET\">\n");
		sb.append("        <description>\n");
		sb.append("          Set a plan in the DB. The 'plan_id' field identifies the\n");
		sb.append("          plan, and a pre-existing plan with the same identifier, if\n");
		sb.append("          any will be overwritten. For requests, the 'arg' field must\n");
		sb.append("          contain a 'PlanSpecification' message.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Delete Plan\" abbrev=\"DEL\">\n");
		sb.append("        <description>\n");
		sb.append("          Delete a plan from the DB. The 'plan_id' field identifies\n");
		sb.append("          the plan to delete.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Get Plan\" abbrev=\"GET\">\n");
		sb.append("        <description>\n");
		sb.append("          Get a plan stored in the DB.The 'plan_id' field identifies\n");
		sb.append("          the plan. Successful replies will yield a\n");
		sb.append("          'PlanSpecification' message in the 'arg' field.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Get Plan Info\" abbrev=\"GET_INFO\">\n");
		sb.append("        <description>\n");
		sb.append("          Get DB state for a stored plan. The 'plan_id' field\n");
		sb.append("          identifies the plan. Successful replies will yield a\n");
		sb.append("          'PlanDBInformation' message in the 'arg' field.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"4\" name=\"Clear Database\" abbrev=\"CLEAR\">\n");
		sb.append("        <description>\n");
		sb.append("          Clear the entire DB.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"5\" name=\"Get Database State (Simple)\" abbrev=\"GET_STATE\">\n");
		sb.append("        <description>\n");
		sb.append("          Get state of the entire DB. Successful replies will yield a\n");
		sb.append("          'PlanDBState' message in the 'arg' field but without\n");
		sb.append("          individual plan information (in the 'plans_info' field of\n");
		sb.append("          'PlanDBState').\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"6\" name=\"Get Database State (Detailed)\"  abbrev=\"GET_DSTATE\">\n");
		sb.append("        <description>\n");
		sb.append("          Get detailed state of the entire DB. Successful replies\n");
		sb.append("          will yield a 'PlanDBState' message in the 'arg' field with\n");
		sb.append("          individual plan information (in the 'plans_info' field of\n");
		sb.append("          'PlanDBState').\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"7\" name=\"Boot Notification\" abbrev=\"BOOT\">\n");
		sb.append("        <description>\n");
		sb.append("          PlanDB replies of this type are sent automatically during\n");
		sb.append("          bootstrap.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Request ID\" abbrev=\"request_id\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Request ID. This may be used by interfacing modules,\n");
		sb.append("        e.g. using sequence counters, to annotate requests and\n");
		sb.append("        appropriately identify replies\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Plan ID\" abbrev=\"plan_id\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Plan identifier for the operation, if one is required.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Argument\" abbrev=\"arg\" type=\"message\">\n");
		sb.append("      <description>\n");
		sb.append("        Request or reply argument.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Complementary Information\" abbrev=\"info\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Human-readable complementary information. For example this\n");
		sb.append("        may be used to detail reasons for failure, or to report\n");
		sb.append("        in-progress information.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"557\" name=\"Plan DB State\" abbrev=\"PlanDBState\">\n");
		sb.append("    <description>\n");
		sb.append("      Characterizes the state of the entire plan database.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Plan -- Count\" abbrev=\"plan_count\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Number of stored plans.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Plan -- Size of all plans\" abbrev=\"plan_size\" type=\"uint32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Size of all plans.The value equals the sum of the IMC payload\n");
		sb.append("        sizes for 'PlanSpecification' stored in the DB.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Last Change -- Time\" abbrev=\"change_time\" type=\"fp64_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Time of last change (Epoch time).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Last Change -- Source Address\" abbrev=\"change_sid\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        IMC address for source of last DB change.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Last Change -- Source Name\" abbrev=\"change_sname\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        IMC node name for source of last DB change.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"MD5\" abbrev=\"md5\" type=\"rawdata\">\n");
		sb.append("      <description>\n");
		sb.append("        MD5 database verification code. The MD5 hash sum is computed\n");
		sb.append("        over the stream formed by the MD5 of all plans, ordered by\n");
		sb.append("        plan id, in compliance with RFC 1321.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Plan info\" abbrev=\"plans_info\" type=\"message-list\" message-type=\"PlanDBInformation\">\n");
		sb.append("      <description>\n");
		sb.append("        Individual information for plans.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"558\" name=\"Plan DB Information\" abbrev=\"PlanDBInformation\">\n");
		sb.append("    <field name=\"Plan ID\" abbrev=\"plan_id\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Plan identifier.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Plan Size\" abbrev=\"plan_size\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Plan size. The value equals the IMC message payload of the\n");
		sb.append("        associated 'PlanSpecification' message in bytes.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Last Changed -- Time\" abbrev=\"change_time\" type=\"fp64_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Time of last change to the plan (Epoch time).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Last Change -- Source Address\" abbrev=\"change_sid\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        IMC address for source of last change to the plan.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Last Change -- Source Name\" abbrev=\"change_sname\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        IMC node name for source of last change to the plan.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"MD5\" abbrev=\"md5\" type=\"rawdata\">\n");
		sb.append("      <description>\n");
		sb.append("        MD5 plan verification code. The value is calculated over the\n");
		sb.append("        message payload of the 'PlanSpecification', in compliance with\n");
		sb.append("        RFC 1321.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"559\" abbrev=\"PlanControl\" name=\"Plan Control\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Plan control request/reply.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Type\" abbrev=\"type\" unit=\"Enumerated\" type=\"uint8_t\" prefix=\"PC\">\n");
		sb.append("      <description>\n");
		sb.append("        Indicates if the message is a request or a reply to a\n");
		sb.append("        previous request. The *op*, *request_id* and *plan_id* fields\n");
		sb.append("        of a request will be echoed in one or more responses to that\n");
		sb.append("        request.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Request\" abbrev=\"REQUEST\"/>\n");
		sb.append("      <value id=\"1\" name=\"Reply -- Success\" abbrev=\"SUCCESS\"/>\n");
		sb.append("      <value id=\"2\" name=\"Reply -- Failure\" abbrev=\"FAILURE\"/>\n");
		sb.append("      <value id=\"3\" name=\"Reply -- In Progress\" abbrev=\"IN_PROGRESS\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"PC\">\n");
		sb.append("      <description>\n");
		sb.append("        Plan control operation.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" abbrev=\"START\" name=\"Start Plan\">\n");
		sb.append("        <description>\n");
		sb.append("          Start plan identified by *plan_id* field.  The command will\n");
		sb.append("          try to load the corresponding plan if none is loaded, and in\n");
		sb.append("          that case will follow the same discipline as the *LOAD*\n");
		sb.append("          command.\n");
		sb.append("\n");
		sb.append("          If the message in *arg* is a :ref:`Maneuver`, a single-maneuver plan\n");
		sb.append("          will be generated and executed.\n");
		sb.append("\n");
		sb.append("          This will override any current plan being executed.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" abbrev=\"STOP\" name=\"Stop Plan\">\n");
		sb.append("        <description>\n");
		sb.append("          Stop current plan being executed if any.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" abbrev=\"LOAD\" name=\"Load Plan\">\n");
		sb.append("        <description>\n");
		sb.append("          Load Plan. If a :ref:`PlanSpecification` is given with the\n");
		sb.append("          request in the *data* field, then that plan is used and\n");
		sb.append("          stored in the Plan DB. Otherwise, the plan is loaded from\n");
		sb.append("          the Plan DB.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" abbrev=\"GET\" name=\"Get Plan\">\n");
		sb.append("        <description>\n");
		sb.append("          Get loaded plan. For a successful reply, the *data* field\n");
		sb.append("          will contain the :ref:`PlanSpecification` message that\n");
		sb.append("          corresponds to the currently loaded plan.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Request ID\" abbrev=\"request_id\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Request ID. This may be used by interfacing modules e.g. using\n");
		sb.append("        sequence counters.  to annotate requests and appropriately\n");
		sb.append("        identify replies.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Plan Identifier\" abbrev=\"plan_id\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        The identifier for the plan to be stopped / started / loaded /\n");
		sb.append("        retrieved according to the command requested (*op* field).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Flags\" abbrev=\"flags\" type=\"uint16_t\" prefix=\"FLG\" unit=\"Bitfield\">\n");
		sb.append("      <!-- Request flags -->\n");
		sb.append("      <value id=\"0x0001\" name=\"Calibrate Vehicle\" abbrev=\"CALIBRATE\">\n");
		sb.append("        <description>\n");
		sb.append("          Perform vehicle calibration.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x0002\" name=\"Ignore Errors\" abbrev=\"IGNORE_ERRORS\">\n");
		sb.append("        <description>\n");
		sb.append("          Execute current plan while ignoring some errors that might be active.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <!-- Response flags -->\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Request/Reply Argument\" abbrev=\"arg\" type=\"message\">\n");
		sb.append("      <description>\n");
		sb.append("        Complementary message argument for requests/replies.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Complementary Info\" abbrev=\"info\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Complementary human-readable information. This is used\n");
		sb.append("        in association to replies.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"560\" name=\"Plan Control State\" flags=\"periodic\" abbrev=\"PlanControlState\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      State of plan control.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"State\" abbrev=\"state\" type=\"uint8_t\" prefix=\"PCS\" unit=\"Enumerated\">\n");
		sb.append("      <description>\n");
		sb.append("        Describes overall state.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Blocked\" abbrev=\"BLOCKED\">\n");
		sb.append("        <description>\n");
		sb.append("          Plan execution is blocked e.g., due to a vehicle error,\n");
		sb.append("          or if no plan is loaded.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Ready\" abbrev=\"READY\">\n");
		sb.append("        <description>\n");
		sb.append("          Ready to start plan execution.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Initializing\" abbrev=\"INITIALIZING\">\n");
		sb.append("        <description>\n");
		sb.append("          Initializing plan for execution.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Executing\" abbrev=\"EXECUTING\">\n");
		sb.append("        <description>\n");
		sb.append("          Executing plan.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Plan -- ID\" abbrev=\"plan_id\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Identifier of plan currently loaded.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Plan -- ETA\" abbrev=\"plan_eta\" type=\"int32_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Current plan estimated time to completion.\n");
		sb.append("        The value will be -1 if the time is unknown or undefined.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Plan -- Progress\" abbrev=\"plan_progress\" type=\"fp32_t\" unit=\"%\">\n");
		sb.append("      <description>\n");
		sb.append("        Current plan estimated progress in percent.\n");
		sb.append("        The value will be negative if unknown or undefined.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maneuver -- ID\" abbrev=\"man_id\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Current node ID, when executing a plan.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maneuver -- Type\" abbrev=\"man_type\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Type of maneuver being executed (IMC serialization id),\n");
		sb.append("        when executing a plan.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Maneuver -- ETA\" abbrev=\"man_eta\" type=\"int32_t\" unit=\"s\">\n");
		sb.append("      <description>\n");
		sb.append("        Current node estimated time to completion, when executing a plan.\n");
		sb.append("        The value will be -1 if the time is unknown or undefined.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Last Plan Outcome\" abbrev=\"last_outcome\" type=\"uint8_t\" prefix=\"LPO\" unit=\"Enumerated\">\n");
		sb.append("      <description>\n");
		sb.append("        Outcome of the last executed plan.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"None\" abbrev=\"NONE\">\n");
		sb.append("        <description>\n");
		sb.append("          Unknown or not filled.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Success\" abbrev=\"SUCCESS\">\n");
		sb.append("        <description>\n");
		sb.append("          Last plan execution was successful.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Failure\" abbrev=\"FAILURE\">\n");
		sb.append("        <description>\n");
		sb.append("          Last plan execution was a failure.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"561\" name=\"Plan Variable\" abbrev=\"PlanVariable\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>A plan variable.</description>\n");
		sb.append("    <field name=\"Name\" abbrev=\"name\" type=\"plaintext\"/>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"plaintext\"/>\n");
		sb.append("    <field name=\"Type\" abbrev=\"type\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"PVT\">\n");
		sb.append("      <value id=\"0\" name=\"Boolean\" abbrev=\"BOOLEAN\"/>\n");
		sb.append("      <value id=\"1\" name=\"Number\" abbrev=\"NUMBER\"/>\n");
		sb.append("      <value id=\"2\" name=\"Text\" abbrev=\"TEXT\"/>\n");
		sb.append("      <value id=\"3\" name=\"Message\" abbrev=\"MESSAGE\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Access Type\" abbrev=\"access\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"PVA\">\n");
		sb.append("      <value id=\"0\" name=\"Input\" abbrev=\"INPUT\"/>\n");
		sb.append("      <value id=\"1\" name=\"Output\" abbrev=\"OUTPUT\"/>\n");
		sb.append("      <value id=\"2\" name=\"Local\" abbrev=\"LOCAL\"/>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"562\" name=\"Plan Generation\" abbrev=\"PlanGeneration\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      This message is used to order the generation of plans based on\n");
		sb.append("      id and set of parameters.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Command\" abbrev=\"cmd\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"CMD\">\n");
		sb.append("      <value abbrev=\"GENERATE\" name=\"Generate\" id=\"0\">\n");
		sb.append("        <description>\n");
		sb.append("          Generate the plan and store it in the PlanDB.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value abbrev=\"EXECUTE\" name=\"Execute\" id=\"1\">\n");
		sb.append("        <description>\n");
		sb.append("          Generate (storing it in the PlanDB) and execute it immediately.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"OP\">\n");
		sb.append("      <value abbrev=\"REQUEST\" name=\"Request\" id=\"0\">\n");
		sb.append("        <description>\n");
		sb.append("          Request the execution of this command.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value abbrev=\"ERROR\" name=\"Error\" id=\"1\">\n");
		sb.append("        <description>\n");
		sb.append("          Some error has occurred while executing the command. The\n");
		sb.append("          error can be found in the 'params' tuplelist (under the\n");
		sb.append("          key 'error').\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value abbrev=\"SUCCESS\" name=\"Success\" id=\"2\">\n");
		sb.append("        <description>\n");
		sb.append("          The requested command was executed successfully.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Plan Identifier\" abbrev=\"plan_id\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        The name of the plan to be generated.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Parameters\" abbrev=\"params\" type=\"plaintext\" unit=\"TupleList\">\n");
		sb.append("      <description>\n");
		sb.append("        An optional list of parameters to be used by the plan\n");
		sb.append("        generation module.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"563\" name=\"Leader State\" abbrev=\"LeaderState\" source=\"vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>\n");
		sb.append("      This message defines the formation leader state.\n");
		sb.append("\n");
		sb.append("      LeaderState is a complete description of the leader state\n");
		sb.append("      in terms of parameters such as position, orientation and\n");
		sb.append("      velocities at a particular moment in time.\n");
		sb.append("\n");
		sb.append("      The system position is given by a North-East-Down (NED)\n");
		sb.append("      local tangent plane displacement (x, y, z) relative to\n");
		sb.append("      an absolute WGS-84 coordinate (latitude, longitude,\n");
		sb.append("      height above ellipsoid).\n");
		sb.append("\n");
		sb.append("      The symbols for position and attitude as well as linear and\n");
		sb.append("      angular velocities were chosen according to SNAME's notation (1950).\n");
		sb.append("      The body-fixed reference frame and Euler angles are depicted\n");
		sb.append("      next:\n");
		sb.append("\n");
		sb.append("      .. figure:: ../images/euler-lauv.png\n");
		sb.append("\n");
		sb.append("      :align:  center\n");
		sb.append("\n");
		sb.append("      Euler angles\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Group Name\" abbrev=\"group_name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Name for the formation group.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Action on the leader state\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"OP\">\n");
		sb.append("      <description>\n");
		sb.append("        Action on the formation leader state variables\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Request\" abbrev=\"REQUEST\"/>\n");
		sb.append("      <value id=\"1\" name=\"Set\" abbrev=\"SET\"/>\n");
		sb.append("      <value id=\"2\" name=\"Report\" abbrev=\"REPORT\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude (WGS-84)\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude (WGS-84)\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Height (WGS-84)\" abbrev=\"height\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Height above the WGS-84 ellipsoid.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Offset north\" abbrev=\"x\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The North offset of the North/East/Down field with respect to\n");
		sb.append("        LLH.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Offset east\" abbrev=\"y\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The East offset of the North/East/Down field with respect to\n");
		sb.append("        LLH.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Offset down\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The Down offset of the North/East/Down field with respect to\n");
		sb.append("        LLH.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Rotation over x axis\" abbrev=\"phi\" type=\"fp32_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The phi Euler angle from the vehicle's attitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Rotation over y axis\" abbrev=\"theta\" type=\"fp32_t\" unit=\"rad\" min=\"-1.57079632679490\" max=\"1.57079632679490\">\n");
		sb.append("      <description>\n");
		sb.append("        The theta Euler angle from the vehicle's attitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Rotation over z axis\" abbrev=\"psi\" type=\"fp32_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The psi Euler angle from the vehicle's attitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Ground Velocity X (North)\" abbrev=\"vx\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Ground Velocity xx axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Ground Velocity Y (East)\" abbrev=\"vy\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Ground Velocity yy axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Ground Velocity Z (Down)\" abbrev=\"vz\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Ground Velocity zz axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Angular Velocity in x\" abbrev=\"p\" type=\"fp32_t\" unit=\"rad/s\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The angular velocity over body-fixed xx axis (roll).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Angular Velocity in y\" abbrev=\"q\" type=\"fp32_t\" unit=\"rad/s\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The angular velocity over body-fixed yy axis (pitch).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Angular Velocity in z\" abbrev=\"r\" type=\"fp32_t\" unit=\"rad/s\"  min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        The angular velocity over body-fixed zz axis (yaw).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Stream Velocity X (North)\" abbrev=\"svx\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Stream Velocity xx axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Stream Velocity Y (East)\" abbrev=\"svy\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Stream Velocity yy axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Stream Velocity Z (Down)\" abbrev=\"svz\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Stream Velocity zz axis velocity component.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"564\" name=\"Plan Statistics\" abbrev=\"PlanStatistics\" source=\"vehicle\">\n");
		sb.append("    <field name=\"Plan Identifier\" abbrev=\"plan_id\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        The name of the plan to be generated.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Type\" abbrev=\"type\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"TP\">\n");
		sb.append("      <description>\n");
		sb.append("        Type of plan statistics, if they are launched before, during or after the plan execution.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Before Plan\" abbrev=\"PREPLAN\"/>\n");
		sb.append("      <value id=\"1\" name=\"During Plan\" abbrev=\"INPLAN\"/>\n");
		sb.append("      <value id=\"2\" name=\"After Plan\" abbrev=\"POSTPLAN\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Properties\" abbrev=\"properties\" type=\"uint8_t\" prefix=\"PRP\" unit=\"Bitfield\">\n");
		sb.append("      <value id=\"0x00\" name=\"Basic Plan\" abbrev=\"BASIC\">\n");
		sb.append("        <description>\n");
		sb.append("          Basic plan, meaning it is Linear, Finite and Noncyclic.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x01\" name=\"Nonlinear\" abbrev=\"NONLINEAR\">\n");
		sb.append("        <description>\n");
		sb.append("          Plan is nonlinear.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x02\" name=\"Infinite\" abbrev=\"INFINITE\">\n");
		sb.append("        <description>\n");
		sb.append("          Plan is infinite in duration.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x04\" name=\"Cyclical\" abbrev=\"CYCLICAL\">\n");
		sb.append("        <description>\n");
		sb.append("          Plan is cyclical.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"0x07\" name=\"All\" abbrev=\"ALL\">\n");
		sb.append("        <description>\n");
		sb.append("          All properties checked.\n");
		sb.append("        </description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Durations\" abbrev=\"durations\" type=\"plaintext\" unit=\"TupleList\">\n");
		sb.append("      <description>\n");
		sb.append("        Maneuver and plan duration statistics in seconds, for example: \u201CTotal=1000,Goto1=20,Rows=980\u201D\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Distances\" abbrev=\"distances\" type=\"plaintext\" unit=\"TupleList\">\n");
		sb.append("      <description>\n");
		sb.append("        Distances travelled in meters in each maneuver and/or total: \u201CTotal=2000,Rows=1800,Elevator=200\u201D\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Actions\" abbrev=\"actions\" type=\"plaintext\" unit=\"TupleList\">\n");
		sb.append("      <description>\n");
		sb.append("        List of components active by plan actions during the plan and time active in seconds: \u201CSidescan=100,Camera Module=150\u201D\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Fuel\" abbrev=\"fuel\" type=\"plaintext\" unit=\"TupleList\">\n");
		sb.append("      <description>\n");
		sb.append("        Amount of fuel spent, in battery percentage, by different parcels (if applicable): \u201CTotal=35,Hotel=5,Payload=10,Motion=20,IMU=0\u201D\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!-- CCU Messages (Internal and between CCUs) -->\n");
		sb.append("  <message id=\"600\" name=\"Reported State\" abbrev=\"ReportedState\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      A vehicle state that is reported to other consoles (including PDAConsole). Source can be acoustic tracker, SMS, Wi-Fi, etc...\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Latitude\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\"/>\n");
		sb.append("    <field name=\"Longitude\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\"/>\n");
		sb.append("    <field name=\"Depth\" abbrev=\"depth\" type=\"fp64_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        The reported depth. In the case of not knowing the depth 0 will be reported.\n");
		sb.append("        Airplanes usually have negative values (por positive altitude).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Roll\" abbrev=\"roll\" type=\"fp64_t\" unit=\"rad\">\n");
		sb.append("      <description>The phi Euler angle from the vehicle's attitude.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Pitch\" abbrev=\"pitch\" type=\"fp64_t\" unit=\"rad\">\n");
		sb.append("      <description>The theta Euler angle from the vehicle's attitude.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Yaw\" abbrev=\"yaw\" type=\"fp64_t\" unit=\"rad\">\n");
		sb.append("      <description>The psi Euler angle from the vehicle's attitude.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Reception Time\" abbrev=\"rcp_time\" type=\"fp64_t\" unit=\"s\" note=\"Correct interpretation of this field may require synchronization of clocks between sender and recipient\">\n");
		sb.append("      <description>\n");
		sb.append("        The time when the packet was sent, as seen by the packet\n");
		sb.append("        dispatcher. The number of seconds is represented in Universal\n");
		sb.append("        Coordinated Time (UCT) in seconds since Jan 1, 1970 using IEEE\n");
		sb.append("        double precision floating point numbers.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"System Identifier\" abbrev=\"sid\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        The id of the system whose position is being reported (it can be a vehicle's id, a boat name, etc)\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Source Type\" abbrev=\"s_type\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"STYPE\">\n");
		sb.append("      <description>How the position was received/calculated</description>\n");
		sb.append("      <value id=\"0\" name=\"Wi-Fi\" abbrev=\"WI_FI\"/>\n");
		sb.append("      <value id=\"1\" name=\"Tracker\" abbrev=\"TRACKER\"/>\n");
		sb.append("      <value id=\"2\" name=\"SMS\" abbrev=\"SMS\"/>\n");
		sb.append("      <value id=\"3\" name=\"Acoustic Modem\" abbrev=\"ACOUSTIC_MODEM\"/>\n");
		sb.append("      <value id=\"254\" name=\"Unknown source\" abbrev=\"UNKNOWN\"/>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"601\" name=\"Remote Sensor Info\" abbrev=\"RemoteSensorInfo\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      Whenever the CUCS receives a message from one of the existing sensors (through SMS, ZigBee, Acoustic Comms, ...) it disseminates that info recurring to this message.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Id\" abbrev=\"id\" type=\"plaintext\">\n");
		sb.append("      <description>An unique string that identifies the sensor. Used mostly for logging/presentation.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Class\" abbrev=\"sensor_class\" type=\"plaintext\">\n");
		sb.append("      <description>The class of a sensor tells the type of sensor originating this message. It will determine how the sensor is to be shown and (optionally) how the custom data (tuplelist) is to be interpreted.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\"/>\n");
		sb.append("    <field name=\"Longitude\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\"/>\n");
		sb.append("    <field name=\"Altitude\" abbrev=\"alt\" type=\"fp32_t\" unit=\"m\"/>\n");
		sb.append("    <field name=\"Heading\" abbrev=\"heading\" type=\"fp32_t\" unit=\"rad\"/>\n");
		sb.append("    <field name=\"Custom Data\" abbrev=\"data\" type=\"plaintext\" unit=\"TupleList\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!-- messages used to send maps to the Android Command and Control Unit (ACCU) -->\n");
		sb.append("  <message id=\"602\" name=\"Map\" abbrev=\"Map\" source=\"ccu\">\n");
		sb.append("    <description>This message represents a simple map that is transferred between CCU consoles (from Neptus to ACCU)</description>\n");
		sb.append("    <field name=\"Identifier\" abbrev=\"id\" type=\"plaintext\">\n");
		sb.append("      <description>The id of the map</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Features\" abbrev=\"features\" type=\"message-list\" message-type=\"MapFeature\">\n");
		sb.append("      <description>A list of map features.</description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"603\" name=\"Map Feature\" abbrev=\"MapFeature\" source=\"ccu\">\n");
		sb.append("    <description>A feature to appear on the map</description>\n");
		sb.append("    <field name=\"Identifier\" abbrev=\"id\" type=\"plaintext\">\n");
		sb.append("      <description>The unique identifier for this feature (used as the name for points of interest)</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"FeatureType\" abbrev=\"feature_type\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"FTYPE\">\n");
		sb.append("      <description>The type of feature</description>\n");
		sb.append("      <value id=\"0\" name=\"Point of Interest\" abbrev=\"POI\">\n");
		sb.append("        <description>These features should appear as a point with a label in the map</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"1\" name=\"Filled Polygon\" abbrev=\"FILLEDPOLY\">\n");
		sb.append("        <description>These features should be represented as a filled polygon (no label)</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"2\" name=\"Countoured Polygon\" abbrev=\"CONTOUREDPOLY\">\n");
		sb.append("        <description>These features should be represented as a countoured closed polygon (no fill and no label)</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"3\" name=\"Line\" abbrev=\"LINE\">\n");
		sb.append("        <description>These features should be represented as an open polygon (no label)</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"4\" name=\"Transponder\" abbrev=\"TRANSPONDER\">\n");
		sb.append("        <description>A transponder location in the map</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"5\" name=\"Start Location\" abbrev=\"STARTLOC\">\n");
		sb.append("        <description>Intended vehicle's starting location</description>\n");
		sb.append("      </value>\n");
		sb.append("      <value id=\"6\" name=\"Home Reference\" abbrev=\"HOMEREF\">\n");
		sb.append("        <description>The offsets reference for this map</description>\n");
		sb.append("      </value>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"RedComponent\" abbrev=\"rgb_red\" type=\"uint8_t\">\n");
		sb.append("      <description>The red component of the color for this point</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"GreenComponent\" abbrev=\"rgb_green\" type=\"uint8_t\">\n");
		sb.append("      <description>The green component of the color for this point</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"BlueComponent\" abbrev=\"rgb_blue\" type=\"uint8_t\">\n");
		sb.append("      <description>The blue component of the color for this point</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Feature\" abbrev=\"feature\" type=\"message-list\" message-type=\"MapPoint\">\n");
		sb.append("      <description>The enclosing feature definition.</description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"604\" name=\"MapPoint\" abbrev=\"MapPoint\" source=\"ccu\">\n");
		sb.append("    <description>This message represents a point in the world.</description>\n");
		sb.append("    <field name=\"Latitude\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\"/>\n");
		sb.append("    <field name=\"Longitude\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\"/>\n");
		sb.append("    <field name=\"Altitude\" abbrev=\"alt\" type=\"fp32_t\" unit=\"m\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"606\" name=\"CCU Event\" abbrev=\"CcuEvent\" source=\"ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      This message is used to signal events among running CCUs.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Event Type\" abbrev=\"type\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"EVT\">\n");
		sb.append("      <value abbrev=\"LOG_ENTRY\" name=\"Log Book Entry Added\" id=\"1\" />\n");
		sb.append("      <value abbrev=\"PLAN_ADDED\" name=\"Plan Added\" id=\"2\" />\n");
		sb.append("      <value abbrev=\"PLAN_REMOVED\" name=\"Plan Removed\" id=\"3\" />\n");
		sb.append("      <value abbrev=\"PLAN_CHANGED\" name=\"Plan Changed\" id=\"4\" />\n");
		sb.append("      <value abbrev=\"MAP_FEATURE_ADDED\" name=\"Map feature added\" id=\"5\" />\n");
		sb.append("      <value abbrev=\"MAP_FEATURE_REMOVED\" name=\"Map feature removed\" id=\"6\" />\n");
		sb.append("      <value abbrev=\"MAP_FEATURE_CHANGED\" name=\"Map feature changed\" id=\"7\" />\n");
		sb.append("      <value abbrev=\"TELEOPERATION_STARTED\" name=\"The sender is now teleoperating the vehicle\" id=\"8\" />\n");
		sb.append("      <value abbrev=\"TELEOPERATION_ENDED\" name=\"The sender stopped teleoperating the vehicle\" id=\"9\" />\n");
		sb.append("    </field>\n");
		sb.append("\n");
		sb.append("    <field name=\"Identifier\" abbrev=\"id\" type=\"plaintext\"/>\n");
		sb.append("    <field name=\"Additional Data\" abbrev=\"arg\" type=\"message\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!-- Autonomy -->\n");
		sb.append("  <message id=\"650\" name=\"Vehicle Links\" abbrev=\"VehicleLinks\" source=\"vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      This message is sent by the TREX task which gives further information to a TREX instance about connected IMC nodes\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Local Name\" abbrev=\"localname\" type=\"plaintext\">\n");
		sb.append("      <description>The name of the vehicle being controlled</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Active Links\" abbrev=\"links\" type=\"message-list\" message-type=\"Announce\">\n");
		sb.append("      <description>A list of Announce messages with last announces heard</description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"651\" name=\"TREX Observation\" abbrev=\"TrexObservation\" source=\"vehicle,ccu\" flags=\"deprecated\">\n");
		sb.append("    <description>\n");
		sb.append("      This message is sent to TREX to post timeline observations\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Timeline\" abbrev=\"timeline\" type=\"plaintext\" />\n");
		sb.append("    <field name=\"Predicate\" abbrev=\"predicate\" type=\"plaintext\" />\n");
		sb.append("    <field name=\"Attributes\" abbrev=\"attributes\" type=\"plaintext\" unit=\"TupleList\" />\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"652\" name=\"TREX Command\" abbrev=\"TrexCommand\" source=\"vehicle,ccu\" flags=\"deprecated\">\n");
		sb.append("    <description>\n");
		sb.append("      This message is used to control TREX execution\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Command\" abbrev=\"command\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"OP\">\n");
		sb.append("      <value abbrev=\"DISABLE\" name=\"Disable TREX\" id=\"0\"/>\n");
		sb.append("      <value abbrev=\"ENABLE\" name=\"Enable TREX\" id=\"1\"/>\n");
		sb.append("      <value abbrev=\"POST_GOAL\" name=\"Post Goal\" id=\"2\"/>\n");
		sb.append("      <value abbrev=\"RECALL_GOAL\" name=\"Recall Goal\" id=\"3\"/>\n");
		sb.append("      <value abbrev=\"REQUEST_PLAN\" name=\"Request current plan\" id=\"4\"/>\n");
		sb.append("      <value abbrev=\"REPORT_PLAN\" name=\"Report current plan\" id=\"5\"/>\n");
		sb.append("    </field>\n");
		sb.append("\n");
		sb.append("    <field name=\"Goal Id\" abbrev=\"goal_id\" type=\"plaintext\">\n");
		sb.append("      <description>The id of the goal, if applicable (OP == POST_GOAL || OP == RECALL_GOAL)</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Goal XML\" abbrev=\"goal_xml\" type=\"plaintext\">\n");
		sb.append("      <description>The goal encoded as XML, if applicable (OP == POST_GOAL)</description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"655\" abbrev=\"TrexOperation\" name=\"TREX Operation\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      This message is used to control TREX execution\n");
		sb.append("    </description>\n");
		sb.append("\n");
		sb.append("    <field name=\"Operation\" abbrev=\"op\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"OP\">\n");
		sb.append("      <value abbrev=\"POST_TOKEN\" name=\"Post Token\" id=\"1\"/>\n");
		sb.append("      <value abbrev=\"POST_GOAL\" name=\"Post Goal\" id=\"2\"/>\n");
		sb.append("      <value abbrev=\"RECALL_GOAL\" name=\"Recall Goal\" id=\"3\"/>\n");
		sb.append("      <value abbrev=\"REQUEST_PLAN\" name=\"Request current plan\" id=\"4\"/>\n");
		sb.append("      <value abbrev=\"REPORT_PLAN\" name=\"Report current plan\" id=\"5\"/>\n");
		sb.append("    </field>\n");
		sb.append("\n");
		sb.append("    <field name=\"Goal Id\" abbrev=\"goal_id\" type=\"plaintext\">\n");
		sb.append("      <description>The id of the goal, if applicable (OP == POST_GOAL || OP == RECALL_GOAL)</description>\n");
		sb.append("    </field>\n");
		sb.append("\n");
		sb.append("    <field name=\"Token\" abbrev=\"token\" type=\"message\" message-type=\"TrexToken\">\n");
		sb.append("      <description>Goal / observation to post, if applicable (OP == POST_GOAL || OP == POST_TOKEN)</description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"656\" abbrev=\"TrexAttribute\" name=\"TREX Attribute\" source=\"vehicle,ccu\">\n");
		sb.append("\n");
		sb.append("    <field name=\"Attribute Name\" abbrev=\"name\" type=\"plaintext\">\n");
		sb.append("      <description>Name of this attribute.</description>\n");
		sb.append("    </field>\n");
		sb.append("\n");
		sb.append("    <field name=\"Attribute type\" abbrev=\"attr_type\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"TYPE\">\n");
		sb.append("      <value abbrev=\"BOOL\" name=\"Boolean Domain\" id=\"1\"/>\n");
		sb.append("      <value abbrev=\"INT\" name=\"Integer Domain\" id=\"2\"/>\n");
		sb.append("      <value abbrev=\"FLOAT\" name=\"Float Domain\" id=\"3\"/>\n");
		sb.append("      <value abbrev=\"STRING\" name=\"String Domain\" id=\"4\"/>\n");
		sb.append("      <value abbrev=\"ENUM\" name=\"Enumerated Domain\" id=\"5\"/>\n");
		sb.append("    </field>\n");
		sb.append("\n");
		sb.append("    <field name=\"Minimum\" abbrev=\"min\" type=\"plaintext\">\n");
		sb.append("      <description>Lower bound of this interval. Empty text means no bound.</description>\n");
		sb.append("    </field>\n");
		sb.append("\n");
		sb.append("    <field name=\"Maximum\" abbrev=\"max\" type=\"plaintext\">\n");
		sb.append("      <description>Upper bound of this interval. Empty text means no bound.</description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"657\" abbrev=\"TrexToken\" name=\"TREX Token\" source=\"vehicle,ccu\">\n");
		sb.append("    <field name=\"Timeline\" abbrev=\"timeline\" type=\"plaintext\" />\n");
		sb.append("    <field name=\"Predicate\" abbrev=\"predicate\" type=\"plaintext\" />\n");
		sb.append("    <field name=\"Attributes\" abbrev=\"attributes\" type=\"message-list\" message-type=\"TrexAttribute\" />\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"658\" abbrev=\"TrexPlan\" name=\"TREX Plan\" source=\"vehicle,ccu\">\n");
		sb.append("    <field name=\"Reactor name\" abbrev=\"reactor\" type=\"plaintext\" />\n");
		sb.append("    <field name=\"Tokens\" abbrev=\"tokens\" type=\"message-list\" message-type=\"TrexToken\" />\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"660\" abbrev=\"Event\" name=\"Event\" source=\"vehicle,ccu\">\n");
		sb.append("    <description>\n");
		sb.append("      This message is used for signaling asynchronous events between different (sub) systems.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Topic\" abbrev=\"topic\" type=\"plaintext\">\n");
		sb.append("      <description>The name or type of this event</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Data\" abbrev=\"data\" type=\"plaintext\" unit=\"TupleList\">\n");
		sb.append("      <description>A map with additional event information.</description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!-- Vision -->\n");
		sb.append("  <message id=\"702\" name=\"Compressed Image\" abbrev=\"CompressedImage\" source=\"ccu, vehicle\">\n");
		sb.append("    <description/>\n");
		sb.append("    <field name=\"Frame Id\" abbrev=\"frameid\" type=\"uint8_t\"/>\n");
		sb.append("    <field name=\"Data\" abbrev=\"data\" type=\"rawdata\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"703\" name=\"Image Transmission Settings\" abbrev=\"ImageTxSettings\" source=\"ccu, vehicle\">\n");
		sb.append("    <description/>\n");
		sb.append("    <field name=\"Frames Per Second\" abbrev=\"fps\" type=\"uint8_t\"/>\n");
		sb.append("    <field name=\"Quality\" abbrev=\"quality\" type=\"uint8_t\"/>\n");
		sb.append("    <field name=\"Repetitions\" abbrev=\"reps\" type=\"uint8_t\"/>\n");
		sb.append("    <field name=\"Target Size\" abbrev=\"tsize\" type=\"uint8_t\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!-- External -->\n");
		sb.append("  <message id=\"750\" name=\"Remote State\" abbrev=\"RemoteState\" source=\"vehicle\">\n");
		sb.append("    <description>State summary for a remote vehicle.</description>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp32_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>WGS-84 Latitude.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp32_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>WGS-84 Longitude.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Depth\" abbrev=\"depth\" type=\"uint8_t\" unit=\"m\">\n");
		sb.append("      <description>Depth.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed\" abbrev=\"speed\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>Speed.</description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Heading\"  abbrev=\"psi\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>Heading.</description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <!-- Development -->\n");
		sb.append("  <message id=\"800\" name=\"Target\" abbrev=\"Target\">\n");
		sb.append("    <description>\n");
		sb.append("      Target.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Label\" abbrev=\"label\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Target identifier.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude WGS-84\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude coordinate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude WGS-84\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude coordinate.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Reference\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Z axis reference. Use z_units to specify whether z represents\n");
		sb.append("        depth, altitude or other.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Course Over Ground\" abbrev=\"cog\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Course Over Ground (true).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Speed Over Ground\" abbrev=\"sog\" type=\"fp32_t\" unit=\"m/s\">\n");
		sb.append("      <description>\n");
		sb.append("        Speed Over Ground.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"801\" name=\"EntityParameter\" abbrev=\"EntityParameter\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Entity parameter.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Name\" abbrev=\"name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Name of the parameter.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Current value of the parameter.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"802\" name=\"EntityParameters\" abbrev=\"EntityParameters\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      List of entity parameters.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Entity Name\" abbrev=\"name\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Name of the entity.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Parameters\" abbrev=\"params\" type=\"message-list\" message-type=\"EntityParameter\">\n");
		sb.append("      <description>\n");
		sb.append("        List of parameters.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"803\" name=\"QueryEntityParameters\" abbrev=\"QueryEntityParameters\" source=\"ccu,vehicle\">\n");
		sb.append("    <field name=\"Entity Name\" abbrev=\"name\" type=\"plaintext\"/>\n");
		sb.append("    <field name=\"Visibility\" abbrev=\"visibility\" type=\"plaintext\"/>\n");
		sb.append("    <field name=\"Scope\" abbrev=\"scope\" type=\"plaintext\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"804\" name=\"SetEntityParameters\" abbrev=\"SetEntityParameters\" source=\"ccu,vehicle\">\n");
		sb.append("    <field name=\"Entity Name\" abbrev=\"name\" type=\"plaintext\"/>\n");
		sb.append("    <field name=\"Parameters\" abbrev=\"params\" type=\"message-list\" message-type=\"EntityParameter\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"805\" name=\"SaveEntityParameters\" abbrev=\"SaveEntityParameters\" source=\"ccu,vehicle\">\n");
		sb.append("    <field name=\"Entity Name\" abbrev=\"name\" type=\"plaintext\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"806\" name=\"Create Session\" abbrev=\"CreateSession\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Request creating a new session with this remote peer. Example\n");
		sb.append("      session sequence is shown in the following diagram.\n");
		sb.append("\n");
		sb.append("      .. figure:: ../images/session_sequence.png\n");
		sb.append("\n");
		sb.append("      :align:  center\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Session Timeout\" abbrev=\"timeout\" type=\"uint32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Session timeout, in seconds. If no messages are received from\n");
		sb.append("        the remote peer, the session will be closed after this ammount\n");
		sb.append("        of seconds have ellapsed.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"807\" name=\"Close Session\" abbrev=\"CloseSession\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Request closing of an ongoing session\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Session Identifier\" abbrev=\"sessid\" type=\"uint32_t\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"808\" name=\"Session Subscription\" abbrev=\"SessionSubscription\" source=\"ccu,vehicle\">\n");
		sb.append("    <field name=\"Session Identifier\" abbrev=\"sessid\" type=\"uint32_t\"/>\n");
		sb.append("    <field name=\"Messages to subscribe\" abbrev=\"messages\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Comma-separated list of messages to subscribe. Example:\n");
		sb.append("        \"EstimatedState,EulerAngles,Temperature\"\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"809\" name=\"Session Keep-Alive\" abbrev=\"SessionKeepAlive\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>Message exchanged to prevent a session from timing out</description>\n");
		sb.append("    <field name=\"Session Identifier\" abbrev=\"sessid\" type=\"uint32_t\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"810\" name=\"Session Status\" abbrev=\"SessionStatus\" source=\"ccu,vehicle\" flags=\"periodic\">\n");
		sb.append("    <description>Message transmitted periodically to inform the state of a communication session</description>\n");
		sb.append("    <field name=\"Session Identifier\" abbrev=\"sessid\" type=\"uint32_t\"/>\n");
		sb.append("    <field name=\"Status\" abbrev=\"status\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"STATUS\">\n");
		sb.append("      <value abbrev=\"ESTABLISHED\" name=\"Established\" id=\"1\"/>\n");
		sb.append("      <value abbrev=\"CLOSED\" name=\"Closed\" id=\"2\"/>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"811\" name=\"Push Entity Parameters\" abbrev=\"PushEntityParameters\" source=\"ccu,vehicle\">\n");
		sb.append("    <field name=\"Entity Name\" abbrev=\"name\" type=\"plaintext\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"812\" name=\"Pop Entity Parameters\" abbrev=\"PopEntityParameters\" source=\"ccu,vehicle\">\n");
		sb.append("    <field name=\"Entity Name\" abbrev=\"name\" type=\"plaintext\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"813\" name=\"I/O Event\" abbrev=\"IoEvent\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Notification of an I/O event.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Type\" abbrev=\"type\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"IOV_TYPE\">\n");
		sb.append("      <description>\n");
		sb.append("        Event type.\n");
		sb.append("      </description>\n");
		sb.append("      <value abbrev=\"INPUT\" name=\"Input Available\" id=\"1\"/>\n");
		sb.append("      <value abbrev=\"INPUT_ERROR\" name=\"Input Error\" id=\"2\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Error Message\" abbrev=\"error\" type=\"plaintext\">\n");
		sb.append("      <description>\n");
		sb.append("        Human-readable error message.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"814\" name=\"UamTxFrame\" abbrev=\"UamTxFrame\" source=\"ccu,vehicle\">\n");
		sb.append("    <field name=\"Sequence Id\" abbrev=\"seq\" type=\"uint16_t\"/>\n");
		sb.append("    <field name=\"Destination System\" abbrev=\"sys_dst\" type=\"plaintext\"/>\n");
		sb.append("    <field name=\"Flags\" abbrev=\"flags\" type=\"uint8_t\" unit=\"Bitfield\" prefix=\"UTF\">\n");
		sb.append("      <value abbrev=\"ACK\" name=\"Acknowledgement\" id=\"0x01\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Data\" abbrev=\"data\" type=\"rawdata\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"815\" name=\"UamRxFrame\" abbrev=\"UamRxFrame\" source=\"ccu,vehicle\">\n");
		sb.append("    <field name=\"Source System\" abbrev=\"sys_src\" type=\"plaintext\"/>\n");
		sb.append("    <field name=\"Destination System\" abbrev=\"sys_dst\" type=\"plaintext\"/>\n");
		sb.append("    <field name=\"Flags\" abbrev=\"flags\" type=\"uint8_t\" unit=\"Bitfield\" prefix=\"URF\">\n");
		sb.append("      <value abbrev=\"PROMISCUOUS\" name=\"Promiscuous\" id=\"0x01\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Data\" abbrev=\"data\" type=\"rawdata\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"816\" name=\"UamTxStatus\" abbrev=\"UamTxStatus\" source=\"ccu,vehicle\">\n");
		sb.append("    <field name=\"Sequence Id\" abbrev=\"seq\" type=\"uint16_t\"/>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"UTS\">\n");
		sb.append("      <value abbrev=\"DONE\" name=\"Transmission Completed\" id=\"0\"/>\n");
		sb.append("      <value abbrev=\"FAILED\" name=\"Transmission Failed\" id=\"1\"/>\n");
		sb.append("      <value abbrev=\"CANCELED\" name=\"Transmission Canceled\" id=\"2\"/>\n");
		sb.append("      <value abbrev=\"BUSY\" name=\"Modem is busy\" id=\"3\"/>\n");
		sb.append("      <value abbrev=\"INV_ADDR\" name=\"Invalid address\" id=\"4\"/>\n");
		sb.append("      <value abbrev=\"IP\" name=\"In Progress\" id=\"5\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Error Message\" abbrev=\"error\" type=\"plaintext\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"817\" name=\"UamRxRange\" abbrev=\"UamRxRange\" source=\"ccu,vehicle\">\n");
		sb.append("    <field name=\"Sequence Id\" abbrev=\"seq\" type=\"uint16_t\"/>\n");
		sb.append("    <field name=\"System\" abbrev=\"sys\" type=\"plaintext\"/>\n");
		sb.append("    <field name=\"Value\" abbrev=\"value\" type=\"fp32_t\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"820\" name=\"Formation Control Parameters\" abbrev=\"FormCtrlParam\" source=\"ccu,vehicle\">\n");
		sb.append("    <description>\n");
		sb.append("      Formation controller paramenters, as: trajectory gains, control boundary layer thickness, and formation shape gains.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Action\" abbrev=\"Action\" type=\"uint8_t\" unit=\"Enumerated\" prefix=\"OP\">\n");
		sb.append("      <description>\n");
		sb.append("        Action on the vehicle formation control parameters.\n");
		sb.append("      </description>\n");
		sb.append("      <value id=\"0\" name=\"Request\" abbrev=\"REQ\"/>\n");
		sb.append("      <value id=\"1\" name=\"Set\" abbrev=\"SET\"/>\n");
		sb.append("      <value id=\"2\" name=\"Report\" abbrev=\"REP\"/>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitudinal Gain\" abbrev=\"LonGain\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Trajectory gain over the vehicle longitudinal direction.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Lateral Gain\" abbrev=\"LatGain\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Trajectory gain over the vehicle lateral direction.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Boundary Layer Thickness\" abbrev=\"BondThick\" type=\"uint32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Control sliding surface boundary layer thickness.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Leader Gain\" abbrev=\"LeadGain\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Formation shape gain (absolute vehicle position tracking).\n");
		sb.append("        Leader control importance gain (relative to the sum of every other formation vehicle).\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Deconfliction Gain\" abbrev=\"DeconflGain\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Collision avoidance and formation shape gain (position tracking relative to the other formation vehicles).\n");
		sb.append("        Individual vehicle importance gain (relative to the leader), when the relative position or the velocity state indicate higher probability of collision.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"821\" name=\"Formation Evaluation Data\" abbrev=\"FormationEval\">\n");
		sb.append("    <description>\n");
		sb.append("      Formation control performance evaluation variables.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Mean position error\" abbrev=\"err_mean\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Mean position error relative to the formation reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Absolute minimum distance\" abbrev=\"dist_min_abs\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Overall minimum distance to any other vehicle in the formation.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Mean minimum distance\" abbrev=\"dist_min_mean\" type=\"fp32_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Mean minimum distance to any other vehicle in the formation.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"877\" abbrev=\"MessagePart\" name=\"Message Fragment\">\n");
		sb.append("    <field name=\"Transmission Unique Id\" abbrev=\"uid\" type=\"uint8_t\"/>\n");
		sb.append("    <field name=\"Fragment Number\" abbrev=\"frag_number\" type=\"uint8_t\"/>\n");
		sb.append("    <field name=\"Total Number of fragments\" abbrev=\"num_frags\" type=\"uint8_t\"/>\n");
		sb.append("    <field name=\"Fragment Data\" abbrev=\"data\" type=\"rawdata\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"888\" abbrev=\"NeptusBlob\" name=\"Neptus Blob\">\n");
		sb.append("    <field name=\"ContentType\" abbrev=\"content_type\" type=\"plaintext\"/>\n");
		sb.append("    <field name=\"Content\" abbrev=\"content\" type=\"rawdata\"/>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"889\" abbrev=\"Aborted\" name=\"Aborted\">\n");
		sb.append("    <description>\n");
		sb.append("      This message signals that an :ref:`Abort` message was received and acted upon.\n");
		sb.append("    </description>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"890\" name=\"USBL Angles\" abbrev=\"UsblAngles\">\n");
		sb.append("    <description>\n");
		sb.append("      This message contains information, collected using USBL, about the\n");
		sb.append("      bearing and elevation of a target.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Target\" abbrev=\"target\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Target's IMC address.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Bearing\" abbrev=\"bearing\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Target's bearing.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Elevation\" abbrev=\"elevation\" type=\"fp32_t\" unit=\"rad\">\n");
		sb.append("      <description>\n");
		sb.append("        Target's elevation.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"891\" name=\"USBL Position\" abbrev=\"UsblPosition\">\n");
		sb.append("    <description>\n");
		sb.append("      This message contains information, collected using USBL, about a\n");
		sb.append("      target's position.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Target\" abbrev=\"target\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Target's IMC address.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"X\" abbrev=\"x\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        X coordinate of the target in the local device's reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Y\" abbrev=\"y\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Y coordinate of the target in the local device's reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Z coordinate of the target in the local device's reference frame.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("\n");
		sb.append("  <message id=\"892\" name=\"USBL Fix\" abbrev=\"UsblFix\">\n");
		sb.append("    <description>\n");
		sb.append("      This message contains the WGS-84 position of a target computed using\n");
		sb.append("      USBL.\n");
		sb.append("    </description>\n");
		sb.append("    <field name=\"Target\" abbrev=\"target\" type=\"uint16_t\">\n");
		sb.append("      <description>\n");
		sb.append("        Target's IMC address.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Latitude (WGS-84)\" abbrev=\"lat\" type=\"fp64_t\" unit=\"rad\" min=\"-1.5707963267948966\" max=\"1.5707963267948966\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Latitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Longitude (WGS-84)\" abbrev=\"lon\" type=\"fp64_t\" unit=\"rad\" min=\"-3.141592653589793\" max=\"3.141592653589793\">\n");
		sb.append("      <description>\n");
		sb.append("        WGS-84 Longitude.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Units\" abbrev=\"z_units\" type=\"uint8_t\" value=\"0\" unit=\"Enumerated\" enum-def=\"ZUnits\">\n");
		sb.append("      <description>\n");
		sb.append("        Units of the z reference.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("    <field name=\"Z Reference\" abbrev=\"z\" type=\"fp32_t\" unit=\"m\">\n");
		sb.append("      <description>\n");
		sb.append("        Target reference in the z axis. Use z_units to specify\n");
		sb.append("        whether z represents depth, altitude or other.\n");
		sb.append("      </description>\n");
		sb.append("    </field>\n");
		sb.append("  </message>\n");
		sb.append("</messages>\n");
		return sb.toString();
	}
}
