/*****************************************************************************
 *                       Yumetech Copyright (c) 2004-2005
 *                               GLSL Source
 *
 * This source is licensed under the modified BSD license.
 * Please read http://www.opensource.org/licenses/bsd-license.php for more 
 * information
 *
 * This software comes with the standard NO WARRANTY disclaimer for any
 * purpose. Use it at your own risk. If there's a problem you get to fix it.
 *
 ****************************************************************************/

// This is the number of matrices in the skeleton. It is changed dynamically by
// the Java code to reflect the real humanoid, before compilation.
attribute vec4 weight;
attribute vec4 matrixIndex;

// skeleton matrices
uniform mat4 boneMatrix[50];

// Number of textures to apply to the object
uniform int numTextures;

// Number of texture coordinates to generate
uniform bool numTexCoords;  

// Should fog values be calculated
uniform int fogSourceType;

// Number of lights to calculate the final colour from
uniform bool lightingEnabled;

// Flag per light indicating if it's enabled or not
uniform bool enabledLights[8];

// Forward decls for the other shaders in use
void processNoLighting(in bool);
void processLighting(in vec3,
                     in vec3,
                     in bool[],
                     in bool,
                     in bool,
                     in bool);

void processFogDepth(in vec3, in bool);

void main()
{      
    ivec4 idx = ivec4(matrixIndex);

    vec4 position = weight.x * boneMatrix[idx.x] * gl_Vertex +
                    weight.y * boneMatrix[idx.y] * gl_Vertex +
                    weight.z * boneMatrix[idx.z] * gl_Vertex +
                    weight.w * boneMatrix[idx.w] * gl_Vertex;

    gl_Position = gl_ModelViewProjectionMatrix * position;

    vec4 norm = vec4(gl_Normal, 0.0);
    vec4 normal = weight.x * boneMatrix[idx.x] * norm +
                  weight.y * boneMatrix[idx.y] * norm +
                  weight.z * boneMatrix[idx.z] * norm +
                  weight.w * boneMatrix[idx.w] * norm;

    vec3 final_normal = normalize(gl_NormalMatrix * normal.xyz);

        gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;
#    gl_FrontColor = 2.0 * gl_Color;
    gl_FrontColor = 1.0;
        
}

